/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.View;

public class FontSize
extends HtmlAttribute {
    private static final int ABSOLUTE = 0;
    private static final int RELATIVE_NUMBER = 1;
    private static final int UNIT = 2;
    private int type;
    private float size;
    private LengthUnit lengthUnit;
    private static final NumberFormat FORMAT = new DecimalFormat("0.#", new DecimalFormatSymbols(Locale.US));

    public FontSize(int pt) {
        this.type = 2;
        this.lengthUnit = new LengthUnit(pt + "pt");
        this.size = this.lengthUnit.getValue();
        this.setString(pt + "pt");
    }

    public FontSize(int pt, boolean isPT) {
        this.type = 2;
        if (isPT) {
            this.lengthUnit = new LengthUnit(pt + "pt");
            this.size = this.lengthUnit.getValue();
            this.setString(pt + "pt");
        } else {
            this.lengthUnit = new LengthUnit(pt + "px");
            this.size = this.lengthUnit.getValue();
            this.setString(pt + "px");
        }
    }

    public FontSize(float pt) {
        this.type = 2;
        this.lengthUnit = new LengthUnit(FORMAT.format(pt) + "pt");
        this.size = this.lengthUnit.getValue();
        this.setString(FORMAT.format(pt) + "pt");
    }

    public FontSize(float pt, boolean isPT) {
        this.type = 2;
        String formatted = FORMAT.format(pt);
        if (isPT) {
            this.lengthUnit = new LengthUnit(formatted + "pt");
            this.size = this.lengthUnit.getValue();
            this.setString(formatted + "pt");
        } else {
            this.lengthUnit = new LengthUnit(formatted + "px");
            this.size = this.lengthUnit.getValue();
            this.setString(formatted + "px");
        }
    }

    public FontSize() {
    }

    public float getValue(BoxView view) {
        View parent = view.getParent();
        float parentSize = 16.0f;
        if (parent != null && parent instanceof BoxView) {
            parentSize = ((BoxView)parent).getFontSize();
        }
        return this.getValue(parentSize);
    }

    public float getValue(float parentFontSize) {
        switch (this.type) {
            case 1: {
                int tableSize = FontSize.convertPointSizeToTableSize(parentFontSize) + (int)this.size;
                return FontSize.convertTableSizeToPointSize(tableSize);
            }
            case 2: {
                if (this.lengthUnit.getType() == 0) {
                    return this.lengthUnit.getValue();
                }
                return parentFontSize * this.lengthUnit.getValue();
            }
        }
        return this.size;
    }

    @Override
    protected AttributeValue parseCssValue(String value, boolean important) {
        FontSize fontSize = new FontSize();
        if ("inherit".equals(value = value.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        if (value.equals("xx-small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(1);
            fontSize.type = 0;
        } else if (value.equals("x-small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(2);
            fontSize.type = 0;
        } else if (value.equals("small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(3);
            fontSize.type = 0;
        } else if (value.equals("medium")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(4);
            fontSize.type = 0;
        } else if (value.equals("large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(5);
            fontSize.type = 0;
        } else if (value.equals("x-large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(6);
            fontSize.type = 0;
        } else if (value.equals("xx-large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(7);
            fontSize.type = 0;
        } else if (value.equals("larger")) {
            fontSize.size = 1.0f;
            fontSize.type = 1;
        } else if (value.equals("smaller")) {
            fontSize.size = -1.0f;
            fontSize.type = 1;
        } else {
            AttributeValue unit = LengthUnit.PARSER.parseCssValue(value, important);
            if (unit == null) {
                return null;
            }
            fontSize.lengthUnit = (LengthUnit)unit;
            fontSize.type = 2;
            fontSize.size = fontSize.lengthUnit.getValue();
        }
        fontSize.setString(value);
        return fontSize;
    }

    @Override
    public AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        try {
            FontSize fontSize = new FontSize();
            char firstChar = value.charAt(0);
            fontSize.setString(value);
            if (firstChar == '+' || firstChar == '-') {
                int size = 3 + Integer.parseInt(firstChar == '+' ? value.substring(1) : value);
                size = Math.max(1, Math.min(7, size));
                fontSize.lengthUnit = new LengthUnit(FontSize.convertTableSizeToPointSize(size) + "pt");
                fontSize.type = 2;
            } else {
                LengthUnit unit = (LengthUnit)LengthUnit.PARSER.parseCssValue(value, false);
                fontSize.type = 2;
                int fontSizePoints = unit != null ? (int)unit.getValue() : Integer.parseInt(value);
                fontSize.lengthUnit = new LengthUnit(FontSize.convertTableSizeToPointSize(fontSizePoints) + "pt");
            }
            return fontSize;
        }
        catch (Throwable th) {
            Logger.error(th);
            return null;
        }
    }

    private static final int convertTableSizeToPointSize(int size) {
        if (size < 1) {
            size = 1;
        }
        switch (size) {
            case 1: {
                return 8;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 18;
            }
            case 6: {
                return 24;
            }
        }
        return 36;
    }

    private static final int convertPointSizeToTableSize(float size) {
        if (size < 9.0f) {
            return 1;
        }
        if (size < 11.0f) {
            return 2;
        }
        if (size < 13.0f) {
            return 3;
        }
        if (size < 16.0f) {
            return 4;
        }
        if (size < 21.0f) {
            return 5;
        }
        if (size < 30.0f) {
            return 6;
        }
        return 7;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontSize) {
            FontSize other = (FontSize)obj;
            if (other.lengthUnit == null || !other.lengthUnit.equals(this.lengthUnit)) {
                return false;
            }
            if (other.size != this.size) {
                return false;
            }
            return other.type == this.type;
        }
        return false;
    }

    static {
        FORMAT.setGroupingUsed(false);
        FORMAT.setMaximumFractionDigits(3);
        FORMAT.setMinimumFractionDigits(0);
    }
}

