/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.finder;

import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.AttributeValue;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.View;

public class GenericFinder<T extends AttributeValue>
implements AttributeFinder<T> {
    private static final HashMap<CSS.Attribute, AttributeFinder<? extends AttributeValue>> FINDER_MAP_CSS = new HashMap();
    private static final HashMap<HTML.Attribute, AttributeFinder<? extends AttributeValue>> FINDER_MAP_HTML = new HashMap();
    private final CSS.Attribute cssAttr;
    private final HTML.Attribute htmlAttr;
    private final Class<?> type;
    private final boolean inherited;

    public GenericFinder(CSS.Attribute cssAttr, HTML.Attribute htmlAttr, boolean inherited, Class<T> type) {
        this.cssAttr = cssAttr;
        this.htmlAttr = htmlAttr;
        this.inherited = inherited;
        this.type = type;
        if (cssAttr != null) {
            FINDER_MAP_CSS.put(cssAttr, this);
        }
        if (htmlAttr != null) {
            FINDER_MAP_HTML.put(htmlAttr, this);
        }
    }

    @Override
    public Object findStyleAttribute(Element element) {
        Object obj;
        if (this.cssAttr != null && element.getAttributes().isDefined((Object)this.cssAttr) && ((obj = element.getAttributes().getAttribute((Object)this.cssAttr)) == AttributeValue.INHERIT || this.type.isInstance(obj))) {
            return obj;
        }
        return null;
    }

    @Override
    public Object findCssAttribute(Styles styles, Element element, boolean important) {
        AttributeValue obj = styles.getCssAttribute(element, this.cssAttr, important);
        if (obj == AttributeValue.INHERIT || this.type.isInstance(obj)) {
            return obj;
        }
        return null;
    }

    @Override
    public Object findCssAttribute(Styles styles, Element element, boolean important, List<Selector> matchList) {
        AttributeValue obj = styles.getCssAttribute(element, this.cssAttr, important, matchList);
        if (obj == AttributeValue.INHERIT || this.type.isInstance(obj)) {
            return obj;
        }
        return null;
    }

    @Override
    public Object findHtmlAttribute(Element element) {
        Object obj;
        if (this.htmlAttr != null && element.getAttributes().isDefined((Object)this.htmlAttr) && this.type.isInstance(obj = element.getAttributes().getAttribute((Object)this.htmlAttr))) {
            return obj;
        }
        return null;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public T getAttributeValue(View view) {
        return (T)((AttributeValue)StyleResolver.getAttributeValue(view.getElement(), this));
    }

    public String toString() {
        if (this.cssAttr != null) {
            return this.cssAttr.toString();
        }
        return this.htmlAttr.toString();
    }

    public static AttributeFinder<? extends AttributeValue> getFinder(CSS.Attribute forAttribute) {
        return FINDER_MAP_CSS.get((Object)forAttribute);
    }

    public static AttributeFinder<? extends AttributeValue> getFinder(HTML.Attribute forAttribute) {
        return FINDER_MAP_HTML.get((Object)forAttribute);
    }

    @Override
    public CSS.Attribute getCSSAttribute() {
        return this.cssAttr;
    }

    @Override
    public HTML.Attribute getHTMLAttribute() {
        return this.htmlAttr;
    }
}

