/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.edit;

import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.css.HTML;
import com.inet.html.edit.EditPainter;
import com.inet.html.edit.ElementEditor;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.SuppressFBWarnings;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Element;

public class LinkEditor
extends MouseAdapter
implements ElementEditor,
EditPainter {
    private static final int SHORTCUT_KEY_MASK = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 128;
    private static final String MSO_BLOCKED_LINK_PREFIX = "blocked::";
    private JEditorPane editor;
    private Element anchor;
    private Element curElem;
    private String href;
    private boolean wasCtrlPressed;
    private Cursor newCursor;

    @Override
    public HTML.Tag[] getHandledTags() {
        return new HTML.Tag[]{HTML.Tag.A};
    }

    @Override
    public MouseAdapter getMouseHandler() {
        return this;
    }

    @Override
    public boolean setSelectedView(BoxView view, Rectangle viewOutline, Element refElement) {
        if (refElement != null && refElement.getAttributes().getAttribute((Object)HTML.Attribute.HREF) != null) {
            this.anchor = refElement;
            return true;
        }
        InetHtmlEditorKit kit = (InetHtmlEditorKit)this.editor.getEditorKit();
        this.editor.setCursor(kit.getDefaultCursor());
        if (this.curElem != null) {
            InetHtmlDocument hdoc = (InetHtmlDocument)this.editor.getDocument();
            this.editor.fireHyperlinkUpdate(this.createHyperlinkEvent(this.editor, hdoc, this.href, this.curElem, HyperlinkEvent.EventType.EXITED));
        }
        this.anchor = null;
        this.curElem = null;
        return true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        InetHtmlEditorKit kit = (InetHtmlEditorKit)this.editor.getEditorKit();
        InetHtmlDocument hdoc = (InetHtmlDocument)this.editor.getDocument();
        boolean isCtrlPressed = (e.getModifiersEx() & SHORTCUT_KEY_MASK) != 0;
        boolean isEditable = this.editor.isEditable();
        boolean adjustCursor = false;
        if (this.anchor != this.curElem) {
            this.curElem = this.anchor;
            if (this.anchor == null) {
                this.href = null;
                this.editor.fireHyperlinkUpdate(this.createHyperlinkEvent(this.editor, hdoc, this.href, this.curElem, HyperlinkEvent.EventType.EXITED));
            } else {
                Object ref = this.anchor.getAttributes().getAttribute((Object)HTML.Attribute.HREF);
                if (ref instanceof UrlValue) {
                    this.href = ((UrlValue)ref).getResolver().getOriginalURI();
                    this.newCursor = kit.getLinkCursor();
                } else {
                    this.href = ref.toString();
                    this.newCursor = kit.getLinkCursor();
                }
                this.editor.fireHyperlinkUpdate(this.createHyperlinkEvent(this.editor, hdoc, this.href, this.curElem, HyperlinkEvent.EventType.ENTERED));
            }
            if (!isCtrlPressed && isEditable) {
                this.newCursor = kit.getDefaultCursor();
            }
            adjustCursor = true;
        } else if (isEditable) {
            if (!this.wasCtrlPressed && isCtrlPressed && this.anchor != null && this.href != null) {
                this.newCursor = kit.getLinkCursor();
                adjustCursor = true;
            }
            if (this.wasCtrlPressed && !isCtrlPressed) {
                this.newCursor = kit.getDefaultCursor();
                adjustCursor = true;
            }
        }
        if (adjustCursor && this.editor.getCursor() != this.newCursor) {
            this.editor.setCursor(this.newCursor);
        }
        this.wasCtrlPressed = isCtrlPressed;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JEditorPane editor = (JEditorPane)e.getSource();
        if (((e.getModifiersEx() & SHORTCUT_KEY_MASK) != 0 || !editor.isEditable()) && this.curElem != null && this.href != null && this.anchor != null && editor.getDocument() instanceof InetHtmlDocument) {
            InetHtmlDocument hdoc;
            InetHtmlEditorKit.ExtendedHyperlinkEvent linkEvent;
            if (this.href.toLowerCase().startsWith(MSO_BLOCKED_LINK_PREFIX)) {
                this.href = this.href.substring(MSO_BLOCKED_LINK_PREFIX.length());
            }
            if ((linkEvent = this.createHyperlinkEvent(editor, hdoc = (InetHtmlDocument)editor.getDocument(), this.href, this.curElem, HyperlinkEvent.EventType.ACTIVATED)) != null) {
                if (!editor.isEditable() && (e.getModifiersEx() & SHORTCUT_KEY_MASK) != 0 || e.getButton() == 2) {
                    linkEvent.setTarget("_newtab");
                }
                if ((e.getModifiersEx() & 0x40) != 0) {
                    linkEvent.setTarget("_blank");
                }
                editor.fireHyperlinkUpdate(linkEvent);
                editor.setToolTipText(null);
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The location is in fact user specified, since it's the href of a link element.")
    private InetHtmlEditorKit.ExtendedHyperlinkEvent createHyperlinkEvent(JEditorPane html, InetHtmlDocument hdoc, String href, Element element, HyperlinkEvent.EventType event) {
        URL u = null;
        try {
            if (href != null) {
                if (href.startsWith("\\\\")) {
                    u = new File(href).toURI().toURL();
                } else {
                    URL base = hdoc.getBase();
                    u = new URL(base, href);
                    if ("file".equals(u.getProtocol()) && href.startsWith("#")) {
                        String baseFile = base.getFile();
                        String newFile = u.getFile();
                        if (baseFile != null && newFile != null && !newFile.startsWith(baseFile)) {
                            u = new URL(base, baseFile + href);
                        }
                    }
                }
            }
        }
        catch (MalformedURLException m) {
            if (Logger.doesLog(2)) {
                Logger.warning("Unable to create link event for invalid URL: " + href);
            }
            u = null;
        }
        if (element != null && element.getAttributes().isDefined((Object)HTML.Attribute.TITLE)) {
            href = element.getAttributes().getAttribute((Object)HTML.Attribute.TITLE).toString();
        }
        InetHtmlEditorKit.ExtendedHyperlinkEvent linkEvent = new InetHtmlEditorKit.ExtendedHyperlinkEvent(html, event, u, href, element);
        return linkEvent;
    }

    @Override
    public void setEditor(JEditorPane editor) {
        this.editor = editor;
    }

    @Override
    public EditPainter getPainter() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public List<Action> getMenuEntries() {
        return null;
    }
}

