/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class SoftBreakAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private static final String BREAK = "</BR>";

    public SoftBreakAction() {
        super("insert-softbreak");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JEditorPane comp = this.getHtmlEditor(ev);
        Document doc = comp.getDocument();
        if (doc instanceof InetHtmlDocument) {
            int pos = comp.getCaretPosition();
            try {
                boolean stopLink;
                InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
                Element leaf = ElementUtils.getLeafAt(doc.getDefaultRootElement(), pos);
                if (leaf == null) {
                    return;
                }
                Element aElement = ElementUtils.findParentByTag(leaf, HTML.Tag.A);
                Element paragraph = ElementUtils.findNextHigherBlock(leaf);
                int pEnd = paragraph.getEndOffset();
                boolean isAtEnd = pos == pEnd - 1;
                boolean bl = stopLink = aElement != null && (isAtEnd && aElement.getEndOffset() == pos + 1 || !isAtEnd && aElement.getEndOffset() == pos);
                if (stopLink) {
                    if (isAtEnd) {
                        htmlDoc.insertBeforeEnd(paragraph, "</BR></BR>");
                    } else {
                        htmlDoc.insertAfterEnd(aElement, BREAK);
                    }
                } else {
                    if (isAtEnd) {
                        htmlDoc.pasteHTML(BREAK, pos, pos, null);
                    }
                    htmlDoc.pasteHTML(BREAK, pos, pos, null);
                }
                if (isAtEnd) {
                    comp.setCaretPosition(comp.getCaretPosition() - 1);
                }
                return;
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        UIManager.getLookAndFeel().provideErrorFeedback(comp);
    }
}

