/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.actions.InetHtmlAction;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class DeletePrevCharAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;

    public DeletePrevCharAction() {
        super("delete-previous");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane target = this.getHtmlEditor(e);
        boolean beep = true;
        if (target != null && target.isEditable()) {
            try {
                Document doc = target.getDocument();
                Caret caret = target.getCaret();
                int dot = caret.getDot();
                int mark = caret.getMark();
                if (dot != mark) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    beep = false;
                } else if (dot > 0) {
                    int delChars = 1;
                    if (dot > 1) {
                        String dotChars = doc.getText(dot - 2, 2);
                        char c0 = dotChars.charAt(0);
                        char c1 = dotChars.charAt(1);
                        if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                            delChars = 2;
                        }
                    }
                    doc.remove(dot - delChars, delChars);
                    beep = false;
                    dot -= delChars;
                } else if (mark == 0 && dot == 0 && doc.getLength() == 1) {
                    doc.remove(0, 1);
                    beep = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (beep) {
            UIManager.getLookAndFeel().provideErrorFeedback(target);
        }
    }
}

