/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.annotations.PublicApi;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.DocType;
import com.inet.html.parser.PushReader;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

@PublicApi
public class InetHtmlParser {
    private static int maximumStackSize = 200;
    private static final String FRAGMENT_START = "StartFragment-->";
    private static final String FRAGMENT_END = "EndFragment-->";
    private PushReader reader;
    private InetHtmlDocument doc;
    private InetHtmlConfiguration currentConfig;
    private URL url;
    private boolean ignoreCharset;
    private boolean ignoreNamespaces = true;
    private String charset;
    private boolean dropUnknownStyles;
    private static final Element[] EMPTY = new Element[0];
    private boolean isInsert = false;
    private Styles styles;
    private Object currentSource;
    private Object classAppendix;
    private long endTime = -1L;
    private InetHtmlDocument.EventList eventList;
    private ParserState state;
    private ParserState rootState;
    private List<ParserState> tableStack = new ArrayList<ParserState>();
    private Position startFragment;
    private Position endFragment;
    private static final HashMap<HTML.Tag, TagList> PARENT_REQUIRED = new HashMap();
    private static final HashMap<HTML.Tag, TagList> PARENT_FORBIDDEN = new HashMap();
    public static final Set<HTML.Tag> TABLE_STRUCT_TAGS = new HashSet<HTML.Tag>(){
        {
            this.add(HTML.Tag.TR);
            this.add(HTML.Tag.TBODY);
            this.add(HTML.Tag.THEAD);
            this.add(HTML.Tag.TFOOT);
            this.add(HTML.Tag.COL);
            this.add(HTML.Tag.COLGROUP);
            this.add(HTML.Tag.TABLE);
        }
    };
    private static final Set<HTML.Tag> TABLE_CELL_TAGS = new HashSet<HTML.Tag>(){
        {
            this.add(HTML.Tag.CAPTION);
            this.add(HTML.Tag.TD);
            this.add(HTML.Tag.TH);
        }
    };

    public static void setMaximumStackSize(int size) {
        maximumStackSize = Math.max(2, size);
    }

    public void parse(Reader in, InetHtmlDocument doc, AbstractDocument.BranchElement root, int insertOffset, InetHtmlDocument.EventList eventList, boolean allowSpaces, Object sourceID) throws IOException, BadLocationException {
        Object nsIgnore;
        Boolean charsetDirective;
        long timeout;
        this.currentConfig = doc.getConfiguration();
        this.dropUnknownStyles = doc.getProperty(InetHtmlDocument.PROPERTY_DROP_UNKNOWN_STYLES) == Boolean.TRUE;
        this.eventList = eventList != null ? eventList : new DummyEventList();
        this.doc = doc;
        this.styles = doc.getStyleResolver().getStyles();
        this.currentSource = sourceID;
        this.startFragment = null;
        this.endFragment = null;
        Object timeoutObj = doc.getProperty(InetHtmlDocument.PROPERTY_TIMEOUT);
        if (timeoutObj instanceof Number && (timeout = ((Number)timeoutObj).longValue()) > 0L) {
            this.endTime = System.currentTimeMillis() + timeout;
        }
        boolean bl = this.ignoreCharset = (charsetDirective = (Boolean)doc.getProperty("IgnoreCharsetDirective")) == null ? false : charsetDirective;
        if (in instanceof InputStreamReader) {
            this.charset = ((InputStreamReader)in).getEncoding();
        }
        this.ignoreNamespaces = (nsIgnore = doc.getProperty(InetHtmlDocument.PROPERTY_IGNORE_NAMESPACES)) == null || !(nsIgnore instanceof Boolean) || nsIgnore != Boolean.FALSE;
        this.reader = new PushReader(in);
        this.isInsert = root != doc.getDefaultRootElement();
        this.url = doc.getBase();
        doc.getDocType().setType(DocType.Type.quirks);
        this.state = new ParserState(root, insertOffset, -1);
        for (Element parent = root; parent != null; parent = parent.getParentElement()) {
            this.state.tagStack.add(parent.getAttributes().getAttribute(StyleConstants.NameAttribute));
        }
        Collections.reverse(this.state.tagStack);
        this.state.activate();
        this.state.isInBody = this.isInsert;
        this.rootState = this.state;
        this.checkForUtf8Prefix();
        int recent = -1;
        try {
            while (true) {
                int ch = this.reader.read();
                switch (ch) {
                    case -1: {
                        this.finishParse(eventList);
                        return;
                    }
                    case 60: {
                        if (this.parseTag()) break;
                        this.appendCharToContent((char)ch);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 65279: {
                        if (this.state.isPreformatted) {
                            if (ch == 13) {
                                this.state.content.append('\n');
                                break;
                            }
                            if (recent == 13 && ch == 10) break;
                            this.state.content.append((char)ch);
                            break;
                        }
                        if (this.state.isFirstTextInLine && !allowSpaces || this.state.wasWhitespace && !this.state.wasNBWhitespace && !allowSpaces) break;
                        this.appendCharToContent(' ');
                        break;
                    }
                    case 38: {
                        this.appendCharToContent(this.reader.readQuotedChar());
                        break;
                    }
                    default: {
                        this.appendCharToContent((char)ch);
                    }
                }
                recent = ch;
            }
        }
        catch (SocketTimeoutException e) {
            this.finishParse(eventList);
            return;
        }
    }

    private void appendCharToContent(char ch) {
        this.state.content.append(ch);
        this.state.isFirstTextInLine = false;
        this.state.wasWhitespace = ch == ' ' || ch == '\u00a0';
        this.state.wasNBWhitespace = this.state.wasWhitespace && ch == '\u00a0';
    }

    private boolean parseTag() throws IOException, BadLocationException {
        boolean monolithic;
        HTML.Tag tag;
        if (this.endTime > 0L && System.currentTimeMillis() > this.endTime) {
            this.reader.shutDown();
            return true;
        }
        this.reader.startTransaction();
        String tagName = this.reader.readKey();
        if (tagName == null) {
            this.reader.rollBack();
            return false;
        }
        if (tagName.length() == 8 && tagName.charAt(0) == '!' && "!DOCTYPE".equals(tagName.toUpperCase())) {
            this.addContentToken(false);
            this.parseDocType();
            this.reader.commit();
            return true;
        }
        if (tagName == "!--") {
            this.reader.commit();
            String skipped = this.reader.skipComment();
            if (this.startFragment == null && FRAGMENT_START.equals(skipped)) {
                this.startFragment = this.doc.getContentImpl().createPosition(this.state.pos.getOffset() - 1);
                if (this.currentSource != null) {
                    this.state.content.setLength(0);
                }
            }
            if (this.endFragment == null && FRAGMENT_END.equals(skipped)) {
                this.endFragment = this.doc.getContentImpl().createPosition(this.state.pos.getOffset() - 1 + this.state.content.length());
            }
            return true;
        }
        if (tagName.length() == 0) {
            if (this.reader.read() != 47) {
                this.addContentToken(true);
                if (Logger.doesLog(2)) {
                    Logger.warning("Empty Tag: " + tagName);
                }
                return true;
            }
            tagName = this.reader.readKey();
            if (tagName != null) {
                tagName = tagName.toLowerCase();
            }
            if (tagName == null) {
                return false;
            }
            tag = HTML.getTag(tagName);
            if (tag != HTML.Tag.BR) {
                if (tag != null && this.skipTagIfNamespace(tagName)) {
                    return true;
                }
                if (!this.reader.skipTag()) {
                    this.reader.rollBack();
                    return false;
                }
                if (tag != null && !ElementUtils.isMonolithic(tag) && !this.isSkipOnInsert(tag)) {
                    this.addContentToken(true);
                    this.removeTag((Object)tag, false);
                } else {
                    this.addContentToken(false);
                    if (tagName.equals(this.state.getParentName())) {
                        tagName = InetHtmlDocument.getCachedString(tagName);
                        this.removeTag(tagName, false);
                    }
                }
                return true;
            }
        }
        if ((tag = HTML.getTag(tagName)) == null && this.skipTagIfNamespace(tagName)) {
            return true;
        }
        if (this.state.isInBody || !this.state.wasWhitespace || this.state.content.length() > 1) {
            this.addContentToken(false);
        } else {
            this.state.content.setLength(0);
            this.state.wasWhitespace = false;
        }
        MutableAttributeSet attrs = this.parseAttributes(tag);
        if (attrs == null) {
            this.reader.rollBack();
            return false;
        }
        this.reader.commit();
        this.setSourceClassIfRequired(attrs);
        Element elem = null;
        if (tag == null) {
            if (tagName.startsWith("![")) {
                return true;
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unknown Tag: " + tagName);
            }
            tagName = InetHtmlDocument.getCachedString(tagName.toLowerCase());
            monolithic = attrs.getAttribute("/") == Boolean.TRUE;
            attrs.addAttribute(StyleConstants.NameAttribute, tagName);
            this.checkForBodyTag();
        } else {
            if (this.isSkipOnInsert(tag)) {
                return true;
            }
            attrs.addAttribute(StyleConstants.NameAttribute, (Object)tag);
            switch (tag) {
                case STYLE: {
                    this.parseStyle();
                    return true;
                }
                case LINK: {
                    this.parseLink(attrs);
                    return true;
                }
                case SCRIPT: {
                    this.reader.skipScript();
                    return true;
                }
                case TITLE: {
                    this.state.isInTitle = true;
                    return true;
                }
                case HTML: {
                    if (!this.isEquals(this.state.getParentElement(), (Object)HTML.Tag.HTML)) break;
                    MutableAttributeSet parentAttrs = (MutableAttributeSet)this.state.getParentElement().getAttributes();
                    parentAttrs.removeAttributes(parentAttrs);
                    parentAttrs.addAttributes(attrs);
                    this.doc.fillAttributes(this.state.getParentElement());
                    return true;
                }
                case BASE: {
                    this.checkBaseURLChange(attrs);
                    break;
                }
                case META: {
                    this.readMetaElement(attrs);
                    break;
                }
                case BODY: {
                    this.removeTag((Object)HTML.Tag.HEAD, false);
                    break;
                }
                default: {
                    this.checkForBodyTag(tag);
                }
            }
            elem = this.removeTagThatNeedNoEndtag(tag, attrs);
            monolithic = ElementUtils.isMonolithic(tag);
        }
        if (elem == null) {
            Element element = elem = monolithic ? this.addLeafElement(attrs, "\n") : this.addBranchElement(attrs);
        }
        if (elem == null) {
            return true;
        }
        if (monolithic) {
            this.state.wasWhitespace = false;
            this.state.isFirstTextInLine = false;
        }
        if (!this.state.isFirstTextInLine && InetHtmlParser.breaksFlow(elem)) {
            this.state.isFirstTextInLine = true;
        }
        if (InetHtmlParser.isPreformatted(elem)) {
            this.state.isPreformatted = true;
        }
        return true;
    }

    private void readMetaElement(MutableAttributeSet attrs) throws ChangedCharSetException {
        if (this.state.isInBody) {
            return;
        }
        if (!this.ignoreCharset && !this.isCharsetSetByHTTP()) {
            String contentValue = (String)attrs.getAttribute((Object)HTML.Attribute.CONTENT);
            String charsetAtt = (String)attrs.getAttribute((Object)HTML.Attribute.CHARSET);
            if (contentValue != null) {
                String httpEquiv = (String)attrs.getAttribute((Object)HTML.Attribute.HTTP_EQUIV);
                if ("content-type".equalsIgnoreCase(httpEquiv)) {
                    if (!contentValue.equalsIgnoreCase("text/html") && !contentValue.equalsIgnoreCase("text/plain")) {
                        this.throwCharsetException(contentValue, false);
                    }
                } else if ("charset".equalsIgnoreCase(httpEquiv)) {
                    this.throwCharsetException(contentValue, true);
                }
            } else if (charsetAtt != null) {
                this.throwCharsetException(charsetAtt, true);
            }
        }
    }

    private void checkBaseURLChange(MutableAttributeSet attrs) {
        block4: {
            Object newBase;
            if (!this.state.isInBody && attrs.isDefined((Object)HTML.Attribute.HREF) && (newBase = attrs.getAttribute((Object)HTML.Attribute.HREF)) instanceof UrlValue) {
                URLResolver resolver = ((UrlValue)newBase).getResolver();
                resolver.setBase(this.url);
                try {
                    URL newBaseUrl = resolver.getFullURL();
                    if (newBaseUrl.getHost() != null) {
                        this.doc.setBase(newBaseUrl);
                        this.url = newBaseUrl;
                    }
                }
                catch (MalformedURLException e) {
                    if (!Logger.doesLog(3)) break block4;
                    Logger.info("Could not set Base-URL, the URL '" + resolver.getOriginalURI() + "'");
                }
            }
        }
    }

    private void setSourceClassIfRequired(MutableAttributeSet attrs) {
        if (this.classAppendix != null && this.currentSource != null) {
            Object value = attrs.getAttribute((Object)HTML.Attribute.CLASS);
            if (!(value instanceof ClassValue)) {
                ClassValue classAtt = new ClassValue();
                attrs.addAttribute((Object)HTML.Attribute.CLASS, classAtt);
                classAtt.addClass(this.classAppendix);
            } else {
                ClassValue classAtt = (ClassValue)value;
                ArrayList<Object> classes = classAtt.getClassNames();
                boolean skip = false;
                if (classes != null && classes.size() > 0) {
                    for (Object clazz : classes) {
                        if (clazz.getClass() != String.class || !clazz.toString().startsWith("jwe-style")) continue;
                        skip = true;
                        break;
                    }
                }
                if (!skip) {
                    classAtt.addClass(this.classAppendix);
                }
            }
        }
    }

    private void throwCharsetException(String contentValue, boolean charsetkey) throws ChangedCharSetException {
        contentValue = contentValue.replaceAll("(?i)gb2312|euc_cn|GB18030", "GBK");
        if (charsetkey) {
            this.charset = contentValue;
        }
        throw new ChangedCharSetException(contentValue, charsetkey);
    }

    private boolean isCharsetSetByHTTP() {
        String contentType = (String)this.doc.getProperty("content-type");
        return contentType != null && contentType.contains("charset");
    }

    private void addContentToken(boolean closeElement) throws BadLocationException {
        Element prevElement;
        char endChar;
        if (this.state.isInTitle) {
            this.state.isInTitle = false;
            this.doc.getDocumentProperties().put("title", this.state.getContentAndReset().trim());
            this.state.isFirstTextInLine = true;
            return;
        }
        if (this.state.content.length() == 0) {
            return;
        }
        this.checkForBodyTag();
        String contentString = this.state.getContentAndReset();
        if (this.state.isInTableStructure()) {
            this.switchToTableFallback();
        }
        this.state.crInsertLevel = this.state.getParentElement();
        if (closeElement && this.state.wasWhitespace && contentString.length() > 0 && InetHtmlDocument.isParagraph(this.state.getParentElement()) && (this.state.getParentElement().getElementCount() == 0 || this.state.getParentElement().getElementCount() <= this.state.getElementIdx()) && ((endChar = contentString.charAt(contentString.length() - 1)) == ' ' || endChar == '\t')) {
            contentString = contentString.substring(0, contentString.length() - 1);
        }
        if (this.state.getElementIdx() > 0 && this.state.tagStack.size() > maximumStackSize && (prevElement = this.state.getParentElement().getElement(this.state.getElementIdx() - 1)).isLeaf() && !ElementUtils.isEndMarker(prevElement) && prevElement.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            this.insertString(this.state.getOffset() - 1, contentString);
            return;
        }
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        attrs.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
        this.addLeafElement(attrs, contentString);
    }

    private void checkForBodyTag() throws BadLocationException {
        if (HTML.Tag.HTML != this.state.getParentName() || this.state.isInBody) {
            return;
        }
        this.removeTag((Object)HTML.Tag.HEAD, false);
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        attrs.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
        this.addBranchElement(attrs);
    }

    private void checkForBodyTag(HTML.Tag tag) throws BadLocationException {
        if (tag != null) {
            switch (tag) {
                case STYLE: 
                case LINK: 
                case SCRIPT: 
                case META: 
                case HEAD: {
                    return;
                }
            }
        }
        this.checkForBodyTag();
    }

    protected static boolean isMonolithic(Element elem) {
        AttributeSet atts = elem.getAttributes();
        if (atts.containsAttribute("CR", Boolean.TRUE)) {
            return true;
        }
        if (atts.containsAttribute("/", Boolean.TRUE)) {
            return true;
        }
        Object tag = atts.getAttribute(StyleConstants.NameAttribute);
        if (tag instanceof HTML.Tag) {
            return ElementUtils.isMonolithic((HTML.Tag)((Object)tag));
        }
        return atts.containsAttribute("/", Boolean.TRUE);
    }

    private boolean isSkipOnInsert(HTML.Tag tag) {
        if (!this.isInsert()) {
            return false;
        }
        switch (tag) {
            case HTML: 
            case META: 
            case BODY: 
            case HEAD: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNeedNoEndTag(HTML.Tag tag) {
        if (tag == null) {
            return false;
        }
        switch (tag) {
            case P: 
            case LI: 
            case TD: 
            case TR: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: 
            case TH: {
                return true;
            }
        }
        return false;
    }

    private static boolean isParagraph(HTML.Tag tag) {
        switch (tag) {
            case P: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: {
                return true;
            }
        }
        return false;
    }

    private static boolean isParagraphTerminator(HTML.Tag tag) {
        switch (tag) {
            case P: 
            case LI: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: 
            case ADDRESS: 
            case BLOCKQUOTE: 
            case DD: 
            case DIV: 
            case DL: 
            case DT: 
            case FORM: 
            case OL: 
            case PRE: 
            case UL: {
                return true;
            }
        }
        return false;
    }

    private Element removeEmptyElement(Element toRemove, Element stop) {
        while (toRemove != null && toRemove.getElementCount() == 0 && toRemove != stop) {
            AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)toRemove.getParentElement();
            if (parent == null) {
                return toRemove;
            }
            int number = parent.getIndex((TreeNode)((Object)toRemove));
            if (number < 0) {
                return parent;
            }
            this.replaceElements(parent, number, EMPTY, new Element[]{toRemove});
            toRemove = parent;
        }
        return toRemove;
    }

    private Element removeTagThatNeedNoEndtag(HTML.Tag tag, AttributeSet attrs) throws BadLocationException {
        if (InetHtmlParser.isNeedNoEndTag(tag)) {
            AbstractDocument.BranchElement parent;
            boolean isPara = InetHtmlParser.isParagraph(tag);
            Element startElem = parent = this.state.getParentElement();
            int initPos = this.state.getOffset() - 1;
            while (this.state == this.rootState && parent != null || this.state != this.rootState && parent != this.state.rootElement) {
                byte displayvalue = StyleResolver.getAttributeValue(parent, AttributeFinder.DISPLAY).getDisplay();
                if (displayvalue != 2) {
                    HTML.Tag parentTag;
                    Object nameAtt = parent.getAttribute(StyleConstants.NameAttribute);
                    HTML.Tag tag2 = parentTag = nameAtt instanceof HTML.Tag ? (HTML.Tag)((Object)nameAtt) : null;
                    if (parentTag != null && (parentTag == tag || isPara && InetHtmlParser.isParagraph(parentTag))) {
                        AbstractDocument.BranchElement returnElem = null;
                        if (startElem.getElementCount() == 0 && startElem != parent) {
                            startElem = this.removeEmptyElement(startElem, parent);
                            this.state.setInsertPointAtTheEndOf(startElem);
                        }
                        if (!this.removeTag((Object)parentTag, false)) {
                            returnElem = this.splitBranchElementIfNeeded(parent, attrs);
                        }
                        if (initPos > startElem.getStartOffset()) {
                            int c;
                            int n = c = initPos > 0 ? (int)this.doc.getContentImpl().getString(initPos - 1, 1).charAt(0) : 0;
                            if (c == 32 || c == 9) {
                                Element leaf = ElementUtils.getLeafAt(this.state.rootElement, initPos - 1);
                                if (leaf != null && leaf.getEndOffset() - leaf.getStartOffset() == 1) {
                                    this.doc.removeCompleteImpl(leaf, this.eventList);
                                }
                                this.removeString(initPos - 1, 1);
                            }
                        }
                        return returnElem;
                    }
                    if (!InetHtmlParser.isNeedNoEndTag(parentTag) || isPara) break;
                }
                parent = (AbstractDocument.BranchElement)parent.getParentElement();
            }
        }
        if (this.state.isInParagraph && InetHtmlParser.isParagraphTerminator(tag)) {
            if (!this.state.tagStack.contains((Object)HTML.Tag.P)) {
                this.state.isInParagraph = false;
                return null;
            }
            for (AbstractDocument.BranchElement parent = this.state.getParentElement(); this.state == this.rootState && parent != null || this.state != this.rootState && parent != this.state.rootElement; parent = (AbstractDocument.BranchElement)parent.getParentElement()) {
                Object nameAtt = parent.getAttribute(StyleConstants.NameAttribute);
                this.removeTag(nameAtt, false);
                if (this.state.isInParagraph) continue;
                return this.addBranchElement(attrs);
            }
        }
        return null;
    }

    private AbstractDocument.BranchElement splitBranchElementIfNeeded(AbstractDocument.BranchElement branch, AttributeSet attrs) {
        AbstractDocument.BranchElement parentParent;
        block6: {
            if (!this.isInsert()) {
                return branch;
            }
            parentParent = (AbstractDocument.BranchElement)branch.getParent();
            if (parentParent == null) {
                return null;
            }
            if (ElementUtils.isRelated(this.state.rootElement, branch)) {
                this.state.rootElement = parentParent;
            }
            try {
                if (this.state.getOffset() - 1 >= branch.getStartOffset()) {
                    this.doc.splitElement(branch, this.state.getOffset() - 1, attrs, this.eventList, false, true);
                }
            }
            catch (BadLocationException e) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error(e);
            }
        }
        this.state.setInsertPoint(0, (AbstractDocument.BranchElement)parentParent.getElement(parentParent.getElementIndex(this.state.getOffset() - 1)));
        return this.state.getParentElement();
    }

    private boolean skipTagIfNamespace(String tagName) throws IOException {
        if ("iframe".equalsIgnoreCase(tagName)) {
            this.reader.read();
            return true;
        }
        if (this.ignoreNamespaces && tagName.indexOf(58) >= 0) {
            return this.reader.skipTag();
        }
        return false;
    }

    private MutableAttributeSet parseAttributes(HTML.Tag tag) throws IOException {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        String key;
        block6: while ((key = this.reader.readKey()) != null) {
            int ch;
            key = key.toLowerCase();
            do {
                ch = this.reader.read();
                switch (ch) {
                    case 60: {
                        return tag != null && ElementUtils.isMonolithic(tag) ? attrs : null;
                    }
                    case -1: 
                    case 62: {
                        if (key.length() > 0) {
                            this.addEmptyValue(tag, attrs, key);
                        }
                        return attrs;
                    }
                    case 61: {
                        String value = this.reader.readValue();
                        HTML.Attribute attr = HTML.getAttributeKey(key);
                        if (attr == HTML.Attribute.STYLE) {
                            new CssParser(value, this.styles, this.url, this.dropUnknownStyles, this.isInsert).parseStyle(attrs);
                            attrs.addAttribute((Object)attr, value);
                            continue block6;
                        }
                        if (attr != null) {
                            AttributeValue val = AttributeValue.convertValue(this.doc, tag, attr, value);
                            attrs.addAttribute((Object)attr, val == null ? InetHtmlDocument.getCachedString(value) : val);
                            continue block6;
                        }
                        if (key.toLowerCase().startsWith("on")) continue block6;
                        attrs.addAttribute(new HTML.UnknownAttribute(key), InetHtmlDocument.getCachedString(value));
                        continue block6;
                    }
                    case 47: {
                        if (tag != null) continue block6;
                        attrs.addAttribute("/", Boolean.TRUE);
                        continue block6;
                    }
                }
            } while (Character.isWhitespace(ch));
            this.reader.push((char)ch);
            this.addEmptyValue(tag, attrs, key);
        }
        return tag != null && ElementUtils.isMonolithic(tag) ? attrs : null;
    }

    private void addEmptyValue(HTML.Tag tag, MutableAttributeSet attrs, String key) {
        HTML.Attribute attr = HTML.getAttributeKey(key);
        if (attr != null) {
            AttributeValue value = AttributeValue.convertValue(this.doc, tag, attr, null);
            if (value == null) {
                attrs.addAttribute((Object)attr, EmptyValue.PARSER);
            } else {
                attrs.addAttribute((Object)attr, value);
            }
        } else {
            attrs.addAttribute(key, EmptyValue.PARSER);
        }
    }

    private void finishParse(InetHtmlDocument.EventList eventList) throws BadLocationException {
        Object toClose;
        int pos;
        if (this.state.isInTableStructure()) {
            this.addContentToken(true);
        }
        if (this.state != this.rootState) {
            this.state.deactivate();
            this.addContentToken(true);
            this.state = this.rootState;
        }
        if (this.tableStack.size() > 0) {
            for (int i = this.tableStack.size() - 1; i >= 0; --i) {
                this.tableStack.remove(i).finalizeState();
            }
        }
        this.state.isOnFinish = true;
        this.addContentToken(true);
        boolean insertCR = this.state.tagStack.contains((Object)HTML.Tag.TABLE);
        if (!insertCR && (pos = this.state.pos.getOffset() - 2) >= 0) {
            Element lastLeaf = this.state.getParentElement().getChildCount() > 0 ? ElementUtils.getLeafAt(this.state.getParentElement(), pos) : this.state.getParentElement();
            insertCR |= ElementUtils.findParentByTag(lastLeaf, HTML.Tag.TABLE) != null;
            if (lastLeaf instanceof InetHtmlDocument.ContentElement && !ElementUtils.isEndMarker(lastLeaf)) {
                boolean endOfDocument;
                Element nextP;
                Element nextLeaf = ElementUtils.getLeafAt(this.state.getParentElement(), pos + 1);
                Element lastP = ElementUtils.getParagraphFor(lastLeaf);
                boolean differentParagraph = lastP != (nextP = ElementUtils.getParagraphFor(nextLeaf));
                boolean missingMarker = nextP.getElement(nextP.getElementCount() - 1) == nextLeaf && !ElementUtils.isEndMarker(nextLeaf);
                boolean bl = endOfDocument = this.state.pos.getOffset() > this.doc.getLength();
                if (differentParagraph || missingMarker || endOfDocument) {
                    insertCR = true;
                }
            }
        }
        if (!(this.state.tagStack.isEmpty() || this.state.parentElement.getElementCount() != 0 && this.state.parentElement.getEndOffset() != this.state.parentElement.getStartOffset() || InetHtmlParser.isMonolithic(this.state.parentElement) || (toClose = this.state.tagStack.get(this.state.tagStack.size() - 1)) == HTML.Tag.HTML)) {
            this.addCRMarker();
        }
        for (int i = this.state.tagStack.size() - 1; i >= 0; --i) {
            i = Math.min(i, this.state.tagStack.size() - 1);
            Object tag = this.state.tagStack.get(i);
            if (insertCR && (tag == HTML.Tag.BODY || tag == HTML.Tag.HTML)) {
                Element body;
                if (tag == HTML.Tag.BODY) {
                    this.addCRMarker();
                    insertCR = false;
                }
                if (tag == HTML.Tag.HTML && (body = ElementUtils.getBodyElement(this.doc)) != null) {
                    AbstractDocument.BranchElement currentRoot = this.state.getParentElement();
                    int index = this.state.getElementIdx();
                    this.state.setInsertPointAtTheEndOf((AbstractDocument.BranchElement)body);
                    this.addCRMarker();
                    this.state.setInsertPoint(index, currentRoot);
                }
            }
            this.removeTag(tag, false);
        }
        this.state.finalizeState();
    }

    private boolean removeTag(Object tag, boolean onFinish) throws BadLocationException {
        if (this.state != this.rootState && (TABLE_CELL_TAGS.contains(tag) || TABLE_STRUCT_TAGS.contains(tag))) {
            this.state.deactivate();
            this.state = this.rootState;
        }
        if (tag == HTML.Tag.HTML || tag == HTML.Tag.BODY) {
            return false;
        }
        int removeIndex = this.state.tagStack.size() - 1;
        boolean inTable = this.state.isInTableStructure();
        if (removeIndex > maximumStackSize) {
            Object currentTag = this.state.tagStack.get(removeIndex);
            while (removeIndex > maximumStackSize && currentTag != tag && removeIndex > 0) {
                currentTag = this.state.tagStack.get(--removeIndex);
                if (currentTag == HTML.Tag.TABLE && tag != currentTag && !onFinish) {
                    return false;
                }
                if ((inTable || tag != HTML.Tag.TH) && tag != HTML.Tag.TD) continue;
                inTable = true;
            }
        }
        Element elem = this.state.getParentElement();
        if (removeIndex <= maximumStackSize) {
            while (elem != null && elem != this.state.rootElement) {
                Object elemTag = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (elemTag == HTML.Tag.TABLE && tag != elemTag && !onFinish) {
                    return false;
                }
                if (!inTable && tag == HTML.Tag.TH || tag == HTML.Tag.TD) {
                    inTable = true;
                }
                if (tag == elemTag) break;
                elem = elem.getParentElement();
                --removeIndex;
            }
            if (elem == null || elem == this.state.rootElement || elem.getParentElement() == null) {
                return false;
            }
        }
        if (tag == HTML.Tag.TABLE) {
            if (this.tableStack.size() > 0) {
                this.tableStack.remove(this.tableStack.size() - 1).finalizeState();
            }
            inTable = false;
            this.state.setInTableStructure(false);
            this.state.isInParagraph = this.state.tagStack.indexOf((Object)HTML.Tag.P) > this.state.tagStack.indexOf((Object)HTML.Tag.TABLE);
        }
        while (this.state.tagStack.size() > removeIndex) {
            Object remTag = this.state.tagStack.remove(this.state.tagStack.size() - 1);
            if (remTag != HTML.Tag.P) continue;
            this.state.isInParagraph = false;
        }
        if (tag == HTML.Tag.P) {
            this.state.isInParagraph = false;
        }
        if (this.state.tagStack.size() > maximumStackSize) {
            this.state.setInTableStructure(inTable);
            return true;
        }
        if (this.state.getParentElement().getChildCount() == 0) {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            attrs.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            if (this.currentConfig.isTransformEmptyBlocks() && this.state.isInBody && ElementUtils.isBlockElement(elem)) {
                attrs.addAttribute("CR", Boolean.TRUE);
                this.addLeafElement(attrs, "\n");
            } else {
                this.addLeafElement(attrs, "");
            }
        }
        if (this.state.getOffset() - 1 < elem.getEndOffset() && !this.state.isOnFinish && this.state.isInBody) {
            Element leaf;
            AbstractDocument.BranchElement parent;
            Element rightNode = elem = this.splitBranchElementIfNeeded((AbstractDocument.BranchElement)elem, elem.getAttributes());
            int indexRight = (parent = (AbstractDocument.BranchElement)elem.getParentElement()).getIndex((AbstractDocument.BranchElement)elem);
            int indexLeft = indexRight - 1;
            elem = parent.getElement(indexLeft >= 0 ? indexLeft : 0);
            if (rightNode.getEndOffset() - rightNode.getStartOffset() == 1 && (leaf = ElementUtils.getLeafAt(rightNode, rightNode.getStartOffset())) != null && ElementUtils.isEndMarker(leaf)) {
                this.replaceElements(parent, indexRight, EMPTY, new Element[]{rightNode});
                this.removeString(rightNode.getStartOffset(), 1);
            }
        }
        if (this.state.getOffset() - 1 == elem.getEndOffset() && InetHtmlParser.breaksFlow(elem)) {
            Element leaf;
            char c;
            Element prevElem = ElementUtils.getLeafAt(elem, elem.getEndOffset() - 1);
            if (prevElem == null || !ElementUtils.isEndMarker(prevElem)) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                attrs.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                attrs.addAttribute("CR", Boolean.TRUE);
                if (this.currentConfig.isTransformEmptyBlocks()) {
                    String content;
                    int size = elem.getEndOffset() - elem.getStartOffset();
                    AbstractDocument.Content docContent = this.doc.getContentImpl();
                    String string = content = this.state.getOffset() > 1 ? docContent.getString(this.state.getOffset() - 2, 1) : "X";
                    if (size == 1 && content.charAt(0) == '\u00a0') {
                        int editOffset = this.state.getOffset() - 1;
                        Element leaf2 = ElementUtils.getLeafAt(elem, editOffset - 1);
                        this.doc.addAttribute(leaf2.getAttributes(), "CR", Boolean.TRUE);
                        this.insertString(editOffset, "\n");
                        this.removeString(editOffset - 1, 1);
                        this.state.isFirstTextInLine = true;
                    } else {
                        if (this.state.crInsertLevel != null) {
                            this.state.setInsertPointAtTheEndOf(this.state.crInsertLevel);
                            if (this.state.getElementIdx() > 0 && InetHtmlParser.getLength(this.state.crInsertLevel) == 0 && this.state.crInsertLevel.getElement(this.state.getElementIdx() - 1) instanceof InetHtmlDocument.ContentElement) {
                                this.removeEmptyElement(this.state.crInsertLevel.getElement(this.state.getElementIdx() - 1), this.state.crInsertLevel);
                                this.state.setInsertPoint(this.state.getElementIdx() - 1, this.state.getParentElement());
                            }
                        } else {
                            this.state.setInsertPointAtTheEndOf((AbstractDocument.BranchElement)elem);
                        }
                        this.addLeafElement(attrs, "\n");
                        this.state.setInsertPointAtTheEndOf((AbstractDocument.BranchElement)elem);
                        this.state.isFirstTextInLine = true;
                    }
                } else {
                    if (this.state.crInsertLevel != null) {
                        this.state.setInsertPointAtTheEndOf(this.state.crInsertLevel);
                    } else {
                        this.state.setInsertPointAtTheEndOf((AbstractDocument.BranchElement)elem);
                    }
                    this.addLeafElement(attrs, "\n");
                    this.state.setInsertPointAtTheEndOf((AbstractDocument.BranchElement)elem);
                    this.state.isFirstTextInLine = true;
                }
            } else {
                this.state.isFirstTextInLine = true;
            }
            int endOffs = elem.getEndOffset();
            if (!(endOffs - elem.getStartOffset() <= 1 || this.state.isPreformatted || (c = this.doc.getContentImpl().getString(endOffs - 2, 1).charAt(0)) != ' ' && c != '\t' || (leaf = ElementUtils.getLeafAt(this.state.rootElement, endOffs - 2)) == null)) {
                boolean blockedByPRE = false;
                for (Element parent = leaf.getParentElement(); parent != null && parent != elem; parent = parent.getParentElement()) {
                    if (!InetHtmlParser.isPreformatted(parent)) continue;
                    blockedByPRE = true;
                    break;
                }
                if (!blockedByPRE) {
                    if (leaf.getEndOffset() - leaf.getStartOffset() == 1) {
                        this.doc.removeCompleteImpl(leaf, this.eventList);
                    }
                    this.removeString(endOffs - 2, 1);
                }
            }
        }
        this.state.setInTableStructure(inTable);
        AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)elem.getParentElement();
        this.state.setInsertPoint(parent.getIndex((AbstractDocument.BranchElement)elem) + 1, parent);
        this.state.isPreformatted = InetHtmlParser.isPreformatted(this.state.getParentElement());
        return true;
    }

    private boolean isEquals(Element elem, Object tag) {
        return tag == elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    private void parseStyle() throws IOException {
        CssParser cssParser = new CssParser(this.reader, this.styles, this.currentSource, this.url, this.dropUnknownStyles, this.isInsert, true);
        this.classAppendix = cssParser.parseWithID();
        this.doc.getStyleResolver().optimize();
        if (this.state.rootElement != null && this.state.rootElement.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) {
            this.doc.getStyleResolver().fillAttributesNonLocked(this.state.rootElement, null);
        }
    }

    private void parseLink(MutableAttributeSet attrs) {
        block11: {
            try {
                Object rel = attrs.getAttribute((Object)HTML.Attribute.REL);
                Object media = attrs.getAttribute((Object)HTML.Attribute.MEDIA);
                Object type = attrs.getAttribute((Object)HTML.Attribute.TYPE);
                Object href = attrs.getAttribute((Object)HTML.Attribute.HREF);
                if (rel == null || !rel.toString().equalsIgnoreCase("stylesheet") || type != null && !type.toString().equalsIgnoreCase("text/css") || media != null && !media.toString().equalsIgnoreCase("all") && !media.toString().toLowerCase().contains("screen") || href == null) break block11;
                String link = href.toString();
                URL cssUrl = new URL(this.url, link);
                try {
                    cssUrl.toURI();
                    CssParser cssParser = new CssParser(cssUrl, this.currentSource == null ? null : cssUrl, this.styles, this.charset, this.dropUnknownStyles);
                    InetHtmlDocument.TimeoutProvider timeoutProvider = this.doc.getTimeoutProvider();
                    if (timeoutProvider != null) {
                        cssParser.setConnectionTimtout(timeoutProvider.getTimeout(cssUrl));
                    }
                    cssParser.parse();
                    this.doc.getStyleResolver().optimize();
                    if (this.state.rootElement != null && this.state.rootElement.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) {
                        this.doc.getStyleResolver().fillAttributesNonLocked(this.state.rootElement, null);
                    }
                }
                catch (URISyntaxException e) {
                    if (Logger.doesLog(2)) {
                        Logger.error(e.getMessage());
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to find the referenced CSS: " + e.getMessage());
                }
            }
            catch (MalformedURLException e) {
                if (Logger.doesLog(3)) {
                    Logger.info("Issue while parsing link HREF: " + e.getMessage());
                }
            }
            catch (Exception e) {
                if (!Logger.doesLog(1)) break block11;
                Logger.error(e);
            }
        }
    }

    private void parseDocType() throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int ch = this.reader.read();
            switch (ch) {
                case -1: 
                case 62: {
                    this.doc.getDocType().parseDocType(builder.toString());
                    return;
                }
            }
            builder.append((char)ch);
        }
    }

    static boolean breaksFlow(Element elem) {
        FloatValue floatValue;
        Object attribute = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (attribute == HTML.Tag.BR) {
            return true;
        }
        if (attribute == HTML.Tag.CONTENT) {
            return false;
        }
        FloatValue floatObj = StyleResolver.getAttributeValue(elem, AttributeFinder.FLOAT);
        if (floatObj != null && ((floatValue = floatObj).getFloat() == 3 || floatValue.getFloat() == 2)) {
            return true;
        }
        DisplayValue display = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        switch (display.getDisplay()) {
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    private static boolean isPreformatted(Element elem) {
        WhiteSpace whiteSpace = StyleResolver.getAttributeValue(elem, AttributeFinder.WHITE_SPACE);
        boolean collapseSpaces = true;
        if (whiteSpace != null) {
            collapseSpaces = whiteSpace.isCollapseSpaces();
        }
        return !collapseSpaces;
    }

    private Element addLeafElement(AttributeSet attrs, String text) throws BadLocationException {
        Object name;
        if (this.state.isInTableStructure() && (name = attrs.getAttribute(StyleConstants.NameAttribute)) != HTML.Tag.COL && (!attrs.isDefined("CR") || attrs.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT) && text.length() > 0) {
            this.switchToTableFallback();
        }
        name = attrs.getAttribute(StyleConstants.NameAttribute);
        if (this.state.isInBody && name == HTML.Tag.META) {
            return null;
        }
        int editOffset = this.state.getOffset();
        if (text.length() > 0 && this.state.isInBody) {
            AbstractDocument.Content docContent = this.doc.getContentImpl();
            char c = docContent.getString(editOffset - 1, 1).charAt(0);
            this.insertString(editOffset, text + c);
            this.removeString(editOffset - 1, 1);
        }
        this.state.crInsertLevel = this.state.getParentElement();
        InetHtmlDocument.ContentElement elem = this.doc.createLeafElement((Element)this.state.getParentElement(), attrs, editOffset - 1, editOffset - 1 + (this.state.isInBody ? text.length() : 0));
        if (this.isInsert && name == HTML.Tag.IMG && attrs.isDefined((Object)HTML.Attribute.SRC)) {
            MutableAttributeSet elemAtts = (MutableAttributeSet)elem.getAttributes();
            DocumentImage documentImage = new DocumentImage(null, elem);
            documentImage.setURL(attrs.getAttribute((Object)HTML.Attribute.SRC).toString());
            elemAtts.addAttribute(StyleConstants.IconAttribute, documentImage);
        }
        this.appendElement(elem);
        return elem;
    }

    private void insertString(int index, String text) throws BadLocationException {
        this.eventList.addEvent(this.doc.getContentImpl().insertString(index, text));
    }

    private void removeString(int index, int length) throws BadLocationException {
        this.eventList.addEvent(this.doc.getContentImpl().remove(index, length));
    }

    private AbstractDocument.BranchElement addBranchElement(AttributeSet attrs) throws BadLocationException {
        AbstractDocument.BranchElement elem;
        Object name;
        block24: {
            name = attrs.getAttribute(StyleConstants.NameAttribute);
            if (name == HTML.Tag.BODY) {
                if (this.state.isInBody) {
                    return null;
                }
                this.state.isInBody = true;
            }
            if (this.state.isInBody && (name == HTML.Tag.HTML || name == HTML.Tag.HEAD)) {
                return null;
            }
            if (name != HTML.Tag.TABLE) {
                if (this.state.isInTableStructure()) {
                    if (TABLE_CELL_TAGS.contains(name)) {
                        this.state.setInTableStructure(false);
                    } else if (!TABLE_STRUCT_TAGS.contains(name)) {
                        this.switchToTableFallback();
                    }
                } else if (this.state != this.rootState && (TABLE_CELL_TAGS.contains(name) || TABLE_STRUCT_TAGS.contains(name))) {
                    this.state.deactivate();
                    this.state = this.rootState;
                    if (TABLE_CELL_TAGS.contains(name)) {
                        this.state.setInTableStructure(false);
                    }
                }
            } else {
                if (this.state != this.rootState || this.state.isInTableStructure()) {
                    if (this.state != this.rootState) {
                        this.state.deactivate();
                        if (this.tableStack.size() > 0) {
                            this.tableStack.remove(this.tableStack.size() - 1).finalizeState();
                        }
                        this.state = this.rootState;
                    }
                    if (this.state.isInTableStructure()) {
                        this.removeTag((Object)HTML.Tag.TABLE, false);
                        this.state.setInTableStructure(false);
                    }
                } else if (this.state.pos.getOffset() <= 1 && this.state == this.rootState) {
                    this.addCRMarker();
                }
                this.state.isInParagraph = false;
            }
            elem = this.doc.createBranchElement((Element)this.state.getParentElement(), attrs);
            try {
                elem = this.checkParent(elem);
            }
            catch (BadLocationException e1) {
                if (!Logger.doesLog(1)) break block24;
                Logger.error(e1);
            }
        }
        elem = this.checkPrequirements(elem);
        if (elem == null) {
            return null;
        }
        this.appendElement(elem);
        if (name == HTML.Tag.TABLE) {
            ParserState fallback = new ParserState(this.state.getParentElement(), this.state.getOffset() - 1, this.state.getElementIdx() - 1);
            fallback.isInBody = this.state.isInBody;
            fallback.tagStack.addAll(this.state.tagStack);
            fallback.isInParagraph = fallback.tagStack.contains((Object)HTML.Tag.P);
            this.tableStack.add(fallback);
        }
        if (this.state == this.rootState && TABLE_STRUCT_TAGS.contains(name)) {
            this.state.setInTableStructure(true);
        }
        if (this.state.tagStack.size() <= maximumStackSize) {
            this.state.setInsertPoint(0, elem);
        }
        return elem;
    }

    private void addCRMarker() throws BadLocationException {
        SimpleAttributeSet atts = new SimpleAttributeSet();
        atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
        atts.addAttribute("CR", Boolean.TRUE);
        this.addLeafElement(atts, "\n");
    }

    private void switchToTableFallback() throws BadLocationException {
        if (this.tableStack.size() == 0) {
            return;
        }
        ParserState fallback = this.tableStack.get(this.tableStack.size() - 1);
        fallback.activate();
        this.state = fallback;
    }

    private void appendElement(Element elem) {
        Element prevElem;
        Object tag = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (!elem.isLeaf()) {
            this.state.tagStack.add(tag);
            if (this.state.tagStack.size() > maximumStackSize) {
                return;
            }
            if (tag == HTML.Tag.P) {
                this.state.isInParagraph = true;
            }
        }
        this.replaceElements(this.state.getParentElement(), this.state.getElementIdx(), new Element[]{elem}, EMPTY);
        this.state.setInsertPoint(this.state.getElementIdx() + 1, this.state.getParentElement());
        this.doc.fillAttributes(elem);
        if (elem instanceof AbstractDocument.BranchElement && InetHtmlDocument.isParagraph(elem) && tag != HTML.Tag.BODY && (prevElem = ElementUtils.getPreviousContent(elem)) != null && !ElementUtils.isEndMarker(prevElem) && prevElem.getEndOffset() - prevElem.getStartOffset() > 0 && !ElementUtils.isBlockElement(prevElem)) {
            try {
                int splitPos = prevElem.getEndOffset();
                int index = ElementUtils.getChildIndex(prevElem.getParentElement(), prevElem);
                this.insertString(splitPos, "\n");
                this.doc.splitContentElement(prevElem, splitPos, this.eventList);
                Element parent = prevElem.getParentElement();
                prevElem = parent.getElement(index + 1);
                MutableAttributeSet atts = (MutableAttributeSet)prevElem.getAttributes();
                ElementUtils.clearTemp(atts);
                atts.removeAttribute(StyleConstants.IconAttribute);
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                atts.addAttribute("CR", Boolean.TRUE);
                this.doc.fillAttributes(prevElem);
                this.updateInsertPosition(this.rootState, parent, index);
                if (this.tableStack.size() > 0) {
                    for (ParserState state : this.tableStack) {
                        this.updateInsertPosition(state, parent, index);
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
        }
    }

    private void updateInsertPosition(ParserState state, Element parent, int insertedAt) {
        if (parent == state.getParentElement() && insertedAt <= state.elementIdx) {
            state.setInsertPoint(state.getElementIdx() + 1, state.getParentElement());
        }
    }

    private void checkForUtf8Prefix() throws IOException, ChangedCharSetException {
        this.reader.checkForUtf8Prefix();
    }

    private boolean isInsert() {
        return this.isInsert;
    }

    private AbstractDocument.BranchElement checkPrequirements(AbstractDocument.BranchElement elementToGenerate) {
        Object newElemName = elementToGenerate.getAttributes().getAttribute(StyleConstants.NameAttribute);
        TagList reqList = PARENT_REQUIRED.get(newElemName);
        if (reqList != null) {
            Object parentName = this.state.getParentName();
            if (parentName == HTML.Tag.FORM && this.state.getParentElement().getParent() != null) {
                parentName = this.state.getParentElement().getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            if (!reqList.contains(parentName)) {
                if (reqList.isAutoCreate()) {
                    Object reqTag = reqList.get(0);
                    InetHtmlDocument.BoxElement createdParent = this.doc.createBranchElement((Element)this.state.getParentElement(), reqTag);
                    AbstractDocument.BranchElement newParent = this.checkPrequirements(createdParent);
                    if (newParent != null) {
                        this.appendElement(newParent);
                        if (this.state.tagStack.size() <= maximumStackSize) {
                            this.state.setInsertPoint(0, newParent);
                        }
                        InetHtmlDocument.BoxElement elemCopy = this.doc.createBranchElement((Element)this.state.getParentElement(), elementToGenerate.getAttributes());
                        return elemCopy;
                    }
                    return null;
                }
                return null;
            }
        }
        return elementToGenerate;
    }

    private AbstractDocument.BranchElement checkParent(AbstractDocument.BranchElement elementToGenerate) throws BadLocationException {
        Object newElemName = elementToGenerate.getAttributes().getAttribute(StyleConstants.NameAttribute);
        TagList parentNameRequirement = PARENT_FORBIDDEN.get(newElemName);
        if (parentNameRequirement != null) {
            List fList = parentNameRequirement;
            Object parentName = this.state.getParentName();
            if (parentName == HTML.Tag.FORM && this.state.getParentElement().getParent() != null) {
                parentName = this.state.getParentElement().getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            if (newElemName == HTML.Tag.TR && parentName == HTML.Tag.TD) {
                parentName = HTML.Tag.TR;
            }
            if (parentName instanceof HTML.Tag && fList.contains(parentName)) {
                if (!this.removeTag(parentName, false)) {
                    return elementToGenerate;
                }
                InetHtmlDocument.BoxElement elemCopy = this.doc.createBranchElement((Element)this.state.getParentElement(), elementToGenerate.getAttributes());
                return this.checkParent(elemCopy);
            }
        }
        return elementToGenerate;
    }

    private static int getLength(Element elem) {
        if (elem.getElementCount() == 0) {
            return 0;
        }
        return elem.getEndOffset() - elem.getStartOffset();
    }

    public int[] getContentOffsets() {
        if (this.startFragment != null && this.endFragment != null) {
            return new int[]{this.startFragment.getOffset(), this.endFragment.getOffset()};
        }
        return null;
    }

    private void replaceElements(AbstractDocument.BranchElement parent, int index, Element[] adds, Element[] removes) {
        this.eventList.getEventFor(parent, index, removes, adds);
        parent.replace(index, removes != null ? removes.length : 0, adds);
    }

    static {
        PARENT_REQUIRED.put(HTML.Tag.TD, new TagList(true, HTML.Tag.TR));
        PARENT_REQUIRED.put(HTML.Tag.TH, new TagList(true, HTML.Tag.TR));
        PARENT_REQUIRED.put(HTML.Tag.TR, new TagList(true, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT));
        PARENT_REQUIRED.put(HTML.Tag.TBODY, new TagList(false, HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.THEAD, new TagList(false, HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.TFOOT, new TagList(false, HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.CAPTION, new TagList(true, HTML.Tag.TABLE, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT));
        PARENT_REQUIRED.put(HTML.Tag.COL, new TagList(true, HTML.Tag.COLGROUP));
        PARENT_REQUIRED.put(HTML.Tag.COLGROUP, new TagList(true, HTML.Tag.TABLE, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT));
        PARENT_FORBIDDEN.put(HTML.Tag.TABLE, new TagList(HTML.Tag.TR, HTML.Tag.TABLE, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT, HTML.Tag.COL, HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.LI, new TagList(HTML.Tag.LI));
        PARENT_FORBIDDEN.put(HTML.Tag.A, new TagList(HTML.Tag.A));
        PARENT_FORBIDDEN.put(HTML.Tag.TR, new TagList(HTML.Tag.COLGROUP, HTML.Tag.COL, HTML.Tag.TR));
        PARENT_FORBIDDEN.put(HTML.Tag.TD, new TagList(HTML.Tag.COLGROUP, HTML.Tag.TD));
        PARENT_FORBIDDEN.put(HTML.Tag.TH, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.TBODY, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.THEAD, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.TFOOT, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.COLGROUP, new TagList(HTML.Tag.COLGROUP));
    }

    private class ParserState {
        private AbstractDocument.BranchElement rootElement;
        private AbstractDocument.BranchElement parentElement;
        private AbstractDocument.BranchElement crInsertLevel;
        private Position pos;
        private int elementIdx;
        private final StringBuilder content = new StringBuilder();
        private boolean isInTitle;
        private boolean isInBody = false;
        private boolean isFirstTextInLine = true;
        private boolean wasWhitespace;
        private boolean wasNBWhitespace;
        private boolean isPreformatted;
        private boolean isOnFinish;
        private boolean isInTableStructure;
        private boolean activated;
        private boolean isInParagraph;
        private int gapOffset;
        private List<Object> tagStack = new ArrayList<Object>(InetHtmlParser.access$2200());

        public ParserState(AbstractDocument.BranchElement root, int insertOffset, int elementIndex) throws BadLocationException {
            this.rootElement = root;
            this.parentElement = root;
            this.gapOffset = insertOffset == 0 ? 0 : -1;
            this.pos = InetHtmlParser.this.doc.getContentImpl().createPosition(insertOffset + this.gapOffset);
            this.elementIdx = elementIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate() throws BadLocationException {
            if (this.activated) {
                return;
            }
            this.activated = true;
            AbstractDocument.Content docContent = InetHtmlParser.this.doc.getContentImpl();
            int insertOffset = this.getOffset();
            this.gapOffset = 0;
            if (this.rootElement.getChildCount() > 0) {
                block23: {
                    Element child;
                    int start;
                    if (this.getElementIdx() < 0) {
                        this.elementIdx = this.rootElement.getElementIndex(insertOffset > 0 ? insertOffset - 1 : 0);
                    }
                    if ((start = ElementUtils.getStartOffset(child = this.rootElement.getElement(this.getElementIdx()))) < 0) {
                        InetHtmlParser.this.insertString(insertOffset, "X");
                        this.pos = docContent.createPosition(insertOffset + 1);
                        if (insertOffset > 0) {
                            try {
                                int level = Logger.getLogLevel();
                                try {
                                    Logger.setLogLevel(-1);
                                    child = ElementUtils.getLeafAt(((InetHtmlParser)InetHtmlParser.this).rootState.rootElement, insertOffset);
                                }
                                finally {
                                    Logger.setLogLevel(level);
                                }
                                if (child != null) {
                                    AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)child.getParentElement();
                                    InetHtmlDocument.ContentElement replace = InetHtmlParser.this.doc.createLeafElement((Element)parent, child.getAttributes(), child.getStartOffset(), insertOffset);
                                    int replaceIndex = parent.getIndex((TreeNode)((Object)child));
                                    InetHtmlParser.this.replaceElements(parent, replaceIndex, new Element[]{replace}, new Element[]{child});
                                    break block23;
                                }
                                --insertOffset;
                            }
                            catch (NullPointerException e) {
                                Logger.debug("Model correction due to several corrupt tables required.");
                                --insertOffset;
                            }
                        }
                    } else if (start < insertOffset) {
                        Element remElement;
                        int end = child.getEndOffset();
                        boolean needSplit = insertOffset != end;
                        InetHtmlParser.this.insertString(insertOffset, " ");
                        Element[] children = new Element[needSplit ? 2 : 1];
                        if (child instanceof AbstractDocument.LeafElement) {
                            children[0] = InetHtmlParser.this.doc.createLeafElement((Element)this.rootElement, child.getAttributes(), start, insertOffset);
                            if (needSplit) {
                                children[1] = InetHtmlParser.this.doc.createLeafElement((Element)this.rootElement, child.getAttributes(), insertOffset + 1, end + 1);
                            }
                        } else {
                            children[0] = InetHtmlParser.this.doc.createBranchElement((Element)this.rootElement, child.getAttributes().copyAttributes());
                            InetHtmlParser.this.doc.createCopy(child, children[0], start, insertOffset);
                            if (needSplit) {
                                children[1] = InetHtmlParser.this.doc.createBranchElement((Element)this.rootElement, child.getAttributes().copyAttributes());
                                InetHtmlParser.this.doc.createCopy(child, children[1], insertOffset + 1, child.getEndOffset());
                            }
                        }
                        Element[] removes = (remElement = this.rootElement.getElement(this.getElementIdx())) != null ? new Element[]{remElement} : new Element[]{};
                        InetHtmlParser.this.replaceElements(this.rootElement, this.elementIdx++, children, removes);
                    } else {
                        String firstChar = docContent.getString(insertOffset, 1);
                        InetHtmlParser.this.insertString(insertOffset + 1, " " + firstChar);
                        InetHtmlParser.this.removeString(insertOffset, 1);
                        AbstractDocument.BranchElement replaceRoot = this.rootElement;
                        int index = this.getElementIdx();
                        if (!(child instanceof AbstractDocument.LeafElement)) {
                            child = ElementUtils.getLeafAt(this.rootElement, insertOffset + 1);
                            replaceRoot = (AbstractDocument.BranchElement)child.getParentElement();
                            index = 0;
                        }
                        Element[] children = new Element[]{InetHtmlParser.this.doc.createLeafElement((Element)replaceRoot, child.getAttributes(), insertOffset + 1, child.getEndOffset())};
                        Element[] removes = new Element[]{replaceRoot.getElement(index)};
                        if (removes[0].getStartOffset() == removes[0].getEndOffset() && replaceRoot.getElementCount() > index + 1) {
                            removes = new Element[]{removes[0], replaceRoot.getElement(index + 1)};
                        }
                        InetHtmlParser.this.replaceElements(replaceRoot, index, children, removes);
                    }
                }
                this.pos = docContent.createPosition(insertOffset + 1);
            } else {
                InetHtmlParser.this.insertString(0, "X");
                this.pos = docContent.createPosition(1);
            }
            if (this.getElementIdx() < 0) {
                this.elementIdx = 0;
            }
        }

        public void deactivate() throws BadLocationException {
            while (this.getParentElement() != this.rootElement) {
                InetHtmlParser.this.removeTag(this.getParentName(), false);
            }
        }

        public Object getParentName() {
            if (this.tagStack.size() <= maximumStackSize) {
                return this.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            return this.tagStack.get(this.tagStack.size() - 1);
        }

        public String getContentAndReset() {
            String content = this.content.toString();
            this.content.setLength(0);
            return content;
        }

        public int getOffset() {
            return this.pos != null ? this.pos.getOffset() - this.gapOffset : -1;
        }

        public void finalizeState() throws BadLocationException {
            if (this.activated) {
                InetHtmlParser.this.eventList.addEvent(InetHtmlParser.this.doc.getContentImpl().remove(this.getOffset() - 1, 1));
                this.pos = null;
            }
        }

        public String toString() {
            int indexOf = InetHtmlParser.this.tableStack.indexOf(this);
            return "[State #" + (indexOf < 0 ? "root" : Integer.toString(indexOf)) + ", active: " + this.activated + "]";
        }

        private void setInTableStructure(boolean isInTableStructure) {
            this.isInTableStructure = isInTableStructure;
        }

        private boolean isInTableStructure() {
            return this.isInTableStructure;
        }

        private AbstractDocument.BranchElement getParentElement() {
            return this.parentElement;
        }

        private int getElementIdx() {
            return this.elementIdx;
        }

        private void setInsertPoint(int elementIdx, AbstractDocument.BranchElement parentElement) {
            this.elementIdx = elementIdx;
            this.parentElement = parentElement;
        }

        private void setInsertPointAtTheEndOf(AbstractDocument.BranchElement parentElement) {
            this.setInsertPoint(parentElement.getElementCount(), parentElement);
        }
    }

    private static class DummyEventList
    extends InetHtmlDocument.EventList {
        private DummyEventList() {
        }

        @Override
        public InetHtmlDocument.ElementEditBuffer getEventFor(Element parent, int index, Element[] removes, Element[] adds) {
            return null;
        }
    }

    private static class TagList
    extends ArrayList<HTML.Tag> {
        private final boolean autoCreate;

        public TagList(boolean autoCreate, HTML.Tag ... tags) {
            this.autoCreate = autoCreate;
            for (HTML.Tag tag : tags) {
                this.add(tag);
            }
        }

        public TagList(HTML.Tag ... tags) {
            this(false, tags);
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }
    }
}

