/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class InetHtmlDocumentIterator
extends HTMLDocument.Iterator {
    private HTML.Tag tag;
    private HTML.Tag secondary;
    private Element pointer;

    protected InetHtmlDocumentIterator(InetHtmlDocument doc, HTML.Tag tag) {
        this.secondary = tag;
        this.pointer = doc.getRootElements()[0];
        if (tag != null) {
            try {
                this.tag = HTML.Tag.valueOf(tag.toString().toUpperCase(Locale.US));
            }
            catch (Exception e) {
                this.tag = null;
            }
        } else {
            this.tag = null;
        }
        this.search();
    }

    private Element getNextElement(Element elem) {
        if (elem.getElementCount() > 0) {
            return elem.getElement(0);
        }
        Element pointerP = elem.getParentElement();
        int index = ElementUtils.getChildIndex(pointerP, elem);
        while (pointerP != null && index == pointerP.getElementCount() - 1) {
            elem = pointerP;
            if ((pointerP = pointerP.getParentElement()) == null) {
                return null;
            }
            index = ElementUtils.getChildIndex(pointerP, elem);
        }
        return pointerP != null ? pointerP.getElement(index + 1) : null;
    }

    private Element search() {
        if (this.pointer == null) {
            return null;
        }
        this.pointer = this.getNextElement(this.pointer);
        do {
            Object nameAtt = this.pointer.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (this.tag != null && nameAtt == this.tag || nameAtt == this.secondary) {
                return this.pointer;
            }
            this.pointer = this.getNextElement(this.pointer);
        } while (this.pointer != null);
        return null;
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.pointer == null) {
            return null;
        }
        AttributeSet origAttributes = this.pointer.getAttributes();
        SimpleAttributeSet set = new SimpleAttributeSet();
        Enumeration<?> names = origAttributes.getAttributeNames();
        while (names.hasMoreElements()) {
            HTML.Attribute oldAtt;
            Object name = names.nextElement();
            if (!(name instanceof HTML.Attribute) || (oldAtt = HTML.getAttributeKey(name.toString())) == null) continue;
            set.addAttribute(oldAtt, origAttributes.getAttribute(name));
        }
        set.addAttributes(origAttributes);
        return set;
    }

    @Override
    public int getEndOffset() {
        return this.pointer != null ? this.pointer.getEndOffset() : 0;
    }

    @Override
    public int getStartOffset() {
        return this.pointer != null ? this.pointer.getStartOffset() : 0;
    }

    @Override
    public HTML.Tag getTag() {
        return this.secondary;
    }

    @Override
    public boolean isValid() {
        return this.pointer != null;
    }

    @Override
    public void next() {
        this.search();
    }
}

