/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ScrollPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private JScrollPane sp;
    private MenuPanel content;
    private WindowAdapter windowAdapter = new WindowAdapter(){

        @Override
        public void windowIconified(WindowEvent e) {
            if (ScrollPopup.this.isVisible()) {
                ScrollPopup.this.setVisible(false);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (ScrollPopup.this.isVisible()) {
                ScrollPopup.this.setVisible(false);
            }
        }
    };

    public ScrollPopup() {
        this(null);
    }

    public ScrollPopup(String label) {
        super(label);
        this.content = new MenuPanel();
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.sp = new JScrollPane();
        this.sp.setBorder(null);
        this.sp.setViewportBorder(null);
        this.sp.setFocusable(false);
        this.sp.getVerticalScrollBar().setFocusable(false);
        Font font2 = new JMenuItem(" ").getFont();
        int fsize = 12;
        if (font2 != null) {
            fsize = font2.getSize();
        }
        this.sp.getVerticalScrollBar().setUnitIncrement(fsize);
        this.sp.setViewportView(this.content);
        super.add(this.sp);
    }

    public void setMenuPanelBackground(Color bg) {
        this.content.setBackground(bg);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getInvoker() != null) {
            GraphicsConfiguration graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            Rectangle screenbounds = graphicsConfiguration.getBounds();
            Point locationOnScreen = this.getInvoker().getLocationOnScreen();
            Component comp = this.getInvoker();
            int invokerH = comp instanceof AbstractButton ? this.getInvoker().getHeight() : 0;
            int maxheight = screenbounds.height - invokerH - locationOnScreen.y - screenInsets.bottom - screenInsets.top - 2;
            if (maxheight < 50) {
                maxheight = 50;
            }
            if (dimension.height > maxheight) {
                dimension.height = maxheight;
                dimension.width += this.sp.getVerticalScrollBar().getMinimumSize().width;
            }
        }
        return dimension;
    }

    @Override
    public void insert(Component component, int index) {
        this.add(component, index);
    }

    @Override
    public JMenuItem add(Action a) {
        JMenuItem mi = super.createActionComponent(a);
        mi.setAction(a);
        return this.add(mi);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.content.add(menuItem);
        return menuItem;
    }

    @Override
    public Component add(Component comp, int index) {
        this.content.add(comp, index);
        return comp;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        Window windowAncestor;
        if (invoker != null && (windowAncestor = SwingUtilities.getWindowAncestor(invoker)) != null) {
            windowAncestor.addWindowListener(this.windowAdapter);
        }
        int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
        int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
        if (y < yOffset) {
            y = yOffset;
        }
        super.show(invoker, x, y);
        int prefWidth = this.content.getPreferredSize().width;
        prefWidth += xOffset;
        for (Component cmp : this.content.getComponents()) {
            if (!(cmp instanceof JMenu)) continue;
            ((JMenu)cmp).setMenuLocation(prefWidth, yOffset);
        }
    }

    @Override
    public void setVisible(boolean b) {
        Window windowAncestor;
        Component invoker = this.getInvoker();
        if (invoker != null && !b && (windowAncestor = SwingUtilities.getWindowAncestor(invoker)) != null) {
            windowAncestor.removeWindowListener(this.windowAdapter);
        }
        super.setVisible(b);
    }

    @Override
    public void addSeparator() {
        this.content.add(new JSeparator());
    }

    public void addSeparatorIfProper() {
        if (this.content.getComponentCount() != 0 && !(this.content.getComponent(this.content.getComponentCount() - 1) instanceof JSeparator)) {
            this.addSeparator();
        }
    }

    @Override
    public Component add(Component comp) {
        this.content.add(comp);
        return comp;
    }

    @Override
    public MenuElement[] getSubElements() {
        return this.content.getSubElements();
    }

    @Override
    public void removeAll() {
        this.content.removeAll();
    }

    @Override
    public Component getComponent() {
        return this.content;
    }

    private class MenuPanel
    extends JPanel
    implements MenuElement {
        private static final long serialVersionUID = 1L;

        private MenuPanel() {
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public MenuElement[] getSubElements() {
            ArrayList<MenuElement> mes = new ArrayList<MenuElement>();
            for (int i = 0; i < ScrollPopup.this.content.getComponentCount(); ++i) {
                Component comp = ScrollPopup.this.content.getComponent(i);
                if (!(comp instanceof MenuElement)) continue;
                MenuElement me = (MenuElement)((Object)comp);
                mes.add(me);
            }
            return mes.toArray(new MenuElement[mes.size()]);
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }
    }
}

