/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class InetToolBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton expandbutton;
    private JToolBar toolbar;
    private JPopupMenu expandPopup;
    private volatile boolean isWorking = false;
    private volatile boolean requireReLayout = false;
    private Object syncObj = new Object();
    private HashMap<JMenuItem, Component> extendMenus = new HashMap();
    private ActionListener extendAction;

    public InetToolBar(JToolBar toolbar) {
        super(new BorderLayout());
        this.toolbar = toolbar;
        toolbar.setFloatable(false);
        this.setOpaque(false);
        this.add((Component)toolbar, "Center");
        this.expandbutton = new JButton(HtmlEditorUtils.getResourceImage("expandtoolbar.gif"));
        this.expandbutton.setMargin(new Insets(0, 2, 0, 2));
        this.expandbutton.setVisible(false);
        this.expandPopup = new JPopupMenu();
        this.registerListeners();
    }

    private void registerListeners() {
        this.expandPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HashSet menuset = new HashSet();
                menuset.addAll(InetToolBar.this.extendMenus.keySet());
                for (JMenuItem mi : menuset) {
                    Component currComp = (Component)InetToolBar.this.extendMenus.get(mi);
                    mi.setVisible(!currComp.getIgnoreRepaint());
                    mi.setEnabled(currComp.isEnabled() && !(currComp instanceof JSeparator));
                    if (!(currComp instanceof AbstractButton)) continue;
                    AbstractButton abstractButton = (AbstractButton)currComp;
                    String text = abstractButton.getText();
                    mi.setText(text == null || text.length() == 0 ? (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() == 0 ? " " : abstractButton.getToolTipText()) : text);
                    mi.setIcon(abstractButton.getIcon());
                    for (MouseListener ml : abstractButton.getMouseListeners()) {
                        mi.addMouseListener(ml);
                    }
                    if (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() <= 0) continue;
                    mi.setToolTipText(abstractButton.getToolTipText());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.extendAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                Component actionComp = (Component)InetToolBar.this.extendMenus.get(source);
                if (actionComp != null && actionComp instanceof AbstractButton) {
                    AbstractButton abButton = (AbstractButton)actionComp;
                    e.setSource(abButton);
                    if (abButton instanceof JToggleButton) {
                        JToggleButton tglButton;
                        tglButton.setSelected(!(tglButton = (JToggleButton)abButton).isSelected());
                    }
                    for (ActionListener al : abButton.getActionListeners()) {
                        al.actionPerformed(e);
                    }
                }
            }
        };
        this.expandbutton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InetToolBar.this.expandPopup.isVisible()) {
                    InetToolBar.this.expandPopup.show(InetToolBar.this.expandbutton, 0, InetToolBar.this.expandbutton.getHeight());
                }
            }
        });
        ComponentListener compListener = new ComponentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentShown(ComponentEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentMoved(ComponentEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentHidden(ComponentEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }
        };
        this.toolbar.addComponentListener(compListener);
        this.addAncestorListener(new AncestorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }
        });
        this.toolbar.addContainerListener(new ContainerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentRemoved(ContainerEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.removePopupComponent(e.getChild());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentAdded(ContainerEvent e) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.addPopupComponent(e.getChild());
                }
            }
        });
    }

    private void removePopupComponent(Component comp) {
        HashSet<JMenuItem> menuset = new HashSet<JMenuItem>();
        menuset.addAll(this.extendMenus.keySet());
        for (JMenuItem mi : menuset) {
            Component currComp = this.extendMenus.get(mi);
            if (!currComp.equals(comp)) continue;
            currComp.setVisible(true);
            this.extendMenus.remove(mi);
            mi.setAction(null);
            this.expandPopup.remove(mi);
        }
        this.relayoutComponents();
    }

    private void addPopupComponent(Component comp) {
        this.relayoutComponents();
    }

    public void relayoutComponents() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.requireReLayout = true;
                    while (InetToolBar.this.requireReLayout) {
                        boolean buttonvisible;
                        Component currComp;
                        int i;
                        Object currComp2;
                        InetToolBar.this.requireReLayout = false;
                        InetToolBar.this.isWorking = true;
                        Rectangle visibleRect = InetToolBar.this.toolbar.getBounds();
                        Component[] components = InetToolBar.this.toolbar.getComponents();
                        for (int i2 = components.length - 1; i2 >= 0 && components.length != 0; --i2) {
                            if (i2 > components.length - 1) {
                                i2 = components.length - 1;
                            }
                            if (!((currComp2 = components[i2]) instanceof AbstractButton) && !(currComp2 instanceof JSeparator) || ((Component)currComp2).getIgnoreRepaint() || !((Component)currComp2).isVisible()) continue;
                            Rectangle compbounds = ((Component)currComp2).getBounds();
                            Dimension compsize = ((Component)currComp2).getPreferredSize();
                            if (compbounds.x + compsize.width <= visibleRect.width) break;
                            JMenuItem mi = new JMenuItem();
                            ((Component)currComp2).setVisible(false);
                            if (currComp2 instanceof AbstractButton) {
                                AbstractButton abstractButton = (AbstractButton)currComp2;
                                if (abstractButton.getAction() != null) {
                                    mi.setAction(abstractButton.getAction());
                                } else {
                                    mi.addActionListener(InetToolBar.this.extendAction);
                                }
                                String text = abstractButton.getText();
                                mi.setActionCommand(abstractButton.getActionCommand());
                                mi.setText((String)(text == null || text.length() == 0 ? (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() == 0 ? " " : abstractButton.getToolTipText()) : text));
                                mi.setIcon(abstractButton.getIcon());
                                if (abstractButton.getToolTipText() != null && abstractButton.getToolTipText().length() > 0) {
                                    mi.setToolTipText(abstractButton.getToolTipText());
                                }
                            }
                            boolean existing = false;
                            for (JMenuItem existingMI : InetToolBar.this.extendMenus.keySet()) {
                                if (!((Component)InetToolBar.this.extendMenus.get(existingMI)).equals(currComp2)) continue;
                                existing = true;
                                break;
                            }
                            if (existing) continue;
                            InetToolBar.this.extendMenus.put(mi, currComp2);
                            InetToolBar.this.expandPopup.add((Component)mi, 0);
                        }
                        int currentUsedSpace = 0;
                        currComp2 = components;
                        int compbounds = ((Component[])currComp2).length;
                        for (int compsize = 0; compsize < compbounds; ++compsize) {
                            Component cmp = currComp2[compsize];
                            if (!cmp.isVisible()) continue;
                            Rectangle cmpbounds = cmp.getBounds();
                            if (cmpbounds.x > currentUsedSpace) {
                                currentUsedSpace = cmpbounds.x + cmpbounds.width;
                                continue;
                            }
                            currentUsedSpace += cmp.getWidth();
                        }
                        int componentCount = InetToolBar.this.expandPopup.getComponentCount();
                        for (i = 0; i < componentCount && InetToolBar.this.expandPopup.getComponentCount() != 0; ++i) {
                            Component curMI = InetToolBar.this.expandPopup.getComponent(i);
                            currComp = (Component)InetToolBar.this.extendMenus.get(curMI);
                            if (currComp == null) continue;
                            Dimension compbounds2 = currComp.getPreferredSize();
                            if (currentUsedSpace + compbounds2.width >= visibleRect.width) break;
                            currComp.setVisible(!currComp.getIgnoreRepaint());
                            InetToolBar.this.extendMenus.remove(curMI);
                            ((JMenuItem)curMI).setAction(null);
                            InetToolBar.this.expandPopup.remove(i);
                            i = -1;
                            componentCount = InetToolBar.this.expandPopup.getComponentCount();
                            currentUsedSpace += compbounds2.width;
                        }
                        componentCount = InetToolBar.this.expandPopup.getComponentCount();
                        for (i = 0; i < componentCount && InetToolBar.this.expandPopup.getComponentCount() != 0; ++i) {
                            Component curMI = InetToolBar.this.expandPopup.getComponent(i);
                            currComp = (Component)InetToolBar.this.extendMenus.get(curMI);
                            if (currComp == null || !currComp.isVisible()) continue;
                            InetToolBar.this.extendMenus.remove(curMI);
                            ((JMenuItem)curMI).setAction(null);
                            InetToolBar.this.expandPopup.remove(i);
                            i = -1;
                            componentCount = InetToolBar.this.expandPopup.getComponentCount();
                        }
                        boolean bl = buttonvisible = InetToolBar.this.expandPopup.getComponentCount() > 0;
                        if (buttonvisible) {
                            buttonvisible = false;
                            for (Component popcomp : InetToolBar.this.expandPopup.getComponents()) {
                                if (!popcomp.isVisible()) continue;
                                buttonvisible = true;
                                break;
                            }
                        }
                        if (buttonvisible) {
                            if (!InetToolBar.this.expandbutton.isVisible()) {
                                InetToolBar.this.add((Component)InetToolBar.this.expandbutton, "East");
                            }
                        } else if (InetToolBar.this.expandbutton.isVisible()) {
                            InetToolBar.this.remove(InetToolBar.this.expandbutton);
                        }
                        InetToolBar.this.expandbutton.setVisible(buttonvisible);
                        InetToolBar.this.isWorking = false;
                    }
                }
                InetToolBar.this.validate();
                InetToolBar.this.repaint();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.toolbar.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension d = super.getPreferredSize();
        if (d.width > 100) {
            d.width = 100;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.toolbar.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension d = super.getMinimumSize();
        if (d.width > 40) {
            d.width = 40;
        }
        return d;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }
}

