/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlEditorKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class HyperlinkInputDialog {
    private String url;
    private String displaytext;
    private int selectedOption = 0;
    private JTextField tfName;
    private JTextField tfUrl;
    public static final int CANCEL_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int REMOVE_LINK_OPTION = 2;

    public HyperlinkInputDialog(String url, String displaytext) {
        this.url = url;
        this.displaytext = displaytext;
    }

    public int showDialog(Component caller) {
        JDialog dialog;
        Window frame;
        Window windowAncestor = SwingUtilities.getWindowAncestor(caller);
        if (windowAncestor == null) {
            windowAncestor = SwingUtilities.windowForComponent(caller);
        }
        if (windowAncestor instanceof Frame) {
            frame = (Frame)windowAncestor;
            dialog = new JDialog((Frame)frame);
        } else if (windowAncestor instanceof Dialog) {
            frame = (Dialog)windowAncestor;
            dialog = new JDialog((Dialog)frame);
        } else {
            dialog = new JDialog();
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setTitle(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Title"));
        AbstractAction okAction = new AbstractAction("okAction"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperlinkInputDialog.this.selectedOption = 1;
                HyperlinkInputDialog.this.url = HyperlinkInputDialog.this.tfUrl.getText();
                HyperlinkInputDialog.this.displaytext = HyperlinkInputDialog.this.tfName.getText();
                dialog.dispose();
            }
        };
        AbstractAction cancelAction = new AbstractAction("cancelAction"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperlinkInputDialog.this.selectedOption = 0;
                dialog.dispose();
            }
        };
        AbstractAction removeLink = new AbstractAction("removeLinkAction"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperlinkInputDialog.this.selectedOption = 2;
                dialog.dispose();
            }
        };
        JPanel contentpane = (JPanel)dialog.getContentPane();
        contentpane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentpane.setLayout(new BorderLayout());
        InputMap inputMap = contentpane.getInputMap(2);
        ActionMap actionMap = contentpane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "okAction");
        inputMap.put(KeyStroke.getKeyStroke(10, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "okAction");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        actionMap.put("okAction", okAction);
        actionMap.put("cancelAction", cancelAction);
        actionMap.put("removeLinkAction", removeLink);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
        contentpane.add((Component)buttonPanel, "South");
        Locale locale = buttonPanel.getLocale();
        JButton btOK = new JButton(UIManager.getString((Object)"OptionPane.okButtonText", locale));
        btOK.addActionListener(okAction);
        JButton btCancel = new JButton(UIManager.getString((Object)"OptionPane.cancelButtonText", locale));
        btCancel.addActionListener(cancelAction);
        JButton btnRemove = new JButton(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.remLink"), new ImageIcon(this.getClass().getResource("/com/inet/editor/images/delete_16.gif")));
        btnRemove.addActionListener(removeLink);
        int height = btCancel.getMinimumSize().height;
        int width = btnRemove.getMinimumSize().width;
        Dimension size = new Dimension(width, height);
        btnRemove.setMinimumSize(size);
        btnRemove.setPreferredSize(size);
        if (this.url != null && !"".equals(this.url) && !"http://".equalsIgnoreCase(this.url)) {
            buttonPanel.add(btnRemove);
        }
        buttonPanel.add(btOK);
        buttonPanel.add(btCancel);
        JPanel inputform = new JPanel(new GridBagLayout());
        contentpane.add((Component)inputform, "Center");
        Icon icon = UIManager.getIcon("OptionPane.questionIcon");
        JLabel lbIcon = new JLabel(icon);
        inputform.add((Component)lbIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel lbName = new JLabel(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Name"));
        inputform.add((Component)lbName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel lburl = new JLabel(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Link"));
        inputform.add((Component)lburl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.tfName = new JTextField(this.displaytext, 20);
        if (this.displaytext != null && this.displaytext.length() > 0) {
            this.tfName.setEditable(false);
        }
        inputform.add((Component)this.tfName, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.tfUrl = new JTextField(this.url, 20);
        inputform.add((Component)this.tfUrl, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 10, 5), 0, 0));
        dialog.getRootPane().setDefaultButton(btOK);
        dialog.pack();
        if (caller instanceof JComponent) {
            JComponent jcomp = (JComponent)caller;
            Point locationOnScreen = jcomp.getLocationOnScreen();
            Rectangle bounds = jcomp.getBounds();
            Rectangle visibleRect = jcomp.getVisibleRect();
            locationOnScreen.x += visibleRect.x;
            locationOnScreen.y += visibleRect.y;
            bounds.width = visibleRect.width > 0 ? visibleRect.width : bounds.width;
            bounds.height = visibleRect.height;
            dialog.setLocation(locationOnScreen.x + bounds.width / 2 - dialog.getWidth() / 2, locationOnScreen.y + bounds.height / 2 - dialog.getHeight() / 2);
        } else {
            dialog.setLocationRelativeTo(caller);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HyperlinkInputDialog.this.tfName.getText().length() > 0) {
                    HyperlinkInputDialog.this.tfUrl.requestFocusInWindow();
                } else {
                    HyperlinkInputDialog.this.tfName.requestFocusInWindow();
                }
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (dialog.isShowing()) {
                    dialog.toFront();
                }
            }
        });
        dialog.setVisible(true);
        return this.selectedOption;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDisplaytext() {
        return this.displaytext;
    }
}

