/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;

class FocusLostComboBox
extends JComboBox
implements FocusListener {
    private static final long serialVersionUID = 6975900908437940675L;
    private Object oldItem;
    private Component lastFocusComponent;

    FocusLostComboBox(Object[] items) {
        super(items);
    }

    @Override
    protected void fireActionEvent() {
    }

    @Override
    public void focusGained(FocusEvent ev) {
        Component comp = ev.getOppositeComponent();
        if (comp != this) {
            this.oldItem = this.getSelectedItemInEditor();
            this.lastFocusComponent = comp;
        }
    }

    private Object getSelectedItemInEditor() {
        if (this.getSelectedIndex() >= 0) {
            return super.getSelectedItem();
        }
        return this.getEditor().getItem();
    }

    @Override
    public void focusLost(FocusEvent ev) {
        Object newItem = this.getSelectedItemInEditor();
        if (newItem == null) {
            if (this.oldItem == null) {
                return;
            }
            super.fireActionEvent();
            return;
        }
        if (newItem.equals(this.oldItem)) {
            return;
        }
        super.fireActionEvent();
    }

    @Override
    public void setPopupVisible(boolean v) {
        super.setPopupVisible(v);
        Component comp = this.lastFocusComponent;
        if (!this.isVisible()) {
            return;
        }
        if (comp != null) {
            comp.requestFocusInWindow();
        }
    }

    @Override
    public void addNotify() {
        super.addFocusListener(this);
        this.getEditor().getEditorComponent().addFocusListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        ComboBoxEditor myEditor = this.getEditor();
        if (myEditor != null && myEditor.getEditorComponent() != null) {
            myEditor.getEditorComponent().removeFocusListener(this);
        }
        super.removeNotify();
    }
}

