/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.actions.InetHtmlAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class AddImageAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private static File lastDir = null;

    public AddImageAction() {
        super("addimage");
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("addimage"));
        this.putValue("Name", HtmlEditorUtils.getTranslation("addimage"));
        this.putValue("SmallIcon", HtmlEditorUtils.getResourceImage("addimage.gif"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
    }

    @Override
    public boolean isEnabled() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPropertyAccess("user.home");
                return super.isEnabled();
            }
            catch (Exception e) {
                return false;
            }
        }
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean newValue) {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkPropertyAccess("user.home");
            }
            super.setEnabled(newValue);
        }
        catch (SecurityException e) {
            super.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof Component) {
            File selectedFile;
            Container parent;
            Component comp = (Component)source;
            JTextComponent text = this.getHtmlEditor(e);
            if (text == null && comp instanceof Container) {
                Container parent2 = (Container)comp;
                while (parent2 != null && !(parent2 instanceof BaseEditor) && !(parent2 instanceof JTextComponent)) {
                    if (parent2 instanceof JPopupMenu) {
                        Component invoker = ((JPopupMenu)parent2).getInvoker();
                        if (invoker instanceof Container) {
                            parent2 = (Container)invoker;
                            continue;
                        }
                        parent2 = null;
                        continue;
                    }
                    if (parent2.getParent() == null) break;
                    parent2 = parent2.getParent();
                }
                if (parent2 != null && parent2 instanceof BaseEditor) {
                    text = ((BaseEditor)parent2).getEditor();
                }
                if (parent2 != null && parent2 instanceof JTextComponent) {
                    text = (JTextComponent)parent2;
                }
            }
            if (text == null || !(text.getTransferHandler() instanceof InetHtmlTransferHandler)) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            JFileChooser fc = new JFileChooser();
            if (lastDir != null) {
                fc.setCurrentDirectory(lastDir);
            }
            fc.setAcceptAllFileFilterUsed(false);
            fc.setDialogTitle(HtmlEditorUtils.getTranslation("addimage"));
            fc.setDialogType(0);
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(2);
            fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    StringBuffer buf = new StringBuffer(HtmlEditorUtils.getTranslation("imagefiles"));
                    buf.append(" (");
                    int i = 0;
                    TreeSet<String> treeSet = new TreeSet<String>();
                    treeSet.addAll(InetHtmlTransferHandler.IMAGE_TYPES);
                    for (String type : treeSet) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(type.toUpperCase(Locale.US));
                        ++i;
                    }
                    buf.append(")");
                    return buf.toString();
                }

                @Override
                public boolean accept(File f) {
                    String extension;
                    String fname;
                    int lastIndexOf;
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.isFile() && (lastIndexOf = (fname = f.getName()).lastIndexOf(46)) > 0 && InetHtmlTransferHandler.IMAGE_TYPES.contains((extension = fname.substring(lastIndexOf + 1)).toLowerCase());
                }
            });
            for (parent = text; parent != null && !(parent instanceof JScrollPane) && parent.getParent() != null; parent = parent.getParent()) {
            }
            int result = fc.showOpenDialog(parent);
            InetHtmlTransferHandler handler = (InetHtmlTransferHandler)text.getTransferHandler();
            if (result == 0 && (selectedFile = fc.getSelectedFile()) != null && selectedFile.exists() && selectedFile.canRead() && selectedFile.isFile()) {
                Caret caret = text.getCaret();
                int end = Math.max(caret.getMark(), caret.getDot());
                int pos = Math.min(caret.getMark(), caret.getDot());
                handler.importFile(selectedFile, text.getDocument(), pos, end, false, true);
                File fparent = selectedFile.getParentFile();
                if (fparent != null) {
                    lastDir = fparent;
                }
            }
        }
    }
}

