/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.views.RenderContext;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ElementUtils {
    private static final int TEMP_ATTRIBUTES_COUNT = TemporaryStyle.Attribute.values().length;

    public static int getChildIndex(Element parent, Element child) {
        if (child.getParentElement() != parent) {
            return -1;
        }
        for (int i = 0; i < parent.getElementCount(); ++i) {
            if (parent.getElement(i) != child) continue;
            return i;
        }
        return -1;
    }

    public static Element[] getChildren(Element parent, int offset, int len) {
        if (offset < parent.getElementCount() && len > 0) {
            Element[] removes = new Element[len];
            for (int i = 0; i < len; ++i) {
                removes[i] = parent.getElement(i + offset);
            }
            return removes;
        }
        return null;
    }

    public static Element[] getAllChildren(Element parent) {
        int len = parent.getElementCount();
        Element[] removes = new Element[len];
        for (int i = 0; i < len; ++i) {
            removes[i] = parent.getElement(i);
        }
        return removes;
    }

    public static AbstractDocument.ElementEdit removeChildren(Element parent, int offset, int len) {
        Element[] removes = ElementUtils.getChildren(parent, offset, len);
        if (removes != null) {
            Element[] emptyElements = new Element[]{};
            ((AbstractDocument.BranchElement)parent).replace(offset, len, emptyElements);
            return new AbstractDocument.ElementEdit(parent, offset, removes, emptyElements);
        }
        return null;
    }

    public static boolean isRelated(Element currentElem, Element ancestor) {
        Element parent = currentElem;
        if (currentElem == null || ancestor == null) {
            return false;
        }
        while (parent != null && parent != ancestor) {
            if ((parent = parent.getParentElement()) != ancestor) continue;
            return true;
        }
        return parent == ancestor;
    }

    public static MutableAttributeSet removeNonessentialAttributes(AttributeSet set, Element parent) {
        if (set == null) {
            return null;
        }
        Enumeration<?> names = set.getAttributeNames();
        SimpleAttributeSet newSet = new SimpleAttributeSet();
        while (names.hasMoreElements()) {
            AttributeFinder<AttributeValue> finder;
            Object key = names.nextElement();
            if (key instanceof TemporaryStyle.Attribute) continue;
            Object value = set.getAttribute(key);
            if (key instanceof CSS.Attribute && (finder = GenericFinder.getFinder((CSS.Attribute)((Object)key))) != null) {
                Object parentValue;
                if (finder.isInherited() || finder == AttributeFinder.TEXT_DECORATION) {
                    parentValue = StyleResolver.getAttributeValue(parent, finder);
                    if (value != null && value.equals(parentValue)) continue;
                    newSet.addAttribute(key, value);
                } else if (finder == AttributeFinder.FONT_SIZE && (parentValue = parent.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) != null) {
                    float thisSize;
                    if (value == AttributeValue.INHERIT) continue;
                    float parentFontSize = RenderContext.getFontSize(parent);
                    float f = thisSize = value instanceof Float ? ((Float)value).floatValue() : ((FontSize)value).getValue(parentFontSize);
                    if (parentFontSize == thisSize) continue;
                }
            }
            newSet.addAttribute(key, value);
        }
        return newSet;
    }

    public static Element getLeafAt(Element root, int offs) {
        try {
            while (root != null && !root.isLeaf()) {
                root = root.getElement(root.getElementIndex(offs));
            }
            return root;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static Element getParagraphFor(Element e) {
        if (e.getParentElement() == null) {
            return e;
        }
        DisplayValue disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        while (disp != null && disp.getDisplay() == 2 && e.getParentElement() != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED) {
            e = e.getParentElement();
            disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        }
        return e;
    }

    public static void clearTemp(MutableAttributeSet attr) {
        Enumeration<?> names = attr.getAttributeNames();
        Object name = null;
        ArrayList toRemove = null;
        while (names.hasMoreElements()) {
            name = names.nextElement();
            if (!(name instanceof TemporaryStyle.Attribute)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList(TEMP_ATTRIBUTES_COUNT);
            }
            toRemove.add(name);
        }
        if (toRemove != null) {
            for (int i = 0; i < toRemove.size(); ++i) {
                attr.removeAttribute(toRemove.get(i));
            }
        }
        attr.removeAttribute(InetHtmlDocument.FLAG_INIT);
    }

    public static Element findSharedParent(int offs, int len, Element root) {
        Element parent = root;
        Element leftChild = parent.getElement(parent.getElementIndex(offs));
        int end = offs + len;
        Element rightChild = parent.getElement(parent.getElementIndex(end));
        while (leftChild == rightChild && !leftChild.isLeaf()) {
            parent = leftChild;
            leftChild = parent.getElement(parent.getElementIndex(offs));
            rightChild = parent.getElement(parent.getElementIndex(end));
        }
        return parent;
    }

    public static Element findSharedParagraph(int offs, int len, Element root) {
        Element parent = root;
        Element paragraph = root;
        int end = offs + len;
        Element leftChild = parent.getElement(parent.getElementIndex(offs));
        Element rightChild = parent.getElement(parent.getElementIndex(end));
        while (leftChild == rightChild && !leftChild.isLeaf()) {
            parent = leftChild;
            leftChild = parent.getElement(parent.getElementIndex(offs));
            rightChild = parent.getElement(parent.getElementIndex(end));
            DisplayValue disp = StyleResolver.getAttributeValue(parent, AttributeFinder.DISPLAY);
            if (disp == null || disp.getDisplay() == 2 || parent.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) continue;
            paragraph = parent;
        }
        return paragraph;
    }

    public static Element findListItemParent(Element paragraph) {
        DisplayValue disp = StyleResolver.getAttributeValue(paragraph, AttributeFinder.DISPLAY);
        Element node = paragraph;
        while ((disp == null || disp.getDisplay() != 4) && node != null) {
            if ((node = node.getParentElement()) == null) continue;
            disp = StyleResolver.getAttributeValue(node, AttributeFinder.DISPLAY);
        }
        return node;
    }

    public static Element findParentByTag(Element node, HTML.Tag tag) {
        while (node != null && node.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
            node = node.getParentElement();
        }
        return node;
    }

    public static Element findListContainer(Element elem) {
        if (elem == null) {
            return null;
        }
        Element node = elem.getParentElement();
        Object name = node.getAttributes().getAttribute(StyleConstants.NameAttribute);
        while (node != null && name != null && name != HTML.Tag.OL && name != HTML.Tag.UL) {
            if ((node = node.getParentElement()) == null) continue;
            name = node.getAttributes().getAttribute(StyleConstants.NameAttribute);
        }
        return node;
    }

    public static Element findNextHigherBlock(Element elem) {
        if (elem == null) {
            return null;
        }
        Element node = elem.getParentElement();
        DisplayValue disp = StyleResolver.getAttributeValue(node, AttributeFinder.DISPLAY);
        while ((disp == null || disp.getDisplay() == 2) && node != null) {
            if ((node = node.getParentElement()) == null) continue;
            disp = StyleResolver.getAttributeValue(node, AttributeFinder.DISPLAY);
        }
        return node;
    }

    public static boolean isTablePart(Element elem) {
        return ElementUtils.isTablePart(elem, false);
    }

    public static boolean isTablePart(Element elem, boolean excludeTableContainer) {
        if (elem == null) {
            return false;
        }
        DisplayValue disp = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        if (disp != null) {
            switch (disp.getDisplay()) {
                case 8: 
                case 9: {
                    if (excludeTableContainer) {
                        return false;
                    }
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isBlockElement(Element elem) {
        if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            return false;
        }
        DisplayValue display = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        if (display == null) {
            return false;
        }
        byte disp = display.getDisplay();
        switch (disp) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonolithic(HTML.Tag tag) {
        switch (tag) {
            case IMG: 
            case HR: 
            case INPUT: 
            case BR: 
            case META: 
            case PARAM: 
            case COL: {
                return true;
            }
        }
        return false;
    }

    public static boolean crossesTable(int start, int end, Element root) {
        DisplayValue disp;
        Element endElem;
        Element startElement = ElementUtils.getLeafAt(root, start);
        if (startElement == null) {
            return true;
        }
        if (end >= startElement.getStartOffset() && end < startElement.getEndOffset()) {
            return false;
        }
        Element startTable = null;
        Element startCell = null;
        for (startElement = startElement.getParentElement(); startElement != null; startElement = startElement.getParentElement()) {
            DisplayValue disp2 = StyleResolver.getAttributeValue(startElement, AttributeFinder.DISPLAY);
            if (disp2 == null) continue;
            if (disp2.getDisplay() == 12 && startCell == null) {
                startCell = startElement;
                continue;
            }
            if (disp2.getDisplay() != 8) continue;
            startTable = startElement;
            break;
        }
        if (startCell != null && end >= startCell.getStartOffset() && end < startCell.getEndOffset()) {
            return false;
        }
        if (!(startCell == null || startTable == null || end >= startCell.getStartOffset() && end < startCell.getEndOffset() || start == startTable.getStartOffset() && end >= startTable.getEndOffset())) {
            return true;
        }
        for (endElem = ElementUtils.getLeafAt(root, end).getParentElement(); endElem != null && ((disp = StyleResolver.getAttributeValue(endElem, AttributeFinder.DISPLAY)) == null || disp.getDisplay() != 12); endElem = endElem.getParentElement()) {
        }
        return endElem != null && (start < endElem.getStartOffset() || start >= endElem.getEndOffset());
    }

    public static boolean isContent(Element elem) {
        if (elem == null) {
            return false;
        }
        if (!elem.isLeaf()) {
            return false;
        }
        AttributeSet atts = elem.getAttributes();
        if (atts.containsAttribute("CR", Boolean.TRUE)) {
            return false;
        }
        Object name = atts.getAttribute(StyleConstants.NameAttribute);
        return name == HTML.Tag.CONTENT;
    }

    public static boolean isEndMarker(Element elem) {
        AttributeSet atts = elem.getAttributes();
        return atts.isDefined("CR");
    }

    public static Element getPreviousContent(Element elem) {
        Element leaf;
        Element parent = elem.getParentElement();
        Element child = elem;
        int index = 0;
        while ((index = ElementUtils.getChildIndex(parent, child)) == 0) {
            child = parent;
            if ((parent = parent.getParentElement()) != null) continue;
            return null;
        }
        if (index < 0) {
            return null;
        }
        for (leaf = parent.getElement(index - 1); leaf != null && !leaf.isLeaf(); leaf = leaf.getElement(leaf.getElementCount() - 1)) {
        }
        return leaf;
    }

    public static Element getBodyElement(InetHtmlDocument doc) {
        Element[] elements = doc.getRootElements();
        Element html = null;
        for (Element elem : elements) {
            if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HTML) continue;
            html = elem;
            break;
        }
        if (html == null) {
            return null;
        }
        for (Element elem : ElementUtils.getAllChildren(html)) {
            if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
            return elem;
        }
        return null;
    }

    public static int getStartOffset(Element e) {
        if (e == null) {
            return -1;
        }
        while (!e.isLeaf()) {
            if (e.getElementCount() == 0) {
                return -1;
            }
            e = e.getElement(0);
        }
        return e.getStartOffset();
    }

    public static boolean isValidEditPosition(int position, Document doc) {
        Element block;
        char charAtCursor;
        if (position < 0 || position > doc.getLength()) {
            return false;
        }
        try {
            charAtCursor = doc.getText(position, 1).charAt(0);
        }
        catch (BadLocationException e) {
            return false;
        }
        if (Character.isLowSurrogate(charAtCursor)) {
            return false;
        }
        if (position == 0) {
            return true;
        }
        Element leaf = ElementUtils.getLeafAt(doc.getDefaultRootElement(), position - 1);
        return leaf == null || !leaf.getAttributes().containsAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BR) || position != (block = ElementUtils.findNextHigherBlock(leaf)).getEndOffset() - 1;
    }
}

