/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractDecoder {
    private byte[] buffer;
    private int offset;
    private int length;
    private transient Image image;
    private int hash = 0;
    private float ppmx = 3779.52f;
    private float ppmy = 3779.52f;
    private int index = 0;

    AbstractDecoder() {
    }

    AbstractDecoder(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public AbstractDecoder setBuffer(byte[] b) {
        this.buffer = b;
        this.index = 0;
        return this;
    }

    private synchronized void decodeImageSynchronized(int w, int h) {
        if (this.image == null) {
            try {
                this.image = this.decodeImage(w, h);
            }
            catch (Exception e) {
                this.image = null;
            }
        }
    }

    public double getResolutionScaleX() {
        return 3780.0f / this.ppmx;
    }

    public double getResolutionScaleY() {
        return 3780.0f / this.ppmy;
    }

    public Image getImage(int w, int h) {
        if (this.image == null) {
            this.decodeImageSynchronized(w, h);
        }
        return this.image;
    }

    private Image scaleImageOnServer(Image imageToScale, int width, int height, int w, int h) {
        try {
            BufferedImage scaled = new BufferedImage(width, height, 1);
            Graphics2D g2 = (Graphics2D)scaled.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.scale((double)width / (double)w, (double)height / (double)h);
            g2.drawImage(imageToScale, null, null);
            return scaled;
        }
        catch (NoClassDefFoundError error) {
            return imageToScale.getScaledInstance(width, height, 1);
        }
    }

    public Image getScaledImage(int width, int height) {
        this.getImage(width, height);
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        if (w == width && h == height) {
            return this.image;
        }
        return this.scaleImageOnServer(this.image, width, height, w, h);
    }

    public final Image getImage() {
        if (this.image == null) {
            this.decodeImageSynchronized(100, 100);
        }
        return this.image;
    }

    abstract Image decodeImage(int var1, int var2) throws Exception;

    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.buffer);
        out.writeInt(this.offset);
        out.writeInt(this.length);
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.buffer = (byte[])in.readObject();
        this.offset = in.readInt();
        this.length = in.readInt();
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            this.hash = this.hash * 31 + this.buffer[i];
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractDecoder that = (AbstractDecoder)o;
        if (that.hashCode() != this.hashCode()) {
            return false;
        }
        if (that.buffer.length != this.buffer.length) {
            return false;
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            if (that.buffer[i] == this.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public float getPpmx() {
        return this.ppmx;
    }

    public float getPpmy() {
        return this.ppmy;
    }

    public void setPpmx(float ppmx) {
        this.ppmx = ppmx;
    }

    public void setPpmy(float ppmy) {
        this.ppmy = ppmy;
    }

    protected int readInt() throws IOException {
        try {
            int result = (this.buffer[this.index] & 0xFF) + ((this.buffer[this.index + 1] & 0xFF) << 8) + ((this.buffer[this.index + 2] & 0xFF) << 16) + (this.buffer[this.index + 3] << 24);
            this.index += 4;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readShort() throws IOException {
        try {
            int result = (this.buffer[this.index] & 0xFF) + (this.buffer[this.index + 1] << 8);
            this.index += 2;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readRGB24() throws IOException {
        try {
            int result = 0xFF000000 | this.buffer[this.index] & 0xFF | (this.buffer[this.index + 1] & 0xFF) << 8 | (this.buffer[this.index + 2] & 0xFF) << 16;
            this.index += 3;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readRGB16() throws IOException {
        int pixelValue = this.readShort();
        int r = (0x7C00 & pixelValue) >> 7;
        int g = (0x3E0 & pixelValue) >> 2;
        int b = (0x1F & pixelValue) << 3;
        int result = 0xFF000000 | b | g << 8 | r << 16;
        return result;
    }

    protected byte readByte() throws IOException {
        try {
            return this.buffer[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Premature end of image data");
        }
    }

    protected void setIndexTo(int index) {
        this.index = index;
    }

    protected void skipBytes(int count) throws IOException {
        this.index += count;
        if (this.index > this.buffer.length) {
            throw new IOException("Premature end of image data");
        }
    }
}

