/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.editor.BaseEditor;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class EnterAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private final Action defaultAction;
    private JEditorPane editor;

    public EnterAction(Action defaultAction) {
        super("insert-break");
        this.defaultAction = defaultAction;
    }

    public EnterAction() {
        super("insert-break");
        this.defaultAction = null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.editor = this.getHtmlEditor(ev);
        if (this.editor != null) {
            Document doc;
            if (!this.editor.isEditable()) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
                return;
            }
            int offset = this.editor.getSelectionStart();
            int len = this.editor.getSelectionEnd() - offset;
            if (len > 0) {
                this.editor.replaceSelection("");
            }
            if ((doc = this.editor.getDocument()) instanceof InetHtmlDocument) {
                CaretListener[] listeners;
                InetHtmlEditorKit kit = (InetHtmlEditorKit)this.editor.getEditorKit();
                MutableAttributeSet atts = kit.getInputAttributes();
                SimpleAttributeSet copy = new SimpleAttributeSet(atts);
                Element leaf = ElementUtils.getLeafAt(doc.getRootElements()[0], offset > 0 ? offset - 1 : 0);
                Element link = ElementUtils.findParentByTag(leaf, HTML.Tag.A);
                boolean doCopy = link == null || offset != link.getEndOffset();
                ((InetHtmlDocument)doc).performParagraphBreak(offset);
                if (doCopy) {
                    atts.addAttributes(copy);
                }
                if ((listeners = this.editor.getCaretListeners()) != null) {
                    BaseEditor.SimpleCaretEvent event = new BaseEditor.SimpleCaretEvent(this.editor, this.editor.getSelectionStart(), this.editor.getSelectionEnd());
                    for (CaretListener l : listeners) {
                        l.caretUpdate(event);
                    }
                }
                return;
            }
        }
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(ev);
        }
    }
}

