/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.MinMaxControl;
import com.inet.html.views.VariableSpaceView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.StackManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

public abstract class Layout {
    private static final Font FALLBACK_FONT = new Font("Sans Serif", 0, 12);
    public static final int MARKER_OFFSET = (int)new LengthUnit("7pt").getValue();
    protected final BoxView view;
    protected int width;
    protected int preferredWidth;
    private int preferredHeight;
    protected int minimumOuterWidth;
    protected int minimumOuterHeight;
    protected int minimumWidth;
    protected int minimumHeight;
    protected int currentTop;
    protected int currentLeft;
    protected int currentWidth;
    protected int currentHeight;
    protected List<PositionInfo> childPositions = new ArrayList<PositionInfo>();
    private boolean isPreLayouted = false;
    private MinMaxControl minMaxControl;

    public Layout(BoxView view) {
        this.view = view;
        this.minMaxControl = new MinMaxControl(view);
        if (!this.minMaxControl.hasWHConstraint()) {
            this.minMaxControl = null;
        }
    }

    public float getCurrentSpan(int axis) {
        if (axis == 0) {
            return this.preferredWidth;
        }
        return this.getPreferredHeight();
    }

    public float getPreferredSpan(int axis) {
        if (axis == 0) {
            return this.preferredWidth;
        }
        return this.getPreferredHeight();
    }

    public float getMinimumSpan(int axis) {
        if (axis == 0) {
            return this.minimumWidth;
        }
        return this.minimumHeight;
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public void getChildAllocation(int i, Rectangle rect) {
        PositionInfo pos = this.childPositions.get(i);
        rect.setLocation(pos.x, pos.y);
        rect.setSize(pos.view.getOuterWidth(), pos.view.getOuterHeight());
    }

    public List<PositionInfo> getChildren() {
        return this.childPositions;
    }

    public int getViewCount() {
        return this.childPositions.size();
    }

    public abstract void preLayout();

    public abstract Rectangle layout(boolean var1);

    public void layoutWidth() {
        this.calculateCollapsedMargins();
        this.width = this.adjustWidth();
        this.setCurrentWidth(this.width);
        this.view.setContentWidth(this.width);
    }

    protected abstract void calculateCollapsedMargins();

    protected boolean isReadjustRequired() {
        if (this.view.getWidthUnit() == null && !this.view.isInFlow()) {
            if (this.view.getParent() != null && this.view.getParent() instanceof BlockView) {
                int parentWidth = ((BlockView)this.view.getParent()).getLayout().getCurrentWidth();
                if (parentWidth > this.preferredWidth) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected int adjustHeight() {
        LengthUnit l = this.view.getHeightUnit();
        if (l == null || l.isAuto()) {
            return Integer.MIN_VALUE;
        }
        if (l.isAbsolute()) {
            return Math.round(l.calculateValue(1.0f, this.view));
        }
        if (l.getType() != 1) {
            return Math.round(l.calculateValue(1.0f, this.view));
        }
        float refSize = 1.0f;
        switch (this.view.getPosition()) {
            case 3: {
                refSize = Layout.getRootHeight(this.view);
                break;
            }
            case 2: {
                return Integer.MIN_VALUE;
            }
            default: {
                BoxView heightParent = Layout.getHeightParent(this.view);
                if (this.hasDefinedHeight(heightParent)) {
                    refSize = Layout.getHeight(this.view, heightParent, false);
                    break;
                }
                return Integer.MIN_VALUE;
            }
        }
        if (refSize >= 0.0f) {
            switch (this.getView().getDisplay()) {
                case 10: 
                case 12: {
                    return Integer.MIN_VALUE;
                }
            }
            return Math.round(l.calculateValue(refSize, this.view));
        }
        return Integer.MIN_VALUE;
    }

    private boolean hasDefinedHeight(BoxView v) {
        if (v != null) {
            return v.getHeightUnit() != null && !v.getHeightUnit().isAuto();
        }
        return true;
    }

    public static BoxView getHeightParent(BoxView view) {
        boolean findAbs;
        View parent = view.getParent();
        boolean bl = findAbs = view.getPosition() == 2;
        while (parent instanceof BoxView) {
            BoxView parentBox = (BoxView)parent;
            if (parentBox.getPosition() == 2 || parentBox.getPosition() == 3 || findAbs && parentBox.getPosition() == 1) {
                return parentBox;
            }
            if (!findAbs) {
                if (parentBox.getHeightUnit() != null && parentBox.getHeightUnit().getType() != -1) {
                    return parentBox;
                }
                if (((InetHtmlDocument)view.getDocument()).getDocType().isHTML4OrHigher()) {
                    return parent instanceof BoxView ? (BoxView)parent : null;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static int getHeight(BoxView current, BoxView v, boolean includePadding) {
        if (v != null) {
            int height = v instanceof ILayouted ? ((ILayouted)((Object)v)).getLayout().getCurrentHeight() : v.getContentHeight();
            return height + (includePadding ? v.getBox().getPadding().top + v.getBox().getPadding().bottom : 0);
        }
        return Layout.getRootHeight(current);
    }

    private static int getRootHeight(BoxView current) {
        HtmlRootView root = current.getHTMLRoot();
        int refSize = current.getRenderContext().getTextContainer() != null ? current.getRenderContext().getViewportHeight() : root.getContentHeight();
        refSize -= root.getBox().getTotalHeightGain();
        if (root.getViewCount() > 0) {
            BoxView body = (BoxView)root.getView(0);
            refSize -= body.getBox().getTotalHeightGain();
        }
        return refSize;
    }

    protected int adjustWidth() {
        int width;
        boolean definedWidth;
        IBoxPainter box = this.view.getBox();
        LengthUnit l = this.view.getWidthUnit();
        int parentWidth = 0;
        View parent = this.view.getParent();
        boolean bl = definedWidth = l != null && !l.isAuto();
        if (this.view.isAbsolutePositioned()) {
            while (parent instanceof BlockView && !((BlockView)parent).isPositionRoot()) {
                parent = parent.getParent();
            }
        }
        if (parent instanceof ILayouted) {
            ILayouted bv = (ILayouted)((Object)parent);
            parentWidth = bv.getLayout().getCurrentWidth();
        } else if (parent instanceof BoxView) {
            parentWidth = ((BoxView)parent).getContentWidth();
        } else {
            return this.view.getContentWidth();
        }
        this.getView().updateRelativeValues(parentWidth);
        int resultWidth = definedWidth ? (l.isAbsolute() ? Math.round(l.calculateValue(1.0f, this.view)) : Math.round(l.calculateValue(parentWidth, this.view))) : (this.view instanceof BlockView && (this.view.isFloating() || this.view.isAbsolutePositioned()) ? (parent instanceof BlockView || parent instanceof HtmlRootView ? (parentWidth > this.preferredWidth + 1 ? this.preferredWidth + 1 : parentWidth) : parentWidth) : (parent instanceof BlockView && this.view.isBlock() ? ((width = parentWidth - box.getTotalWidthGain()) < this.minimumWidth && this.view.isTableCell() ? this.minimumWidth : width) : this.preferredWidth));
        if (this.view.isAbsolutePositioned()) {
            int rightX;
            Element elem = this.view.getElement();
            LengthUnit left = StyleResolver.getAttributeValue(elem, AttributeFinder.LEFT);
            LengthUnit right = StyleResolver.getAttributeValue(elem, AttributeFinder.RIGHT);
            boolean leftSet = left != null && left.getType() != -1;
            boolean rightSet = right != null && right.getType() != -1;
            BoxView positionContainer = (BoxView)parent;
            int leftX = 0;
            if (leftSet || rightSet) {
                rightX = positionContainer.getContentWidth();
                if (leftSet) {
                    leftX = (int)left.calculateValue(positionContainer.getContentWidth(), this.view);
                    if (definedWidth) {
                        rightX = leftX + resultWidth;
                    } else if (rightSet) {
                        rightX -= (int)right.calculateValue(positionContainer.getContentWidth(), this.view);
                    }
                } else {
                    rightX -= (int)right.calculateValue(positionContainer.getContentWidth(), this.view);
                    if (definedWidth) {
                        leftX = rightX - resultWidth;
                    }
                }
            } else {
                int margin = this.view.getBox().getTotalWidthGain();
                if (parent instanceof BlockView) {
                    BlockView blockParent = (BlockView)parent;
                    Point parentPos = blockParent.getLeftUpperCorner(blockParent);
                    leftX = parentPos.x;
                }
                rightX = definedWidth ? leftX + resultWidth : leftX + Math.min(positionContainer.getContentWidth() - leftX - margin, resultWidth);
            }
            resultWidth = rightX - leftX;
        }
        if (this.minMaxControl == null) {
            return resultWidth;
        }
        return this.minMaxControl.getMinMaxValues((boolean)true, (int)resultWidth, (int)0).width;
    }

    protected View getLeafViewAtPosition(int pos) {
        BoxView block = this.view;
        return this.getLeafViewAtPosition(block, pos);
    }

    private View getLeafViewAtPosition(View block, int pos) {
        int n = block.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = block.getView(i);
            if (v.getStartOffset() >= pos || pos >= v.getEndOffset()) continue;
            return this.getLeafViewAtPosition(v, pos);
        }
        return block;
    }

    public static void replace(View oldView, View[] newViews) {
        int off;
        View parent = oldView.getParent();
        int n = parent.getViewCount();
        if (newViews != null && newViews.length == 1 && oldView == newViews[0] && parent == newViews[0].getParent()) {
            return;
        }
        for (off = 0; off < n && oldView != parent.getView(off); ++off) {
        }
        if (off >= n) {
            return;
        }
        parent.replace(off, 1, newViews);
    }

    public PositionInfo getChildPosition(BoxView childView) {
        for (PositionInfo info : this.childPositions) {
            if (info.view != childView) continue;
            return info;
        }
        return null;
    }

    public BoxView getView() {
        return this.view;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public int getCurrentTop() {
        return this.currentTop;
    }

    public int getCurrentLeft() {
        return this.currentLeft;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public boolean isPreLayouted() {
        return this.isPreLayouted;
    }

    public void setPreLayouted() {
        this.isPreLayouted = true;
    }

    public void setCurrentHeight(int currentHeight) {
        this.currentHeight = currentHeight;
    }

    public void setCurrentWidth(int currentWidth) {
        this.currentWidth = currentWidth;
    }

    public abstract void predictWidth(int var1);

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.view.toString();
    }

    public abstract void layoutVerticalAlign(int var1, int var2);

    public abstract ViewPositionInfo getViewForPosition(Point var1, Rectangle var2);

    protected View getChild(BoxView parent, boolean firstOne) {
        int startIndex = 0;
        int lowerGap = 0;
        int direction = 1;
        int viewCount = parent.getViewCount();
        if (viewCount < 1) {
            return null;
        }
        if (firstOne) {
            View v0;
            if (parent.isListItemWithMarker() && (v0 = parent.getView(0)) instanceof BoxView && !((BoxView)v0).isBlock()) {
                startIndex = 1;
            }
        } else {
            if (parent.isListItemWithMarker()) {
                lowerGap = 1;
            }
            startIndex = viewCount - 1;
            direction = -1;
        }
        for (int i = startIndex; i >= lowerGap && i < viewCount; i += direction) {
            View v = parent.getView(i);
            if (!(v instanceof BoxView) || !((BoxView)v).isInFlow()) continue;
            return v;
        }
        return null;
    }

    public abstract Rectangle getSpan();

    public static void union(Rectangle union, Rectangle join) {
        int min = union.x < join.x ? union.x : join.x;
        int max = (int)Math.max(union.getMaxX(), join.getMaxX());
        union.x = min;
        union.width = max - min;
        min = union.y < join.y ? union.y : join.y;
        max = (int)Math.max(union.getMaxY(), join.getMaxY());
        union.y = min;
        union.height = max - min;
    }

    public static void union(Rectangle union, int x, int y, int width, int height) {
        int min = union.x < x ? union.x : x;
        int max = union.x + union.width > x + width ? union.x + union.width : x + width;
        union.x = min;
        union.width = max - min;
        min = union.y < y ? union.y : y;
        max = union.y + union.height > y + height ? union.y + union.height : y + height;
        union.y = min;
        union.height = max - min;
    }

    protected void reverseOrder(int innerStart, int innerEnd, int leftBound, int rightBound) {
        for (int idx = innerStart; idx <= innerEnd; ++idx) {
            PositionInfo pos = this.childPositions.get(idx);
            pos.x = rightBound - (pos.x + pos.width - leftBound);
        }
    }

    protected void setFinalHight(int cssHeight, int calculatedHeight, Rectangle span) {
        BoxView heightParent;
        if (this.view.isAbsolutePositioned()) {
            View parent = this.view.getParent();
            while (parent instanceof BlockView && !((BlockView)parent).isPositionRoot()) {
                parent = parent.getParent();
            }
            if (parent instanceof BlockView) {
                int tempHeight;
                BlockView root = (BlockView)parent;
                Element elem = this.view.getElement();
                LengthUnit top = StyleResolver.getAttributeValue(elem, AttributeFinder.TOP);
                LengthUnit bottom = StyleResolver.getAttributeValue(elem, AttributeFinder.BOTTOM);
                int topY = 0;
                int bottomY = tempHeight = calculatedHeight + this.view.getOuterHeight() - this.view.getContentHeight();
                if (top != null && top.getType() != -1) {
                    int offset = (int)top.calculateValue(root.getContentHeight(), this.view);
                    topY += offset;
                    bottomY += offset;
                }
                if (bottom != null && bottom.getType() != -1) {
                    int ref = root.getContentHeight();
                    bottomY = (int)((float)ref - bottom.calculateValue(ref, this.view));
                    if (top == null || top.getType() == -1) {
                        topY = bottomY - tempHeight;
                    }
                    if (bottomY < topY) {
                        bottomY = topY;
                    }
                }
                calculatedHeight = bottomY - topY;
            }
        }
        this.setCurrentHeight(calculatedHeight);
        if (cssHeight == Integer.MIN_VALUE && this.view.getHeightUnit() != null && this.view.getHeightUnit().getType() == 1 && (this.hasDefinedHeight(heightParent = Layout.getHeightParent(this.view)) || this.view.getPosition() == 2)) {
            int refHeight = Layout.getHeight(this.view, heightParent, true);
            if (this.getView().getHeightUnit().getType() == 1) {
                switch (this.getView().getDisplay()) {
                    case 10: 
                    case 12: {
                        refHeight = Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            if (refHeight != Integer.MIN_VALUE) {
                cssHeight = (int)this.view.getHeightUnit().calculateValue(refHeight, this.view);
            }
        }
        if (cssHeight != Integer.MIN_VALUE) {
            if (this.view.getDisplay() == 12) {
                if (cssHeight > calculatedHeight) {
                    span.height = Math.max(span.height, cssHeight);
                    this.setCurrentHeight(cssHeight);
                }
            } else {
                span.height = Math.max(span.height, cssHeight);
                this.setCurrentHeight(cssHeight);
            }
        }
    }

    public static void offsetRelative(ViewPosition info) {
        Element elem = info.view.getElement();
        LengthUnit left = StyleResolver.getAttributeValue(elem, AttributeFinder.LEFT);
        LengthUnit right = StyleResolver.getAttributeValue(elem, AttributeFinder.RIGHT);
        if (right != null && right.getType() != -1 && right.getType() != 1) {
            info.x = (int)((float)info.x - right.calculateValue(info.view.getFontSize(), info.view));
        } else if (left != null && left.getType() != -1 && left.getType() != 1) {
            info.x = (int)((float)info.x + left.calculateValue(info.view.getFontSize(), info.view));
        }
        LengthUnit top = StyleResolver.getAttributeValue(elem, AttributeFinder.TOP);
        LengthUnit bottom = StyleResolver.getAttributeValue(elem, AttributeFinder.BOTTOM);
        if (bottom != null && bottom.getType() != -1 && bottom.getType() != 1) {
            info.y = (int)((float)info.y - bottom.calculateValue(info.view.getFontSize(), info.view));
        } else if (top != null && top.getType() != -1 && top.getType() != 1) {
            info.y = (int)((float)info.y + top.calculateValue(info.view.getFontSize(), info.view));
        }
    }

    protected Dimension applyMinMaxValue(boolean widthOnly, int w, int h) {
        if (this.minMaxControl != null) {
            return this.minMaxControl.getMinMaxValues(widthOnly, w, h);
        }
        return null;
    }

    protected FontMetrics getFallbackFontMetrics() {
        FontMetrics metrics;
        Font f = this.view.getRenderContext().getFont(this.view, false);
        JEditorPane c = this.view.getRenderContext().getTextContainer();
        FontMetrics fontMetrics = metrics = c != null ? ((Component)c).getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
        if (metrics.getHeight() == 0 && f.getSize() > 0) {
            f = FALLBACK_FONT.deriveFont(f.getSize2D()).deriveFont(f.getStyle());
            metrics = c != null ? ((Component)c).getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
        }
        return metrics;
    }

    protected void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public boolean getVisibleElements(Rectangle2D clip, DOMUtils.ResultMap result) {
        StackManager manager;
        boolean hasVisibleChildren = false;
        StackManager stackManager = manager = this.getView() instanceof BlockView ? ((BlockView)this.getView()).getPositionManager(false) : null;
        if (manager != null) {
            hasVisibleChildren |= manager.getVisibleElements(clip, this.getView(), false, result);
        }
        int yOffset = this.view.getTopInset();
        int xOffset = this.view.getLeftInset();
        Rectangle2D.Double subClip = new Rectangle2D.Double(clip.getX() - (double)xOffset, clip.getY() - (double)yOffset, clip.getWidth(), clip.getHeight());
        hasVisibleChildren |= this.getVisibileNormalFlowElements(subClip, result);
        if (manager != null) {
            hasVisibleChildren |= manager.getVisibleElements(clip, this.getView(), true, result);
        }
        return hasVisibleChildren;
    }

    protected boolean getVisibileNormalFlowElements(Rectangle2D clip, DOMUtils.ResultMap result) {
        boolean hasVisibleChildren = false;
        for (PositionInfo info : this.childPositions) {
            if (!info.paintInFlow) continue;
            Rectangle2D.Double subClip = new Rectangle2D.Double(clip.getX() - info.getX(), clip.getY() - info.getY(), clip.getWidth(), clip.getHeight());
            Rectangle span = info.view.getSpan();
            if ((double)span.y > subClip.getMaxY()) {
                result.setFirstClippedContentLocation(-((RectangularShape)subClip).getY());
                continue;
            }
            result.setLastVisibleContentLocation(-((RectangularShape)subClip).getY());
            hasVisibleChildren |= info.view.getVisibleDOM(subClip, result);
        }
        return hasVisibleChildren;
    }

    public class PositionInfo
    extends ViewPosition {
        private static final long serialVersionUID = 1L;
        public short baseline;
        public byte vAlign;
        public boolean isVarSpace = false;
        public boolean isFixed = false;
        public boolean isLayouted = false;
        public boolean paintInFlow = true;

        public PositionInfo(BoxView viewToPosition) {
            this.view = viewToPosition;
            if (this.view instanceof VariableSpaceView) {
                this.isVarSpace = true;
                boolean bl = this.isFixed = ((VariableSpaceView)this.view).isFixed() || this.view.isBreak();
            }
            if (viewToPosition instanceof ILayouted) {
                this.isLayouted = true;
            }
        }

        @Override
        public String toString() {
            return "Position for " + this.view + " is " + this.x + ":" + this.y + " width:" + this.width;
        }
    }

    public static class ViewPosition
    extends Rectangle {
        private static final long serialVersionUID = 1L;
        public BoxView view;
    }
}

