/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.ViewPainter;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.ElementUtils;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentPainter;
import com.inet.html.views.ContentView;
import com.inet.html.views.IBoxPainter;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;

public class VariableSpaceView
extends ContentView {
    private static final Segment SPACE_SEGMENT = new Segment(new char[]{' '}, 0, 1);
    private int predictedWidth = -1;
    private int predictedHeight = -1;
    private byte type = (byte)2;
    private boolean isFixed = false;
    private boolean isBreakChar = false;
    private boolean isPre = false;
    private boolean isBorderPart = false;
    private boolean breakable = true;
    private boolean isCRmarker = false;
    private boolean isTab = false;
    private boolean isPreLayouted = false;

    public VariableSpaceView(Element leaf) {
        super(leaf);
    }

    public VariableSpaceView(Element leaf, boolean isBreakChar) {
        super(leaf);
        this.isBreakChar = isBreakChar;
    }

    public VariableSpaceView(Element leaf, int paintMode) {
        super(leaf);
        this.type = (byte)paintMode;
    }

    public VariableSpaceView(Element elem, ViewPainter painter) {
        super(elem, painter);
    }

    public VariableSpaceView(Element elem, boolean isBreakChar, ViewPainter painter) {
        super(elem, painter);
        this.isBreakChar = isBreakChar;
    }

    public VariableSpaceView(Element elem, int paintMode, ViewPainter painter) {
        super(elem, painter);
        this.type = (byte)paintMode;
    }

    public VariableSpaceView(Element elem, int paintMode, ViewPainter painter, ContentPainter contentPainter) {
        super(elem, painter, contentPainter);
        this.type = (byte)paintMode;
    }

    @Override
    public void setParent(View parent) {
        if (this.getParent() != null && this.getParent() == parent) {
            return;
        }
        this.isPreLayouted = false;
        super.setParent(parent);
        if (parent == null) {
            return;
        }
        if (ElementUtils.isEndMarker(this.getElement())) {
            this.isCRmarker = true;
            this.predictedWidth = 0;
            this.isFixed = true;
        }
        if (this.type == 1 || this.type == 3) {
            IBoxPainter topPainter = ((BoxView)parent).getBoxPainter(this.getElement());
            if (topPainter == null) {
                this.setWidth(0);
            } else {
                if (this.type == 1) {
                    this.setWidth(topPainter.getLeftBorderPadding());
                } else {
                    this.setWidth(topPainter.getTotalWidthGain() - topPainter.getLeftBorderPadding());
                }
                this.isBorderPart = true;
            }
            this.isFixed = true;
        }
        this.performPreLayout();
    }

    @Override
    protected String getText() {
        return null;
    }

    public void setPaintMode(int paintMode) {
        this.type = (byte)paintMode;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == 0 && this.predictedWidth >= 0 && this.isFixed) {
            return this.predictedWidth;
        }
        if (axis == 1 && this.predictedHeight >= 0 && this.isFixed) {
            return this.predictedHeight;
        }
        if (axis == 2) {
            return super.getPreferredSpan(axis);
        }
        return this.getMinimumSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (axis == 0) {
            if (!this.isFixed) {
                return this.getContentPainter().getSpan() * (float)(this.isPre ? this.getEndOffset() - this.getStartOffset() : 1);
            }
            return this.predictedWidth;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        if (!this.isFixed) {
            this.setContentWidth(this.getPreferredSpan(0));
        }
        return null;
    }

    public void setWidth(int width) {
        if (this.isBorderPart || this.isCRmarker) {
            return;
        }
        this.predictedWidth = width;
        this.isFixed = width >= 0;
        this.isPreLayouted = false;
    }

    public void setHeight(int height) {
        this.predictedHeight = height;
        this.isPreLayouted = false;
    }

    @Override
    public int getOuterHeight() {
        if (this.predictedHeight >= 0) {
            return this.predictedHeight;
        }
        return super.getContentHeight();
    }

    @Override
    public int getOuterWidth() {
        if (this.isFixed && this.predictedWidth >= 0) {
            return this.predictedWidth;
        }
        return super.getContentWidth();
    }

    @Override
    public int getLeftInset() {
        return 0;
    }

    @Override
    public int getRightInset() {
        return 0;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean isFixed) {
        if (this.isBorderPart || this.isCRmarker) {
            this.isFixed = true;
            return;
        }
        this.isFixed = isFixed;
        this.isPreLayouted = false;
    }

    @Override
    public void setSize(float newWidth, float newHeight) {
        this.setWidth((int)newWidth);
        this.setHeight((int)newHeight);
    }

    @Override
    public void setStartAndEndOffset(int start, int end) {
        super.setStartAndEndOffset(start, end);
    }

    @Override
    public int getContentWidth() {
        return this.getOuterWidth();
    }

    @Override
    protected int getTopPainterType() {
        return this.type;
    }

    @Override
    public void performPreLayout() {
        if (this.isPreLayouted) {
            return;
        }
        super.performPreLayout();
        if (this.predictedWidth >= 0 || this.predictedHeight >= 0) {
            float newWidth = this.predictedWidth >= 0 ? (float)this.predictedWidth : (float)this.getContentWidth();
            float newHeight = this.predictedHeight >= 0 ? (float)this.predictedHeight : (float)this.getOuterHeight();
            this.setSizeContent(newWidth, newHeight);
        }
        this.isPreLayouted = true;
    }

    @Override
    public String toString() {
        return "VarSpace(" + (this.isFixed ? "fixed" : "variable") + ") " + this.getStartOffset() + "," + this.getEndOffset();
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle rect = a.getBounds();
        if ((this.isPre || this.isTab) && rect != null) {
            int contentSize = this.getEndOffset() - this.getStartOffset();
            int w = this.getContentWidth();
            float ratio = (float)w / (float)contentSize;
            rect.x = this.isNativeLTR() ? (int)((float)rect.x + ratio * (float)(pos - this.getStartOffset())) : (int)((float)rect.x + ((float)w - ratio * (float)(pos - this.getStartOffset())));
            rect.width = 0;
            return rect;
        }
        rect = (Rectangle)super.modelToView(pos, a, b);
        if (this.isBreak() && rect != null) {
            rect.width = 10;
        }
        return rect;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle rect = (Rectangle)a;
        if (rect != null) {
            int pos;
            int contentSize = this.getEndOffset() - this.getStartOffset();
            int n = pos = this.isBreak() ? 0 : Math.round((x - (float)rect.x) / ((float)rect.width / (float)contentSize));
            if (!this.isNativeLTR()) {
                pos = contentSize - pos;
            }
            return pos += this.getStartOffset();
        }
        return super.viewToModel(x, y, a, biasReturn);
    }

    public void setPre(boolean isPre) {
        this.isPre = isPre;
        this.isPreLayouted = false;
    }

    @Override
    public boolean isBreak() {
        if (this.isBreakChar) {
            switch (this.getWhiteSpace()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return super.isBreak();
    }

    public void setIsBreakChar() {
        this.isBreakChar = true;
        this.isPreLayouted = false;
    }

    @Override
    public boolean isBreakable() {
        return this.isBreak() || this.breakable && !this.isNativePre();
    }

    @Override
    public void setBreakable(boolean isBreakable) {
        this.breakable = isBreakable;
    }

    @Override
    protected Segment getSegment() throws BadLocationException {
        return SPACE_SEGMENT;
    }

    public boolean isTab() {
        return this.isTab;
    }

    public void setTab(boolean isTab) {
        this.isTab = isTab;
    }

    public boolean isCRmarker() {
        return this.isCRmarker;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.isBreak() || this.isCRmarker) {
            return;
        }
        super.paint(g, allocation);
    }

    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        DOMUtils.DOMVisibilityResult res;
        if (!this.getElement().isLeaf() && this.getStartOffset() == this.getEndOffset()) {
            if (this.getPainter() != null) {
                this.getPainter().markAsPainted();
            }
            return clip.getMaxY() > 0.0;
        }
        int h = this.getOuterHeight();
        boolean partial = false;
        if (clip.getHeight() < 0.0 || clip.getMinY() > (double)h || clip.getMaxY() < (double)h) {
            boolean canBePartial;
            boolean bl = canBePartial = !Boolean.TRUE.equals(result.getProperty(DOMUtils.ClippingProperty.FirstLineRendered)) && !result.isSet(DOMUtils.ClippingProperty.WholeContentOnly);
            if (canBePartial) {
                partial = true;
            }
        }
        if ((res = (DOMUtils.DOMVisibilityResult)result.get(this.getElement())) == null) {
            res = new DOMUtils.DOMVisibilityResult();
            result.put(this.getElement(), res);
        }
        res.addVisibleArea(this, partial);
        if (result.isSet(DOMUtils.ClippingProperty.WholeContentOnly)) {
            return clip.getMaxY() >= (double)this.getContentHeight();
        }
        return true;
    }
}

