/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.views.BackgroundPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.text.Element;

public class BoxPainter
extends BackgroundPainter
implements IBoxPainter {
    private final BoxView view;
    private Insets padding;
    private Insets borderInsets;
    private Insets borderStyles;
    private Insets margins;
    private ColorValue borderTopColor;
    private ColorValue borderLeftColor;
    private ColorValue borderRightColor;
    private ColorValue borderBottomColor;
    static final int MODE_BORDER = 0;
    static final int MODE_PADDING = 1;
    static final int MODE_MARGIN = 2;
    private boolean relevant = true;

    protected BoxPainter(BoxView view) {
        super(view != null ? view.getElement() : null, view);
        this.view = view;
        this.init(true);
    }

    protected BoxPainter(BoxView view, Element bindToElement) {
        super(bindToElement, view);
        this.view = view;
        this.init(false);
    }

    public static IBoxPainter createBoxPainter(ContentView parent, Element descendant) {
        IBoxPainter painter;
        if (descendant != null) {
            painter = parent.getBoxPainter(descendant);
            if (painter == null && (painter = new BoxPainter(parent, descendant)).isRelevant()) {
                parent.addBoxPainter(descendant, painter);
            }
        } else {
            painter = new BoxPainter(parent);
        }
        if (!painter.isRelevant()) {
            return RenderContext.getEmptyBoxPainter();
        }
        return painter;
    }

    public static IBoxPainter createBoxPainter(BoxView parent, ContentView paintRef, Element descendant) {
        if (descendant != null) {
            IBoxPainter painter = parent.getBoxPainter(descendant);
            if (painter == null) {
                painter = new BoxPainter(parent, descendant);
                painter.setReferenceView(paintRef);
                parent.addBoxPainter(descendant, painter);
            }
            return painter;
        }
        BoxPainter painter = new BoxPainter(parent);
        painter.setReferenceView(paintRef);
        return painter;
    }

    protected static IBoxPainter createRootPainter(BoxView view) {
        return new BoxPainter(view);
    }

    public static IBoxPainter createBoxPainter(BoxView view) {
        BoxPainter boxPainter = new BoxPainter(view);
        if (!boxPainter.isRelevant()) {
            return RenderContext.getEmptyBoxPainter();
        }
        return boxPainter;
    }

    private void init(boolean useMargins) {
        this.borderInsets = this.getInsets(0);
        Element elem = this.getElement();
        BorderStyleValue styleTop = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_TOP_STYLE);
        BorderStyleValue styleLeft = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_LEFT_STYLE);
        BorderStyleValue styleBottom = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_BOTTOM_STYLE);
        BorderStyleValue styleRight = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_RIGHT_STYLE);
        this.borderStyles = new Insets(styleTop != null ? styleTop.getStyle() : 0, styleLeft != null ? styleLeft.getStyle() : 0, styleBottom != null ? styleBottom.getStyle() : 0, styleRight != null ? styleRight.getStyle() : 0);
        if (this.borderStyles.equals(EMPTY_INSETS)) {
            this.borderStyles = EMPTY_INSETS;
        }
        if (this.isInVisibleStyle(this.borderStyles.top)) {
            this.borderInsets.top = 0;
        } else {
            this.borderTopColor = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_TOP_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.left)) {
            this.borderInsets.left = 0;
        } else {
            this.borderLeftColor = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_LEFT_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.bottom)) {
            this.borderInsets.bottom = 0;
        } else {
            this.borderBottomColor = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_BOTTOM_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.right)) {
            this.borderInsets.right = 0;
        } else {
            this.borderRightColor = StyleResolver.getAttributeValue(elem, AttributeFinder.BORDER_RIGHT_COLOR);
        }
        this.padding = this.getInsets(1);
        this.margins = useMargins ? this.getInsets(2) : EMPTY_INSETS;
        this.relevant = this.isRelevant();
    }

    private Insets getInsets(int type) {
        return this.view.getBaseInsets(type, 0, this.getElement());
    }

    protected boolean isInVisibleStyle(int style) {
        return style == 0 || style == 9;
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public Insets getMargins() {
        return this.margins;
    }

    @Override
    public Insets getBorderInsets() {
        return this.borderInsets;
    }

    @Override
    public Insets getBorderStyles() {
        return this.borderStyles;
    }

    @Override
    public int getTotalWidthGain() {
        int borderSize = this.getBorderInsets().left + this.getBorderInsets().right;
        int paddingSize = this.getPadding().left + this.getPadding().right;
        int marginSize = this.getMargins().left + this.getMargins().right;
        return borderSize + paddingSize + marginSize;
    }

    @Override
    public int getTotalHeightGain() {
        int borderSize = this.getBorderInsets().top + this.getBorderInsets().bottom;
        int paddingSize = this.getPadding().top + this.getPadding().bottom;
        int marginSize = this.getMargins().top + this.getMargins().bottom;
        return borderSize + paddingSize + marginSize;
    }

    @Override
    public int getLeftBorderPadding() {
        return this.getBorderInsets().left + this.getPadding().left;
    }

    @Override
    public int getTopBorderPadding() {
        return this.getBorderInsets().top + this.getPadding().top;
    }

    @Override
    public int getBottomBorderPadding() {
        return this.getBorderInsets().bottom + this.getPadding().bottom;
    }

    @Override
    public int getRightBorderPadding() {
        return this.getBorderInsets().right + this.getPadding().right;
    }

    @Override
    public int getTotalLeftGain() {
        return this.getBorderInsets().left + this.getPadding().left + this.getMargins().left;
    }

    @Override
    public int getTotalTopGain() {
        return this.getBorderInsets().top + this.getPadding().top + this.getMargins().top;
    }

    protected static void drawBorderLine(Graphics2D g, float x, float y, float width, float height, int style, float lineWidth) {
        BasicStroke stroke;
        float x2 = x + width;
        float y2 = y + height;
        switch (style) {
            case 0: 
            case 9: {
                return;
            }
            case 6: {
                float dashWidth = 3.0f * lineWidth;
                float length = Math.max(width, height) - dashWidth;
                int holes = (int)(length / (2.0f * dashWidth));
                float holeWidth = holes == 0 ? 0.0f : (length - dashWidth * (float)holes) / (float)holes;
                float[] dash = new float[]{dashWidth, holeWidth};
                stroke = new BasicStroke(lineWidth, 0, 2, 10.0f, dash, 0.0f);
                break;
            }
            case 5: {
                float length = Math.max(width, height) - lineWidth;
                int holes = (int)(length / (2.0f * lineWidth));
                float holeWidth = holes == 0 ? 0.0f : (length - lineWidth * (float)holes) / (float)holes;
                float[] dot = new float[]{lineWidth, holeWidth};
                stroke = new BasicStroke(lineWidth, 0, 2, 10.0f, dot, 0.0f);
                break;
            }
            default: {
                stroke = new BasicStroke(lineWidth, 0, 2);
            }
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.draw(new Line2D.Float(x, y, x2, y2));
        g.setStroke(oldStroke);
    }

    @Override
    public void paint(Graphics g, Rectangle r, int paintMode, BoxView paintRef) {
        this.paint(g, r.x, r.y, r.width, r.height, paintMode, paintRef);
    }

    @Override
    public void paint(Graphics g, int x, int y, int width, int height, int paintMode, BoxView paintRef) {
        Area lineArea;
        Polygon lineClip;
        float lineWidth;
        int intLineWidth;
        int style;
        ColorValue colorValue;
        if (!this.relevant) {
            return;
        }
        if (paintMode != 4) {
            this.paintBackground(g, x, y, width, height, paintRef);
        }
        Shape clip = g.getClip();
        Area clipArea = null;
        Insets borderInsetsCopy = null;
        if (paintMode != 0 && paintMode != 4) {
            borderInsetsCopy = (Insets)this.borderInsets.clone();
            switch (paintMode) {
                case 1: {
                    this.borderInsets.right = 0;
                    break;
                }
                case 2: {
                    this.borderInsets.right = 0;
                    this.borderInsets.left = 0;
                    break;
                }
                case 3: {
                    this.borderInsets.left = 0;
                }
            }
        }
        if (this.borderInsets.top > 0) {
            colorValue = this.borderTopColor;
            if (colorValue == null) {
                colorValue = AttributeFinder.COLOR.getAttributeValue(this.view);
            }
            g.setColor(colorValue.getValue());
            style = this.borderStyles.top;
            intLineWidth = this.borderInsets.top;
            lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y);
            lineClip.addPoint(x + width, y);
            lineClip.addPoint(x + width - this.borderInsets.right, y + intLineWidth);
            lineClip.addPoint(x + this.borderInsets.left, y + intLineWidth);
            lineArea = new Area(lineClip);
            if (clip != null) {
                clipArea = new Area(clip);
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            if (style == 8) {
                BoxPainter.drawBorderLine((Graphics2D)g, x, (float)y + (lineWidth /= 3.0f) * 2.5f, width, 0.0f, style, lineWidth * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)g, x, (float)y + lineWidth * 0.5f, width, 0.0f, style, lineWidth * 1.01f);
        }
        if (this.borderInsets.left > 0) {
            colorValue = this.borderLeftColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.borderStyles.left;
            intLineWidth = this.borderInsets.left;
            lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y);
            lineClip.addPoint(x, y + height);
            lineClip.addPoint(x + intLineWidth, y + height - this.borderInsets.bottom);
            lineClip.addPoint(x + intLineWidth, y + this.borderInsets.top);
            lineArea = new Area(lineClip);
            if (clip != null) {
                if (clipArea == null) {
                    clipArea = new Area(clip);
                }
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            if (style == 8) {
                BoxPainter.drawBorderLine((Graphics2D)g, (float)x + (lineWidth /= 3.0f) * 2.5f, y, 0.0f, height, style, lineWidth * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)g, (float)x + lineWidth * 0.5f, y, 0.0f, height, style, lineWidth * 1.01f);
        }
        if (this.borderInsets.bottom > 0) {
            colorValue = this.borderBottomColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.borderStyles.bottom;
            intLineWidth = this.borderInsets.bottom;
            lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y + height);
            lineClip.addPoint(x + width, y + height);
            lineClip.addPoint(x + width - this.borderInsets.right, y + height - intLineWidth);
            lineClip.addPoint(x + this.borderInsets.left, y + height - intLineWidth);
            lineArea = new Area(lineClip);
            if (clip != null) {
                if (clipArea == null) {
                    clipArea = new Area(clip);
                }
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            if (style == 8) {
                BoxPainter.drawBorderLine((Graphics2D)g, x, (float)(y + height) - (lineWidth /= 3.0f) * 2.5f, width, 0.0f, style, lineWidth * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)g, x, (float)(y + height) - lineWidth * 0.5f, width, 0.0f, style, lineWidth * 1.01f);
        }
        if (this.borderInsets.right > 0) {
            colorValue = this.borderRightColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.borderStyles.right;
            intLineWidth = this.borderInsets.right;
            lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x + width, y);
            lineClip.addPoint(x + width, y + height);
            lineClip.addPoint(x + width - intLineWidth, y + height - this.borderInsets.bottom);
            lineClip.addPoint(x + width - intLineWidth, y + this.borderInsets.top);
            lineArea = new Area(lineClip);
            if (clip != null) {
                if (clipArea == null) {
                    clipArea = new Area(clip);
                }
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            if (style == 8) {
                BoxPainter.drawBorderLine((Graphics2D)g, (float)(x + width) - (lineWidth /= 3.0f) * 2.5f, y, 0.0f, height, style, lineWidth * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)g, (float)(x + width) - lineWidth * 0.5f, y, 0.0f, height, style, lineWidth * 1.01f);
        }
        if (paintMode != 0 && paintMode != 4) {
            this.borderInsets = borderInsetsCopy;
        }
        if (clipArea != null || clip == null) {
            g.setClip(clip);
        }
    }

    @Override
    public BoxView getView() {
        return this.view;
    }

    @Override
    public ColorValue getBorderTopColor() {
        return this.borderTopColor;
    }

    @Override
    public ColorValue getBorderLeftColor() {
        return this.borderLeftColor;
    }

    @Override
    public ColorValue getBorderRightColor() {
        return this.borderRightColor;
    }

    @Override
    public ColorValue getBorderBottomColor() {
        return this.borderBottomColor;
    }

    @Override
    public void setBorderBottomColor(ColorValue borderBottomColor) {
        this.borderBottomColor = borderBottomColor;
    }

    @Override
    public void setBorderLeftColor(ColorValue borderLeftColor) {
        this.borderLeftColor = borderLeftColor;
    }

    @Override
    public void setBorderRightColor(ColorValue borderRightColor) {
        this.borderRightColor = borderRightColor;
    }

    @Override
    public void setBorderTopColor(ColorValue borderTopColor) {
        this.borderTopColor = borderTopColor;
    }

    @Override
    public boolean isRelevant() {
        if (super.isRelevant()) {
            return true;
        }
        if (!EMPTY_INSETS.equals(this.margins) || this.view.hasRelativeMargin()) {
            return true;
        }
        if (!EMPTY_INSETS.equals(this.padding) || this.view.hasRelativePadding()) {
            return true;
        }
        if (this.isBorderVisible(this.borderLeftColor, this.borderInsets.left, this.borderStyles.left)) {
            return true;
        }
        if (this.isBorderVisible(this.borderTopColor, this.borderInsets.top, this.borderStyles.top)) {
            return true;
        }
        if (this.isBorderVisible(this.borderRightColor, this.borderInsets.right, this.borderStyles.right)) {
            return true;
        }
        return this.isBorderVisible(this.borderBottomColor, this.borderInsets.bottom, this.borderStyles.bottom);
    }

    private boolean isBorderVisible(ColorValue color, int width, int style) {
        return width != 0 && style != 0 && color != null && !color.isTransparent();
    }

    @Override
    public void updateRelevance() {
        this.relevant = this.isRelevant();
    }

    @Override
    public void setBorderStyles(Insets borderStyles) {
        this.borderStyles = borderStyles;
    }

    @Override
    public void setBorderInsets(Insets borderInsets) {
        this.borderInsets = borderInsets;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    @Override
    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    @Override
    public Insets setBorderInsets() {
        if (this.borderInsets == EMPTY_INSETS) {
            this.borderInsets = new Insets(0, 0, 0, 0);
        }
        return this.borderInsets;
    }

    @Override
    public Insets setBorderStyles() {
        if (this.borderStyles == EMPTY_INSETS) {
            this.borderStyles = new Insets(0, 0, 0, 0);
        }
        return this.borderStyles;
    }

    @Override
    public Insets setMargins() {
        if (this.margins == EMPTY_INSETS) {
            this.margins = new Insets(0, 0, 0, 0);
        }
        return this.margins;
    }

    @Override
    public Insets setPadding() {
        if (this.padding == EMPTY_INSETS) {
            this.padding = new Insets(0, 0, 0, 0);
        }
        return this.padding;
    }

    @Override
    public boolean useDefaultLookAndFeelBorder() {
        return this.borderStyles != null && this.borderStyles.left == 10 && this.borderStyles.right == 10 && this.borderStyles.top == 10 && this.borderStyles.bottom == 10;
    }
}

