/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.LineHeight;
import com.inet.html.parser.converter.VerticalAlign;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DOMUtils {
    public static DOMElement createCopy(Element e, int startOffs, int endOffs, MutableAttributeSet addtionalAttributes) {
        Document document = e.getDocument();
        if (e instanceof AbstractDocument.BranchElement) {
            throw new IllegalArgumentException("Cannot create a branch element with start and end offset");
        }
        try {
            LeafElement copy = new LeafElement(e.getParentElement(), e.getAttributes(), document, startOffs, endOffs);
            if (addtionalAttributes != null) {
                copy.setAttributes(addtionalAttributes);
            }
            return copy;
        }
        catch (BadLocationException e1) {
            throw new IllegalArgumentException(e1);
        }
    }

    public static DOMElement createCopy(Element e, List<DOMElement> children, MutableAttributeSet addtionalAttributes) {
        Document document = e.getDocument();
        if (children.stream().filter(c -> c.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED).findAny().isPresent()) {
            ArrayList<DOMElement> unwrapped = new ArrayList<DOMElement>(children.size());
            for (DOMElement c2 : children) {
                if (c2.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
                    unwrapped.addAll(((BranchElement)c2).getChildren());
                    continue;
                }
                unwrapped.add(c2);
            }
            children = unwrapped;
        }
        if (e instanceof AbstractDocument.BranchElement) {
            BranchElement copy = new BranchElement(e.getParentElement(), e.getAttributes(), document, children);
            if (addtionalAttributes != null) {
                copy.setAttributes(addtionalAttributes);
            }
            return copy;
        }
        throw new IllegalArgumentException("Cannot create a leaf element with children");
    }

    public static VisibleDOMResult copyVisibleDOM(BoxView root, Rectangle clip, ClippingProperty ... properties) {
        double lastContent;
        double firstClipped;
        DOMElement rootElement;
        Document doc;
        ResultMap viewMap = new ResultMap(clip);
        if (properties != null) {
            for (ClippingProperty property : properties) {
                viewMap.setProperty(property, Boolean.TRUE);
            }
        }
        List<DOMElement> result = null;
        if (root.getVisibleDOM(clip, viewMap) && (result = DOMUtils.recurseCopy(root.getElement(), viewMap)) != null && result.get(0) != null && (doc = (rootElement = result.get(0)).getDocument()) instanceof InetHtmlDocument) {
            ((InetHtmlDocument)doc).getStyleResolver().fillAttributesNonLocked(rootElement, null);
        }
        if ((firstClipped = viewMap.getFirstClippedContentLocation()) < 2.147483647E9) {
            firstClipped += (double)clip.y;
        }
        if ((lastContent = viewMap.getLastVisibleContentLocation()) >= -2.147483648E9) {
            lastContent += (double)clip.y;
        }
        return new VisibleDOMResult(result != null ? result.get(0) : null, firstClipped, lastContent);
    }

    private static List<DOMElement> recurseCopy(Element root, Map<Element, DOMVisibilityResult> viewMap) {
        boolean isFillBlock;
        DOMVisibilityResult value = viewMap.get(root);
        if (root.isLeaf()) {
            if (value == null) {
                return null;
            }
            ArrayList<DOMElement> result = new ArrayList<DOMElement>();
            for (DOMVisibilityResultPart part : value.getParts()) {
                switch (part.getVisibility()) {
                    case visible: {
                        part.markAsPainted();
                    }
                    case visible_paged: {
                        result.add(DOMUtils.createCopy(root, part.getStartOffset(), part.getEndOffset(), part.getAdditionalAttributes()));
                        break;
                    }
                    case dummy: {
                        throw new IllegalStateException("Visibilty 'dummy' is for block level elements only");
                    }
                    case fillbreak: {
                        DOMElement leaf = DOMUtils.createCopy(root, part.getStartOffset(), part.getEndOffset(), part.getAdditionalAttributes());
                        leaf.setAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BR);
                        leaf.setAttribute("CR", Boolean.TRUE);
                        leaf.setAttributes(part.getAdditionalAttributes());
                        Object height = part.getAdditionalAttributes().getAttribute((Object)CSS.Attribute.HEIGHT);
                        if (height == null) {
                            result.add(leaf);
                            break;
                        }
                        ArrayList<DOMElement> children = new ArrayList<DOMElement>();
                        children.add(leaf);
                        BranchElement copy = new BranchElement(root.getParentElement(), root.getAttributes(), root.getDocument(), children);
                        copy.setAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                        copy.setAttribute((Object)CSS.Attribute.HEIGHT, height);
                        copy.setAttribute((Object)CSS.Attribute.DISPLAY, new DisplayValue(3));
                        result.add(copy);
                    }
                }
            }
            return result;
        }
        ArrayList<DOMElement> children = new ArrayList<DOMElement>();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element e = root.getElement(i);
            List<DOMElement> copy = DOMUtils.recurseCopy(e, viewMap);
            if (copy == null) continue;
            children.addAll(copy);
        }
        boolean bl = isFillBlock = children.size() == 0 && value != null && (value.getVisibility() == Visibility.dummy || DOMUtils.isRowSpanCell(root));
        if (isFillBlock) {
            DisplayValue disp = StyleResolver.getAttributeValue(root, AttributeFinder.DISPLAY);
            if (disp != null && disp.getDisplay() == 8) {
                SimpleAttributeSet atts = new SimpleAttributeSet();
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.TR);
                BranchElement tr = new BranchElement(root, atts, root.getDocument(), new ArrayList<DOMElement>());
                atts = new SimpleAttributeSet();
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.TD);
                BranchElement td = new BranchElement(tr, atts, root.getDocument(), new ArrayList<DOMElement>());
                tr.add(td);
                SimpleAttributeSet a = new SimpleAttributeSet();
                a.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                a.addAttribute("CR", Boolean.TRUE);
                try {
                    td.add(new LeafElement(td, a, root.getDocument(), root.getStartOffset(), root.getEndOffset()));
                }
                catch (BadLocationException e) {
                    return null;
                }
                children.add(tr);
            } else {
                SimpleAttributeSet a = new SimpleAttributeSet();
                a.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                a.addAttribute("CR", Boolean.TRUE);
                try {
                    children.add(new LeafElement(root, a, root.getDocument(), root.getStartOffset(), root.getEndOffset()));
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
        }
        if (children.size() == 0) {
            return null;
        }
        if (value != null && value.hasView() && !isFillBlock) {
            BoxView view = value.getView();
            if (view.getContentVerticalOffset() != 0) {
                Insets padding = value.getView().getBox().getPadding();
                value.setAttribute((Object)CSS.Attribute.PADDING_TOP, new LengthUnit(padding.top + value.getView().getContentVerticalOffset()));
                value.setAttribute((Object)CSS.Attribute.VERTICAL_ALIGN, VerticalAlign.getAlignValue((byte)7));
            } else if (view.getDisplay() == 12) {
                value.setAttribute((Object)CSS.Attribute.VERTICAL_ALIGN, VerticalAlign.getAlignValue((byte)7));
            }
            if (view.getPainter() != null) {
                view.getPainter().markAsPainted();
            }
        }
        return Arrays.asList(DOMUtils.createCopy(root, children, value != null ? value.getAdditionalAttributes() : null));
    }

    private static boolean isRowSpanCell(Element e) {
        if (e == null) {
            return false;
        }
        DisplayValue display = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        if (display == null || display.getDisplay() != 12) {
            return false;
        }
        IntegerValue span = StyleResolver.getAttributeValue(e, AttributeFinder.ROW_SPAN);
        return span != null && span.getInt() > 1;
    }

    public static void markAllVisible(Element root, Map<Element, DOMVisibilityResult> result) {
        result.put(root, new DOMVisibilityResult(root, Visibility.visible));
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element child = root.getElement(i);
            if (child.isLeaf()) {
                result.put(child, new DOMVisibilityResult(child, Visibility.visible));
                continue;
            }
            DOMUtils.markAllVisible(child, result);
        }
    }

    public static class LeafElement
    extends DOMElement {
        private Position start;
        private Position end;

        public LeafElement(Element parent, AttributeSet a, Document doc, int startOffs, int endOffs) throws BadLocationException {
            super(parent, a, doc);
            this.start = doc.createPosition(startOffs);
            this.end = doc.createPosition(endOffs);
        }

        @Override
        public int getStartOffset() {
            return this.start.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.end.getOffset();
        }

        @Override
        public int getElementIndex(int offset) {
            return 0;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public String toString() {
            try {
                return this.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
            }
            catch (BadLocationException e) {
                return this.getName();
            }
        }
    }

    public static abstract class DOMElement
    extends SimpleAttributeSet
    implements Element {
        private Element parent;
        private Document doc;

        protected DOMElement(Element parent, AttributeSet a, Document doc) {
            this.parent = parent;
            this.addAttributes(a);
            this.doc = doc;
            this.stripTempAttributes(this);
        }

        private void stripTempAttributes(MutableAttributeSet a) {
            ArrayList nameList = new ArrayList(a.getAttributeCount());
            Enumeration<?> names = a.getAttributeNames();
            while (names.hasMoreElements()) {
                nameList.add(names.nextElement());
            }
            for (Object name : nameList) {
                if (!(name instanceof TemporaryStyle.Attribute)) continue;
                a.removeAttribute(name);
            }
        }

        @Override
        public Object getAttribute(Object attrName) {
            Object result = super.getAttribute(attrName);
            if (result == null && this.parent != null) {
                AttributeSet parentAtts = this.parent.getAttributes();
                return parentAtts != null ? parentAtts.getAttribute(attrName) : null;
            }
            return super.getAttribute(attrName);
        }

        public void setParent(Element parent) {
            this.parent = parent;
        }

        @Override
        public Document getDocument() {
            return this.doc;
        }

        @Override
        public Element getParentElement() {
            return this.parent;
        }

        @Override
        public String getName() {
            Object obj = this.getAttribute(StyleConstants.NameAttribute);
            if (obj != null) {
                return obj.toString();
            }
            return HTML.Tag.CONTENT.name();
        }

        public void setAttributes(AttributeSet set) {
            if (set == null) {
                return;
            }
            Enumeration<?> names = set.getAttributeNames();
            while (names.hasMoreElements()) {
                Object key = names.nextElement();
                Object value = set.getAttribute(key);
                if (value != null) {
                    this.addAttribute(key, value);
                    continue;
                }
                this.removeAttribute(key);
            }
        }

        public void setAttribute(Object key, Object value) {
            this.removeAttribute(key);
            this.addAttribute(key, value);
        }

        @Override
        public MutableAttributeSet getAttributes() {
            return this;
        }
    }

    public static class BranchElement
    extends DOMElement {
        private List<DOMElement> children;

        public BranchElement(Element parent, AttributeSet a, Document doc, List<DOMElement> children) {
            super(parent, a, doc);
            this.children = children;
            children.forEach(c -> c.setParent(this));
        }

        @Override
        public int getStartOffset() {
            return this.children.get(0).getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.children.get(this.children.size() - 1).getEndOffset();
        }

        @Override
        public int getElementIndex(int offset) {
            Optional<DOMElement> result = this.children.stream().filter(c -> c.getStartOffset() <= offset && c.getEndOffset() > offset).findFirst();
            return result.isPresent() ? this.children.indexOf(result.get()) : -1;
        }

        @Override
        public int getElementCount() {
            return this.children.size();
        }

        @Override
        public Element getElement(int index) {
            return this.children.get(index);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String toString() {
            return this.getName() + ": " + this.children.stream().map(c -> c.getName()).collect(Collectors.joining(", "));
        }

        public List<DOMElement> getChildren() {
            return this.children;
        }

        public void add(DOMElement child) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public static class ResultMap
    extends HashMap<Element, DOMVisibilityResult> {
        private Map<ClippingProperty, Object> properties = new HashMap<ClippingProperty, Object>();
        private double firstClipped = 2.147483647E9;
        private double lastContent = -2.147483648E9;
        private Rectangle clip;

        public ResultMap(Rectangle clip) {
            this.clip = clip;
        }

        public void setProperty(ClippingProperty property, Object value) {
            this.properties.put(property, value);
        }

        public Rectangle getBaseClip() {
            return this.clip;
        }

        public boolean isSet(ClippingProperty property) {
            return Boolean.TRUE.equals(this.properties.get((Object)property));
        }

        public Object getProperty(ClippingProperty property) {
            return this.properties.get((Object)property);
        }

        public void merge(ResultMap lineElements) {
            for (Map.Entry e : lineElements.entrySet()) {
                Element element = (Element)e.getKey();
                DOMVisibilityResult r = (DOMVisibilityResult)this.get(element);
                if (((DOMVisibilityResult)e.getValue()).getParts().size() == 0) continue;
                if (r != null) {
                    r.add((DOMVisibilityResult)e.getValue());
                    continue;
                }
                this.put(element, (DOMVisibilityResult)e.getValue());
            }
            if (lineElements.lastContent > -2.147483648E9) {
                this.setLastVisibleContentLocation(lineElements.lastContent);
            }
            if (lineElements.firstClipped < 2.147483647E9) {
                this.setFirstClippedContentLocation(lineElements.firstClipped);
            }
        }

        public void setFirstClippedContentLocation(double y) {
            this.firstClipped = Math.min(this.firstClipped, y);
        }

        public double getFirstClippedContentLocation() {
            return this.firstClipped;
        }

        public void setLastVisibleContentLocation(double lastContent) {
            this.lastContent = Math.max(lastContent, this.lastContent);
        }

        public double getLastVisibleContentLocation() {
            return this.lastContent;
        }
    }

    public static enum ClippingProperty {
        WholeContentOnly,
        FirstLineRendered;

    }

    public static class VisibleDOMResult {
        private DOMElement dom;
        private double firstClippedPosition;
        private double lastContent;

        private VisibleDOMResult(DOMElement dom, double firstClippedPosition, double lastContent) {
            this.dom = dom;
            this.firstClippedPosition = firstClippedPosition;
            this.lastContent = lastContent;
        }

        public DOMElement getVisibleDOM() {
            return this.dom;
        }

        public double getFirstClippedPosition() {
            return this.firstClippedPosition;
        }

        public double getLastContentPosition() {
            return this.lastContent;
        }
    }

    public static class DOMVisibilityResult {
        private List<DOMVisibilityResultPart> parts = new ArrayList<DOMVisibilityResultPart>();

        public DOMVisibilityResult(BoxView view, Visibility visibility) {
            if (view instanceof ContentView && (visibility == Visibility.visible || visibility == Visibility.visible_paged)) {
                this.addVisibleArea((ContentView)view, visibility == Visibility.visible_paged);
            } else {
                this.parts.add(new DOMVisibilityResultPart(view, visibility));
            }
        }

        public DOMVisibilityResult(Element element, Visibility visibility) {
            this.parts.add(new DOMVisibilityResultPart(element, visibility));
        }

        public DOMVisibilityResult() {
        }

        public DOMVisibilityResult addVisibleArea(ContentView view, boolean partial) {
            int start = view.getStartOffset();
            if (this.parts.size() > 0) {
                Visibility newVisibility;
                DOMVisibilityResultPart recent = this.parts.get(this.parts.size() - 1);
                Visibility visibility = newVisibility = partial ? Visibility.visible_paged : Visibility.visible;
                if (recent.visibility == newVisibility && recent.getEndOffset() == start) {
                    recent.addVisibleArea(view);
                    return this;
                }
            }
            this.parts.add(new DOMVisibilityResultPart(view, view.getStartOffset(), view.getEndOffset(), partial));
            return this;
        }

        public DOMVisibilityResult addFillLine(BoxView view, int lineHeight) {
            DOMVisibilityResultPart part = new DOMVisibilityResultPart(view, Visibility.fillbreak);
            if (lineHeight > 0) {
                part.setAttribute((Object)CSS.Attribute.HEIGHT, new LineHeight(lineHeight));
            }
            this.parts.add(part);
            return this;
        }

        public boolean isMultiPart() {
            return this.parts.size() > 1;
        }

        private void checkMultiPart() {
            if (this.isMultiPart()) {
                throw new IllegalStateException("Single-Part methods must not be used on Multi-Part results.");
            }
        }

        public List<DOMVisibilityResultPart> getParts() {
            return this.parts;
        }

        public BoxView getView() {
            this.checkMultiPart();
            return (BoxView)this.parts.get(0).views.get(0);
        }

        public boolean hasView() {
            this.checkMultiPart();
            return this.parts.get(0).views.size() > 0 && this.parts.get(0).views.get(0) != null;
        }

        public Visibility getVisibility() {
            this.checkMultiPart();
            return this.parts.get(0).getVisibility();
        }

        public void setAttribute(Object key, Object value) {
            this.checkMultiPart();
            this.parts.get(0).setAttribute(key, value);
        }

        public MutableAttributeSet getAdditionalAttributes() {
            this.checkMultiPart();
            return this.parts.get(0).getAdditionalAttributes();
        }

        public void add(DOMVisibilityResult result) {
            boolean sort = this.parts.size() > 0 && result.getParts().size() > 0;
            this.parts.addAll(result.getParts());
            if (sort) {
                Collections.sort(this.parts);
            }
        }
    }

    public static class DOMVisibilityResultPart
    implements Comparable<DOMVisibilityResultPart> {
        private List<BoxView> views = new ArrayList<BoxView>();
        private Visibility visibility;
        private MutableAttributeSet additionalAtts = null;
        private int startOffset = -1;
        private int endOffset = -1;

        public DOMVisibilityResultPart(BoxView view, Visibility visibility) {
            this.views.add(view);
            this.visibility = visibility;
            this.startOffset = view.getStartOffset();
            this.endOffset = view.getEndOffset();
        }

        public DOMVisibilityResultPart(Element element, Visibility visibility) {
            this.visibility = visibility;
            this.startOffset = element.getStartOffset();
            this.endOffset = element.getEndOffset();
        }

        private DOMVisibilityResultPart(ContentView view, int startOffset, int endOffset, boolean partial) {
            this.views.add(view);
            this.visibility = partial ? Visibility.visible_paged : Visibility.visible;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public void addVisibleArea(ContentView view) {
            this.views.add(view);
            this.startOffset = Math.min(view.getStartOffset(), this.startOffset);
            this.endOffset = Math.max(view.getEndOffset(), this.endOffset);
        }

        private void markAsPainted() {
            for (BoxView view : this.views) {
                if (view.getPainter() == null) continue;
                view.getPainter().markAsPainted();
            }
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public void setAttribute(Object key, Object value) {
            if (this.additionalAtts == null) {
                this.additionalAtts = new SimpleAttributeSet();
            }
            if (value == null && this.additionalAtts.isDefined(key)) {
                this.additionalAtts.removeAttribute(key);
            } else {
                this.additionalAtts.addAttribute(key, value);
            }
        }

        public MutableAttributeSet getAdditionalAttributes() {
            return this.additionalAtts;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public int compareTo(DOMVisibilityResultPart o) {
            int diff = Integer.compare(this.startOffset, o.startOffset);
            if (diff != 0) {
                return diff;
            }
            return Integer.compare(this.endOffset, o.endOffset);
        }
    }

    public static enum Visibility {
        visible,
        visible_paged,
        dummy,
        fillbreak;

    }
}

