/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;

public class ZIndexValue
extends SingleAttributeValue {
    static final ZIndexValue PARSER = new ZIndexValue();
    private boolean isAuto = false;
    private int intValue = 0;

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        if ("auto".equalsIgnoreCase(valueStr)) {
            ZIndexValue intValue = new ZIndexValue();
            intValue.isAuto = true;
            intValue.setString(valueStr);
            intValue.setImportant(important);
            return intValue;
        }
        try {
            if ("inherit".equalsIgnoreCase(valueStr)) {
                return AttributeValue.INHERIT;
            }
            int val = Integer.parseInt(valueStr);
            ZIndexValue intValue = new ZIndexValue();
            intValue.intValue = val;
            intValue.setString(valueStr);
            intValue.setImportant(important);
            return intValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public int getInt() {
        return this.intValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ZIndexValue) {
            ZIndexValue other = (ZIndexValue)obj;
            if (other.getInt() != this.getInt()) {
                return false;
            }
            if (other.isAuto() != this.isAuto()) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }
}

