/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;

public class BorderStyleValue
extends SingleAttributeValue {
    public static final int NONE = 0;
    public static final int INSET = 1;
    public static final int GROOVE = 2;
    public static final int OUTSET = 3;
    public static final int RIDGE = 4;
    public static final int DOTTED = 5;
    public static final int DASHED = 6;
    public static final int SOLID = 7;
    public static final int DOUBLE = 8;
    public static final int HIDDEN = 9;
    public static final int LNF_DEFAULT = 10;
    private int style;
    private static final Hashtable<String, BorderStyleValue> MAP = new Hashtable();
    static final BorderStyleValue PARSER;

    public BorderStyleValue(String strValue, int intValue) {
        this.style = intValue;
        this.setString(strValue);
    }

    private BorderStyleValue() {
    }

    private static void factory(String strValue, int intValue) {
        BorderStyleValue style = new BorderStyleValue();
        style.style = intValue;
        style.setString(strValue);
        MAP.put(strValue, style);
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        if ("inherit".equalsIgnoreCase(valueStr)) {
            return AttributeValue.INHERIT;
        }
        return MAP.get(valueStr != null ? valueStr.toLowerCase() : null);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BorderStyleValue)) {
            return false;
        }
        BorderStyleValue other = (BorderStyleValue)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.style == other.style;
    }

    static {
        BorderStyleValue.factory("none", 0);
        BorderStyleValue.factory("hidden", 9);
        BorderStyleValue.factory("dotted", 5);
        BorderStyleValue.factory("dashed", 6);
        BorderStyleValue.factory("solid", 7);
        BorderStyleValue.factory("double", 8);
        BorderStyleValue.factory("groove", 2);
        BorderStyleValue.factory("ridge", 4);
        BorderStyleValue.factory("inset", 1);
        BorderStyleValue.factory("outset", 3);
        BorderStyleValue.factory("lnfdefault", 10);
        PARSER = MAP.get("none");
    }
}

