/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.image.AnimationObserver;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.URLResolver;
import com.inet.html.utils.Logger;
import com.inet.html.views.RenderContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageFetcher {
    private static boolean useToolkit = false;
    private static LinkedBlockingQueue<ImageLoadData> pending = new LinkedBlockingQueue();
    private static Vector<FetcherThread> threads = new Vector();
    private static int THREAD_COUNT = 5;
    private static int DEFAULT_DELAY = 100;

    public static void setUseToolkit(boolean useToolkit) {
        ImageFetcher.useToolkit = useToolkit;
    }

    public RemoteImage getImage(URL location, int timeout, boolean progressive, AnimationObserver observer) {
        if (location == null) {
            return null;
        }
        return this.getImage(new URLResolver(location), timeout, progressive, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteImage getImage(URLResolver resolver, int timeout, boolean progressive, AnimationObserver observer) {
        Vector<FetcherThread> vector = threads;
        synchronized (vector) {
            for (FetcherThread t : threads) {
                ImageLoadData threadImage = t.img;
                if (threadImage == null || threadImage.getImage() == null || !resolver.equals(threadImage.getImage().getResolver())) continue;
                RemoteImage img = threadImage.getImage();
                img.addObserver(observer);
                if (img.getWidth() > 0 || img.getHeight() > 0) {
                    img.imageUpdate(3, 0, 0, img.getWidth(), img.getHeight());
                }
                return img;
            }
        }
        RemoteImage img = new RemoteImage(resolver, timeout);
        img.addObserver(observer);
        pending.offer(new ImageLoadData(img, progressive));
        ImageFetcher.checkThreadStates();
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkThreadStates() {
        Vector<FetcherThread> vector = threads;
        synchronized (vector) {
            if (threads.size() >= THREAD_COUNT) {
                return;
            }
            FetcherThread fetcher = new FetcherThread();
            Thread t = new Thread(fetcher);
            try {
                t.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t.start();
            threads.add(fetcher);
        }
    }

    public static InputStream openStreamFromURL(URL url, int timeout) throws IOException, MalformedURLException {
        URLConnection connection = ImageFetcher.openConnection(url, timeout);
        return ImageFetcher.openStream(connection);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The image fetcher can access any location referenced by IMG-elements or background images. But it can only load image ressources, any other content will be ignored.")
    public static URLConnection openConnection(URL url, int timeout) throws IOException, MalformedURLException {
        String location;
        HttpURLConnection httpConnection;
        int code;
        URLConnection connection = url.openConnection();
        if (timeout >= 0) {
            connection.setConnectTimeout(timeout);
        }
        RenderContext.setSSLSocketFactory(connection);
        InputStream sourceStream = connection.getInputStream();
        if (connection instanceof HttpURLConnection && (code = (httpConnection = (HttpURLConnection)connection).getResponseCode()) >= 300 && code < 400 && (location = httpConnection.getHeaderField("Location")) != null) {
            sourceStream.close();
            connection = new URL(location).openConnection();
            if (timeout >= 0) {
                connection.setConnectTimeout(timeout);
            }
            RenderContext.setSSLSocketFactory(connection);
            sourceStream = connection.getInputStream();
        }
        return connection;
    }

    public static InputStream openStream(URLConnection connection) throws IOException {
        String contentEncoding;
        InputStream sourceStream = connection.getInputStream();
        if (connection instanceof HttpURLConnection && (contentEncoding = ((HttpURLConnection)connection).getContentEncoding()) != null && contentEncoding.equalsIgnoreCase("gzip")) {
            sourceStream = new GZIPInputStream(sourceStream);
        }
        return sourceStream;
    }

    public static Image fetchImage(File location) throws IOException {
        RemoteImage image = new RemoteImage(location.toURI().toURL(), 0);
        FileImageInputStream stream = new FileImageInputStream(location);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            ImageFetcher.fetchImage(stream, reader, false, image);
            return image.getContent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchImage(ImageInputStream stream, ImageReader reader, boolean progressive, RemoteImage targetImage) throws IOException {
        BufferedImage image;
        ImageProgressiveLoadListener pListener = null;
        ImageLoadListener listener = null;
        reader.setInput(stream, true, true);
        int orientation = -1;
        boolean requiresRotation = false;
        try {
            ImageReadParam param;
            block25: {
                param = reader.getDefaultReadParam();
                try {
                    IIOMetadata imageMetadata = reader.getImageMetadata(0);
                    if (!imageMetadata.isStandardMetadataFormatSupported()) break block25;
                    Node metaTree = imageMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
                    NodeList childNodes = metaTree.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        if ("markerSequence".equals(childNodes.item(i).getNodeName())) {
                            NodeList markerSequenceChildren = childNodes.item(i).getChildNodes();
                            for (int j = 0; j < markerSequenceChildren.getLength(); ++j) {
                                IIOMetadataNode metadataNode = (IIOMetadataNode)markerSequenceChildren.item(j);
                                byte[] bytes = (byte[])metadataNode.getUserObject();
                                if (bytes == null) continue;
                                byte[] magicNumber = new byte[4];
                                ByteBuffer.wrap(bytes).get(magicNumber);
                                if ("Exif".equals(new String(magicNumber))) {
                                    orientation = ImageFetcher.findOrientation(bytes);
                                }
                                if (orientation != -1) break;
                            }
                        }
                        if (orientation == -1) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable iae) {
                    if (!Logger.doesLog(4)) break block25;
                    Logger.debug("Error reading user image meta data");
                    Logger.warning(iae);
                }
            }
            boolean bl = requiresRotation = orientation != -1 && orientation != 1;
            if (requiresRotation) {
                progressive = false;
            }
            if (progressive) {
                pListener = new ImageProgressiveLoadListener(targetImage);
                reader.addIIOReadUpdateListener(pListener);
                listener = new ImageLoadListener(targetImage);
                reader.addIIOReadProgressListener(listener);
            }
            image = reader.read(0, param);
            int width = image.getWidth();
            int height = image.getHeight();
            if (requiresRotation) {
                AffineTransform t = new AffineTransform();
                switch (orientation) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        t.scale(-1.0, 1.0);
                        t.translate(-width, 0.0);
                        break;
                    }
                    case 3: {
                        t.translate(width, height);
                        t.rotate(Math.PI);
                        break;
                    }
                    case 4: {
                        t.scale(1.0, -1.0);
                        t.translate(0.0, -height);
                        break;
                    }
                    case 5: {
                        t.rotate(-1.5707963267948966);
                        t.scale(-1.0, 1.0);
                        break;
                    }
                    case 6: {
                        t.translate(height, 0.0);
                        t.rotate(1.5707963267948966);
                        break;
                    }
                    case 7: {
                        t.scale(-1.0, 1.0);
                        t.translate(-height, 0.0);
                        t.translate(0.0, width);
                        t.rotate(4.71238898038469);
                        break;
                    }
                    case 8: {
                        t.translate(0.0, width);
                        t.rotate(4.71238898038469);
                        break;
                    }
                }
                AffineTransformOp op = new AffineTransformOp(t, 3);
                BufferedImage tempImage = op.createCompatibleDestImage(image, image.getType() == 10 ? image.getColorModel() : null);
                Graphics2D g = (Graphics2D)tempImage.getGraphics();
                g.setTransform(t);
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                image = tempImage;
            }
            if (pListener != null) {
                reader.removeIIOReadUpdateListener(pListener);
                reader.removeIIOReadProgressListener(listener);
            }
        }
        catch (Throwable throwable) {
            if (pListener != null) {
                reader.removeIIOReadUpdateListener(pListener);
                reader.removeIIOReadProgressListener(listener);
            }
            throw throwable;
        }
        targetImage.setContent(image);
        if (!progressive) {
            targetImage.imageUpdate(32, 0, 0, image.getWidth(), image.getHeight());
        }
    }

    private static int findOrientation(byte[] exifData) {
        if (exifData == null || exifData.length == 0) {
            return -1;
        }
        ByteBuffer buf = ByteBuffer.wrap(exifData);
        if (buf.getInt() != 1165519206 || buf.getShort() != 0) {
            throw new IllegalArgumentException("Invalid EXIF Header!");
        }
        buf = buf.slice();
        switch (buf.getShort()) {
            case 18761: {
                buf.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            case 19789: {
                buf.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid byte order!");
            }
        }
        if (buf.getShort() != 42) {
            throw new IllegalArgumentException("Invalid TIFF Header!");
        }
        buf.position(buf.getInt());
        int numOfTags = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numOfTags; ++i) {
            short currentTag = buf.getShort();
            if (currentTag == 274) {
                buf.position(buf.position() + 6);
                return buf.getShort() & 0xFF;
            }
            buf.position(buf.position() + 10);
        }
        return -1;
    }

    static /* synthetic */ LinkedBlockingQueue access$200() {
        return pending;
    }

    static /* synthetic */ boolean access$300() {
        return useToolkit;
    }

    static /* synthetic */ Vector access$400() {
        return threads;
    }

    static {
        ImageIO.setUseCache(false);
    }

    private static class FetcherThread
    implements Runnable {
        private ImageLoadData img;

        private FetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setName("JWebEngine Image Fetcher");
            }
            catch (SecurityException var1_1) {
                // empty catch block
            }
            while (true) lbl-1000:
            // 8 sources

            {
                this.img = (ImageLoadData)ImageFetcher.access$200().poll();
                if (this.img == null) {
                    return;
                }
                refImage = this.img.getImage();
                if (ImageFetcher.access$300()) {
                    data = new byte[16384];
                    try {
                        in = refImage.getResolver().getContent(refImage.getConnectionTimeout());
                        try {
                            buffer = new ByteArrayOutputStream();
                            while ((nRead = in.read(data, 0, data.length)) != -1) {
                                buffer.write(data, 0, nRead);
                            }
                            data = buffer.toByteArray();
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        refImage.imageUpdate(64, 0, 0, 0, 0);
                        Logger.error("Exception " + e.getClass() + " while read for data from: " + refImage.getLocationString());
                        continue;
                    }
                    refImage.setContent(Toolkit.getDefaultToolkit().createImage(data));
                    Toolkit.getDefaultToolkit().checkImage(refImage.getContent(), -1, -1, new ImageObserver(){

                        @Override
                        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                            refImage.imageUpdate(infoflags, x, y, width, height);
                            return (infoflags & 0x20) <= 0 && (infoflags & 0x80) <= 0 && (infoflags & 0x40) <= 0;
                        }
                    });
                    continue;
                }
                sourceStream = null;
                stream = null;
                try {
                    sourceStream = refImage.getResolver().getContent(refImage.getConnectionTimeout());
                    stream = ImageIO.createImageInputStream(sourceStream);
                    readers = ImageIO.getImageReaders(stream);
                    if (readers.hasNext()) {
                        reader = readers.next();
                        if (reader.getFormatName().toLowerCase().equals("gif")) {
                            this.loadImageGIF(stream, reader);
                        }
                        this.loadImageDefault(stream, reader, this.img.isProgressive());
                    }
                    refImage.imageUpdate(64, 0, 0, 0, 0);
                    Logger.error("No image reader for data from: " + refImage.getLocationString());
                }
                catch (Throwable ex) {
                    refImage.imageUpdate(64, 0, 0, 0, 0);
                    Logger.error("Error loading image from : " + refImage.getLocationString());
                    Logger.error(ex);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException readers) {}
                    }
                    if (sourceStream == null) continue;
                    try {
                        sourceStream.close();
                    }
                    catch (IOException readers) {}
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                ImageFetcher.access$400().remove(this);
            }
        }

        private void loadImageGIF(ImageInputStream stream, ImageReader reader) throws IOException {
            reader.setInput(stream, true, false);
            int maxImages = Short.MAX_VALUE;
            BufferedImage backdrop = null;
            for (int i = 0; i < maxImages; ++i) {
                try {
                    BufferedImage image = reader.read(i);
                    Rectangle bounds = null;
                    int delay = DEFAULT_DELAY;
                    int tIndex = -1;
                    boolean restoreBackground = false;
                    IIOMetadata meta = reader.getImageMetadata(i);
                    if (meta != null) {
                        Node node = meta.getAsTree("javax_imageio_gif_image_1.0");
                        bounds = this.getGIFBoundsFromMetadata(node);
                        delay = this.getGIFdelay(node);
                        tIndex = this.getTransparentColorIndex(node);
                        restoreBackground = this.restoreBackground(node);
                    }
                    if (backdrop == null) {
                        backdrop = new BufferedImage(image.getWidth(), image.getHeight(), 6);
                        backdrop.getGraphics().drawImage(image, 0, 0, null);
                    } else {
                        Graphics g = backdrop.getGraphics();
                        if (restoreBackground) {
                            g.setColor(Color.WHITE);
                            g.fillRect(0, 0, backdrop.getWidth(), backdrop.getHeight());
                        }
                        if (bounds == null) {
                            g.drawImage(image, 0, 0, null);
                        } else {
                            g.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, null);
                        }
                        if (tIndex > 0) {
                            BufferedImage copy;
                            if (bounds == null) {
                                copy = new BufferedImage(backdrop.getWidth(), backdrop.getHeight(), 6);
                                copy.getGraphics().drawImage(backdrop, 0, 0, null);
                            } else {
                                copy = new BufferedImage(bounds.width, bounds.height, 6);
                                copy.getGraphics().drawImage(backdrop, -bounds.x, -bounds.y, null);
                            }
                            image = copy;
                        }
                    }
                    this.img.getImage().addContent(image, delay, bounds);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    return;
                }
            }
        }

        private int getTransparentColorIndex(Node node) {
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node child = list.item(j);
                if (!"GraphicControlExtension".equals(child.getNodeName())) continue;
                NamedNodeMap atts = child.getAttributes();
                Node hasTransparency = atts.getNamedItem("transparentColorFlag");
                Node transparencyIndex = atts.getNamedItem("transparentColorIndex");
                if (hasTransparency == null || !Boolean.valueOf(hasTransparency.getNodeValue()).booleanValue()) break;
                try {
                    return Integer.valueOf(transparencyIndex.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            return -1;
        }

        private boolean restoreBackground(Node node) {
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node child = list.item(j);
                if (!"GraphicControlExtension".equals(child.getNodeName())) continue;
                NamedNodeMap atts = child.getAttributes();
                Node disposalMethod = atts.getNamedItem("disposalMethod");
                return disposalMethod != null && "restoreToBackgroundColor".equals(disposalMethod.getNodeValue());
            }
            return false;
        }

        private int getGIFdelay(Node node) {
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node child = list.item(j);
                if (!"GraphicControlExtension".equals(child.getNodeName())) continue;
                NamedNodeMap atts = child.getAttributes();
                Node timeNode = atts.getNamedItem("delayTime");
                if (timeNode == null || timeNode.getNodeValue() == null) break;
                try {
                    return Integer.valueOf(timeNode.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            return DEFAULT_DELAY;
        }

        private Rectangle getGIFBoundsFromMetadata(Node treeRoot) {
            NodeList list = treeRoot.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node child = list.item(j);
                if (!"ImageDescriptor".equals(child.getNodeName())) continue;
                NamedNodeMap atts = child.getAttributes();
                try {
                    int x = Integer.valueOf(atts.getNamedItem("imageLeftPosition").getNodeValue());
                    int y = Integer.valueOf(atts.getNamedItem("imageTopPosition").getNodeValue());
                    int width = Integer.valueOf(atts.getNamedItem("imageWidth").getNodeValue());
                    int height = Integer.valueOf(atts.getNamedItem("imageHeight").getNodeValue());
                    return new Rectangle(x, y, width, height);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        private void loadImageDefault(ImageInputStream stream, ImageReader reader, boolean progressive) throws IOException {
            ImageFetcher.fetchImage(stream, reader, progressive, this.img.getImage());
        }
    }

    private static class ImageLoadData {
        private RemoteImage image;
        private boolean progressive;

        public ImageLoadData(RemoteImage image, boolean progressive) {
            this.image = image;
            this.progressive = progressive;
        }

        public RemoteImage getImage() {
            return this.image;
        }

        public boolean isProgressive() {
            return this.progressive;
        }
    }

    private static class ImageProgressiveLoadListener
    implements IIOReadUpdateListener {
        private final RemoteImage img;
        private int width;
        private int height;
        private boolean filled = false;

        public ImageProgressiveLoadListener(RemoteImage img) {
            this.img = img;
        }

        @Override
        public void imageUpdate(ImageReader source, BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
            this.img.setContent(theImage);
            if (!this.filled) {
                this.filled = true;
                if (minY == 0 && periodX <= 1 && periodY <= 1 && height < theImage.getHeight() && width == theImage.getWidth()) {
                    Graphics g = theImage.getGraphics();
                    if (theImage.getColorModel().hasAlpha()) {
                        g.setColor(new Color(255, 255, 255, 255));
                    } else {
                        g.setColor(Color.WHITE);
                    }
                    g.fillRect(0, height, width, theImage.getHeight() - height);
                }
            }
            if (theImage != null) {
                int flags = 0;
                if (theImage.getWidth() != width) {
                    this.width = theImage.getWidth();
                    ++flags;
                }
                if (theImage.getHeight() != height) {
                    this.height = theImage.getHeight();
                    flags += 2;
                }
                if (flags != 0) {
                    this.img.imageUpdate(flags, 0, 0, this.width, this.height);
                    return;
                }
            }
            this.img.imageUpdate(8, minX, minY, width, height);
        }

        @Override
        public void passComplete(ImageReader source, BufferedImage theImage) {
            this.img.setContent(theImage);
            this.img.imageUpdate(16, 0, 0, this.width, this.height);
        }

        @Override
        public void passStarted(ImageReader source, BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
            this.img.setContent(theImage);
        }

        @Override
        public void thumbnailPassComplete(ImageReader source, BufferedImage theThumbnail) {
        }

        @Override
        public void thumbnailPassStarted(ImageReader source, BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        }

        @Override
        public void thumbnailUpdate(ImageReader source, BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        }
    }

    private static class ImageLoadListener
    implements IIOReadProgressListener {
        private final RemoteImage img;

        public ImageLoadListener(RemoteImage img) {
            this.img = img;
        }

        @Override
        public void imageComplete(ImageReader source) {
            this.img.imageUpdate(32, 0, 0, this.img.getWidth(), this.img.getHeight());
        }

        @Override
        public void imageProgress(ImageReader source, float percentageDone) {
        }

        @Override
        public void imageStarted(ImageReader source, int imageIndex) {
        }

        @Override
        public void readAborted(ImageReader source) {
            this.img.imageUpdate(128, 0, 0, this.img.getWidth(), this.img.getHeight());
        }

        @Override
        public void sequenceComplete(ImageReader source) {
            this.img.imageUpdate(16, 0, 0, this.img.getWidth(), this.img.getHeight());
        }

        @Override
        public void sequenceStarted(ImageReader source, int minIndex) {
        }

        @Override
        public void thumbnailComplete(ImageReader source) {
        }

        @Override
        public void thumbnailProgress(ImageReader source, float percentageDone) {
        }

        @Override
        public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
        }
    }
}

