/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.annotations.PublicApi;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.TextDecoration;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

@PublicApi
public class CSS {
    private static final Hashtable<String, Attribute> ATTRIBUTE_MAP = new Hashtable();

    public static final Attribute getAttribute(String name) {
        return ATTRIBUTE_MAP.get(name);
    }

    public static void setTextColor(MutableAttributeSet a, Color color) {
        a.addAttribute((Object)Attribute.COLOR, new ColorValue(color));
    }

    public static void setFontSizePT(MutableAttributeSet a, int size) {
        FontSize fontSize = new FontSize(size, true);
        a.addAttribute((Object)Attribute.FONT_SIZE, fontSize);
    }

    public static void setFontSizePT(MutableAttributeSet a, float size) {
        FontSize fontSize = new FontSize(size, true);
        a.addAttribute((Object)Attribute.FONT_SIZE, fontSize);
    }

    public static void setFontSize(MutableAttributeSet a, int size) {
        FontSize fontSize = new FontSize(size, false);
        a.addAttribute((Object)Attribute.FONT_SIZE, fontSize);
    }

    public static void setFontWeight(MutableAttributeSet a, boolean bold) {
        FontWeight fontWeight = new FontWeight(bold);
        a.addAttribute((Object)Attribute.FONT_WEIGHT, fontWeight);
    }

    public static void setFontStyle(MutableAttributeSet a, boolean italic) {
        FontStyle fontStyle = new FontStyle(italic);
        a.addAttribute((Object)Attribute.FONT_STYLE, fontStyle);
    }

    public static void setTextDecoration(MutableAttributeSet a, int decoration) {
        TextDecoration textDecoration = new TextDecoration(decoration);
        a.addAttribute((Object)Attribute.TEXT_DECORATION, textDecoration);
    }

    public static void setFontFamily(MutableAttributeSet a, String family) {
        FontFamily fontFamily = new FontFamily(family);
        a.addAttribute((Object)Attribute.FONT_FAMILY, fontFamily);
    }

    public static boolean isBold(Element element) {
        FontWeight bold = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_WEIGHT);
        return bold != null && bold.isBold();
    }

    public static boolean isItalic(Element element) {
        FontStyle style = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_STYLE);
        return style != null && style.isItalic();
    }

    public static boolean isUnderline(Element element) {
        TextDecoration decoration = StyleResolver.getAttributeValue(element, AttributeFinder.TEXT_DECORATION);
        return decoration != null && decoration.getDecoration() == 1;
    }

    public static void setMarginLeft(MutableAttributeSet a, int pixels) {
        LengthUnit margin = new LengthUnit(pixels + "px");
        a.addAttribute((Object)Attribute.MARGIN_LEFT, margin);
    }

    static {
        for (Attribute attr : Attribute.values()) {
            ATTRIBUTE_MAP.put(attr.toString(), attr);
        }
        ATTRIBUTE_MAP.put("-webkit-transform", Attribute.TRANSFORM);
        ATTRIBUTE_MAP.put("-ms-transform", Attribute.TRANSFORM);
        ATTRIBUTE_MAP.put("-moz-transform", Attribute.TRANSFORM);
        ATTRIBUTE_MAP.put("-webkit-transform-origin", Attribute.TRANSFORM_ORIGIN);
        ATTRIBUTE_MAP.put("-ms-transform-origin", Attribute.TRANSFORM_ORIGIN);
        ATTRIBUTE_MAP.put("-moz-transform-origin", Attribute.TRANSFORM_ORIGIN);
    }

    public static enum Attribute {
        BACKGROUND("background"),
        BACKGROUND_ATTACHMENT("background-attachment"),
        BACKGROUND_COLOR("background-color"),
        BACKGROUND_IMAGE("background-image"),
        BACKGROUND_POSITION("background-position"),
        BACKGROUND_REPEAT("background-repeat"),
        BACKGROUND_SIZE("background-size"),
        BORDER("border"),
        BORDER_BOTTOM("border-bottom"),
        BORDER_BOTTOM_COLOR("border-bottom-color"),
        BORDER_BOTTOM_STYLE("border-bottom-style"),
        BORDER_BOTTOM_WIDTH("border-bottom-width"),
        BORDER_COLLAPSE("border-collapse"),
        BORDER_COLOR("border-color"),
        BORDER_LEFT("border-left"),
        BORDER_LEFT_COLOR("border-left-color"),
        BORDER_LEFT_STYLE("border-left-style"),
        BORDER_LEFT_WIDTH("border-left-width"),
        BORDER_RIGHT("border-right"),
        BORDER_RIGHT_COLOR("border-right-color"),
        BORDER_RIGHT_STYLE("border-right-style"),
        BORDER_RIGHT_WIDTH("border-right-width"),
        BORDER_SPACING("border-spacing"),
        BORDER_STYLE("border-style"),
        BORDER_TOP("border-top"),
        BORDER_TOP_COLOR("border-top-color"),
        BORDER_TOP_STYLE("border-top-style"),
        BORDER_TOP_WIDTH("border-top-width"),
        BORDER_WIDTH("border-width"),
        BOTTOM("bottom"),
        CLEAR("clear"),
        CONTENT("content"),
        COLOR("color"),
        DISPLAY("display"),
        DIRECTION("direction"),
        FLOAT("float"),
        FONT("font"),
        FONT_FAMILY("font-family"),
        FONT_SIZE("font-size"),
        FONT_STYLE("font-style"),
        FONT_VARIANT("font-variant"),
        FONT_WEIGHT("font-weight"),
        HEIGHT("height"),
        LEFT("left"),
        LETTER_SPACING("letter-spacing"),
        LINE_HEIGHT("line-height"),
        LIST_STYLE("list-style"),
        LIST_STYLE_IMAGE("list-style-image"),
        LIST_STYLE_POSITION("list-style-position"),
        LIST_STYLE_TYPE("list-style-type"),
        MARGIN("margin"),
        MARGIN_BOTTOM("margin-bottom"),
        MARGIN_LEFT("margin-left"),
        MARGIN_RIGHT("margin-right"),
        MARGIN_TOP("margin-top"),
        MAX_HEIGHT("max-height"),
        MAX_WIDTH("max-width"),
        MIN_HEIGHT("min-height"),
        MIN_WIDTH("min-width"),
        OUTLINE("outline"),
        OVERFLOW("overflow"),
        OVERFLOW_WRAP("overflow-wrap"),
        PADDING("padding"),
        PADDING_BOTTOM("padding-bottom"),
        PADDING_LEFT("padding-left"),
        PADDING_RIGHT("padding-right"),
        PADDING_TOP("padding-top"),
        POSITION("position"),
        RIGHT("right"),
        SPAN("span"),
        TEXT_ALIGN("text-align"),
        TEXT_DECORATION("text-decoration"),
        TEXT_INDENT("text-indent"),
        TEXT_TRANSFORM("text-transform"),
        TOP("top"),
        TRANSFORM("transform"),
        TRANSFORM_ORIGIN("transform-origin"),
        VERTICAL_ALIGN("vertical-align"),
        VISIBILITY("visibility"),
        WORD_SPACING("word-spacing"),
        WHITE_SPACE("white-space"),
        WIDTH("width"),
        UNICODEBIDI("unicode-bidi"),
        ZINDEX("z-index");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class UnknownAttribute
    extends CSS {
        private String name;

        public UnknownAttribute(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

