/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlFactory;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.views.BoxView;
import com.inet.html.views.ImageView;
import com.inet.html.views.ViewPositionInfo;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class SetAutoScaleAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private boolean enabled;

    public SetAutoScaleAction(String nm) {
        super(nm);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewFactory factory;
        JEditorPane editor = this.getHtmlEditor(e);
        if (editor != null && (factory = editor.getEditorKit().getViewFactory()) instanceof InetHtmlFactory) {
            this.enabled = !this.enabled;
            InetHtmlFactory inetFactory = (InetHtmlFactory)factory;
            inetFactory.setAutoScaleImages(this.enabled);
            this.updateViews(editor.getUI().getRootView(editor).getView(0));
            if (this.enabled) {
                ImageScaleHandler l = new ImageScaleHandler(editor);
                editor.addMouseListener(l);
                editor.addMouseMotionListener(l);
            } else {
                for (MouseListener l : editor.getMouseListeners()) {
                    if (!(l instanceof ImageScaleHandler)) continue;
                    editor.removeMouseListener(l);
                    editor.removeMouseMotionListener((ImageScaleHandler)l);
                    break;
                }
            }
        }
    }

    private void updateViews(View root) {
        for (int i = 0; i < root.getViewCount(); ++i) {
            View child = root.getView(i);
            if (child instanceof ImageView) {
                ((ImageView)child).setAutoScaleMode(this.enabled);
                continue;
            }
            this.updateViews(child);
        }
    }

    private static class ImageScaleHandler
    extends MouseAdapter {
        private JEditorPane editor;
        private WeakReference<ImageView> recentImage;

        public ImageScaleHandler(JEditorPane editor) {
            this.editor = editor;
        }

        private ImageView getImage(Point pt) {
            View rootView = this.editor.getUI().getRootView(this.editor).getView(0);
            if (this.editor.getDocument() instanceof InetHtmlDocument && rootView instanceof BoxView) {
                ViewPositionInfo info;
                Insets margin;
                BoxView boxView = (BoxView)rootView;
                Border border = this.editor.getBorder();
                if (border != null && (margin = border.getBorderInsets(this.editor)) != null) {
                    pt.x -= margin.left;
                    pt.y -= margin.top;
                }
                if ((info = ((BoxView)rootView).getViewForPosition(pt, new Rectangle(0, 0, boxView.getOuterWidth(), boxView.getOuterHeight()))) != null && info.getView() instanceof ImageView) {
                    return (ImageView)info.getView();
                }
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ImageView newImage = this.getImage(e.getPoint());
            if (newImage != null) {
                newImage.setAutoScaleMode(!newImage.isAutoScaleMode());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ImageView lastImage;
            ImageView newImage = this.getImage(e.getPoint());
            ImageView imageView = lastImage = this.recentImage != null ? (ImageView)this.recentImage.get() : null;
            if (lastImage == newImage) {
                return;
            }
            if (lastImage != null) {
                lastImage.setZoomIconVisible(false);
            }
            if (newImage != null) {
                this.recentImage = new WeakReference<ImageView>(newImage);
                newImage.setZoomIconVisible(true);
                this.editor.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.editor.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

