/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

public class HyperlinkActionPopup
extends AbstractAction {
    private static final long serialVersionUID = 1428792977186450745L;
    public static final String NAME = "popupHyperlinkAction";
    private final JEditorPane editor;

    public HyperlinkActionPopup(JEditorPane editor) {
        this.editor = editor;
        this.putValue("AcceleratorKey", null);
        this.putValue("Name", HtmlEditorUtils.getTranslation("popup.hyperlinkpopup"));
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("popup.hyperlinkpopupHelp"));
        this.putValue("SmallIcon", HtmlEditorUtils.getResourceImage("hyperlinkpopupimage.gif"));
    }

    private Element findAnchorElement(InetHtmlDocument doc, int offset) {
        Element e;
        for (e = ElementUtils.getLeafAt(doc.getDefaultRootElement(), offset); e != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.A; e = e.getParentElement()) {
        }
        return e;
    }

    @Override
    public boolean isEnabled() {
        if (this.editor != null && this.editor.getDocument() instanceof InetHtmlDocument) {
            InetHtmlDocument doc = (InetHtmlDocument)this.editor.getDocument();
            Element start = this.findAnchorElement(doc, this.editor.getSelectionStart());
            Element end = this.findAnchorElement(doc, this.editor.getSelectionEnd());
            if (start != null && start == end && start.getAttributes().isDefined((Object)HTML.Attribute.HREF)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Action hyperlinlEaction = this.editor.getActionMap().get("hyperlink");
        if (hyperlinlEaction != null) {
            hyperlinlEaction.actionPerformed(e);
        }
    }
}

