/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.CSS;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.BorderCollapseValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.MultiIntegerValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.BackgroundPainter;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBackgroundPainter;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.TableView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

public class TableLayout
extends Layout {
    private static int constraintIndexCounter = 0;
    private static BorderDescription NOBORDER;
    private List<ColumnData> columnData = new ArrayList<ColumnData>();
    private List<RowData> rowHeight;
    private List<ListRow<CellData>> tableHeader;
    private List<ListRow<CellData>> tableContent;
    private List<ListRow<CellData>> tableFooter;
    private TableView table;
    private int width;
    private int widthPref;
    private int widthMax;
    private boolean borderCollapse = false;
    private int cellSpacingH = 0;
    private int cellSpacingHtotal = 0;
    private int cellSpacingV = 0;
    private Rectangle span = new Rectangle();
    private TreeSet<WidthConstraint> constraints;
    private static final int CELL_TYPE_AUTO = 0;
    private static final int CELL_TYPE_FIXED = 1;
    private static final int CELL_TYPE_RELATIVE = 2;

    public TableLayout(BoxView view) {
        super(view);
        NOBORDER = new BorderDescription();
        NOBORDER.style = 0;
        NOBORDER.width = 0;
        this.table = (TableView)view;
        BorderCollapseValue borderCollapseValue = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.BORDER_COLLAPSE);
        this.borderCollapse = borderCollapseValue != null && borderCollapseValue.getCollapseType() == 1;
    }

    @Override
    public Rectangle layout(boolean hard) {
        int targetHeight;
        int height = this.calculateRowHeights(hard);
        if (this.getView().getHeightUnit() != null && this.getView().getHeightUnit().isAbsolute() && (targetHeight = (int)this.getView().getHeightUnit().calculateValue(height, this.getView())) > height) {
            int[] dist = this.distribute(targetHeight - height, this.rowHeight.size());
            int i = 0;
            for (RowData row : this.rowHeight) {
                row.height = row.selfHeight + dist[i++];
            }
        }
        height = this.applyRowHeights();
        this.setCurrentHeight(height);
        this.view.setSizeContent(this.width, height);
        IBoxPainter box = this.view.getBox();
        this.span.setBounds(box.getLeftBorderPadding(), box.getTopBorderPadding(), this.view.getOuterWidth(), this.view.getOuterHeight());
        for (Layout.PositionInfo child : this.childPositions) {
            if (child.view == null) continue;
            this.view.setFirstLineBaseLine((short)(child.y + child.view.getFirstLineBaseLine() + child.view.getTopInset() + child.view.getMargins().top));
            break;
        }
        return this.span;
    }

    private int calculateRowHeights(boolean hard) {
        int currentRowHeight = 0;
        int currentRowBaseLine = 0;
        int height = 0;
        int rowID = 0;
        int totalHeight = 0;
        this.rowHeight.clear();
        for (int i = 0; i < 3; ++i) {
            List<ListRow<CellData>> block = null;
            if (i == 0) {
                block = this.tableHeader;
            }
            if (i == 1) {
                block = this.tableContent;
            }
            if (i == 2) {
                block = this.tableFooter;
            }
            for (int indexY = 0; block != null && indexY < block.size(); ++indexY) {
                ListRow<CellData> row = block.get(indexY);
                currentRowHeight = 0;
                currentRowBaseLine = 0;
                if (((ListRow)row).rowHeight != null && ((ListRow)row).rowHeight.isAbsolute()) {
                    currentRowHeight = Math.round(((ListRow)row).rowHeight.calculateValue(1.0f, this.table));
                }
                for (int indexX = 0; indexX < row.size(); ++indexX) {
                    int rowspan;
                    CellData cell = (CellData)row.get(indexX);
                    if (cell.filled && !cell.fillFinish || cell.reference == null) continue;
                    BoxView content = cell.reference.getContent();
                    float cellTotalWidth = this.columnData.get(indexX).size;
                    if (cell.reference.getColspan() > 1) {
                        for (int offsetX = 1; offsetX < cell.reference.getColspan() && indexX + offsetX < this.columnData.size(); ++offsetX) {
                            cellTotalWidth += (float)(this.columnData.get(indexX + offsetX).size + this.cellSpacingH);
                        }
                    }
                    if (content != null) {
                        int newheight;
                        content.setContentWidth(cellTotalWidth - (float)content.getBox().getTotalWidthGain());
                        content.performLayout(hard);
                        currentRowBaseLine = Math.max(content.getFirstLineBaseLine(), currentRowBaseLine);
                        height = content.getOuterHeight() + content.getMargins().top + content.getMargins().bottom;
                        LengthUnit heightUnit = content.getHeightUnit();
                        if (heightUnit != null && heightUnit.isAbsolute() && ((newheight = (int)heightUnit.calculateValue(1.0f, this.view)) > height || content.getEndOffset() - content.getStartOffset() <= 1)) {
                            height = newheight;
                        }
                    }
                    if ((rowspan = cell.reference.getRowspan()) > 1) {
                        int rowSpanHeight = height;
                        if (!cell.fillFinish) continue;
                        for (int offsetY = 0; offsetY < rowspan - 1; ++offsetY) {
                            rowSpanHeight -= this.rowHeight.get(rowID - rowspan + offsetY + 1).selfHeight + this.cellSpacingV;
                        }
                        height = rowSpanHeight;
                    }
                    currentRowHeight = Math.max(currentRowHeight, height);
                }
                totalHeight += currentRowHeight;
                this.rowHeight.add(new RowData(currentRowHeight, currentRowBaseLine));
                ++rowID;
            }
        }
        return totalHeight;
    }

    private int applyRowHeights() {
        int currentRowTop = this.cellSpacingV;
        int currentRowLeft = this.cellSpacingH;
        int rowID = 0;
        this.childPositions.clear();
        for (int i = 0; i < 3; ++i) {
            List<ListRow<CellData>> block = null;
            if (i == 0) {
                block = this.tableHeader;
            }
            if (i == 1) {
                block = this.tableContent;
            }
            if (i == 2) {
                block = this.tableFooter;
            }
            for (int indexY = 0; block != null && indexY < block.size(); ++indexY) {
                List row = block.get(indexY);
                RowData currentRowData = this.rowHeight.get(rowID);
                currentRowLeft = this.cellSpacingH;
                int idxStart = this.childPositions.size();
                for (int indexX = 0; indexX < row.size(); ++indexX) {
                    CellData cell = (CellData)row.get(indexX);
                    ColumnData currentColData = this.columnData.get(indexX);
                    float cellWidth = currentColData.size;
                    if ((!cell.filled || cell.fillFinish) && cell.reference != null) {
                        BoxView content = cell.reference.getContent();
                        CellPositionInfo pos = new CellPositionInfo(content, cell.reference);
                        float cellTotalWidth = cellWidth;
                        if (cell.reference.getColspan() > 1) {
                            for (int offsetX = 1; offsetX < cell.reference.getColspan() && indexX + offsetX < this.columnData.size(); ++offsetX) {
                                cellTotalWidth += (float)(this.columnData.get(indexX + offsetX).size + this.cellSpacingH);
                            }
                        }
                        int cellHeight = currentRowData.height;
                        int rowspan = cell.reference.getRowspan();
                        if (rowspan > 1) {
                            if (!cell.fillFinish) {
                                currentRowLeft = (int)((float)currentRowLeft + (cellWidth + (float)this.cellSpacingH));
                                continue;
                            }
                            for (int offsetY = 0; offsetY < rowspan - 1; ++offsetY) {
                                cellHeight += this.rowHeight.get(rowID - rowspan + offsetY + 1).height + this.cellSpacingV;
                            }
                            pos.y = currentRowData.height - cellHeight;
                        }
                        if (content != null) {
                            content.setSize(cellTotalWidth, cellHeight);
                            if (content.getAlignment(1) != 7.0f) {
                                content.performLayoutVAlign(currentRowData.baseline);
                            }
                        }
                        pos.x += currentRowLeft;
                        pos.y += currentRowTop;
                        pos.width = (int)cellTotalWidth;
                        pos.rowPainter = cell.rowPainter;
                        pos.columnPainter = currentColData.painter;
                        this.childPositions.add(pos);
                    }
                    currentRowLeft = (int)((float)currentRowLeft + (cellWidth + (float)this.cellSpacingH));
                }
                currentRowTop += currentRowData.height + this.cellSpacingV;
                int idxEnd = this.childPositions.size() - 1;
                if (!this.view.isLTR() && idxEnd > idxStart) {
                    int leftBound = ((Layout.PositionInfo)this.childPositions.get((int)idxStart)).x;
                    Layout.PositionInfo rightBox = (Layout.PositionInfo)this.childPositions.get(idxEnd);
                    int rightBound = rightBox.x + rightBox.width;
                    this.reverseOrder(idxStart, idxEnd, leftBound, rightBound);
                }
                ++rowID;
            }
        }
        return currentRowTop;
    }

    @Override
    public void preLayout() {
        TableView.TableContainer container;
        this.columnData = new ArrayList<ColumnData>();
        this.rowHeight = new ArrayList<RowData>();
        this.tableHeader = new ArrayList<ListRow<CellData>>();
        this.tableContent = new ArrayList<ListRow<CellData>>();
        this.tableFooter = new ArrayList<ListRow<CellData>>();
        if (!this.borderCollapse) {
            MultiIntegerValue cellSpacing;
            if (this.table.getHTMLBorderValue() > -1) {
                this.cellSpacingV = 2;
                this.cellSpacingH = 2;
            }
            if ((cellSpacing = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.CELL_SPACING)) != null) {
                if (cellSpacing.getValues().size() == 1) {
                    this.cellSpacingH = this.cellSpacingV = cellSpacing.getValues().get(0).getInt();
                }
                if (cellSpacing.getValues().size() >= 2) {
                    this.cellSpacingH = cellSpacing.getValues().get(0).getInt();
                    this.cellSpacingV = cellSpacing.getValues().get(1).getInt();
                }
            } else {
                LengthUnit borderSpace = StyleResolver.getAttributeValue(this.table.getElement(), AttributeFinder.BORDER_SPACING);
                if (borderSpace != null) {
                    this.cellSpacingH = this.cellSpacingV = (int)borderSpace.calculateValue(1.0f, this.table);
                }
            }
        }
        if ((container = this.table.getTableContainer()).getHeader() != null) {
            this.prepareTablePart(container.getHeader(), this.tableHeader);
        }
        if (container.getBody() != null) {
            this.prepareTablePart(container.getBody(), this.tableContent);
        }
        if (container.getFooter() != null) {
            this.prepareTablePart(container.getFooter(), this.tableFooter);
        }
        this.constraints = new TreeSet();
        ArrayList<ListRow<CellData>> combined = new ArrayList<ListRow<CellData>>();
        combined.addAll(this.tableHeader);
        combined.addAll(this.tableContent);
        combined.addAll(this.tableFooter);
        if (combined.size() > 0) {
            this.doATLpass1(combined);
        }
        if (this.columnData.size() == 0) {
            LengthUnit wu = this.view.getWidthUnit();
            if (wu != null) {
                if (wu.isAbsolute()) {
                    int setWidth = (int)wu.calculateValue(0.0f, this.view);
                    if (this.minimumWidth < setWidth) {
                        this.minimumWidth = setWidth;
                    }
                    if (this.preferredWidth < setWidth) {
                        this.preferredWidth = setWidth;
                    }
                } else if (wu.getType() == 1 && wu.getValue() != 1.0f) {
                    LengthUnit reverse = new LengthUnit("100%", 1.0f / wu.getValue(), 1);
                    this.preferredWidth = (int)Math.ceil(reverse.calculateValue(this.preferredWidth, this.getView()));
                }
            }
            this.setPreLayouted();
            return;
        }
        List<TableView.TableColumnGroupInfo> groups = this.table.getTableContainer().getColDescription();
        if (groups != null) {
            int groupIndex = 0;
            for (TableView.TableColumnGroupInfo group : groups) {
                int groupStart = groupIndex;
                int groupEnd = groupIndex;
                IntegerValue colSpanUnit = StyleResolver.getAttributeValue(group.getSource(), AttributeFinder.COL_SPAN_COL);
                if (colSpanUnit != null) {
                    LengthUnit width = StyleResolver.getAttributeValue(group.getSource(), AttributeFinder.WIDTH);
                    IBackgroundPainter painter = this.createPainter(group.getSource());
                    groupEnd = groupStart + colSpanUnit.getInt();
                    if (width != null && !width.isAuto()) {
                        for (int i = groupStart; i < groupEnd; ++i) {
                            this.addConstraintUnique(new WidthConstraint(width, false, i, i + 1));
                            if (width.isAbsolute()) {
                                this.fixWidthOfColumn(i, width);
                            }
                            if (painter == null || this.columnData.size() <= i) continue;
                            this.columnData.get(i).painter = painter;
                        }
                    }
                }
                int index = groupStart;
                for (TableView.TableColumnInfo column : group.getColumns()) {
                    IBackgroundPainter painter;
                    LengthUnit width;
                    Element source = column.getSource();
                    colSpanUnit = StyleResolver.getAttributeValue(source, AttributeFinder.COL_SPAN_COL);
                    int colspan = 1;
                    if (colSpanUnit != null) {
                        colspan = colSpanUnit.getInt();
                    }
                    if ((width = StyleResolver.getAttributeValue(column.getSource(), AttributeFinder.WIDTH)) != null && !width.isAuto()) {
                        this.addConstraintUnique(new WidthConstraint(width, false, index, index + colspan));
                        if (colspan == 1 && width.isAbsolute()) {
                            this.fixWidthOfColumn(index, width);
                        }
                    }
                    if ((painter = this.createPainter(source)) != null) {
                        for (int i = index; i < index + colspan; ++i) {
                            this.columnData.get(i).painter = painter;
                        }
                    }
                    index += colspan;
                }
                groupIndex = Math.max(index, groupEnd);
            }
        }
        for (int indexY = 0; indexY < this.tableContent.size(); ++indexY) {
            List row = this.tableContent.get(indexY);
            for (int indexX = 0; indexX < row.size(); ++indexX) {
                TableView.TableCellInfo content;
                CellData cell = this.fetchCell(row, indexX);
                if (cell.filled || (content = cell.reference) == null || content.getContent() == null || !(content.getContent() instanceof BlockView)) continue;
                LengthUnit widthUnit = ((BlockView)content.getContent()).getWidthUnit();
                int endIndex = indexX + content.getColspan();
                if (!(widthUnit == null || widthUnit.isAsterisk() || widthUnit.isAuto() || widthUnit.getType() == 1 && widthUnit.getValue() == 1.0f)) {
                    if (content.getContent() != null && widthUnit.getType() == 0) {
                        widthUnit = new LengthUnit((int)widthUnit.getValue() + content.getContent().getBox().getTotalWidthGain());
                        this.addConstraintUnique(new WidthConstraint(widthUnit, true, indexX, endIndex));
                        continue;
                    }
                    this.addConstraintUnique(new WidthConstraint(widthUnit, true, indexX, endIndex));
                    continue;
                }
                if (content.getContent() == null || content.getColspan() <= 1) continue;
                int cellWidth = (int)content.getContent().getMinimumSpan(0);
                LengthUnit prefWidth = new LengthUnit(cellWidth += content.getContent().getBox().getTotalWidthGain());
                this.addConstraintUnique(new WidthConstraint(prefWidth, true, indexX, endIndex));
            }
        }
        this.minimumWidth = 0;
        this.preferredWidth = 0;
        for (ColumnData width : this.columnData) {
            this.minimumWidth += width.virtualMin;
            this.preferredWidth += width.virtualMax;
        }
        this.cellSpacingHtotal = this.cellSpacingH * (this.columnData.size() + 1);
        this.minimumWidth += this.cellSpacingHtotal;
        this.preferredWidth += this.cellSpacingHtotal;
        LengthUnit wu = this.view.getWidthUnit();
        if (wu != null) {
            if (wu.isAbsolute()) {
                int setWidth = (int)wu.calculateValue(0.0f, this.view);
                if (this.minimumWidth < setWidth) {
                    this.minimumWidth = setWidth;
                }
                if (this.preferredWidth < setWidth) {
                    this.preferredWidth = setWidth;
                }
            } else if (wu.getType() == 1 && wu.getValue() != 1.0f) {
                LengthUnit reverse = new LengthUnit("100%", 1.0f / wu.getValue(), 1);
                this.preferredWidth = (int)Math.ceil(reverse.calculateValue(this.preferredWidth, this.getView()));
            }
        }
        this.setPreLayouted();
    }

    private void fixWidthOfColumn(int index, LengthUnit width) {
        if (index >= this.columnData.size()) {
            return;
        }
        int value = Math.round(width.calculateValue(1.0f, this.table));
        ColumnData col = this.columnData.get(index);
        col.size = value;
        col.max = value;
        col.virtualMax = value;
    }

    private IBackgroundPainter createPainter(Element element) {
        if (element == null) {
            return null;
        }
        ColorValue color = StyleResolver.getAttributeValue(element, AttributeFinder.BACKGROUND_COLOR);
        UriValue image = StyleResolver.getAttributeValue(element, AttributeFinder.BACKGROUND_IMAGE);
        if (color != null && !color.isTransparent() || image != null && !image.isNone()) {
            return new BackgroundPainter(element, this.getView().getRenderContext());
        }
        return null;
    }

    private void addConstraintUnique(WidthConstraint constraint) {
        if (constraint.start >= this.columnData.size()) {
            return;
        }
        if (constraint.end > this.columnData.size()) {
            constraint.end = this.columnData.size();
        }
        for (WidthConstraint oldConst : this.constraints) {
            if (oldConst.start != constraint.start || oldConst.end != constraint.end || oldConst.type != constraint.type || !(oldConst.amount.getValue() <= constraint.amount.getValue())) continue;
            this.constraints.remove(oldConst);
            break;
        }
        this.constraints.add(constraint);
    }

    private BorderDescription getWinningBorder(BoxView boxLeft, BoxView boxRight, boolean isTableLeftEdge, boolean isTableRightEdge) {
        BorderDescription left = isTableLeftEdge ? this.getBorder(boxLeft, true) : this.getBorder(boxLeft, false);
        BorderDescription right = isTableRightEdge ? this.getBorder(boxRight, false) : this.getBorder(boxRight, true);
        if (left.style == 9) {
            return left;
        }
        if (right.style == 9) {
            return right;
        }
        if (right.width > left.width) {
            return right;
        }
        if (right.width < left.width) {
            return left;
        }
        if (right.style != left.style) {
            return right.style > left.style ? right : left;
        }
        if (isTableLeftEdge) {
            return right;
        }
        if (isTableRightEdge) {
            return left;
        }
        return left;
    }

    private BorderDescription getWinningBorderH(BoxView boxTop, BoxView boxBottom, boolean isTableTopEdge, boolean isTableBottomEdge) {
        BorderDescription top = isTableTopEdge ? this.getBorderH(boxTop, true) : this.getBorderH(boxTop, false);
        BorderDescription bottom = isTableBottomEdge ? this.getBorderH(boxBottom, false) : this.getBorderH(boxBottom, true);
        if (top.style == 9) {
            return top;
        }
        if (bottom.style == 9) {
            return bottom;
        }
        if (bottom.width > top.width) {
            return bottom;
        }
        if (bottom.width < top.width) {
            return top;
        }
        if (bottom.style != top.style) {
            return bottom.style > top.style ? bottom : top;
        }
        if (isTableTopEdge) {
            return bottom;
        }
        if (isTableBottomEdge) {
            return top;
        }
        return top;
    }

    private BorderDescription getBorder(BoxView box, boolean left) {
        BorderDescription border = new BorderDescription();
        IBoxPainter boxPainter = box.getBox();
        if (left) {
            border.style = boxPainter.setBorderStyles().left;
            if (boxPainter instanceof TableBoxPainter) {
                border.width = ((TableBoxPainter)boxPainter).getPaintInsets().left;
            } else {
                border.width = boxPainter.setBorderInsets().left;
            }
        } else {
            border.style = boxPainter.setBorderStyles().right;
            if (boxPainter instanceof TableBoxPainter) {
                border.width = ((TableBoxPainter)boxPainter).getPaintInsets().right;
            } else {
                border.width = boxPainter.setBorderInsets().right;
            }
        }
        border.source = box;
        return border;
    }

    private BorderDescription getBorderH(BoxView box, boolean top) {
        BorderDescription border = new BorderDescription();
        IBoxPainter boxPainter = box.getBox();
        if (top) {
            border.style = boxPainter.setBorderStyles().top;
            if (boxPainter instanceof TableBoxPainter) {
                border.width = ((TableBoxPainter)boxPainter).getPaintInsets().top;
            } else {
                border.width = boxPainter.setBorderInsets().top;
            }
        } else {
            border.style = boxPainter.setBorderStyles().bottom;
            if (boxPainter instanceof TableBoxPainter) {
                border.width = ((TableBoxPainter)boxPainter).getPaintInsets().bottom;
            } else {
                border.width = boxPainter.setBorderInsets().bottom;
            }
        }
        border.source = box;
        return border;
    }

    private void doATLpass1(List<ListRow<CellData>> cells) {
        int rowNum = 0;
        for (List list : cells) {
            ListRow<CellData> nextRow = this.getNextRow(cells, rowNum);
            boolean isLastRow = nextRow == null;
            for (int i = 0; i < list.size(); ++i) {
                CellData cell = (CellData)list.get(i);
                if (cell == null || cell.reference == null) continue;
                BoxView content = cell.reference.getContent();
                if (content != null) {
                    content.performLayoutWidth();
                }
                if (this.borderCollapse) {
                    BorderDescription bottomBorder;
                    BorderDescription topBorder;
                    BorderDescription rightBorder;
                    BorderDescription leftBorder;
                    boolean topIsTable = false;
                    boolean leftIsTable = false;
                    boolean bottomIsTable = false;
                    boolean rightIsTable = false;
                    if (i == 0 || ((CellData)list.get(i - 1)).reference == null) {
                        leftBorder = this.getWinningBorder(this.table, content, true, false);
                        leftIsTable = true;
                    } else {
                        leftBorder = this.getWinningBorder(((CellData)list.get(i - 1)).reference.getContent(), content, false, false);
                    }
                    if (i == list.size() - 1 || ((CellData)list.get(i + 1)).reference == null) {
                        rightBorder = this.getWinningBorder(content, this.table, false, true);
                        rightIsTable = true;
                    } else {
                        rightBorder = this.getWinningBorder(content, ((CellData)list.get(i + 1)).reference.getContent(), false, false);
                    }
                    if (rowNum == 0) {
                        topBorder = this.getWinningBorderH(this.table, content, true, false);
                        topIsTable = true;
                    } else {
                        List rowAbove = cells.get(rowNum - 1);
                        if (rowAbove.size() > i && ((CellData)rowAbove.get(i)).reference != null) {
                            BoxView cellAbove = ((CellData)rowAbove.get(i)).reference.getContent();
                            topBorder = this.getWinningBorderH(cellAbove, content, false, false);
                        } else {
                            topBorder = this.getBorderH(content, true);
                        }
                    }
                    if (isLastRow) {
                        bottomBorder = this.getWinningBorderH(content, this.table, false, true);
                        bottomIsTable = true;
                    } else if (nextRow != null && nextRow.size() > i) {
                        BoxView cellBelow = ((CellData)nextRow.get(i)).reference.getContent();
                        bottomBorder = this.getWinningBorderH(content, cellBelow, false, false);
                    } else {
                        bottomBorder = this.getBorderH(content, false);
                    }
                    if (content != null) {
                        IBoxPainter contentBox = content.getBox();
                        TableBoxPainter tablePainter = (TableBoxPainter)(contentBox instanceof TableBoxPainter ? contentBox : null);
                        if (i > 0) {
                            contentBox.setBorderInsets().left = (int)Math.ceil((float)leftBorder.width / 2.0f);
                        } else if (leftBorder.source == content && tablePainter != null) {
                            tablePainter.setLeftIsTableBorder(true);
                        }
                        if (i < this.columnData.size() - 1) {
                            contentBox.setBorderInsets().right = (int)Math.floor((float)rightBorder.width / 2.0f);
                        } else if (rightBorder.source == content && tablePainter != null) {
                            tablePainter.setRightIsTableBorder(true);
                        }
                        if (rowNum > 0) {
                            contentBox.setBorderInsets().top = (int)Math.ceil((float)topBorder.width / 2.0f);
                        } else if (topBorder.source == content && tablePainter != null) {
                            tablePainter.setTopIsTableBorder(true);
                        }
                        if (!isLastRow) {
                            contentBox.setBorderInsets().bottom = (int)Math.floor((float)bottomBorder.width / 2.0f);
                        } else if (bottomBorder.source == content && tablePainter != null) {
                            tablePainter.setBottomIsTableBorder(true);
                        }
                        if (leftBorder.source != content) {
                            if (leftIsTable) {
                                contentBox.setBorderStyles().left = this.table.box.getBorderStyles().left;
                                contentBox.setBorderInsets().left = this.table.box.getBorderInsets().left;
                                contentBox.setBorderLeftColor(this.table.box.getBorderLeftColor());
                                if (tablePainter != null) {
                                    tablePainter.getPaintInsets().left = this.table.box.getBorderInsets().left;
                                }
                            } else {
                                contentBox.setBorderStyles().left = 0;
                            }
                        }
                        if (rightBorder.source != content) {
                            if (rightIsTable) {
                                contentBox.setBorderStyles().right = this.table.box.getBorderStyles().right;
                                contentBox.setBorderInsets().right = this.table.box.getBorderInsets().right;
                                contentBox.setBorderRightColor(this.table.box.getBorderRightColor());
                                if (tablePainter != null) {
                                    tablePainter.getPaintInsets().right = this.table.box.getBorderInsets().right;
                                }
                            } else {
                                contentBox.setBorderStyles().right = 0;
                            }
                        }
                        if (topBorder.source != content) {
                            if (topIsTable) {
                                contentBox.setBorderStyles().top = this.table.box.getBorderStyles().top;
                                contentBox.setBorderInsets().top = this.table.box.getBorderInsets().top;
                                contentBox.setBorderTopColor(this.table.box.getBorderTopColor());
                                if (tablePainter != null) {
                                    tablePainter.getPaintInsets().top = this.table.box.getBorderInsets().top;
                                }
                            } else {
                                contentBox.setBorderStyles().top = 0;
                            }
                        }
                        if (bottomBorder.source != content) {
                            if (bottomIsTable) {
                                contentBox.setBorderStyles().bottom = this.table.box.getBorderStyles().bottom;
                                contentBox.setBorderInsets().bottom = this.table.box.getBorderInsets().bottom;
                                contentBox.setBorderBottomColor(this.table.box.getBorderBottomColor());
                                if (tablePainter != null) {
                                    tablePainter.getPaintInsets().bottom = this.table.box.getBorderInsets().bottom;
                                }
                            } else {
                                contentBox.setBorderStyles().bottom = 0;
                            }
                        }
                    }
                }
                if (cell.filled) continue;
                int colspan = cell.reference.getColspan();
                if (colspan == 1) {
                    if (content != null) {
                        int widthGain = content.getBox().getTotalWidthGain();
                        int minWidth = (int)content.getMinimumSpan(0) + widthGain;
                        int maxWidth = (int)content.getPreferredSpan(0) + widthGain;
                        LengthUnit widthUnit = content.getWidthUnit();
                        ColumnData currentCol = this.columnData.get(i);
                        if (currentCol == null) {
                            currentCol = new ColumnData();
                            this.columnData.set(i, currentCol);
                        }
                        if (currentCol.virtualMax < maxWidth) {
                            currentCol.virtualMax = maxWidth;
                        }
                        if (widthUnit != null && widthUnit.isAbsolute()) {
                            int minByUnit = (int)widthUnit.getValue();
                            currentCol.size = minByUnit;
                        }
                        if (currentCol.min < minWidth) {
                            currentCol.min = minWidth;
                        }
                        if (currentCol.max < maxWidth) {
                            currentCol.max = maxWidth;
                        }
                        if (currentCol.virtualMin >= minWidth) continue;
                        currentCol.virtualMin = minWidth;
                        continue;
                    }
                    ColumnData currentCol = this.columnData.get(i);
                    if (currentCol != null) continue;
                    currentCol = new ColumnData();
                    this.columnData.set(i, currentCol);
                    continue;
                }
                if (content != null) {
                    ColumnData currentCol;
                    int j;
                    int diff;
                    int minWidth = (int)content.getMinimumSpan(0) + content.getBox().getTotalWidthGain();
                    int maxWidth = (int)content.getPreferredSpan(0) + content.getBox().getTotalWidthGain();
                    int subCellsMinWidth = 0;
                    int subCellsMaxWidth = 0;
                    for (int j2 = 0; j2 < colspan; ++j2) {
                        ColumnData currentCol2 = this.columnData.get(i + j2);
                        if (currentCol2 == null) {
                            currentCol2 = new ColumnData();
                            this.columnData.set(i + j2, currentCol2);
                        }
                        subCellsMinWidth += currentCol2.virtualMin;
                        subCellsMaxWidth += currentCol2.virtualMax;
                    }
                    subCellsMaxWidth += (colspan - 1) * this.cellSpacingH;
                    if (minWidth > (subCellsMinWidth += (colspan - 1) * this.cellSpacingH)) {
                        diff = minWidth - subCellsMinWidth;
                        int[] dist = this.distribute(diff, colspan);
                        for (j = 0; j < colspan; ++j) {
                            currentCol = this.columnData.get(i + j);
                            currentCol.virtualMin += dist[j];
                        }
                    }
                    if (maxWidth <= subCellsMaxWidth) continue;
                    diff = maxWidth - subCellsMaxWidth;
                    int[] dist = this.distribute(diff, colspan);
                    for (j = 0; j < colspan; ++j) {
                        currentCol = this.columnData.get(i + j);
                        currentCol.virtualMax += dist[j];
                    }
                    continue;
                }
                for (int j = 0; j < colspan; ++j) {
                    ColumnData currentCol = this.columnData.get(i);
                    if (currentCol != null) continue;
                    currentCol = new ColumnData();
                    this.columnData.set(i, currentCol);
                }
            }
            ++rowNum;
        }
    }

    private int[] distribute(int amount, int n) {
        int[] result = new int[n];
        for (int i = n; i > 0; --i) {
            int share;
            result[i - 1] = share = (int)Math.round((double)amount / (double)i);
            amount -= share;
        }
        return result;
    }

    private ListRow<CellData> getNextRow(List<ListRow<CellData>> cells, int rowNum) {
        if (rowNum < cells.size() - 1) {
            return cells.get(rowNum);
        }
        if (cells == this.tableHeader) {
            if (this.tableContent.size() > 0) {
                return this.tableContent.get(0);
            }
            if (this.tableFooter.size() > 0) {
                return this.tableFooter.get(0);
            }
        }
        if (cells == this.tableContent && this.tableFooter.size() > 0) {
            return this.tableFooter.get(0);
        }
        return null;
    }

    private void prepareTablePart(TableView.TableRowGroup source, List<ListRow<CellData>> target) {
        int x = 0;
        int y = 0;
        int columns = 0;
        for (TableView.TableRowInfo row : source.getRows()) {
            columns = Math.max(columns, row.countValidCells());
        }
        for (TableView.TableRowInfo row : source.getRows()) {
            x = 0;
            ListRow<CellData> thisRow = this.fetchLine(target, y, row.getSource());
            ((ListRow)thisRow).painter = this.createPainter(row.getSource());
            List<TableView.TableCellInfo> cells = row.getCells();
            if (cells.size() < columns && cells.size() > 0 && row.countErrorCells() > 0) {
                TableView.TableCellInfo lastCell = cells.get(cells.size() - 1);
                lastCell.setColspan(columns - cells.size() + 1);
            }
            for (TableView.TableCellInfo cell : cells) {
                CellData thisCell = this.fetchCell(thisRow, x);
                while (thisCell == null || thisCell.filled || thisCell.reference != null) {
                    if (thisCell != null && thisCell.rowPainter == null) {
                        thisCell.rowPainter = ((ListRow)thisRow).painter;
                    }
                    thisCell = this.fetchCell(thisRow, ++x);
                }
                if (thisCell.rowPainter == null) {
                    thisCell.rowPainter = ((ListRow)thisRow).painter;
                }
                thisCell.filled = false;
                thisCell.reference = cell;
                if (cell.getContent() != null) {
                    cell.getContent().performPreLayout();
                }
                if (cell.getRowspan() > 1 || cell.getColspan() > 1) {
                    for (int offsetY = 0; offsetY < cell.getRowspan(); ++offsetY) {
                        ListRow<CellData> spanRow = this.fetchLine(target, y + offsetY, null);
                        for (int offsetX = 0; offsetX < cell.getColspan(); ++offsetX) {
                            CellData spanCell = this.fetchCell(spanRow, x + offsetX);
                            spanCell.filled = true;
                            spanCell.reference = cell;
                            spanCell.rowPainter = ((ListRow)thisRow).painter;
                            if (offsetX != 0 || offsetY != cell.getRowspan() - 1) continue;
                            spanCell.fillFinish = true;
                        }
                    }
                }
                thisCell.filled = false;
                ++x;
            }
            ++y;
        }
    }

    private CellData fetchCell(List<CellData> line, int cellNr) {
        while (line.size() <= cellNr) {
            line.add(new CellData());
            if (this.columnData.size() >= line.size()) continue;
            this.columnData.add(null);
        }
        return line.get(cellNr);
    }

    private ListRow<CellData> fetchLine(List<ListRow<CellData>> target, int line, Element element) {
        while (target.size() <= line) {
            target.add(new ListRow());
            if (this.rowHeight.size() >= target.size()) continue;
            this.rowHeight.add(null);
        }
        ListRow<CellData> row = target.get(line);
        if (element != null && ((ListRow)row).rowHeight == null) {
            ((ListRow)row).rowHeight = StyleResolver.getAttributeValue(element, AttributeFinder.HEIGHT);
        }
        return row;
    }

    @Override
    protected int adjustWidth() {
        int maxBoxSize = 0;
        LengthUnit l = this.view.getWidthUnit();
        if (l != null && !l.isAuto()) {
            if (l.isAbsolute()) {
                maxBoxSize = Math.round(l.calculateValue(1.0f, this.view));
            } else {
                ILayouted bv = (ILayouted)((Object)this.view.getParent());
                int refSize = bv.getLayout().getCurrentWidth();
                maxBoxSize = Math.round(l.calculateValue(refSize, this.view));
            }
            maxBoxSize -= this.cellSpacingHtotal;
            this.widthPref = maxBoxSize -= this.view.getBox().getTotalWidthGain();
        } else {
            maxBoxSize = this.view.getParent() != null && this.view.getParent() instanceof BlockView ? ((BlockView)this.view.getParent()).getLayout().getCurrentWidth() : this.view.getContentWidth();
            maxBoxSize -= this.cellSpacingHtotal;
            maxBoxSize -= this.view.getBox().getTotalWidthGain();
        }
        int minimumInnerBox = this.minimumWidth - this.cellSpacingHtotal - this.view.getBox().getLeftBorderPadding() - this.view.getBox().getRightBorderPadding();
        if (maxBoxSize < minimumInnerBox) {
            maxBoxSize = minimumInnerBox;
        }
        if (this.widthPref < minimumInnerBox) {
            this.widthPref = minimumInnerBox;
        }
        this.widthMax = maxBoxSize;
        return maxBoxSize;
    }

    @Override
    public void layoutWidth() {
        this.widthPref = this.preferredWidth - this.cellSpacingHtotal;
        this.adjustWidth();
        this.width = 0;
        for (ColumnData data : this.columnData) {
            if (data.min == 0 && data.max == 0 && data.size == 0) {
                data.min = data.virtualMin;
                data.max = data.virtualMax;
            }
            data.size = data.min;
        }
        for (WidthConstraint constraint : this.constraints) {
            if (constraint.type != 1) continue;
            this.applyConstraintFixed(constraint);
        }
        this.scale(0, false);
        float total = 0.0f;
        boolean[] affected = new boolean[this.columnData.size()];
        for (WidthConstraint constraint : this.constraints) {
            if (constraint.type != 2 || constraint.end - constraint.start > 1 || affected[constraint.start]) continue;
            affected[((WidthConstraint)constraint).start] = true;
            total += constraint.amount.getValue();
        }
        boolean allAffected = true;
        float widhtNotAffected = 0.0f;
        for (int i = 0; i < affected.length; ++i) {
            if (affected[i]) continue;
            allAffected = false;
            widhtNotAffected += (float)this.columnData.get(i).size;
        }
        if (!allAffected) {
            int newSize;
            float totalTMP = total;
            if (total >= 1.0f) {
                totalTMP = 0.99f;
            }
            if ((newSize = (int)(widhtNotAffected + widhtNotAffected / (1.0f - totalTMP) * totalTMP)) > this.widthPref) {
                this.widthPref = newSize;
                if (this.widthPref > this.widthMax) {
                    this.widthPref = this.widthMax;
                }
            }
        }
        for (WidthConstraint constraint : this.constraints) {
            int newSize;
            if (constraint.type != 2 || constraint.end - constraint.start > 1 || (newSize = this.getConstraintUpscaleValue(constraint, total, widhtNotAffected, allAffected)) <= this.widthPref) continue;
            this.widthPref = newSize;
            if (this.widthPref <= this.widthMax) continue;
            this.widthPref = this.widthMax;
            break;
        }
        for (WidthConstraint constraint : this.constraints) {
            if (constraint.type != 2 || constraint.end - constraint.start > 1) continue;
            this.applyConstraintSingleRelative(constraint, total, widhtNotAffected, allAffected);
        }
        if (this.view.getRenderContext().getMedia() == "print") {
            int cellContentTotal = ((BoxView)this.view.getParent()).getContentWidth();
            cellContentTotal -= this.view.getBox().getTotalWidthGain();
            if ((cellContentTotal -= this.cellSpacingHtotal) < this.widthPref) {
                this.scale(cellContentTotal, true);
            } else {
                this.scale(this.widthPref, false);
            }
        } else {
            this.scale(this.widthPref, false);
        }
        this.setCurrentWidth(this.width + this.cellSpacingHtotal);
        this.view.setContentWidth(this.width + this.cellSpacingHtotal);
    }

    private int getConstraintUpscaleValue(WidthConstraint constraint, float totalAmout, float notRelativeWidth, boolean all) {
        if (constraint.type != 2) {
            return -1;
        }
        if (constraint.end - constraint.start > 1) {
            return -1;
        }
        float amount = constraint.amount.getValue();
        if (amount == 1.0f) {
            return -1;
        }
        if (!all) {
            if (totalAmout >= 1.0f) {
                amount /= totalAmout;
                totalAmout = 0.99f;
            }
        } else {
            amount /= totalAmout;
        }
        ColumnData col = this.columnData.get(constraint.start);
        return Math.round((float)col.max / amount);
    }

    private void applyConstraintSingleRelative(WidthConstraint constraint, float totalAmout, float notRelativeWidth, boolean all) {
        if (constraint.type != 2) {
            return;
        }
        if (constraint.end - constraint.start > 1) {
            return;
        }
        float amount = constraint.amount.getValue();
        if (amount == 1.0f) {
            return;
        }
        float completeWidth = Math.min(this.widthPref, this.widthMax);
        if (!all) {
            if (totalAmout >= 1.0f) {
                totalAmout = 0.99f;
            }
        } else {
            amount /= totalAmout;
        }
        ColumnData col = this.columnData.get(constraint.start);
        int newColWidth = Math.round(completeWidth * amount);
        col.size = Math.max(col.min, newColWidth);
        col.type = 2;
    }

    private void applyConstraintFixed(WidthConstraint constraint) {
        ColumnData data;
        int i;
        if (constraint.type != 1) {
            return;
        }
        if (this.columnData == null || this.columnData.size() == 0) {
            return;
        }
        int amount = (int)constraint.amount.getValue();
        if (constraint.end - constraint.start == 1) {
            ColumnData currentCol = this.columnData.get(constraint.start);
            int oldColWidth = currentCol.size;
            currentCol.type = constraint.type;
            if (oldColWidth < amount) {
                this.width += amount - oldColWidth;
                currentCol.size = amount;
            }
            return;
        }
        int spreadTo = 0;
        for (i = constraint.start; i < constraint.end; ++i) {
            data = this.columnData.get(i);
            if (data.type == 0) {
                ++spreadTo;
            }
            amount -= data.size;
        }
        if (amount > 0) {
            this.width += amount;
            for (i = constraint.start; i < constraint.end; ++i) {
                data = this.columnData.get(i);
                if (data.type != 0) continue;
                int oldColWidth = this.columnData.get(i).size;
                this.columnData.get(i).size = oldColWidth + amount / spreadTo;
            }
        }
        this.width = 0;
        for (ColumnData cellWidth : this.columnData) {
            this.width += cellWidth.size;
        }
    }

    private void scale(int fixedTarget, boolean allowDownscale) {
        int type;
        int diff;
        this.width = 0;
        for (ColumnData cellWidth : this.columnData) {
            this.width += cellWidth.size;
        }
        int targetWidth = this.widthPref;
        if (this.width >= this.widthPref && this.width < this.widthMax && (fixedTarget == 0 || fixedTarget == this.width)) {
            return;
        }
        if (this.width < this.widthPref) {
            targetWidth = this.widthPref;
        }
        if (fixedTarget > 0) {
            targetWidth = fixedTarget;
        }
        if (targetWidth > this.widthMax) {
            targetWidth = this.widthMax;
        }
        if ((diff = targetWidth - this.width) == 0) {
            return;
        }
        int[] scaleMin = new int[3];
        int[] scaleMax = new int[3];
        int[] scaleShare = new int[3];
        int[] scaleSize = new int[3];
        for (ColumnData data : this.columnData) {
            if (data.size < data.min) {
                data.size = data.min;
            }
            int n = data.type;
            scaleSize[n] = scaleSize[n] + data.size;
            int n2 = data.type;
            scaleMax[n2] = scaleMax[n2] + (data.max > 0 ? data.max : data.size);
            int n3 = data.type;
            scaleMin[n3] = scaleMin[n3] + data.min;
            int n4 = data.type;
            scaleShare[n4] = scaleShare[n4] + 1;
        }
        if (this.width < this.widthMax && scaleMax[0] == 0 && scaleMax[2] == 0 && scaleMax[1] > 0 && scaleShare[1] == this.columnData.size()) {
            if (this.view.getWidthUnit() != null && this.view.getWidthUnit().isAbsolute()) {
                int fixedWidth = (int)this.view.getWidthUnit().calculateValue(0.0f, this.view);
                if (fixedWidth == this.width) {
                    return;
                }
            } else {
                return;
            }
        }
        for (type = 0; type <= 2; ++type) {
            int numberOfElementsOfThisType = scaleShare[type];
            if (numberOfElementsOfThisType > 0) {
                int appliableDifference;
                int bestScale;
                int part = diff > 0 ? diff : ((bestScale = scaleMin[type] - scaleSize[type]) > diff ? bestScale : diff);
                diff -= part;
                this.width += part;
                int currentShare = part;
                int total = scaleMax[type] - scaleSize[type];
                if (part > 0 && total > 0 && scaleMax[type] > 0) {
                    float scaleFactor = 0.0f;
                    scaleFactor = total < part ? 1.0f : (float)part / (float)total;
                    for (ColumnData data : this.columnData) {
                        int amount;
                        if (data.type != type || (amount = data.max - data.size) <= 0) continue;
                        appliableDifference = Math.round((float)amount * scaleFactor);
                        part -= appliableDifference;
                        data.size += appliableDifference;
                    }
                }
                currentShare = part;
                if (part != 0 && scaleMax[type] > 0) {
                    int potential = 0;
                    for (ColumnData data : this.columnData) {
                        if (data.type != type) continue;
                        potential += part >= 0 ? (data.max > 0 ? data.max : data.size) : data.size - data.min;
                    }
                    if (potential != 0) {
                        for (ColumnData data : this.columnData) {
                            if (data.type != type) continue;
                            float weight = (float)(part >= 0 ? (data.max > 0 ? data.max : data.size) : data.size - data.min) / (float)potential;
                            appliableDifference = Math.round((float)currentShare * weight);
                            if (appliableDifference < data.min - data.size) {
                                appliableDifference = data.min - data.size;
                            }
                            part -= appliableDifference;
                            data.size += appliableDifference;
                        }
                        if (part > 0) {
                            this.columnData.get(this.columnData.size() - 1).size += part;
                            part = 0;
                        }
                    }
                }
                diff += part;
                this.width -= part;
            }
            if (diff == 0) break;
        }
        for (type = 0; type <= 2; ++type) {
            int remaining = scaleShare[type];
            if (remaining <= 0 || Math.abs(diff) <= 2) continue;
            Iterator<ColumnData> iterator = this.columnData.iterator();
            while (iterator.hasNext()) {
                int appliableDifference = diff / remaining;
                ColumnData data = iterator.next();
                if (appliableDifference < data.min - data.size) {
                    appliableDifference = data.min - data.size;
                }
                diff -= appliableDifference;
                data.size += appliableDifference;
            }
        }
        if (allowDownscale || diff > 0) {
            int[] dist = this.distribute(diff, this.columnData.size());
            int i = 0;
            for (ColumnData data : this.columnData) {
                data.size += dist[i++];
            }
            diff = 0;
        }
        this.width = targetWidth - diff;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", pos);
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape returnValue = null;
        for (Layout.PositionInfo child : this.getChildren()) {
            if (child.view == null) continue;
            int startOffset = child.view.getStartOffset();
            int endOffset = child.view.getEndOffset();
            if (b == Position.Bias.Forward) {
                --endOffset;
            } else {
                ++startOffset;
            }
            if (startOffset > pos || endOffset < pos) continue;
            rect.x = child.x + boxX;
            rect.y = child.y + boxY;
            rect.width = child.view.getOuterWidth();
            rect.height = child.view.getOuterHeight();
            returnValue = child.view.modelToView(pos, rect, b);
            break;
        }
        return returnValue;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int returnValue = -1;
        Point refPoint = new Point((int)x, (int)y);
        for (Layout.PositionInfo pos : this.getChildren()) {
            if (pos.view == null) continue;
            rect.x = pos.x + boxX;
            rect.y = pos.y + boxY;
            rect.width = pos.view.getOuterWidth();
            rect.height = pos.view.getOuterHeight();
            if (!rect.contains(refPoint)) continue;
            returnValue = pos.view.viewToModel(x, y, rect, biasReturn);
            break;
        }
        if (returnValue < 0) {
            double minDistance = 2.147483647E9;
            Layout.PositionInfo minPos = null;
            Point checkPoint = new Point();
            double minDist = 0.0;
            for (Layout.PositionInfo pos : this.getChildren()) {
                if (pos.view == null) continue;
                rect.x = pos.x + boxX;
                rect.y = pos.y + boxY;
                rect.width = pos.view.getOuterWidth();
                rect.height = pos.view.getOuterHeight();
                checkPoint.x = rect.x;
                checkPoint.y = rect.y;
                minDist = checkPoint.distance(refPoint);
                checkPoint.x += rect.width;
                minDist = Math.min(minDist, checkPoint.distance(refPoint));
                checkPoint.y += rect.height;
                minDist = Math.min(minDist, checkPoint.distance(refPoint));
                checkPoint.x -= rect.width;
                if (!((minDist = Math.min(minDist, checkPoint.distance(refPoint))) < minDistance)) continue;
                minDistance = minDist;
                minPos = pos;
            }
            if (minPos != null) {
                rect.x = minPos.x + boxX;
                rect.y = minPos.y + boxY;
                rect.width = minPos.view.getOuterWidth();
                rect.height = minPos.view.getOuterHeight();
                returnValue = minPos.view.viewToModel(x, y, rect, biasReturn);
            }
        }
        return returnValue;
    }

    @Override
    public void predictWidth(int width) {
        this.width = width;
    }

    public boolean isBorderCollapse() {
        return this.borderCollapse;
    }

    @Override
    public void layoutVerticalAlign(int align, int baselineOffset) {
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point position, Rectangle a) {
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo returnValue = null;
        for (Layout.PositionInfo pos : this.getChildren()) {
            if (pos.view != null) {
                rect.setBounds(pos.x + boxX, pos.y + boxY, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            } else {
                rect.setBounds(pos.x + boxX, pos.y + boxY, pos.width, pos.height);
            }
            if (!rect.contains(position)) continue;
            returnValue = pos.view.getViewForPosition(position, rect);
            if (returnValue == null) {
                return new ViewPositionInfo(rect, pos.view, pos.view.getViewCount() != 0);
            }
            return returnValue;
        }
        return null;
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    @Override
    protected void calculateCollapsedMargins() {
    }

    public int getCellSpacingV() {
        return this.cellSpacingV;
    }

    @Override
    public boolean getVisibleElements(Rectangle2D clip, DOMUtils.ResultMap result) {
        int x = this.table.getLeftInset();
        int y = this.table.getTopInset() + this.table.getContentVerticalOffset();
        boolean hasVisibleViews = false;
        for (Layout.PositionInfo info : this.childPositions) {
            Rectangle2D.Double subClip = new Rectangle2D.Double(clip.getX() - info.getX() - (double)x, clip.getY() - info.getY() - (double)y, clip.getWidth(), clip.getHeight());
            Rectangle span = info.view.getSpan();
            if ((double)span.y > subClip.getMaxY()) {
                result.setFirstClippedContentLocation(-((RectangularShape)subClip).getY());
                continue;
            }
            hasVisibleViews = info.view.getVisibleDOM(subClip, result);
            DOMUtils.DOMVisibilityResult value = new DOMUtils.DOMVisibilityResult(info.view, hasVisibleViews ? DOMUtils.Visibility.visible : DOMUtils.Visibility.dummy);
            TableView.TableCellInfo cellInfo = ((CellPositionInfo)info).source;
            LengthUnit originalWidth = info.view.getWidthUnit();
            if (cellInfo.getColspan() == 1 && originalWidth == null || !originalWidth.isAbsolute()) {
                value.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(info.view.getContentWidth()));
            }
            result.put(info.view.getElement(), value);
        }
        return hasVisibleViews;
    }

    static /* synthetic */ int access$008() {
        return constraintIndexCounter++;
    }

    private static class BorderDescription {
        private int width;
        private int style;
        private BoxView source;

        private BorderDescription() {
        }
    }

    private static class RowData {
        private int selfHeight;
        private int height;
        private int baseline;

        public RowData(int selfHeight, int baseline) {
            this.selfHeight = selfHeight;
            this.height = selfHeight;
            this.baseline = baseline;
        }
    }

    private static class ListRow<T>
    extends ArrayList<T> {
        private IBackgroundPainter painter;
        private LengthUnit rowHeight;

        private ListRow() {
        }
    }

    private static class CellData {
        private boolean filled = false;
        private boolean fillFinish = false;
        private TableView.TableCellInfo reference;
        private IBackgroundPainter rowPainter;

        private CellData() {
        }

        public String toString() {
            if (this.reference != null) {
                if (this.filled) {
                    return "Spaned Cell";
                }
                return this.reference.getContent().toString();
            }
            return "Empty Cell";
        }
    }

    private static class ColumnData {
        private int min;
        private int virtualMin;
        private int max;
        private int virtualMax;
        private int type;
        private int size;
        private IBackgroundPainter painter = null;

        private ColumnData() {
        }

        public String toString() {
            return "Min:" + this.min + ",Max:" + this.max + ",Type:" + this.type + ",Size:" + this.size;
        }
    }

    public class CellPositionInfo
    extends Layout.PositionInfo {
        private static final long serialVersionUID = 6888370347647866367L;
        private IBackgroundPainter columnPainter;
        private IBackgroundPainter rowPainter;
        private TableView.TableCellInfo source;

        public CellPositionInfo(BoxView viewToPosition, TableView.TableCellInfo source) {
            super(viewToPosition);
            this.source = source;
        }

        public IBackgroundPainter getColumnPainter() {
            return this.columnPainter;
        }

        public IBackgroundPainter getRowPainter() {
            return this.rowPainter;
        }
    }

    private static class WidthConstraint
    implements Comparable<WidthConstraint> {
        private int index = TableLayout.access$008();
        private int type;
        private LengthUnit amount;
        private int start;
        private int end;

        public WidthConstraint(LengthUnit amount, boolean innerWidth, int start, int end) {
            this.start = start;
            this.end = end;
            this.amount = amount;
            this.type = amount.isAbsolute() ? 1 : 2;
        }

        public String toString() {
            return "[" + this.start + ":" + this.end + "] width:" + this.amount;
        }

        @Override
        public int compareTo(WidthConstraint o) {
            if (this.type < o.type) {
                return 1;
            }
            if (this.end - this.start < o.end - o.start) {
                return 1;
            }
            int diff = (int)(this.amount.getValue() - o.amount.getValue());
            if (diff != 0) {
                return -diff;
            }
            return o.index - this.index;
        }
    }
}

