/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.layouts.ControlLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ControlView
extends BoxView
implements ILayouted {
    public static final int TYPE_BUTTON = 0;
    public static final int TYPE_TEXTFIELD = 1;
    public static final int TYPE_TEXTAREA = 2;
    public static final int TYPE_RADIOBUTTON = 3;
    public static final int TYPE_CHECKBOX = 4;
    public static final int TYPE_SELECT = 5;
    public static final int TYPE_MENU = 6;
    public static final int TYPE_HIDDEN = 7;
    private JComponent control;
    private boolean controlCreated = false;
    private Font font;
    private Color color;
    private ControlLayout layout;
    private int type;
    private boolean isSubmit = false;
    private boolean isReset;
    private static final String DEFAULT_BUTTON_TEXT = "Button";

    public ControlView(Element elem) {
        super(elem);
    }

    public ControlView(Element elem, ViewPainter painter) {
        super(elem, painter);
    }

    @Override
    public void setParent(View parent) {
        Container container;
        if (this.getParent() != null && this.getParent() == parent && parent != null) {
            return;
        }
        if (this.control != null && (container = this.control.getParent()) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                container.remove(this.control);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        container.remove(ControlView.this.control);
                    }
                });
            }
        }
        if (parent == null) {
            this.getRenderContext().deregisterControl(this);
            return;
        }
        super.setParent(parent);
        this.font = this.getRenderContext().getFont(this, false);
        this.layout = new ControlLayout(this);
        this.setStatus(2);
    }

    private synchronized JComponent getControlComponent() {
        if (!this.controlCreated) {
            Container container;
            this.controlCreated = true;
            this.control = this.createControl();
            if (this.control != null && (container = this.getContainer()) != null) {
                container.add(this.control);
            }
            this.getHTMLRoot().getRenderContext().registerControl(this);
            this.layout.preLayout();
        }
        return this.control;
    }

    @Override
    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    protected JComponent createControl() {
        JComponent control = null;
        AttributeSet attributes = this.getElement().getAttributes();
        Object tag = attributes.getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            Object value = attributes.getAttribute((Object)HTML.Attribute.VALUE);
            Object type = attributes.getAttribute((Object)HTML.Attribute.TYPE);
            if (type != null) {
                type = type.toString().toLowerCase();
            }
            if (type != null && !type.equals("text") && !type.equals("password")) {
                if (type.equals("image")) {
                    URLResolver imageSource = this.getImageURL();
                    control = new JButton(DEFAULT_BUTTON_TEXT);
                    final WeakReference<JComponent> buttonRef = new WeakReference<JComponent>(control);
                    if (imageSource != null) {
                        InetHtmlDocument document = (InetHtmlDocument)this.getElement().getDocument();
                        ImageCache.getStaticInstance().getImage(imageSource, document.getTimeoutProvider(), false, new AnimationObserver(){

                            @Override
                            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                                JComponent component = (JComponent)buttonRef.get();
                                if (component instanceof JButton) {
                                    JButton button = (JButton)component;
                                    if ((infoflags & 0x20) != 0) {
                                        if (button.getText() == ControlView.DEFAULT_BUTTON_TEXT) {
                                            button.setText("");
                                        }
                                        button.setIcon(new ImageIcon(img));
                                    }
                                }
                                return (infoflags & 0xE0) == 0;
                            }

                            @Override
                            public boolean doAnimate() {
                                return false;
                            }
                        });
                    }
                    ((JButton)control).setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                    ((JButton)control).setContentAreaFilled(false);
                    ((JButton)control).setHorizontalAlignment(this.getSwingAlign(0));
                    ((JButton)control).setVerticalAlignment(this.getSwingAlign(1));
                    if (value != null) {
                        ((JButton)control).setText(value.toString());
                    }
                    this.persistSize(control);
                    this.type = 0;
                    this.isSubmit = true;
                } else if (type.equals("button")) {
                    control = new JButton(DEFAULT_BUTTON_TEXT);
                    ((JButton)control).setOpaque(true);
                    if (value != null) {
                        ((JButton)control).setText(value.toString());
                    }
                    this.persistSize(control);
                    this.type = 0;
                } else if (type.equals("submit")) {
                    String submit = UIManager.getString("FormView.submitButtonText");
                    control = new JButton(submit != null ? submit : "OK");
                    ((JButton)control).setOpaque(true);
                    if (value != null) {
                        ((JButton)control).setText(value.toString());
                    }
                    this.persistSize(control);
                    this.type = 0;
                    this.isSubmit = true;
                } else if (type.equals("reset")) {
                    String reset = UIManager.getString("FormView.resetButtonText");
                    control = new JButton(reset != null ? reset : "Reset");
                    ((JButton)control).setOpaque(true);
                    if (value != null) {
                        ((JButton)control).setText(value.toString());
                    }
                    this.persistSize(control);
                    this.type = 0;
                    this.isSubmit = true;
                    this.isReset = true;
                } else if (type.equals("hidden")) {
                    this.type = 7;
                } else if (type.equals("radio")) {
                    control = new JRadioButton();
                    control.setFont(new Font("Arial", 0, 2));
                    ((JRadioButton)control).setOpaque(false);
                    ((JRadioButton)control).setBorderPainted(false);
                    if (value != null && value.toString().trim().equalsIgnoreCase("on")) {
                        ((JRadioButton)control).setSelected(true);
                    }
                    this.persistSize(control);
                    this.type = 3;
                } else if (type.equals("checkbox")) {
                    control = new JCheckBox();
                    control.setFont(new Font("Arial", 0, 2));
                    ((JCheckBox)control).setOpaque(false);
                    ((JCheckBox)control).setBorderPainted(false);
                    if (attributes.isDefined((Object)HTML.Attribute.CHECKED)) {
                        ((JCheckBox)control).setSelected(true);
                    }
                    this.persistSize(control);
                    this.type = 4;
                }
            } else {
                control = this.createTextField(attributes, type != null && type.equals("password"));
                this.type = 1;
            }
        } else if (tag == HTML.Tag.SELECT) {
            control = this.createSelectControl();
            this.type = 5;
        } else if (tag == HTML.Tag.TEXTAREA) {
            int rows = this.getIntegerValue(attributes, (Object)HTML.Attribute.ROWS, 3);
            int cols = this.getIntegerValue(attributes, (Object)HTML.Attribute.COLS, 15);
            control = this.createTextArea(rows, cols);
            this.type = 2;
        }
        return control;
    }

    private URLResolver getImageURL() {
        UrlValue link = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.SRC);
        if (link != null) {
            return link.getResolver();
        }
        return null;
    }

    protected void persistSize(JComponent comp) {
        this.setControlAttributes(comp);
        Dimension preferredSize = comp.getPreferredSize();
        if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto()) {
            preferredSize.height = (int)this.getHeightUnit().calculateValue(preferredSize.height, this);
        }
        if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
            preferredSize.width = (int)this.getWidthUnit().calculateValue(preferredSize.width, this);
        }
        this.layout.setPreferredSize(preferredSize.width, preferredSize.height);
        comp.setSize(preferredSize);
    }

    private int getIntegerValue(AttributeSet atts, Object key, int defaultValue) {
        Object obj = atts.getAttribute(key);
        int value = defaultValue;
        if (obj != null) {
            try {
                value = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private JComponent createTextField(AttributeSet attributes, boolean isPassword) {
        int cols = this.getIntegerValue(attributes, (Object)HTML.Attribute.SIZE, 10);
        JTextField textField = null;
        if (isPassword) {
            textField = new JPasswordField(cols);
            textField.setUI(new BasicPasswordFieldUI());
            ((JPasswordField)textField).setEchoChar('*');
        } else {
            textField = new JTextField(cols);
            textField.setUI(new BasicTextFieldUI());
        }
        Object preset = attributes.getAttribute((Object)HTML.Attribute.VALUE);
        if (preset != null) {
            textField.setText(preset.toString());
        }
        try {
            textField.setDragEnabled(true);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        textField.setOpaque(false);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)textField, "Center");
        if (!this.getBox().useDefaultLookAndFeelBorder()) {
            textField.setBorder(null);
        }
        this.persistSize(wrapper);
        wrapper.doLayout();
        return wrapper;
    }

    private JComponent createTextArea(int rows, int cols) {
        JScrollPane scrollPane;
        block9: {
            Insets emptyInsets = new Insets(0, 0, 0, 0);
            scrollPane = new JScrollPane();
            JTextArea textArea = new JTextArea();
            textArea.setBorder(new EmptyBorder(emptyInsets));
            textArea.setMargin(emptyInsets);
            try {
                textArea.setDragEnabled(true);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (this.font != null) {
                textArea.setFont(this.font);
            }
            textArea.setRows(rows);
            textArea.setColumns(cols);
            Dimension preferredSize = textArea.getPreferredSize();
            textArea.setRows(1);
            textArea.setColumns(1);
            if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto()) {
                preferredSize.height = (int)this.getHeightUnit().calculateValue(preferredSize.height, this);
            }
            if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
                preferredSize.width = (int)this.getWidthUnit().calculateValue(preferredSize.width, this);
            }
            scrollPane.setViewportBorder(new EmptyBorder(emptyInsets));
            scrollPane.setMinimumSize(preferredSize);
            scrollPane.setPreferredSize(preferredSize);
            scrollPane.setMaximumSize(preferredSize);
            scrollPane.setViewportView(textArea);
            scrollPane.setOpaque(false);
            try {
                int start = this.getElement().getStartOffset();
                int end = this.getElement().getEndOffset();
                if (start < end - 1) {
                    textArea.setText(this.getDocument().getText(start, end - start - 1));
                }
            }
            catch (Exception e) {
                if (!Logger.doesLog(1)) break block9;
                Logger.error(e);
            }
        }
        scrollPane.setBorder(new BevelBorder(1, ColorUtils.get3DLight(), ColorUtils.get3DDark()));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)scrollPane, "Center");
        wrapper.setOpaque(false);
        if (!this.getBox().useDefaultLookAndFeelBorder()) {
            scrollPane.setBorder(null);
        }
        this.persistSize(wrapper);
        wrapper.doLayout();
        scrollPane.doLayout();
        scrollPane.getViewport().doLayout();
        return wrapper;
    }

    private JComponent createSelectControl() {
        Vector<String> options = new Vector<String>();
        Element elem = this.getElement();
        Document doc = this.getDocument();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (int i = 0; i < elem.getElementCount(); ++i) {
            Element option = elem.getElement(i);
            if (option.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.OPTION) continue;
            int start = option.getStartOffset();
            int end = option.getEndOffset();
            try {
                String text = doc.getText(start, end - start);
                if (option.getAttributes().isDefined((Object)HTML.Attribute.SELECTED)) {
                    selected.add(options.size());
                }
                options.add(text);
                continue;
            }
            catch (BadLocationException text) {
                // empty catch block
            }
        }
        if (options.size() == 0) {
            options.add("");
        }
        IntegerValue rowCount = AttributeFinder.SIZE.getAttributeValue(this);
        JComponent control = this.getControlComponent();
        if (rowCount == null || rowCount.getInt() == 1) {
            control = new JComboBox(options);
            if (selected.size() > 0) {
                control.setSelectedIndex((Integer)selected.get(selected.size() - 1));
            }
        } else {
            boolean multiple = elem.getAttributes().isDefined((Object)HTML.Attribute.MULTIPLE);
            JList list = new JList(options);
            list.setVisibleRowCount(rowCount.getInt());
            if (selected.size() > 0) {
                int[] selectedIndices = new int[selected.size()];
                for (int i = 0; i < selected.size(); ++i) {
                    selectedIndices[i] = (Integer)selected.get(i);
                }
                list.setSelectedIndices(selectedIndices);
            }
            list.setSelectionMode(multiple ? 2 : 0);
            control = new JScrollPane(list);
        }
        this.persistSize(control);
        control.invalidate();
        control.doLayout();
        return control;
    }

    private JComponent getInnerControl(JComponent control) {
        if (control instanceof JPanel) {
            control = (JComponent)control.getComponent(0);
        }
        if (control instanceof JScrollPane) {
            control = (JComponent)((JScrollPane)control).getViewport().getComponent(0);
        }
        return control;
    }

    private void setControlAttributes(JComponent control) {
        if (this.getParent() == null) {
            return;
        }
        this.color = AttributeFinder.COLOR.getAttributeValue(this).getValue();
        if (control != null) {
            JComponent innerControl = this.getInnerControl(control);
            if (!this.getBox().useDefaultLookAndFeelBorder()) {
                control.setBorder(new CSSBorder(this));
            } else {
                if (control instanceof JButton) {
                    Insets border = control.getBorder().getBorderInsets(control);
                    Dimension pref = control.getPreferredSize();
                    Insets padding = this.getBox().getPadding();
                    pref.height += Math.max(padding.top - border.top, 0) + Math.max(padding.bottom - border.bottom, 0);
                    pref.width += Math.max(padding.left - border.left, 0) + Math.max(padding.right - border.right, 0);
                    control.setMinimumSize(pref);
                    control.setPreferredSize(pref);
                    control.setSize(pref);
                    Dimension max = control.getMaximumSize();
                    max.width = Math.max(max.width, pref.width);
                    max.height = Math.max(max.height, pref.height);
                    control.setMaximumSize(max);
                }
                if (innerControl instanceof JTextComponent) {
                    JTextComponent field = (JTextComponent)innerControl;
                    field.setMargin(this.getBox().getPadding());
                }
            }
            if (this.color != null) {
                innerControl.setForeground(this.color);
            }
            if (this.getBox().isBackgroundOpaque()) {
                innerControl.setOpaque(false);
                control.setOpaque(false);
                if (this.getBackgroundValue() != null && this.getBackgroundValue().getValue().getAlpha() > 0) {
                    innerControl.setOpaque(true);
                    innerControl.setBackground(this.getBackgroundValue().getValue());
                    control.setOpaque(false);
                    control.setBackground(this.getBackgroundValue().getValue());
                } else {
                    innerControl.setBackground(null);
                    control.setBackground(null);
                }
            }
            if (this.font != null) {
                innerControl.setFont(this.font);
            }
            control.setVisible(false);
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        JComponent control = this.getControlComponent();
        if (control != null && this.layout != null) {
            if (axis == 2) {
                return this.getFirstLineBaseLine();
            }
            return this.layout.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (pos >= this.getStartOffset() && pos <= this.getEndOffset()) {
            return a;
        }
        return null;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            clip = clip.intersection(allocation.getBounds());
            if (clip.width <= 0 || clip.height <= 0) {
                return;
            }
        }
        int top = allocation.getBounds().x;
        int left = allocation.getBounds().y;
        int width = allocation.getBounds().width;
        int height = allocation.getBounds().height;
        this.getBox().paintBackground(g, top, left, width, height, this);
        JComponent control = this.getControlComponent();
        if (control != null) {
            control.setSize(width, height);
            control.setVisible(true);
            control.setBounds(allocation.getBounds());
            control.setVisible(true);
            if (control.getParent() == null) {
                Graphics g2 = g.create(top, left, width, height);
                g2.setClip(0, 0, width, height);
                control.print(g2);
            }
        }
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return this.getStartOffset();
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        if (hard || this.getStatus() != 0) {
            return this.layout.layout(hard);
        }
        return null;
    }

    public int getControlWidth() {
        JComponent control = this.getControlComponent();
        if (control != null) {
            return control.getMinimumSize().width;
        }
        return 0;
    }

    public int getControlHeight() {
        JComponent control = this.getControlComponent();
        if (control != null) {
            return control.getMinimumSize().height;
        }
        return 0;
    }

    @Override
    public void performLayoutWidth() {
        if (this.layout != null) {
            this.layout.layoutWidth();
        }
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public void performPreLayout() {
        if (this.layout != null) {
            this.layout.preLayout();
        }
    }

    @Override
    public void predictWidth(int width) {
        JComponent control = this.getControlComponent();
        if (control != null) {
            this.setSizeContent(width, control.getHeight() - this.getBox().getTopBorderPadding() - this.getBox().getBottomBorderPadding());
        }
    }

    public String toString() {
        JComponent control = this.getControlComponent();
        return "ControlView: " + this.getElement().toString() + " -> " + (control != null ? control.getClass().getSimpleName() : "NULL");
    }

    public JComponent getControl() {
        JComponent control = this.getControlComponent();
        if (control != null && control instanceof JScrollPane) {
            return (JComponent)((JScrollPane)control).getViewport().getComponent(0);
        }
        return control;
    }

    public JComponent getControlPanel() {
        return this.getControlComponent();
    }

    @Override
    public void performLayoutVAlign(int baseline) {
        this.layout.layoutVerticalAlign((int)this.getAlignment(1), baseline);
    }

    @Override
    public int getFirstLineBaseLine() {
        JComponent control = this.getControlComponent();
        if (control != null) {
            if (control instanceof JPanel && ((JPanel)control).getComponentCount() == 1) {
                control = (JComponent)((JPanel)control).getComponent(0);
            }
            if (control instanceof JScrollPane) {
                control = (JComponent)((JScrollPane)control).getViewport().getView();
            }
            try {
                Object value;
                Method m = JComponent.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                if (m != null && (value = m.invoke((Object)control, this.getOuterWidth(), this.getOuterHeight())) != null && value instanceof Integer && (Integer)value >= 0) {
                    return (Integer)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (int)this.layout.getPreferredSpan(2);
    }

    public int getType() {
        return this.type;
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public Object getValue() {
        JComponent control = this.getInnerControl(this.getControl());
        if (control != null && control instanceof JToggleButton) {
            String value = this.getValueAttribute();
            if (value == null) {
                value = ((JToggleButton)control).isSelected() ? "on" : "off";
            }
            return value;
        }
        if (control != null && control instanceof JTextField) {
            return ((JTextField)control).getText();
        }
        if (control != null && control instanceof JTextArea) {
            return ((JTextArea)control).getText();
        }
        if (control != null && control instanceof JComboBox) {
            Object selectedItem = ((JComboBox)control).getSelectedItem();
            return selectedItem != null ? selectedItem.toString() : null;
        }
        if (control != null && control instanceof JList) {
            return ((JList)control).getSelectedValuesList();
        }
        return this.getValueAttribute();
    }

    private String getValueAttribute() {
        AttributeSet attributes = this.getElement().getAttributes();
        if (attributes.isDefined((Object)HTML.Attribute.VALUE)) {
            return attributes.getAttribute((Object)HTML.Attribute.VALUE).toString();
        }
        return null;
    }

    public String getName() {
        AttributeSet attributes = this.getElement().getAttributes();
        if (attributes.isDefined((Object)HTML.Attribute.NAME)) {
            return attributes.getAttribute((Object)HTML.Attribute.NAME).toString();
        }
        return null;
    }

    public boolean isSuccessful(ControlView activator) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        if (this.type == 7) {
            return true;
        }
        if (this.type == 0) {
            return this == activator;
        }
        JComponent control = this.getInnerControl(this.getControl());
        if (control != null && control instanceof JToggleButton) {
            return ((JToggleButton)control).isSelected();
        }
        if (control != null && control instanceof JTextField) {
            return true;
        }
        if (control != null && control instanceof JTextArea) {
            return true;
        }
        if (control != null && control instanceof JList) {
            return ((JList)control).getSelectedIndices().length > 0;
        }
        if (control != null && control instanceof JComboBox) {
            return ((JComboBox)control).getSelectedItem() != null;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (this.getPainter() != null && this.getPainter().wasPainted()) {
            return false;
        }
        int h = this.getOuterHeight();
        boolean partial = false;
        if (clip.getHeight() < 0.0 || clip.getMinY() > (double)h || clip.getMaxY() < (double)h) {
            if (!Boolean.TRUE.equals(result.getProperty(DOMUtils.ClippingProperty.FirstLineRendered))) {
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY() + clip.getHeight());
            } else {
                if (result.isSet(DOMUtils.ClippingProperty.WholeContentOnly)) {
                    result.setFirstClippedContentLocation(-clip.getY());
                    return false;
                }
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY());
            }
        } else {
            result.setLastVisibleContentLocation(-clip.getY() + (double)h);
        }
        DOMUtils.markAllVisible(this.getElement(), result);
        DOMUtils.DOMVisibilityResult myResult = new DOMUtils.DOMVisibilityResult(this, partial ? DOMUtils.Visibility.visible_paged : DOMUtils.Visibility.visible);
        myResult.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(this.getContentWidth()));
        myResult.setAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(this.getContentHeight()));
        result.put(this.getElement(), myResult);
        return true;
    }

    private static class CSSBorder
    implements Border {
        private final BoxView view;

        public CSSBorder(BoxView view) {
            this.view = view;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle region = new Rectangle(x, y, width, height);
            this.view.getBox().paint(g, region, 4, this.view);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = this.view.getBox().getBorderInsets();
            Insets padding = this.view.getBox().getPadding();
            return new Insets(insets.top + padding.top, insets.left + padding.left, insets.bottom + padding.bottom, insets.right + padding.right);
        }

        @Override
        public boolean isBorderOpaque() {
            Insets styles = this.view.getBox().getBorderStyles();
            return this.isOpaqueStyle(styles.top) && this.isOpaqueStyle(styles.left) && this.isOpaqueStyle(styles.right) && this.isOpaqueStyle(styles.bottom);
        }

        private boolean isOpaqueStyle(int style) {
            return style != 6 && style != 5 && style != 8;
        }
    }
}

