/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftEntry> hash = new HashMap<K, SoftEntry>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public synchronized V get(Object key) {
        V value = null;
        SoftReference reference = this.hash.get(key);
        if (reference != null && (value = (V)reference.get()) == null) {
            this.hash.remove(key);
        }
        return value;
    }

    private synchronized void processQueue() {
        SoftEntry sv;
        while ((sv = (SoftEntry)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    @Override
    public synchronized V put(K key, V value) {
        this.processQueue();
        if (value == null) {
            return this.remove(key);
        }
        SoftEntry previousContent = this.hash.put(key, new SoftEntry(key, value, this.queue));
        if (previousContent != null) {
            return (V)previousContent.get();
        }
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        this.processQueue();
        SoftEntry remContent = this.hash.remove(key);
        if (remContent != null) {
            return (V)remContent.get();
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public synchronized int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (SoftEntry e : this.hash.values()) {
            set.add(e);
        }
        return set;
    }

    private class SoftEntry
    extends SoftReference<V>
    implements Map.Entry<K, V> {
        private final K key;

        public SoftEntry(K key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("SoftReferenced values cannot be updated!");
        }
    }
}

