/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;

public class FontUtils {
    private static ArrayList<Font> unicodeFonts = new ArrayList();

    public static Font getFontFor(String characters, int style, float size) {
        Font[] allfonts;
        if (unicodeFonts.size() > 0) {
            for (Font font : unicodeFonts) {
                int canDisplayUpTo = font.canDisplayUpTo(characters);
                if (canDisplayUpTo >= 0) continue;
                return font.deriveFont(style, size);
            }
        }
        if ((allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) != null) {
            for (int i = allfonts.length - 1; i >= 0; --i) {
                Font font = allfonts[i];
                if (font.canDisplayUpTo(characters) >= 0) continue;
                unicodeFonts.add(font);
                return font.deriveFont(style, size);
            }
        }
        return null;
    }

    static {
        Font font = new Font("DejaVu Sans", 0, 1);
        if (!font.getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("Serif.plain", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("MS Gothic Sans", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("Arial Unicode MS", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
    }
}

