/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;

public class FontStyle
extends SingleAttributeValue {
    private boolean italic;

    public FontStyle() {
    }

    public FontStyle(boolean isItalic) {
        this.italic = isItalic;
        if (isItalic) {
            this.setString("italic");
        } else {
            this.setString("normal");
        }
    }

    public boolean isItalic() {
        return this.italic;
    }

    @Override
    protected AttributeValue parseCssValue(String value, boolean important) {
        if ("inherit".equalsIgnoreCase(value)) {
            return AttributeValue.INHERIT;
        }
        FontStyle fontStyle = new FontStyle();
        if (value.equalsIgnoreCase("italic") || value.equalsIgnoreCase("oblique")) {
            fontStyle.italic = true;
        } else if (value.equalsIgnoreCase("normal")) {
            fontStyle.italic = false;
        } else {
            return null;
        }
        fontStyle.setString(value);
        fontStyle.setImportant(important);
        return fontStyle;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontStyle) {
            FontStyle other = (FontStyle)obj;
            if (other.isItalic() != this.isItalic()) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }
}

