/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.MultiAttributeValue;

public class BackgroundPosition
extends MultiAttributeValue {
    private LengthUnit percentX = new LengthUnit();
    private LengthUnit percentY = new LengthUnit();
    private boolean isXset = false;
    private boolean isYset = false;
    static final BackgroundPosition PARSER = new BackgroundPosition();

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BackgroundPosition) {
            BackgroundPosition other = (BackgroundPosition)obj;
            if (other.isImportant() != this.isImportant()) {
                return false;
            }
            return this.percentX.equals(other.getPercentX()) && this.percentY.equals(other.getPercentY());
        }
        return false;
    }

    public LengthUnit getPercentX() {
        return this.percentX;
    }

    public LengthUnit getPercentY() {
        return this.percentY;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        String[] parts;
        String value = valueStr.toLowerCase().trim();
        if ("inherit".equals(value)) {
            return AttributeValue.INHERIT;
        }
        BackgroundPosition resolver = this;
        if (value.indexOf(" ") > 0 && (parts = value.split("[\\s\\t]+")) != null && parts.length == 2 && (resolver = (BackgroundPosition)resolver.parseCssValue(parts[0], important)) != null) {
            resolver.parseCssValue(parts[1], important);
            return resolver;
        }
        if (!this.isXset && !this.isYset || resolver == null) {
            resolver = new BackgroundPosition();
        }
        LengthUnit len = (LengthUnit)LengthUnit.PARSER.parseCssValue(valueStr, important);
        if (value.equals("left")) {
            resolver.setPercentX((LengthUnit)LengthUnit.PARSER.parseCssValue("0%", important));
        } else if (value.equals("right")) {
            resolver.setPercentX((LengthUnit)LengthUnit.PARSER.parseCssValue("100%", important));
        } else if (value.equals("center")) {
            if (!this.isXset) {
                resolver.setPercentX((LengthUnit)LengthUnit.PARSER.parseCssValue("50%", important));
            } else {
                resolver.setPercentY((LengthUnit)LengthUnit.PARSER.parseCssValue("50%", important));
            }
        } else if (value.equals("top")) {
            resolver.setPercentY((LengthUnit)LengthUnit.PARSER.parseCssValue("0%", important));
        } else if (value.equals("bottom")) {
            resolver.setPercentY((LengthUnit)LengthUnit.PARSER.parseCssValue("100%", important));
        } else if (len != null) {
            if (!this.isXset) {
                resolver.setPercentX(len);
            } else {
                resolver.setPercentY(len);
            }
        } else {
            return null;
        }
        resolver.setString(valueStr);
        return resolver;
    }

    private void setPercentX(LengthUnit percentX) {
        this.percentX = percentX;
        this.isXset = true;
    }

    private void setPercentY(LengthUnit percentY) {
        this.percentY = percentY;
        this.isYset = true;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.percentX != null) {
            if (this.percentX.getValue() == 0.0f && this.percentX.getType() == 1) {
                b.append("left");
            } else if (this.percentX.getValue() == 0.5f && this.percentX.getType() == 1) {
                b.append("center");
            } else if (this.percentX.getValue() == 1.0f && this.percentX.getType() == 1) {
                b.append("right");
            } else if (!"null".equals(this.percentX.toString())) {
                b.append(this.percentX.toString());
            }
        } else {
            b.append("auto");
        }
        b.append(" ");
        if (this.percentY != null) {
            if (this.percentY.getValue() == 0.0f && this.percentY.getType() == 1) {
                b.append("top");
            } else if (this.percentY.getValue() == 0.5f && this.percentY.getType() == 1) {
                b.append("center");
            } else if (this.percentY.getValue() == 1.0f && this.percentY.getType() == 1) {
                b.append("bottom");
            } else if (!"null".equals(this.percentY.toString())) {
                b.append(this.percentY.toString());
            }
        } else {
            b.append("auto");
        }
        return b.toString();
    }
}

