/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocumentIterator;
import com.inet.html.InetHtmlParser;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.event.AttributeUndoableEdit;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.image.ImageCache;
import com.inet.html.parser.DocType;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.Background;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.parser.converter.TransformValue;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.EmbeddedImage;
import com.inet.html.utils.InetStreamHandler;
import com.inet.html.utils.Logger;
import com.inet.html.utils.URLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.management.StringValueExp;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class InetHtmlDocument
extends HTMLDocument
implements CssDocument {
    public static final int MAJOR_VERSION = 1;
    private StyleResolver styleResolver;
    public static final Object FLAG_INIT = StyleConstants.ModelAttribute;
    @Deprecated
    public static final int DOCTYPE_UNKNOWN = 0;
    @Deprecated
    public static final int DOCTYPE_HTML = 1;
    @Deprecated
    public static final int DOCTYPE_XHTML = 2;
    @Deprecated
    public static final int DOCTYPE_STRICT = 3;
    @Deprecated
    public static final int DOCTYPE_TRANSIENT = 4;
    @Deprecated
    public static final int DOCTYPE_FRAMESET = 5;
    public static final Object PROPERTY_INDENT_SPACE = "IndentSpace";
    public static final Object PROPERTY_WRITE_HIERARCHY = "WriteHierarchy";
    public static final Object PROPERTY_CONFIGURATION = "Configuration";
    public static final Object PROPERTY_DEFAULT_FONT = "DefaultFont";
    public static final Object PROPERTY_DROP_UNKNOWN_STYLES = "DropUnknownStyles";
    public static final Object PROPERTY_MEDIA = "RenderMedia";
    public static final String MEDIA_SCREEN = "screen";
    public static final String MEDIA_PRINT = "print";
    public static final Object PROPERTY_PERSISTENT_STYLES = "PersistentStyles";
    public static final Object PROPERTY_DEFAULT_STYLE_CLASS = "DefaultStyleClass";
    public static final Object PROPERTY_IGNORE_NAMESPACES = "IgnoreNameSpaces";
    public static final Object PROPERTY_TIMEOUT = "ParserTimeout";
    public static final Object PROPERTY_TAB_WIDTH = "TabWidth";
    public static final Object PROPERTY_BREAK_MODE = "BreakMode";
    public static final Object BREAK_MODE_OVERFLOW = "BreakModeOverflow";
    public static final Object BREAK_MODE_WORDBREAK = "BreakModeWordbreak";
    public static final Object BREAK_MODE_WORDBREAKINLINE = "BreakModeWordbreakInline";
    public static final Object PROPERTY_USE_FONT_FALLBACK = "UseFontFallback";
    public static final Object PROPERTY_CONNECTION_TIMEOUT = "ConnectionTimeout";
    public static final int VALUE_CONNECTION_TIMEOUT_DEFAULT = -4242;
    private DocType docType = new DocType();
    private boolean eventsLocked = false;
    private boolean allowTableEdit = false;
    private String defaultStyleName = null;
    private InetHtmlConfiguration configuration = InetHtmlConfiguration.getMailEditorConfig();
    private Dictionary<Object, Object> documentProperties;
    private int siteCount = 0;
    private int revision = 0;
    private static boolean dhInit = false;
    private static final String[][] PATH = new String[][]{{"com.inet.report.layout.richhtml.", "com.inet.report.layout.richhtml.", "com.inet.thread."}, {"com.inet.report.layout.richhtml.", "com.inet.report.layout.richhtml.", "com.inet.report.renderer.thread."}, {"com.inet.designer.", "com.inet.designer.", "com.inet.designer.", "com.inet.designer."}, {"com.inet.helpdesk.components.editor", "com.inet.helpdesk.dialogs", "inet"}, {"srv.ListeningServerSocket.init", "srv.ListeningServerSocket"}, {"com.inet.ccquality.InetHtmlIndexerKit.parse", "com.sun.java.help.search.Indexer.compile", "com.inet.ccquality.InetIndexer.main"}, {"com.inet.setup.panels.AbstractPanel", "com.inet.setup.panels.CCLicensePanel", "com.izforge.izpack.installer.InstallerFrame"}, {"at javax.swing.JEditorPane.setContentType", "com.izforge.izpack.uninstaller.UninstallerFrame.buildUninstallerScreen", "com.izforge.izpack.uninstaller.UninstallerFrame.buildGUI"}, {"com.inet.helpdesk.help.HelpBrowser.showHelpPage", "inet.HelpDeskClient.showHelp(HelpDeskClient.java", "com.inet.helpdesk.auth.LoginBox"}, {"javax.help.JHelpContentViewer.setUI", "javax.help.WindowPresentation.createJHelp", "com.inet.report.configuration.util.HelpUtils.showHelp", "com.inet.report.configuration.view.MainViewImpl"}, {"com.inet.report.encode.html.", "com.inet.report.renderer.doc.controller.", "com.inet.report.renderer.doc.controller.", ".run"}, {"com.inet.pdfc.gui.GUIUtils.preInit", "com.inet.pdfc.ui.UIUtils.initUI(", "com.inet.pdfc.Startup$1"}, {"com.inet.helpdesk.components.HelpDeskAboutBox.buildDialog", "com.inet.helpdesk.components.HelpDeskAboutBox", "inet.HelpDeskClient.detectAndOpenOptionsDialog"}, {"com.inet.helpdesk.util.UtilFunctions.convertHtml2OptionPaneText", "inet.HelpDeskClient.loadStartInfo"}, {"com.inet.help.swing.HelpPagePanel.", "com.inet.help.swing.HelpWindowCtrl.", "com.inet.help.swing.HelpManager."}};

    public InetHtmlDocument() {
        if (this.styleResolver == null) {
            this.styleResolver = new StyleResolver();
        }
        AttributeFinder<Background> f = AttributeFinder.BACKGROUND;
        this.fillAttributes(this.getDefaultRootElement());
        if (!dhInit) {
            dhInit = this.isInitialized();
        }
        this.writeLock();
        Element leaf = ElementUtils.getLeafAt(this.getDefaultRootElement(), 0);
        ((MutableAttributeSet)leaf.getAttributes()).addAttribute("CR", Boolean.TRUE);
        this.writeUnlock();
    }

    public static final boolean isReady() {
        return dhInit;
    }

    private boolean isInitialized() {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("com.inet.html.dump"))) {
                PrintWriter pw = new PrintWriter(new File("./JWebEngine.dump"));
                new Throwable().printStackTrace(pw);
                pw.close();
            }
        }
        catch (Throwable pw) {
            // empty catch block
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        new Throwable().printStackTrace(pw);
        pw.flush();
        String stacktrace = baos.toString();
        block2: for (int i = 0; i < PATH.length; ++i) {
            String[] current = PATH[i];
            int lastIndex = -1;
            for (int j = 0; j < current.length; ++j) {
                String element = current[j];
                int indexOf = stacktrace.indexOf(element, lastIndex + 1);
                if (indexOf < 0) continue block2;
                lastIndex = indexOf;
            }
            return true;
        }
        return false;
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.styleResolver;
    }

    public boolean isLocked() {
        return this.getCurrentWriter() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader in, int pos) throws IOException, BadLocationException {
        AbstractDocument.BranchElement root;
        boolean isInsert;
        InetHtmlParser parser = new InetHtmlParser();
        int length = this.getModelLength();
        boolean bl = isInsert = length > 1;
        if (isInsert) {
            int elementPos = pos > 0 ? pos - 1 : 0;
            root = (AbstractDocument.BranchElement)this.getParagraphElement(elementPos);
        } else {
            root = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        }
        EventList list = new EventList();
        Element[] removed = ElementUtils.getAllChildren(root);
        Element[] added = null;
        boolean isFinish = false;
        try {
            this.writeLock();
            if (!isInsert) {
                int childCount = root.getChildCount();
                root.replace(0, childCount, new Element[0]);
                list.getEventFor(root, 0, removed, new Element[0]);
                list.addEvent(this.getContent().remove(0, length));
                ++this.siteCount;
            }
            parser.parse(in, this, root, pos, list, false, null);
            added = ElementUtils.getAllChildren(root);
            if (this.getModelLength() == 0) {
                list.addEvent(this.getContent().insertString(0, "\n"));
                AbstractDocument.BranchElement body = (AbstractDocument.BranchElement)root.getElement(0);
                if (body != null) {
                    SimpleAttributeSet set = new SimpleAttributeSet();
                    set.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                    set.addAttribute("CR", Boolean.TRUE);
                    Element[] newElems = new Element[]{this.createLeafElement((Element)body, set, 0, 1)};
                    this.replaceElements(ElementUtils.getChildren(body, 0, 1), newElems, list);
                    list.getEventFor(root, 0, new Element[0], ElementUtils.getChildren(root, 0, 1));
                } else {
                    this.clearBody(list);
                }
            }
            isFinish = true;
        }
        finally {
            if (!isFinish) {
                root.replace(0, root.getElementCount(), removed);
            }
            this.styleResolver.optimize();
            this.writeUnlock();
        }
        ExtendedDocuementEvent event = null;
        if (isInsert) {
            int startOffset = added[0].getStartOffset();
            int len = added[added.length - 1].getEndOffset() - startOffset;
            event = new ExtendedDocuementEvent(startOffset, len, DocumentEvent.EventType.INSERT, this);
            list.getEventFor(root, 0, removed, added);
            try {
                this.writeLock();
                this.splice(root, pos, list, false);
                this.splice(root, pos + (this.getModelLength() - len), list, false);
            }
            finally {
                this.writeUnlock();
            }
        } else {
            event = new ExtendedDocuementEvent(0, this.getModelLength(), DocumentEvent.EventType.CHANGE, this);
        }
        list.fillEvent(event);
        event.end();
        if (isInsert) {
            this.fireInsertUpdate(event);
        } else {
            this.fireChangedUpdate(event);
        }
        UndoableEditEvent undo = new UndoableEditEvent(this, event);
        this.fireUndoableEditUpdate(undo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDocument.DefaultDocumentEvent parseLight(Reader in, int pos, Element parent, Element anchor, boolean beforeAnchor, boolean forceParent, EventList list, Object sourceID) throws IOException, BadLocationException {
        Element newParent;
        int index;
        InetHtmlParser parser = new InetHtmlParser();
        Element root = this.getDefaultRootElement();
        if (parent == null) {
            parent = ElementUtils.getLeafAt(root, pos);
            if (parent == null) {
                throw new BadLocationException("Cannot parse the HTML content since the target DOM element is malformed", pos);
            }
            if (parent.isLeaf()) {
                parent = parent.getParentElement();
            }
        }
        int docLen = this.getModelLength();
        int startOffset = pos;
        int achorCheckOffs = 0;
        int n = index = anchor == null ? parent.getElementIndex(pos) : ElementUtils.getChildIndex(parent, anchor);
        if (anchor != null) {
            if (beforeAnchor) {
                startOffset = anchor.getStartOffset();
                achorCheckOffs = 0;
            } else {
                startOffset = anchor.getEndOffset();
                ++index;
                achorCheckOffs = 1;
            }
        }
        int length = parent.getElementCount();
        if (!forceParent && this.getParagraphElement(startOffset + achorCheckOffs) == this.getParagraphElement(startOffset) && (newParent = ElementUtils.getLeafAt(parent, startOffset + achorCheckOffs)) != null) {
            parent = newParent.getParentElement();
            index = parent.getElementIndex(pos);
            length = parent.getElementCount();
        }
        EventList eventList = new EventList(list);
        try {
            this.writeLock();
            parser.parse(in, this, (AbstractDocument.BranchElement)parent, pos, eventList, false, sourceID);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.styleResolver.optimize();
        int newElementsLength = parent.getElementCount() - length;
        if (newElementsLength == 0) {
            return null;
        }
        int newContent = this.getModelLength() - docLen;
        int endOffset = startOffset + newContent;
        Element[] newElements = null;
        if (anchor != null) {
            newElements = new Element[newElementsLength];
            System.arraycopy(ElementUtils.getChildren(parent, 0, parent.getElementCount()), index, newElements, 0, newElementsLength);
            eventList.getEventFor(parent, index, new Element[0], newElements);
        }
        parent = this.getParagraphElement(endOffset, root, true);
        this.splice(parent, endOffset, eventList, false);
        parent = this.getParagraphElement(startOffset, root, true);
        this.splice(parent, startOffset, eventList, false);
        ExtendedDocuementEvent event = new ExtendedDocuementEvent(startOffset, endOffset - startOffset, DocumentEvent.EventType.INSERT, this);
        eventList.fillEvent(event);
        event.end();
        this.fillAttributes(parent);
        return event;
    }

    private void checkAndCleanModel(EventList list) {
        this.checkAndCleanModelRecurse(this.getDefaultRootElement(), list);
    }

    private void checkAndCleanModelRecurse(Element root, EventList list) {
        Element current;
        int i;
        Element lastElem = root.getElement(0);
        if (root.getElementCount() > 1) {
            for (i = 1; i < root.getElementCount(); ++i) {
                current = root.getElement(i);
                if (!current.isLeaf() && current.getElementCount() == 0) {
                    if (Logger.doesLog(2)) {
                        Logger.warning("Inconsistent datamodel state found!");
                        Logger.warning("Branch element has no children: " + lastElem.getName());
                    }
                } else {
                    int diff;
                    block12: {
                        diff = current.getStartOffset() - lastElem.getEndOffset();
                        if (diff > 0) {
                            if (Logger.doesLog(2)) {
                                Logger.warning("Inconsistent datamodel state found...");
                                Logger.warning("Left Element : " + lastElem.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + lastElem.getStartOffset() + ":" + lastElem.getEndOffset() + ")");
                                Logger.warning("Right Element: " + current.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + current.getStartOffset() + ":" + current.getEndOffset() + ")");
                            }
                            try {
                                list.addEvent(this.getContent().remove(lastElem.getEndOffset(), diff));
                            }
                            catch (BadLocationException e) {
                                if (!Logger.doesLog(1)) break block12;
                                Logger.error(e);
                            }
                        }
                    }
                    if (diff < 0 && Logger.doesLog(2)) {
                        Logger.warning("Inconsistent datamodel state found!");
                        Logger.warning("Left Element : " + lastElem.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + lastElem.getStartOffset() + ":" + lastElem.getEndOffset() + ")");
                        Logger.warning("Right Element: " + current.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + current.getStartOffset() + ":" + current.getEndOffset() + ")");
                    }
                }
                lastElem = current;
            }
        }
        for (i = 0; i < root.getElementCount(); ++i) {
            current = root.getElement(i);
            if (current.getParentElement() != root && Logger.doesLog(2)) {
                Logger.warning("Inconsistent datamodel state found!");
                Logger.warning("Element has deprecated parent: " + current.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + current.getStartOffset() + ":" + current.getEndOffset() + ")");
            }
            if (current.isLeaf()) continue;
            this.checkAndCleanModelRecurse(current, list);
        }
    }

    protected final AbstractDocument.Content getContentImpl() {
        return super.getContent();
    }

    public Color getForeground(Element elem) {
        return StyleResolver.getAttributeValue(elem, AttributeFinder.COLOR).getValue();
    }

    public Color getBackground(Element elem) {
        ColorValue obj = StyleResolver.getAttributeValue(elem, AttributeFinder.BACKGROUND_COLOR);
        if (obj != null) {
            return obj.getValue();
        }
        return super.getBackground(elem.getAttributes());
    }

    public static float getFontSize(Element elem) {
        return ((Float)elem.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)).floatValue();
    }

    public static Font getFont(Element elem) {
        return InetHtmlDocument.getFont(elem, InetHtmlDocument.getFontSize(elem));
    }

    public static Font getFont(Element elem, float size) {
        SingleAttributeValue obj = StyleResolver.getAttributeValue(elem, AttributeFinder.FONT_FAMILY);
        String fontFamily = obj.getFamily();
        int style = 0;
        obj = StyleResolver.getAttributeValue(elem, AttributeFinder.FONT_STYLE);
        if (obj instanceof FontStyle && ((FontStyle)obj).isItalic()) {
            style |= 2;
        }
        if ((obj = StyleResolver.getAttributeValue(elem, AttributeFinder.FONT_WEIGHT)) instanceof FontWeight && ((FontWeight)obj).isBold()) {
            style |= 1;
        }
        return new Font(fontFamily, style, (int)size);
    }

    @Override
    protected BoxElement createBranchElement(Element parent, AttributeSet a) {
        if (parent == null && a.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        BoxElement boxElement = new BoxElement(parent, a);
        return boxElement;
    }

    protected BoxElement createBranchElement(Element parent, Object name) throws IllegalArgumentException {
        if (parent == null && name != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        SimpleAttributeSet atts = new SimpleAttributeSet();
        atts.addAttribute(StyleConstants.NameAttribute, name);
        BoxElement boxElement = new BoxElement(parent, (AttributeSet)atts);
        return boxElement;
    }

    @Override
    protected ContentElement createLeafElement(Element parent, AttributeSet a, int startOffs, int endOffs) {
        ContentElement contentElement = new ContentElement(parent, a, startOffs, endOffs);
        return contentElement;
    }

    protected ContentElement createLeafElement(Element parent, Object name, int startOffs, int endOffs) {
        if (parent == null && name != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        SimpleAttributeSet atts = new SimpleAttributeSet();
        atts.addAttribute(StyleConstants.NameAttribute, name);
        ContentElement contentElement = new ContentElement(parent, (AttributeSet)atts, startOffs, endOffs);
        return contentElement;
    }

    @Override
    public AbstractDocument.BranchElement createAnnonymousElement(Element parent) {
        ImpliedElement impliedElement = new ImpliedElement(parent);
        return impliedElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAfterEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertAfterEnd");
        }
        boolean locked = false;
        AbstractDocument.DefaultDocumentEvent event = null;
        Element parent = elem.getParentElement();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            int startOffset = elem.getEndOffset();
            event = this.parseLight(new StringReader(htmlText), startOffset, parent, elem, false, false, null, null);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        if (event != null) {
            this.fireInsertUpdate(event);
            UndoableEditEvent undo = new UndoableEditEvent(this, event);
            this.fireUndoableEditUpdate(undo);
        }
    }

    public void insertHTML(String html, int position) {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertHTML(" + position + ")");
        }
        this.pasteHTML(html, position, position);
    }

    public void pasteHTML(String html, int start, int end) {
        this.pasteHTML(html, start, end, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteHTML(String html, int start, int end, Object sourceID) {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:pasteHTML(" + start + ")");
            Logger.debug("PASTE CONTENT START ###");
            Logger.debug(html);
            Logger.debug("PASTE CONTENT END ###");
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(start, end, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        EventList list = new EventList();
        int len = 0;
        int editLineOffset = 0;
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (end > start) {
                this.removeImpl(start, end - start, list);
            }
            len = this.getContent().length();
            if (html.contains("Fragment-->") && html.contains("<!--StartFragment-->") && html.contains("<!--EndFragment-->")) {
                InetHtmlDocument dummyDoc = new InetHtmlDocument();
                dummyDoc.writeLock();
                dummyDoc.setDocumentProperties(this.getDocumentProperties());
                dummyDoc.setDocumentProperty("IgnoreCharsetDirective", Boolean.TRUE);
                AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)dummyDoc.getRootElements()[0];
                int childCount = root.getChildCount();
                root.replace(0, childCount, new Element[0]);
                InetHtmlParser parser = new InetHtmlParser();
                parser.parse(new StringReader(html), dummyDoc, root, 0, null, false, sourceID);
                dummyDoc.writeUnlock();
                int[] offsets = parser.getContentOffsets();
                if (offsets != null) {
                    StringWriter out = new StringWriter();
                    InetHtmlWriter writer = new InetHtmlWriter((Writer)out, dummyDoc, offsets[0], offsets[1] - offsets[0]);
                    writer.setStyleContainer(HTML.Tag.SPAN);
                    writer.setAllowStyleSpan(true);
                    writer.setInlineMode(true);
                    writer.write();
                    html = out.toString();
                }
            }
            this.parseLight(new StringReader(html), start, null, null, false, false, list, sourceID);
            int insertEnd = start + this.getContent().length() - len;
            if (insertEnd > 0 && sourceID != null && this.appendEditLine(list, insertEnd - 1)) {
                ++editLineOffset;
            }
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        int startOffset = list.getStartOffset();
        int endOffset = list.getEndOffset();
        int offs = start;
        len = this.getContent().length() - len - editLineOffset;
        ExtendedDocuementEvent changes = new ExtendedDocuementEvent(offs, len, startOffset, endOffset - startOffset, DocumentEvent.EventType.INSERT, this);
        list.fillEvent(changes);
        changes.end();
        this.fireInsertUpdate(changes);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
    }

    private boolean appendEditLine(EventList list, int position) throws IOException, BadLocationException {
        boolean isAtDocEnd;
        Element leaf = ElementUtils.getLeafAt(this.getRootElements()[0], position);
        boolean bl = isAtDocEnd = this.getLength() == position + 1;
        if (leaf != null && isAtDocEnd) {
            Object blockTag;
            Object tag;
            Element block = ElementUtils.findNextHigherBlock(leaf);
            if (block == null) {
                return false;
            }
            Element parentBlock = ElementUtils.findNextHigherBlock(block);
            if (!this.shouldHaveEditLineAfter(block)) {
                return false;
            }
            Object object = tag = parentBlock != null ? parentBlock.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            while (tag != HTML.Tag.BODY && tag != HTML.Tag.HTML && block.getEndOffset() >= position + 1) {
                parentBlock = ElementUtils.findNextHigherBlock(block = ElementUtils.findNextHigherBlock(block));
                tag = parentBlock != null ? parentBlock.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            }
            Object object2 = blockTag = block != null ? block.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            if (blockTag != HTML.Tag.P) {
                if (!this.shouldHaveEditLineAfter(block)) {
                    return false;
                }
                this.parseLight(new StringReader("<p" + (this.defaultStyleName != null ? " class=\"" + this.defaultStyleName + "\"" : "") + "></p>"), position + 1, parentBlock, block, false, true, list, null);
                if (position + 2 == this.getLength()) {
                    this.removeCompleteImpl(ElementUtils.getLeafAt(parentBlock, position + 2), list);
                    list.addEvent(this.getContent().remove(position + 2, 1));
                }
                return true;
            }
        }
        return false;
    }

    private boolean shouldHaveEditLineAfter(Element element) {
        if (element == null) {
            return false;
        }
        Object tag = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.BODY || tag == HTML.Tag.HTML) {
            return false;
        }
        FloatValue floatValue = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT);
        if (floatValue != null && floatValue.getFloat() != 0) {
            return false;
        }
        DisplayValue display = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (display == null) {
            return false;
        }
        switch (display.getDisplay()) {
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAfterStart(Element elem, String htmlText) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertAfterEnd");
        }
        boolean locked = false;
        Element parent = elem.getParentElement();
        AbstractDocument.DefaultDocumentEvent event = null;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            int startOffset = elem.getEndOffset();
            event = this.parseLight(new StringReader(htmlText), startOffset, parent, elem, true, true, null, null);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        if (event != null) {
            this.fireInsertUpdate(event);
            UndoableEditEvent undo = new UndoableEditEvent(this, event);
            this.fireUndoableEditUpdate(undo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBeforeEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertAfterEnd");
        }
        boolean locked = false;
        Element parent = elem;
        AbstractDocument.DefaultDocumentEvent event = null;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            int startOffset = elem.getEndOffset();
            event = this.parseLight(new StringReader(htmlText), startOffset, parent, elem, true, true, null, null);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        if (event != null) {
            this.fireInsertUpdate(event);
            UndoableEditEvent undo = new UndoableEditEvent(this, event);
            this.fireUndoableEditUpdate(undo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBeforeStart(Element elem, String htmlText) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertBeforeStart");
        }
        boolean locked = false;
        Element parent = elem.getParentElement();
        AbstractDocument.DefaultDocumentEvent event = null;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            int startOffset = elem.getStartOffset();
            event = this.parseLight(new StringReader(htmlText), startOffset, parent, elem, true, true, null, null);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        if (event != null) {
            this.fireInsertUpdate(event);
            UndoableEditEvent undo = new UndoableEditEvent(this, event);
            this.fireUndoableEditUpdate(undo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertString(" + offs + ", \"" + str + "\")");
        }
        if (str == null || str.length() == 0) {
            return;
        }
        Element paragraph = this.getParagraphElement(offs);
        Element elemAtOffs = ElementUtils.getLeafAt(paragraph, offs);
        Element elemPrevOffs = ElementUtils.getLeafAt(paragraph, offs - 1);
        if (elemAtOffs != null) {
            Element aElement = ElementUtils.findParentByTag(elemPrevOffs, HTML.Tag.A);
            if (aElement != null && !ElementUtils.isRelated(paragraph, aElement)) {
                if (aElement.getEndOffset() == offs) {
                    this.insertStringBeforeStart(elemAtOffs, str, elemAtOffs.getAttributes());
                    return;
                }
                if (aElement.getStartOffset() == offs) {
                    this.insertStringBeforeStart(aElement, str, elemAtOffs.getAttributes());
                    return;
                }
                if (aElement.getEndOffset() == offs + 1 && ElementUtils.isEndMarker(elemAtOffs)) {
                    AbstractDocument.Content content = this.getContent();
                    EventList list = new EventList();
                    this.writeLock();
                    try {
                        Element parentElement = aElement.getParentElement();
                        this.splitElement(aElement, offs, null, list, false, true);
                        int len = str.length();
                        list.addEvent(content.insertString(offs + 1, str + "\n"));
                        list.addEvent(content.remove(offs, 1));
                        Element oldcontent = ElementUtils.getLeafAt(parentElement, offs);
                        aElement = ElementUtils.findParentByTag(oldcontent, HTML.Tag.A);
                        MutableAttributeSet aAttributes = (MutableAttributeSet)aElement.getAttributes();
                        aAttributes.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                        aAttributes.removeAttribute((Object)HTML.Attribute.HREF);
                        aAttributes.removeAttribute((Object)HTML.Attribute.NAME);
                        aAttributes.removeAttribute((Object)HTML.Attribute.ALT);
                        aAttributes.removeAttribute((Object)HTML.Attribute.CLASS);
                        aAttributes = ElementUtils.removeNonessentialAttributes(aAttributes, aElement.getParentElement());
                        ElementUtils.clearTemp(aAttributes);
                        if (aAttributes.getAttributeCount() == 1) {
                            Element parent = aElement.getParentElement();
                            int index = ElementUtils.getChildIndex(parent, aElement);
                            this.createCopy(aElement, parent, aElement.getStartOffset(), aElement.getEndOffset(), index);
                            int count = aElement.getElementCount();
                            Element[] adds = ElementUtils.getChildren(parent, index, count);
                            ((AbstractDocument.BranchElement)parent).replace(index + count, 1, new Element[0]);
                            list.getEventFor(parent, index, new Element[]{aElement}, adds);
                            oldcontent = ElementUtils.getLeafAt(parent, offs);
                        }
                        parentElement = oldcontent.getParentElement();
                        ContentElement contentElem = this.createLeafElement(parentElement, (Object)HTML.Tag.CONTENT, offs, offs + len);
                        SimpleAttributeSet set = new SimpleAttributeSet();
                        set.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                        set.addAttribute("CR", Boolean.TRUE);
                        ContentElement crElem = this.createLeafElement(parentElement, set, offs + len, offs + len + 1);
                        this.replaceElements(new Element[]{oldcontent}, new Element[]{contentElem, crElem}, list);
                        this.styleResolver.fillAttributesNonLocked(aElement, null);
                        this.styleResolver.fillAttributesNonLocked(contentElem, null);
                        this.styleResolver.fillAttributesNonLocked(crElem, null);
                    }
                    finally {
                        this.writeUnlock();
                    }
                    this.fireUpdateEvent(offs, str.length(), DocumentEvent.EventType.INSERT, list);
                    return;
                }
            } else if (!ElementUtils.isContent(elemAtOffs)) {
                this.insertStringBeforeStart(elemAtOffs, str, a);
                return;
            }
        }
        AbstractDocument.Content content = this.getContent();
        EventList list = new EventList();
        str = str.replaceAll("\\n", " ");
        if (offs == paragraph.getStartOffset() || elemPrevOffs != null && !ElementUtils.isContent(elemPrevOffs)) {
            String firstChar = content.getString(offs, 1);
            list.add(content.insertString(offs + 1, str + firstChar));
            list.add(content.remove(offs, 1));
        } else {
            list.add(content.insertString(offs, str));
        }
        Element refElement = ElementUtils.getLeafAt(paragraph, offs);
        MutableAttributeSet textAttributes = ElementUtils.removeNonessentialAttributes(a, refElement.getParentElement());
        if (!StyleResolver.matchesAttributes(refElement, textAttributes)) {
            this.writeLock();
            try {
                this.setCharacterAttributesSegment(offs, str.length(), paragraph, textAttributes, false, false, list);
                this.splice(paragraph, offs, list, false);
                this.splice(paragraph, offs + str.length(), list, false);
            }
            finally {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(offs, str.length(), DocumentEvent.EventType.INSERT, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStringBeforeStart(Element elemAtOffs, String str, AttributeSet a) throws BadLocationException {
        Element parent = elemAtOffs.getParentElement();
        int index = ElementUtils.getChildIndex(parent, elemAtOffs);
        int offs = elemAtOffs.getStartOffset();
        int origLen = elemAtOffs.getEndOffset() - offs;
        boolean isHR = elemAtOffs.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HR;
        EventList list = new EventList();
        AbstractDocument.Content content = this.getContent();
        String prevChar = offs > 0 ? content.getString(offs - 1, 1) : "";
        boolean locked = false;
        try {
            MutableAttributeSet textAttributes;
            Element refElement;
            Element marker;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (index == 0 || !ElementUtils.isContent(parent.getElement(parent.getElementIndex(offs > 0 ? offs - 1 : 0))) || "\n".equals(prevChar)) {
                String firstChar = content.getString(offs, 1);
                list.addEvent(content.insertString(offs + 1, str + firstChar));
                list.addEvent(content.remove(offs, 1));
                SimpleAttributeSet atts = new SimpleAttributeSet();
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                ContentElement left = this.createLeafElement(parent, atts, offs, offs + str.length());
                this.fillAttributes(left);
                Element right = this.createCopy(elemAtOffs, offs + str.length(), offs + str.length() + origLen, parent);
                this.fillAttributes(right);
                Element[] remove = new Element[]{elemAtOffs};
                Element[] add = new Element[]{left, right};
                ((AbstractDocument.BranchElement)parent).replace(index, 1, add);
                list.getEventFor(parent, index, remove, add);
                if (isHR) {
                    parent = this.wrapImpliedElement(offs, list);
                }
            } else {
                list.addEvent(content.insertString(offs, str));
            }
            int len = str.length();
            int markerPos = parent.getElementIndex(offs + len);
            Element element = marker = markerPos >= 0 ? parent.getElement(markerPos) : null;
            if (marker != null && ElementUtils.isEndMarker(marker)) {
                ++len;
            }
            if ((refElement = ElementUtils.getLeafAt(parent, offs)) != null && refElement.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                refElement = refElement.getParentElement();
            }
            if ((textAttributes = ElementUtils.removeNonessentialAttributes(a, parent)) != null) {
                if (textAttributes.containsAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT)) {
                    textAttributes.removeAttribute(StyleConstants.NameAttribute);
                }
                textAttributes.removeAttribute("CR");
                textAttributes.removeAttribute(FLAG_INIT);
            }
            if (refElement != null && !StyleResolver.matchesAttributes(refElement, textAttributes)) {
                if (!InetHtmlDocument.isParagraph(parent)) {
                    parent = parent.getParentElement();
                }
                this.setCharacterAttributesSegment(offs, len, parent, textAttributes, false, false, list);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(offs, str.length(), DocumentEvent.EventType.INSERT, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performParagraphBreak(int pos) {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:performParagraphBreak( " + pos + " )");
        }
        Element paragraph = this.getParagraphElement(pos);
        if (!this.allowTableEdit && ElementUtils.isTablePart(paragraph)) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        Element elemAtOffs = ElementUtils.getLeafAt(paragraph, pos);
        if (elemAtOffs != null && !ElementUtils.isContent(elemAtOffs) && InetHtmlDocument.isParagraph(elemAtOffs)) {
            block23: {
                try {
                    this.insertBeforeStart(elemAtOffs, "<p> </p>");
                }
                catch (IOException e) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                }
                catch (BadLocationException e) {
                    if (!Logger.doesLog(1)) break block23;
                    Logger.error(e);
                }
            }
            return;
        }
        Element listItem = ElementUtils.findListItemParent(paragraph);
        EventList list = new EventList();
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (listItem != null) {
                int startOffset;
                int endOffset = paragraph.getEndOffset();
                if (endOffset - (startOffset = paragraph.getStartOffset()) <= 1) {
                    Element container = ElementUtils.findListContainer(listItem);
                    if (container != null) {
                        Element parentContainer = ElementUtils.findListContainer(container);
                        if (parentContainer != null) {
                            this.changeIndent(-1, startOffset, 1, false);
                        } else {
                            Object name = container.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            this.changeListStatus(startOffset, 1, name == HTML.Tag.OL);
                        }
                    } else {
                        BoxElement newBlock = this.createBranchElement(listItem.getParentElement(), (Object)this.configuration.getDefaultBlock());
                        this.checkDefaultStyle(newBlock);
                        SimpleAttributeSet set = new SimpleAttributeSet();
                        set.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                        set.addAttribute("CR", Boolean.TRUE);
                        ContentElement content = this.createLeafElement((Element)newBlock, set, listItem.getStartOffset(), listItem.getEndOffset());
                        ((AbstractDocument.BranchElement)newBlock).replace(0, 0, new Element[]{content});
                        this.replaceElements(new Element[]{listItem}, new Element[]{newBlock}, list);
                    }
                    return;
                }
                this.splitElement(listItem, pos, null, list, false, true);
            } else {
                this.splitElement(paragraph, pos, null, list, true, true);
            }
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(pos, 1, DocumentEvent.EventType.INSERT, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertHRule(int pos) {
        Element paragraph = this.getParagraphElement(pos);
        if (paragraph.isLeaf()) {
            paragraph = ElementUtils.findNextHigherBlock(paragraph);
        }
        Object tag = paragraph.getAttributes().getAttribute(StyleConstants.NameAttribute);
        Element leaf = ElementUtils.getLeafAt(paragraph, pos);
        Object leafTag = leaf != null ? leaf.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
        DisplayValue disp = StyleResolver.getAttributeValue(paragraph, AttributeFinder.DISPLAY);
        EventList list = new EventList();
        boolean locked = false;
        boolean splitted = false;
        int splittDiff = 0;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (leafTag != HTML.Tag.HR) {
                if (tag == HTML.Tag.BODY || disp != null && disp.getDisplay() == 4) {
                    paragraph = this.wrapImpliedElement(pos, list);
                }
                if (pos > paragraph.getStartOffset()) {
                    this.splitElement(paragraph, pos, null, list, false, true);
                    splitted = true;
                    ++pos;
                }
                paragraph = paragraph.getParentElement();
            }
            splittDiff = splitted ? 1 : 0;
            SimpleAttributeSet atts = new SimpleAttributeSet();
            atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.HR);
            int insertOffset = pos;
            AbstractDocument.Content docContent = this.getContent();
            String firstChar = docContent.getString(insertOffset, 1);
            list.addEvent(docContent.insertString(insertOffset + 1, "\n" + firstChar));
            list.addEvent(docContent.remove(insertOffset, 1));
            Element right = ElementUtils.getLeafAt(paragraph, insertOffset);
            this.cropElement(right, insertOffset + 1, right.getEndOffset(), list);
            ContentElement hr = this.createLeafElement(paragraph, atts, pos, pos + 1);
            int index = paragraph.getElementIndex(insertOffset);
            Element[] adds = new Element[]{hr};
            ((AbstractDocument.BranchElement)paragraph).replace(index, 0, adds);
            list.getEventFor(paragraph, index, new Element[0], adds);
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(pos - splittDiff, 1 + splittDiff, DocumentEvent.EventType.INSERT, list);
    }

    AbstractDocument.DefaultDocumentEvent splitElement(Element elem, int pos, AttributeSet rightBlockAttributes, EventList list, boolean autoWrap, boolean autoFill) throws BadLocationException {
        Element leaf;
        AbstractDocument.AbstractElement blockRight;
        AbstractDocument.AbstractElement blockLeft;
        boolean insertBreak;
        EventList internalList = new EventList(list);
        int origPos = pos;
        boolean isParagraph = insertBreak = InetHtmlDocument.isParagraph(elem);
        AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)elem.getParentElement();
        if (elem instanceof AbstractDocument.BranchElement) {
            Element wrap;
            if (autoWrap && (wrap = this.wrapImpliedElement(pos, internalList)) != null) {
                elem = wrap;
                parent = (AbstractDocument.BranchElement)elem.getParentElement();
            }
            blockLeft = this.createBranchElement(elem.getParentElement(), elem.getAttributes().copyAttributes());
            blockRight = this.createBranchElement(elem.getParentElement(), rightBlockAttributes != null ? rightBlockAttributes : elem.getAttributes().copyAttributes());
            int limitLeft = elem.getStartOffset();
            int limitRight = elem.getEndOffset();
            if (limitLeft == pos) {
                AbstractDocument.Content content = this.getContent();
                String text = content.getString(limitLeft, 1);
                internalList.addEvent(content.insertString(limitLeft + 1, "\n" + text));
                internalList.addEvent(content.remove(limitLeft, 1));
                ++pos;
                ++limitRight;
                insertBreak = false;
            }
            if (limitRight == pos) {
                internalList.addEvent(this.getContent().insertString(limitRight, "\n"));
                Logger.debug("Split inconsistent in element : " + elem);
                ++limitRight;
            }
            this.createCopy(elem, blockLeft, limitLeft, pos);
            this.createCopy(elem, blockRight, pos, limitRight);
            if (pos - limitLeft == 1 && !insertBreak && isParagraph && (leaf = ElementUtils.getLeafAt(blockLeft, limitLeft)) != null) {
                MutableAttributeSet atts = (MutableAttributeSet)leaf.getAttributes();
                atts.removeAttribute(StyleConstants.IconAttribute);
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                atts.addAttribute("CR", Boolean.TRUE);
            }
        } else {
            blockLeft = this.createLeafElement(elem.getParentElement(), elem.getAttributes().copyAttributes(), elem.getStartOffset(), pos);
            blockRight = this.createLeafElement(elem.getParentElement(), elem.getAttributes().copyAttributes(), pos, elem.getEndOffset());
            insertBreak = false;
        }
        int index = parent.getElementIndex(pos);
        Element[] newElements = new Element[]{blockLeft, blockRight};
        parent.replace(index, 1, newElements);
        leaf = ElementUtils.getLeafAt(blockLeft, pos - 1);
        if (leaf != null) {
            String terminator = pos > 0 ? this.getContent().getString(pos - 1, 1) : "";
            boolean isMonolithic = !ElementUtils.isContent(leaf);
            boolean isCR = ElementUtils.isEndMarker(leaf);
            if (isMonolithic && isCR || !isMonolithic && "\n".equals(terminator)) {
                insertBreak = false;
            }
            if (insertBreak) {
                internalList.addEvent(this.getContent().insertString(pos, "\n"));
                Element aElement = leaf.getParentElement();
                if (aElement.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.A) {
                    SimpleAttributeSet set = new SimpleAttributeSet(aElement.getAttributes());
                    set.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                    set.removeAttribute((Object)HTML.Attribute.HREF);
                    set.removeAttribute((Object)HTML.Attribute.NAME);
                    set.removeAttribute((Object)HTML.Attribute.TITLE);
                    set.removeAttribute((Object)HTML.Attribute.ALT);
                    set.removeAttribute((Object)HTML.Attribute.CLASS);
                    ElementUtils.clearTemp(set);
                    this.splitElement(aElement, pos, set, list, false, true);
                    if (set.getAttributeCount() <= 1) {
                        Element content = ElementUtils.getLeafAt(parent, pos);
                        Element span = content.getParentElement();
                        Element paragraph = span.getParentElement();
                        Element[] toRemove = new Element[]{span};
                        Element[] toAdd = new Element[]{new ContentElement(paragraph, content.getAttributes(), content.getStartOffset(), content.getEndOffset())};
                        this.replaceElements(toRemove, toAdd, list);
                    }
                } else {
                    this.splitContentElement(leaf, pos, list);
                }
                leaf = ElementUtils.getLeafAt(blockLeft, pos);
                MutableAttributeSet atts = (MutableAttributeSet)leaf.getAttributes();
                ElementUtils.clearTemp(atts);
                atts.removeAttribute(StyleConstants.IconAttribute);
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                atts.addAttribute("CR", Boolean.TRUE);
            }
        }
        if (autoFill) {
            this.fillAttributes(blockLeft);
            this.fillAttributes(blockRight);
        }
        internalList.getEventFor(parent, index, new Element[]{elem}, newElements);
        ExtendedDocuementEvent e = new ExtendedDocuementEvent(origPos, 1, DocumentEvent.EventType.INSERT, this);
        internalList.fillEvent(e);
        e.end();
        return e;
    }

    static boolean isParagraph(Element elem) {
        DisplayValue disp = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        return disp != null && disp.getDisplay() != 2 && disp.getDisplay() != 1 && elem.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED;
    }

    private int getLowerContentBoundary(int pos, Element topLevelParagraph, Element currentElem) {
        int endIndex = currentElem.getElementIndex(pos);
        int paragraphBreak = -1;
        for (int i = endIndex; i >= 0; --i) {
            Element subElement = currentElem.getElement(i);
            if (!subElement.isLeaf()) {
                if (InetHtmlDocument.isParagraph(subElement)) {
                    return subElement.getEndOffset();
                }
                int endOffset = subElement.getEndOffset();
                endOffset = pos < endOffset ? pos : endOffset;
                paragraphBreak = this.getLowerContentBoundary(endOffset, topLevelParagraph, subElement);
                if (paragraphBreak < 0) continue;
                break;
            }
            if (!InetHtmlDocument.isParagraph(subElement)) continue;
            return subElement.getEndOffset();
        }
        return paragraphBreak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLowerContentBoundary(int pos, Element topLevelParagraph) {
        try {
            this.readLock();
            int paragraphBreak = this.getLowerContentBoundary(pos, topLevelParagraph, topLevelParagraph);
            if (paragraphBreak >= 0) {
                int n = paragraphBreak;
                return n;
            }
            int n = topLevelParagraph.getStartOffset();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    private int getUpperContentBoundaryImpl(int pos, Element topLevelParagraph, Element currentElem) {
        int startIndex = currentElem.getElementIndex(pos);
        int paragraphBreak = -1;
        if (currentElem.isLeaf()) {
            return currentElem.getEndOffset();
        }
        for (int i = startIndex; i < currentElem.getElementCount(); ++i) {
            Element subElement = currentElem.getElement(i);
            if (!subElement.isLeaf()) {
                if (InetHtmlDocument.isParagraph(subElement)) {
                    return subElement.getStartOffset();
                }
                int startOffset = subElement.getStartOffset();
                startOffset = pos > startOffset ? pos : startOffset;
                paragraphBreak = this.getUpperContentBoundaryImpl(startOffset, topLevelParagraph, subElement);
                if (paragraphBreak < 0) continue;
                break;
            }
            if (!InetHtmlDocument.isParagraph(subElement)) continue;
            return subElement.getStartOffset();
        }
        return paragraphBreak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpperContentBoundary(int pos, Element topLevelParagraph) {
        try {
            this.readLock();
            if (pos == topLevelParagraph.getEndOffset()) {
                int n = pos;
                return n;
            }
            int paragraphBreak = this.getUpperContentBoundaryImpl(pos, topLevelParagraph, topLevelParagraph);
            if (paragraphBreak >= 0) {
                int n = paragraphBreak;
                return n;
            }
            int n = topLevelParagraph.getEndOffset();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element wrapImpliedElement(int pos, EventList list) throws BadLocationException {
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            Element parentP = this.getParagraphElement(pos);
            int start = this.getLowerContentBoundary(pos, parentP);
            int end = this.getUpperContentBoundary(pos, parentP);
            Object name = parentP.getAttributes().getAttribute(StyleConstants.NameAttribute);
            DisplayValue disp = StyleResolver.getAttributeValue(parentP, AttributeFinder.DISPLAY);
            if (!(start != parentP.getStartOffset() || end != parentP.getEndOffset() || name == HTML.Tag.BODY || disp != null && disp.getDisplay() == 4 || ElementUtils.isTablePart(parentP))) {
                Element element = parentP;
                return element;
            }
            BoxElement block = this.createBranchElement(parentP, (Object)this.configuration.getDefaultBlock());
            this.checkDefaultStyle(block);
            this.createCopy(parentP, block, start, end);
            int indexStart = parentP.getElementIndex(start);
            int indexEnd = parentP.getElementIndex(end - 1);
            BoxElement startElement = null;
            BoxElement endElement = null;
            if (start > parentP.getStartOffset() && indexStart == parentP.getElementIndex(start - 1)) {
                Element oldStartElement = parentP.getElement(parentP.getElementIndex(start - 1));
                startElement = this.createBranchElement(parentP, oldStartElement.getAttributes().copyAttributes());
                this.createCopy(oldStartElement, startElement, oldStartElement.getStartOffset(), start);
            }
            if (end < parentP.getEndOffset() && indexEnd == parentP.getElementIndex(end)) {
                Element oldEndElement = parentP.getElement(parentP.getElementIndex(end + 1));
                endElement = this.createBranchElement(parentP, oldEndElement.getAttributes().copyAttributes());
                this.createCopy(oldEndElement, endElement, end, oldEndElement.getEndOffset());
            }
            ++indexEnd;
            ArrayList<BoxElement> newElementsList = new ArrayList<BoxElement>(3);
            if (startElement != null) {
                newElementsList.add(startElement);
            }
            newElementsList.add(block);
            if (endElement != null) {
                newElementsList.add(endElement);
            }
            int length = indexEnd - indexStart;
            Element[] newElements = newElementsList.toArray(new Element[newElementsList.size()]);
            Element[] removes = ElementUtils.getChildren(parentP, indexStart, length);
            list.getEventFor(parentP, indexStart, removes, newElements);
            ((AbstractDocument.BranchElement)parentP).replace(indexStart, length, newElements);
            int offset = block.getEndOffset();
            Element marker = ElementUtils.getLeafAt(block, offset - 1);
            if (marker != null && !ElementUtils.isEndMarker(marker)) {
                list.addEvent(this.getContent().insertString(offset, "\n"));
                Element node = ElementUtils.getLeafAt(block, offset);
                Element parent = node.getParentElement();
                this.splitElement(node, offset, null, list, false, false);
                SimpleAttributeSet atts = new SimpleAttributeSet();
                atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                atts.addAttribute("CR", Boolean.TRUE);
                ContentElement leaf = this.createLeafElement(parent, atts, offset, offset + 1);
                newElements = new Element[]{leaf};
                removes = new Element[]{parent.getElement(parent.getElementCount() - 1)};
                this.replaceElements(removes, newElements, list);
            }
            this.styleResolver.fillAttributesNonLocked(block, null);
            BoxElement boxElement = block;
            return boxElement;
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
    }

    private void checkDefaultStyle(Element e) {
        if (this.defaultStyleName != null) {
            ClassValue classNames;
            Element parent = e.getParentElement();
            if (HTML.Tag.BODY != parent.getAttributes().getAttribute(StyleConstants.NameAttribute) && parent.getAttributes().isDefined((Object)HTML.Attribute.CLASS) && ((classNames = (ClassValue)parent.getAttributes().getAttribute((Object)HTML.Attribute.CLASS)) == null || !classNames.getClassNames().contains(this.defaultStyleName))) {
                return;
            }
            MutableAttributeSet atts = (MutableAttributeSet)e.getAttributes();
            if (!atts.isDefined((Object)HTML.Attribute.CLASS)) {
                ClassValue classNames2 = new ClassValue();
                classNames2.addClass(this.defaultStyleName);
                atts.addAttribute((Object)HTML.Attribute.CLASS, classNames2);
            } else {
                ClassValue classNames3 = (ClassValue)atts.getAttribute((Object)HTML.Attribute.CLASS);
                if (!classNames3.getClassNames().contains(this.defaultStyleName)) {
                    classNames3.addClass(this.defaultStyleName);
                }
            }
            this.styleResolver.fillAttributesNonLocked(e, null);
        }
    }

    protected Element createCopy(Element from, int limitLeft, int limitRight, Element newParent) {
        SimpleAttributeSet atts = new SimpleAttributeSet(from.getAttributes());
        ElementUtils.clearTemp(atts);
        if (from.isLeaf()) {
            return this.createLeafElement(newParent, atts, limitLeft, limitRight);
        }
        BoxElement branch = this.createBranchElement(newParent, atts);
        this.createCopy(from, branch, limitLeft, limitRight);
        return branch;
    }

    protected Element createCopy(Element from, Element to, int limitLeft, int limitRight) {
        return this.createCopy(from, to, limitLeft, limitRight, to.getElementCount());
    }

    protected Element createCopy(Element from, Element to, int limitLeft, int limitRight, int insertIndex) {
        int n = from.getElementCount();
        int insertOffs = 0;
        if (limitLeft < limitRight) {
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement newBlock;
                Element child = from.getElement(i);
                int startOffset = child.getStartOffset();
                int endOffset = child.getEndOffset();
                if (!(startOffset < limitRight && endOffset > limitLeft || startOffset == limitRight && endOffset == limitRight) && (startOffset != limitLeft || endOffset != limitLeft)) continue;
                if (child instanceof AbstractDocument.BranchElement) {
                    newBlock = this.createBranchElement(to, child.getAttributes());
                    this.createCopy(child, newBlock, limitLeft, limitRight, 0);
                    if (newBlock.getElementCount() > 0) {
                        ((AbstractDocument.BranchElement)to).replace(insertIndex + insertOffs, 0, new Element[]{newBlock});
                    }
                } else {
                    int start = startOffset >= limitLeft ? startOffset : limitLeft;
                    int end = endOffset <= limitRight ? endOffset : limitRight;
                    newBlock = this.createLeafElement(to, child.getAttributes().copyAttributes(), start, end);
                    ((AbstractDocument.BranchElement)to).replace(insertIndex + insertOffs, 0, new Element[]{newBlock});
                }
                ++insertOffs;
            }
        } else {
            return null;
        }
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offs, int len) throws BadLocationException {
        EventList list = new EventList();
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            this.removeImpl(offs, len, list);
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(offs, len, DocumentEvent.EventType.REMOVE, list);
    }

    public void removeImpl(int offs, int len, EventList list) throws BadLocationException {
        int length;
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:remove(" + offs + ", " + len + ")");
        }
        if (len >= (length = this.getLength()) && offs == 0) {
            this.clearBody(list);
            return;
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(offs, offs + len, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        if (offs + len > length && (len = length - offs - 1) <= 0) {
            return;
        }
        if (!this.mergeBlocks(offs, len, true)) {
            Element root = ElementUtils.findSharedParent(offs, len, this.getDefaultRootElement());
            this.removeRange(root, offs, offs + len, list);
            list.addEvent(this.getContent().remove(offs, len));
            if (offs > root.getStartOffset() && offs < root.getEndOffset()) {
                Element leafLeft = ElementUtils.getLeafAt(root, offs - 1);
                Element leafRight = ElementUtils.getLeafAt(root, offs);
                if (leafLeft != null && leafRight != null) {
                    Element leftParent = leafLeft.getParentElement();
                    Element rightParent = leafRight.getParentElement();
                    if (ElementUtils.isEndMarker(leafRight) && leftParent != rightParent) {
                        ContentElement newRightLeaf = this.createLeafElement(leftParent, leafRight.getAttributes(), leafRight.getStartOffset(), leafRight.getEndOffset());
                        this.removeCompleteImpl(leafRight, list);
                        int index = leftParent.getElementCount();
                        Element[] adds = new Element[]{newRightLeaf};
                        ((AbstractDocument.BranchElement)leftParent).replace(index, 0, adds);
                        list.getEventFor(leftParent, index, new Element[0], adds);
                    }
                } else {
                    throw new BadLocationException("Cannot remove content from " + offs + " to " + (offs + len) + " due to a malformed DOM element at position " + (leafLeft == null ? offs - 1 : offs), leafLeft == null ? offs - 1 : offs);
                }
            }
        }
        if (this.getLength() == 0) {
            this.styleResolver.clearStyles();
        }
    }

    @Override
    public Element getCharacterElement(int pos) {
        try {
            this.readLock();
            Element element = ElementUtils.getLeafAt(this.getDefaultRootElement(), pos);
            return element;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getLength() {
        return super.getLength() - 1;
    }

    public int getModelLength() {
        return super.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBody(EventList event) {
        int len = this.getModelLength();
        ++this.siteCount;
        boolean locked = false;
        try {
            this.allowTableEdit = true;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            AbstractDocument.BranchElement html = (AbstractDocument.BranchElement)this.getDefaultRootElement();
            AbstractDocument.Content content = this.getContent();
            if (len > 0) {
                event.add(content.remove(0, len));
                len = this.getModelLength();
            }
            if (len <= 0) {
                event.add(content.insertString(0, "\n"));
            }
            SimpleAttributeSet atts = new SimpleAttributeSet();
            atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
            BoxElement body = this.createBranchElement((Element)html, atts);
            atts = new SimpleAttributeSet();
            atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            atts.addAttribute("CR", Boolean.TRUE);
            Element[] insert = new Element[]{this.createLeafElement((Element)body, atts, 0, 1)};
            body.replace(0, 0, insert);
            insert = new Element[]{body};
            Element[] removes = ElementUtils.getChildren(html, 0, html.getElementCount());
            html.replace(0, removes != null ? removes.length : 0, insert);
            event.add(new StyleSheetClearEdit(this.styleResolver.getStyles()));
            Styles newStyles = new Styles("INLINE", (Styles)this.getProperty(PROPERTY_PERSISTENT_STYLES));
            this.styleResolver.setStyles(newStyles);
            Object fontObj = this.getProperty(PROPERTY_DEFAULT_FONT);
            if (fontObj != null) {
                if (fontObj instanceof Font) {
                    SimpleAttributeSet defaultFontAttrs = new SimpleAttributeSet();
                    Font defaultFont = (Font)fontObj;
                    defaultFontAttrs.addAttribute((Object)CSS.Attribute.FONT_SIZE, new FontSize(defaultFont.getSize(), true));
                    CSS.setFontFamily(defaultFontAttrs, defaultFont.getName());
                    CSS.setFontStyle(defaultFontAttrs, defaultFont.isItalic());
                    CSS.setFontWeight(defaultFontAttrs, defaultFont.isBold());
                    newStyles.addInitialRule("body", defaultFontAttrs, null);
                }
                if (fontObj instanceof MutableAttributeSet) {
                    newStyles.addInitialRule("body", (MutableAttributeSet)fontObj, null);
                }
            }
            ElementUtils.clearTemp(html);
            ElementUtils.clearTemp(body);
            this.fillAttributes(html);
            event.getEventFor(html, 0, removes != null ? removes : new Element[]{}, insert);
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            this.allowTableEdit = false;
            if (locked) {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeComplete(Element toRemove) {
        boolean locked = false;
        int start = toRemove.getStartOffset();
        int end = toRemove.getEndOffset();
        EventList list = new EventList();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            this.removeCompleteImpl(toRemove, list);
            list.addEvent(this.getContent().remove(start, end - start));
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(start, end - start, DocumentEvent.EventType.REMOVE, list);
    }

    void removeCompleteImpl(Element toRemove, EventList list) {
        Element parent;
        int start = toRemove.getStartOffset();
        int end = toRemove.getEndOffset();
        Element body = this.getDefaultRootElement().getElement(this.getDefaultRootElement().getElementCount() - 1);
        for (parent = toRemove.getParentElement(); parent.getParentElement() != null && parent != body && parent.getStartOffset() == start && parent.getEndOffset() == end && (this.allowTableEdit || !ElementUtils.isTablePart(parent.getParentElement())); parent = parent.getParentElement()) {
            toRemove = parent;
        }
        int index = ElementUtils.getChildIndex(parent, toRemove);
        Element[] empty = new Element[]{};
        ((AbstractDocument.BranchElement)parent).replace(index, 1, empty);
        if (list != null) {
            list.getEventFor(parent, index, new Element[]{toRemove}, empty);
        }
    }

    private void removeRange(Element parent, int start, int end, EventList list) {
        if (parent.isLeaf()) {
            return;
        }
        int startIndex = parent.getElementIndex(start);
        int endIndex = parent.getElementIndex(end);
        Element startChild = parent.getElement(startIndex);
        Element endChild = parent.getElement(endIndex);
        int startEndOffset = startChild.getEndOffset();
        int startStartOffset = startChild.getStartOffset();
        int endEndOffset = endChild.getEndOffset();
        int endStartOffset = endChild.getStartOffset();
        if (startChild == endChild) {
            if (startStartOffset == start && startEndOffset == end) {
                endIndex = startIndex + 1;
            } else {
                this.removeRange(startChild, start, end, list);
            }
        } else {
            if (startStartOffset < start) {
                this.removeRange(startChild, start, startEndOffset, list);
                ++startIndex;
            }
            if (endEndOffset > end) {
                if (endStartOffset < end) {
                    this.removeRange(endChild, endStartOffset, end, list);
                }
            } else {
                ++endIndex;
            }
        }
        int lenIndex = endIndex - startIndex;
        if (lenIndex > 0) {
            Element[] adds = new Element[]{};
            Element[] removes = ElementUtils.getChildren(parent, startIndex, lenIndex);
            boolean doBlock = false;
            for (Element elem : removes) {
                if (this.allowTableEdit || !ElementUtils.isTablePart(elem, true)) continue;
                this.removeRange(elem, elem.getStartOffset(), elem.getEndOffset(), list);
                doBlock = true;
            }
            if (!doBlock) {
                if (list != null) {
                    list.getEventFor(parent, startIndex, removes, adds);
                }
                ((AbstractDocument.BranchElement)parent).replace(startIndex, lenIndex, adds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(AttributeSet selector, int start, int end, boolean keepStyles) {
        boolean locked = false;
        EventList list = new EventList();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            int position = start;
            while (position < end) {
                Element node;
                for (node = ElementUtils.getLeafAt(this.getDefaultRootElement(), position); node != null && !StyleResolver.matchesAttributes(node, selector); node = node.getParentElement()) {
                }
                if (node == null) {
                    ++position;
                    continue;
                }
                int endOffset = node.getEndOffset();
                if (node.isLeaf()) {
                    position = endOffset;
                    continue;
                }
                Element parent = node.getParentElement();
                int nodeIndex = ElementUtils.getChildIndex(parent, node);
                int startOffset = node.getStartOffset();
                ((AbstractDocument.BranchElement)parent).replace(nodeIndex, 1, new Element[0]);
                this.createCopy(node, parent, startOffset, endOffset, nodeIndex);
                Element[] added = ElementUtils.getChildren(parent, nodeIndex, node.getElementCount());
                Element[] remove = new Element[]{node};
                list.getEventFor(parent, nodeIndex, remove, added);
                if (keepStyles) {
                    SimpleAttributeSet set = new SimpleAttributeSet(node.getAttributes());
                    set.removeAttribute((Object)HTML.Attribute.ALINK);
                    set.removeAttribute((Object)HTML.Attribute.ALT);
                    set.removeAttribute((Object)HTML.Attribute.CLASS);
                    set.removeAttribute((Object)HTML.Attribute.CLEAR);
                    set.removeAttribute((Object)HTML.Attribute.HREF);
                    set.removeAttribute((Object)HTML.Attribute.NAME);
                    set.removeAttribute((Object)HTML.Attribute.ID);
                    set.removeAttribute((Object)HTML.Attribute.SRC);
                    set.removeAttribute(StyleConstants.NameAttribute);
                    set.removeAttribute(StyleConstants.IconAttribute);
                    ElementUtils.clearTemp(set);
                    Element nodeParentP = ElementUtils.findNextHigherBlock(node);
                    this.setCharacterAttributesSegment(startOffset, endOffset - startOffset, nodeParentP, set, false, false, list);
                    parent = nodeParentP;
                }
                this.splice(parent, startOffset, list, false);
                this.splice(parent, endOffset, list, false);
                position = endOffset;
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(start, end - start, DocumentEvent.EventType.CHANGE, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeBlocks(int offs, int len, boolean allowSplice) throws BadLocationException {
        boolean isRightChildInParent;
        Element parentP = ElementUtils.findSharedParagraph(offs, len, this.getDefaultRootElement());
        Element parent = ElementUtils.findSharedParent(offs, len, parentP);
        int endOffs = offs + len;
        Element leftParagraph = this.getParagraphElement(offs, parent, true);
        Element rightParagraph = this.getParagraphElement(endOffs, parent, true);
        Element leftChild = ElementUtils.getLeafAt(leftParagraph, offs);
        if (leftChild == null) {
            return false;
        }
        boolean isLeftChildInParent = leftParagraph == parentP;
        boolean bl = isRightChildInParent = rightParagraph == parentP;
        if (isLeftChildInParent && isRightChildInParent && this.getUpperContentBoundary(offs, parentP) >= offs + len) {
            if (leftChild.isLeaf() && len == 1 && leftChild.getEndOffset() - leftChild.getStartOffset() == 1) {
                this.removeComplete(leftChild);
                return true;
            }
            return false;
        }
        if (len == 1 && leftParagraph.getEndOffset() - leftParagraph.getStartOffset() == 1) {
            this.removeComplete(leftParagraph);
            return true;
        }
        EventList eventList = new EventList();
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (offs != leftParagraph.getStartOffset() && leftChild.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HR) {
                Element splitElement;
                int copyEnd = this.getUpperContentBoundary(endOffs, rightParagraph);
                Element copy = this.createCopy(rightParagraph, endOffs, copyEnd, leftParagraph);
                if (copy.getElementCount() == 0) {
                    ++copyEnd;
                    ++len;
                }
                if (!(splitElement = leftParagraph.getElement(leftParagraph.getElementIndex(offs))).isLeaf() && splitElement.getEndOffset() - splitElement.getStartOffset() > 1) {
                    int contentLength = this.getContent().length();
                    this.splitElement(splitElement, offs, null, eventList, false, true);
                    int diff = this.getContent().length() - contentLength;
                    copyEnd += diff;
                    parentP = ElementUtils.findSharedParagraph(offs, len += diff, this.getDefaultRootElement());
                    parent = ElementUtils.findSharedParent(offs, len, parentP);
                    leftParagraph = this.getParagraphElement(offs, parent, true);
                }
                this.removeRange(parentP, offs, copyEnd, eventList);
                eventList.addEvent(this.getContent().remove(offs, len));
                if (copy.getElementCount() > 0) {
                    int insertIndex = leftParagraph.getElementIndex(offs);
                    if (leftParagraph.getElement(insertIndex).getEndOffset() == offs) {
                        ++insertIndex;
                    }
                    this.createCopy(copy, leftParagraph, copy.getStartOffset(), copy.getEndOffset(), insertIndex);
                    Element[] adds = ElementUtils.getChildren(leftParagraph, insertIndex, copy.getElementCount());
                    eventList.getEventFor(leftParagraph, insertIndex, new Element[0], adds);
                    if (allowSplice) {
                        this.splice(parentP, offs, eventList, false);
                    }
                } else {
                    eventList.addEvent(this.getContent().insertString(offs, "\n"));
                }
            } else {
                this.removeRange(parentP, offs, offs + len, eventList);
                eventList.addEvent(this.getContent().remove(offs, len));
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        int structureChangeLen = eventList.getEndOffset() - offs;
        ExtendedDocuementEvent e = new ExtendedDocuementEvent(offs, len, structureChangeLen, DocumentEvent.EventType.REMOVE, this);
        eventList.fillEvent(e);
        e.end();
        this.fireRemoveUpdate(e);
        UndoableEditEvent undo = new UndoableEditEvent(this, e);
        this.fireUndoableEditUpdate(undo);
        return true;
    }

    private void cropElement(Element elementToCrop, int limitLeft, int limitRight, EventList docEvent) {
        if (elementToCrop.getStartOffset() < limitLeft || elementToCrop.getEndOffset() > limitRight) {
            if (!elementToCrop.isLeaf()) {
                int i;
                Element[] removes;
                int len;
                int removeLStart = -1;
                int removeLEnd = -1;
                int gapLeft = -1;
                int removeRStart = -1;
                int removeREnd = -1;
                int gapRight = -1;
                int n = elementToCrop.getElementCount();
                for (int i2 = 0; i2 < n; ++i2) {
                    Element e = elementToCrop.getElement(i2);
                    if (e.getEndOffset() < limitLeft) {
                        if (removeLStart <= 0) {
                            removeLStart = 0;
                        }
                        removeLEnd = i2 + 1;
                    }
                    if (e.getStartOffset() > limitRight) {
                        if (removeRStart <= 0) {
                            removeRStart = i2;
                        }
                        removeREnd = i2 + 1;
                    }
                    if (e.getStartOffset() < limitLeft && e.getEndOffset() > limitLeft) {
                        gapLeft = i2;
                    }
                    if (e.getStartOffset() >= limitRight || e.getEndOffset() <= limitRight) continue;
                    gapRight = i2;
                }
                if (gapLeft >= 0) {
                    this.cropElement(elementToCrop.getElement(gapLeft), limitLeft, limitRight, docEvent);
                }
                if (gapRight >= 0 && gapRight != gapLeft) {
                    this.cropElement(elementToCrop.getElement(gapRight), limitLeft, limitRight, docEvent);
                }
                if (removeLStart >= 0) {
                    len = removeLEnd - removeLStart;
                    removes = new Element[len];
                    for (i = 0; i < len; ++i) {
                        removes[i] = elementToCrop.getElement(removeLStart + i);
                    }
                    ((AbstractDocument.BranchElement)elementToCrop).replace(removeLStart, len, new Element[0]);
                    if (docEvent != null) {
                        docEvent.getEventFor(elementToCrop, removeLStart, removes, new Element[0]);
                    }
                }
                if (removeRStart >= 0) {
                    len = removeREnd - removeRStart;
                    removes = new Element[len];
                    for (i = 0; i < len; ++i) {
                        removes[i] = elementToCrop.getElement(removeRStart + i);
                    }
                    ((AbstractDocument.BranchElement)elementToCrop).replace(removeRStart, len, new Element[0]);
                    if (docEvent != null) {
                        docEvent.getEventFor(elementToCrop, removeRStart, removes, new Element[0]);
                    }
                }
            } else {
                Element parent = elementToCrop.getParentElement();
                AttributeSet atts = elementToCrop.getAttributes().copyAttributes();
                int start = elementToCrop.getStartOffset() > limitLeft ? elementToCrop.getStartOffset() : limitLeft;
                int end = elementToCrop.getEndOffset() < limitRight ? elementToCrop.getEndOffset() : limitRight;
                ContentElement content = this.createLeafElement(parent, atts, start, end);
                int index = ElementUtils.getChildIndex(parent, elementToCrop);
                Element[] remove = new Element[]{elementToCrop};
                Element[] add = new Element[]{content};
                ((AbstractDocument.BranchElement)parent).replace(index, 1, add);
                if (docEvent != null) {
                    docEvent.getEventFor(parent, index, remove, add);
                }
            }
        }
    }

    private void splice(Element elem, int position, EventList docEvent, boolean autoBlockSplice) {
        block20: {
            boolean doSplice;
            Element rightElem;
            Element leftElem;
            if (position < 1 || position >= elem.getEndOffset()) {
                return;
            }
            if (autoBlockSplice) {
                leftElem = this.getParagraphElement(position - 1);
                rightElem = this.getParagraphElement(position);
            } else {
                leftElem = elem.getElement(elem.getElementIndex(position - 1));
                rightElem = elem.getElement(elem.getElementIndex(position));
            }
            if (leftElem == rightElem) {
                if (leftElem != null && !leftElem.isLeaf()) {
                    this.splice(leftElem, position, docEvent, false);
                }
                return;
            }
            boolean bl = doSplice = !(!StyleResolver.matchesAttributes(leftElem, rightElem.getAttributes()) || !StyleResolver.matchesAttributes(rightElem, leftElem.getAttributes()) || leftElem.isLeaf() && !ElementUtils.isContent(leftElem) || rightElem.isLeaf() && !ElementUtils.isContent(rightElem));
            if (autoBlockSplice) {
                DisplayValue lDisplay = StyleResolver.getAttributeValue(leftElem, AttributeFinder.DISPLAY);
                DisplayValue rDisplay = StyleResolver.getAttributeValue(rightElem, AttributeFinder.DISPLAY);
                if (lDisplay != null && lDisplay.isBlockElement() && rDisplay != null && rDisplay.isBlockElement()) {
                    doSplice = true;
                }
            }
            if (doSplice) {
                if (leftElem.isLeaf() && rightElem.isLeaf()) {
                    Element[] remove = new Element[]{leftElem, rightElem};
                    Element[] add = new Element[]{this.createLeafElement(elem, leftElem.getAttributes().copyAttributes(), leftElem.getStartOffset(), rightElem.getEndOffset())};
                    int index = ElementUtils.getChildIndex(elem, leftElem);
                    ((AbstractDocument.BranchElement)elem).replace(index, 2, add);
                    if (docEvent != null) {
                        docEvent.getEventFor(elem, index, remove, add);
                    }
                } else {
                    Element viewSplice = null;
                    Element lastLeft = leftElem.getElement(leftElem.getElementCount() - 1);
                    int lastLeftOffs = 0;
                    if (lastLeft != null && lastLeft.getStartOffset() == lastLeft.getEndOffset()) {
                        lastLeftOffs = 1;
                    }
                    if (docEvent != null) {
                        int index = leftElem.getElementCount() - 1 - lastLeftOffs;
                        index = index >= 0 ? index : 0;
                        viewSplice = this.spliceElements(leftElem.getElement(index), rightElem.getElement(0));
                    }
                    Element[] remove = null;
                    remove = viewSplice != null ? (lastLeftOffs > 0 ? new Element[]{leftElem.getElement(leftElem.getElementCount() - 2), lastLeft} : new Element[]{leftElem.getElement(leftElem.getElementCount() - 1)}) : (lastLeftOffs > 0 ? new Element[]{lastLeft} : new Element[]{});
                    Element[] add = new Element[rightElem.getElementCount()];
                    for (int i = 0; i < rightElem.getElementCount(); ++i) {
                        if (viewSplice != null && i == 0) {
                            add[i] = viewSplice;
                            continue;
                        }
                        Element element = rightElem.getElement(i);
                        if (element instanceof ElementClonable) {
                            add[i] = ((ElementClonable)((Object)element)).clone(leftElem);
                            continue;
                        }
                        Logger.error("The current document object is not a valid InetHtml document.");
                    }
                    int index = leftElem.getElementCount() - remove.length;
                    ((AbstractDocument.BranchElement)leftElem).replace(index, remove.length, add);
                    if (docEvent != null) {
                        docEvent.getEventFor(leftElem, index, remove, add);
                    }
                    this.removeCompleteImpl(rightElem, docEvent);
                    this.splice(leftElem, position, docEvent, false);
                }
                int leftEndIndex = position - 1;
                try {
                    if (docEvent != null && "\n".equals(this.getText(leftEndIndex, 1)) && ElementUtils.isContent(ElementUtils.getLeafAt(leftElem, leftEndIndex))) {
                        UndoableEdit undoEvent = this.getContent().remove(leftEndIndex, 1);
                        docEvent.addEvent(undoEvent);
                    }
                }
                catch (BadLocationException e) {
                    if (!Logger.doesLog(1)) break block20;
                    Logger.error(e);
                }
            }
        }
    }

    private Element spliceElements(Element leftElem, Element rightElem) {
        if (leftElem == rightElem || leftElem == null || rightElem == null) {
            return null;
        }
        if (!(!leftElem.getAttributes().isEqual(rightElem.getAttributes()) || leftElem.isLeaf() && !ElementUtils.isContent(leftElem) || rightElem.isLeaf() && !ElementUtils.isContent(rightElem))) {
            if (leftElem.isLeaf() && rightElem.isLeaf()) {
                return this.createLeafElement(leftElem.getParentElement(), leftElem.getAttributes().copyAttributes(), leftElem.getStartOffset(), rightElem.getEndOffset());
            }
            Element[] add = new Element[leftElem.getElementCount() + rightElem.getElementCount()];
            BoxElement newElement = this.createBranchElement(leftElem.getParentElement(), leftElem.getAttributes().copyAttributes());
            for (int i = 0; i < leftElem.getElementCount(); ++i) {
                add[i] = ((ElementClonable)((Object)leftElem.getElement(i))).clone(newElement);
            }
            int offset = leftElem.getElementCount();
            for (int i = 0; i < rightElem.getElementCount(); ++i) {
                add[i + offset] = ((ElementClonable)((Object)rightElem.getElement(i))).clone(newElement);
            }
            newElement.replace(0, 0, add);
            return newElement;
        }
        return null;
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:replace(" + offset + ", " + length + ", '" + text + "', " + (attrs != null ? attrs.getAttribute(StyleConstants.NameAttribute) : "no attributes") + ")");
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(offset, offset + length, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        super.replace(offset, length, text, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        try {
            SimpleAttributeSet a;
            block8: {
                this.writeLock();
                a = new SimpleAttributeSet();
                try {
                    AbstractDocument.Content content = this.getContent();
                    int len = this.getModelLength();
                    if (len > 0) {
                        content.remove(0, len);
                        len = this.getModelLength();
                    }
                    if (len <= 0) {
                        content.insertString(0, "\n");
                    }
                }
                catch (BadLocationException e) {
                    if (!Logger.doesLog(1)) break block8;
                    Logger.error(e);
                }
            }
            a.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.HTML);
            BoxElement html = this.createBranchElement(null, a.copyAttributes());
            a.removeAttributes(a);
            a.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
            BoxElement body = this.createBranchElement((Element)html, a.copyAttributes());
            a.removeAttributes(a);
            a.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            ContentElement brk = this.createLeafElement((Element)body, a, 0, 1);
            Element[] buff = new Element[]{brk};
            body.replace(0, 0, buff);
            buff[0] = body;
            html.replace(0, 0, buff);
            if (this.styleResolver != null) {
                this.fillAttributes(html);
            }
            BoxElement boxElement = html;
            return boxElement;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setBase(URL base) {
        base = URLUtils.safeEncode(base);
        this.putProperty("stream", base);
    }

    @Override
    public URL getBase() {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            return (URL)desc;
        }
        return null;
    }

    protected void fillAttributes(Element root) {
        boolean locked = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            this.styleResolver.fillAttributesNonLocked(root, null);
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
    }

    public void checkInit(Element elem) {
        if (this.getCurrentWriter() != null && this.getCurrentWriter() == Thread.currentThread() && !elem.getAttributes().isDefined(FLAG_INIT)) {
            this.fillAttributes(elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AttributeSet attrs, Object name, Object value) {
        try {
            this.writeLock();
            if (value != null && attrs != null && name != null && attrs instanceof MutableAttributeSet) {
                ((MutableAttributeSet)attrs).addAttribute(name, value);
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Deprecated
    public void setDocType(int docType) {
        this.setDocVariant(docType);
    }

    @Deprecated
    public void setDocVersion(float docVersion) {
        this.getDocType().setVersion(docVersion);
    }

    @Deprecated
    public void setDocVariant(int docVariant) {
        DocType dt = this.getDocType();
        switch (docVariant) {
            case 1: {
                dt.setType(DocType.Type.HTML);
                break;
            }
            case 3: {
                dt.setVariant(DocType.Variant.Strict);
                break;
            }
            case 5: {
                dt.setVariant(DocType.Variant.Frameset);
                break;
            }
            case 2: {
                dt.setType(DocType.Type.XHTML);
                break;
            }
            case 4: {
                dt.setVariant(DocType.Variant.Transitional);
                break;
            }
            case 0: {
                dt.setType(DocType.Type.quirks);
            }
        }
    }

    @Deprecated
    public float getHtmlVersion() {
        switch (this.docType.getType()) {
            case HTML: {
                return this.docType.getVersion();
            }
            case XHTML: {
                if (this.docType.getVersion() < 2.0f) {
                    return this.docType.getVersion() + 3.0f;
                }
                return this.docType.getVersion();
            }
        }
        return 3.2f;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Element getParagraphElement(int pos, Element root, boolean deepSearch) {
        int index;
        Element e = root;
        if (e.getElementCount() == 0) {
            return e;
        }
        Element last = null;
        for (e = root; e != null && !e.isLeaf(); e = e.getElement(index)) {
            DisplayValue disp;
            index = e.getElementIndex(pos);
            last = e;
            if (deepSearch || e == null || (disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY)) == null || !disp.isBlockElement()) continue;
            return e;
        }
        if (e == null) {
            if (last != null) {
                e = last;
            } else {
                return root;
            }
        }
        DisplayValue disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        while (disp != null && !disp.isBlockElement() && e.getParentElement() != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED) {
            e = e.getParentElement();
            disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        }
        return e;
    }

    public Element getNextParagraphElement(int pos, Element root) {
        int index;
        Element e = root;
        if (e.getElementCount() == 0) {
            return e;
        }
        DisplayValue disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        for (e = root; e != null && disp.getDisplay() == 2 && e.getParentElement() != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED; e = e.getElement(index)) {
            index = e.getElementIndex(pos);
            disp = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
        }
        return e;
    }

    @Override
    public Element getParagraphElement(int pos) {
        if (this.styleResolver == null) {
            return null;
        }
        try {
            this.readLock();
            Element element = this.getParagraphElement(pos, this.getDefaultRootElement(), true);
            return element;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getBlockStart(int pos) {
        return this.getLowerContentBoundary(pos, this.getParagraphElement(pos, this.getDefaultRootElement(), true));
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.setCharacterAttributes(offset, length, s, replace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace, boolean forceStacking) {
        EventList list = new EventList();
        Element paragraph = this.getParagraphElement(offset);
        int position = offset;
        int endOffset = offset + length;
        Element pEnd = this.getParagraphElement(endOffset);
        if (endOffset == pEnd.getEndOffset() - 1) {
            ++length;
            ++endOffset;
        }
        int upperBound = 0;
        try {
            this.writeLock();
            while (position < endOffset) {
                Element currentP = this.getParagraphElement(position);
                upperBound = this.getUpperContentBoundary(position, currentP);
                if (upperBound <= position) {
                    ++position;
                    continue;
                }
                if (currentP.isLeaf()) {
                    position = upperBound;
                    continue;
                }
                this.setCharacterAttributesSegment(position, (upperBound < endOffset ? upperBound : endOffset) - position, currentP, s, replace, forceStacking, list);
                position = upperBound;
            }
            this.splice(paragraph, offset, list, false);
            this.splice(this.getParagraphElement(endOffset), endOffset, list, false);
        }
        finally {
            this.writeUnlock();
        }
        this.fireUpdateEvent(offset, length, DocumentEvent.EventType.CHANGE, list);
    }

    public int findNextBlank(int startOffset, boolean directionForward) {
        int lowerbound = Math.max(0, startOffset - (directionForward ? 0 : 3000));
        int upperbound = Math.min(this.getLength(), startOffset + (directionForward ? 3000 : 0));
        Segment s = new Segment();
        try {
            this.getContent().getChars(lowerbound, upperbound - lowerbound, s);
        }
        catch (BadLocationException e) {
            return startOffset;
        }
        int offset = lowerbound - s.getBeginIndex();
        if (directionForward) {
            char c = s.first();
            while (s.getIndex() < s.getEndIndex()) {
                if (c == ' ' || c == '\u00a0' || c == '\n') {
                    return s.getIndex() + offset;
                }
                c = s.next();
            }
            return s.getEndIndex() + offset;
        }
        char c = s.last();
        while (s.getIndex() > s.getBeginIndex()) {
            if (c == ' ' || c == '\u00a0' || c == '\n') {
                return s.getIndex() + offset + 1;
            }
            c = s.previous();
        }
        return s.getBeginIndex() + offset;
    }

    private void setCharacterAttributesSegment(int offset, int length, Element p, AttributeSet s, boolean replace, boolean forceStacking, EventList list) {
        int startPos = offset;
        Element currentInline = null;
        int offsetEnd = offset + length;
        boolean isLink = s.containsAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.A);
        while (startPos < offsetEnd) {
            Element newParent;
            SimpleAttributeSet attr;
            Element parent;
            currentInline = ElementUtils.getLeafAt(p, startPos);
            if (currentInline == null) {
                ++startPos;
                continue;
            }
            int endOffset = currentInline.getEndOffset();
            if (StyleResolver.matchesAttributes(currentInline, s)) {
                startPos = endOffset == startPos ? endOffset + 1 : endOffset;
                continue;
            }
            if (currentInline.getParentElement() != p && !this.configuration.isInlineBoxCompatible() && !forceStacking) {
                block22: {
                    parent = currentInline.getParentElement();
                    try {
                        if (startPos > parent.getStartOffset()) {
                            this.splitElement(parent, startPos, null, list, false, true);
                            Element leafAt = ElementUtils.getLeafAt(p, startPos);
                            parent = leafAt.getParentElement();
                        }
                        if (parent.getEndOffset() > offsetEnd) {
                            this.splitElement(parent, offsetEnd, null, list, false, true);
                        }
                    }
                    catch (BadLocationException e) {
                        if (!Logger.doesLog(4)) break block22;
                        Logger.debug(e.getMessage());
                    }
                }
                currentInline = ElementUtils.getLeafAt(p, startPos);
            } else {
                if (startPos > currentInline.getStartOffset()) {
                    this.splitContentElement(currentInline, startPos, list);
                    currentInline = ElementUtils.getLeafAt(p, startPos);
                }
                if (endOffset > offsetEnd) {
                    this.splitContentElement(currentInline, offsetEnd, list);
                    currentInline = ElementUtils.getLeafAt(p, startPos);
                    endOffset = currentInline.getEndOffset();
                }
            }
            parent = currentInline.getParentElement();
            if (parent != p) {
                if (parent.getStartOffset() >= offset && parent.getEndOffset() <= offsetEnd) {
                    attr = new SimpleAttributeSet(parent.getAttributes());
                    ElementUtils.clearTemp(attr);
                    if (replace) {
                        attr.removeAttributes(attr);
                    }
                    attr.addAttributes(s);
                    newParent = this.createCopy(parent, this.createBranchElement(parent.getParentElement(), attr), 0, this.getModelLength());
                    this.fillAttributes(newParent);
                    if (StyleResolver.hasRelevantInlineStyles(newParent)) {
                        this.replaceElements(new Element[]{parent}, new Element[]{newParent}, list);
                    } else {
                        Element[] newChildren = new Element[parent.getElementCount()];
                        for (int i = 0; i < parent.getElementCount(); ++i) {
                            Element child = parent.getElement(i);
                            newChildren[i] = child.isLeaf() ? this.createLeafElement(parent.getParentElement(), child.getAttributes().copyAttributes(), child.getStartOffset(), child.getEndOffset()) : this.createCopy(child, this.createBranchElement(parent.getParentElement(), child.getAttributes().copyAttributes()), 0, this.getModelLength());
                        }
                        this.replaceElements(new Element[]{parent}, newChildren, list);
                    }
                    this.splice(p, startPos, list, false);
                    int checkPos = this.scanForAttributes(parent, s, true);
                    startPos = checkPos >= 0 ? Math.max(checkPos, startPos + 1) : newParent.getEndOffset();
                    continue;
                }
                attr = new SimpleAttributeSet();
                attr.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                if (replace) {
                    attr.removeAttributes(attr);
                }
                attr.addAttributes(s);
                newParent = this.createBranchElement(parent, attr);
                Element[] contentElem = new Element[]{currentInline};
                this.createCopy(parent, newParent, currentInline.getStartOffset(), endOffset);
                this.fillAttributes(newParent);
                if (StyleResolver.hasRelevantInlineStyles(newParent)) {
                    this.replaceElements(contentElem, new Element[]{newParent}, list);
                }
                this.splice(p, startPos, list, false);
                startPos = ((BoxElement)newParent).getEndOffset();
                continue;
            }
            attr = new SimpleAttributeSet();
            if (replace) {
                attr.removeAttributes(attr);
            }
            attr.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
            attr.addAttributes(s);
            if (isLink && ElementUtils.isEndMarker(currentInline)) {
                attr.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                attr.removeAttribute((Object)HTML.Attribute.HREF);
                attr.removeAttribute((Object)HTML.Attribute.NAME);
                attr.removeAttribute((Object)HTML.Attribute.TITLE);
                attr.removeAttribute((Object)HTML.Attribute.ALT);
                attr.removeAttribute((Object)HTML.Attribute.CLASS);
            }
            newParent = this.createBranchElement(p, attr);
            ContentElement newContent = this.createLeafElement(newParent, currentInline.getAttributes().copyAttributes(), currentInline.getStartOffset(), endOffset);
            Element[] contentElem = new Element[]{currentInline};
            ((AbstractDocument.BranchElement)newParent).replace(0, 0, new Element[]{newContent});
            ElementUtils.clearTemp((MutableAttributeSet)((Object)newParent));
            this.fillAttributes(newParent);
            if (StyleResolver.hasRelevantInlineStyles(newParent)) {
                this.replaceElements(contentElem, new Element[]{newParent}, list);
            }
            this.splice(p, startPos, list, false);
            startPos = ((BoxElement)newParent).getEndOffset();
        }
    }

    private int scanForAttributes(Element parent, AttributeSet set, boolean isRoot) {
        for (int i = 0; i < parent.getElementCount(); ++i) {
            int limit;
            Element child = parent.getElement(i);
            if (!(child instanceof AbstractDocument.LeafElement)) {
                Enumeration<?> attNames = set.getAttributeNames();
                while (attNames.hasMoreElements()) {
                    AttributeFinder<AttributeValue> finder;
                    Object name = attNames.nextElement();
                    Object value = set.getAttribute(name);
                    AttributeValue current = null;
                    if (name instanceof HTML.Attribute) {
                        finder = GenericFinder.getFinder((HTML.Attribute)((Object)name));
                        if (!finder.isInherited() && !isRoot) continue;
                        current = StyleResolver.getAttributeValue(child, finder);
                    } else if (name instanceof CSS.Attribute) {
                        finder = GenericFinder.getFinder((CSS.Attribute)((Object)name));
                        if (!finder.isInherited() && !isRoot) continue;
                        current = StyleResolver.getAttributeValue(child, finder);
                    } else {
                        if (isRoot) continue;
                        value = set.getAttribute(name);
                    }
                    if (!(value != null ? !value.equals(current) : current != null)) continue;
                    return child.getStartOffset();
                }
            }
            if ((limit = this.scanForAttributes(child, set, false)) < 0) continue;
            return limit;
        }
        return -1;
    }

    private void replaceElements(Element[] old, Element[] newElems, EventList list) {
        if (old == null || old.length == 0) {
            return;
        }
        AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)old[0].getParentElement();
        int index = ElementUtils.getChildIndex(parent, old[0]);
        parent.replace(index, old.length, newElems);
        list.getEventFor(parent, index, old, newElems);
    }

    void splitContentElement(Element content, int pos, EventList list) {
        if (pos == content.getStartOffset() || pos == content.getEndOffset() || !(content instanceof AbstractDocument.LeafElement)) {
            return;
        }
        AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)content.getParentElement();
        AttributeSet attr = content.getAttributes();
        ContentElement left = this.createLeafElement((Element)parent, attr.copyAttributes(), content.getStartOffset(), pos);
        ContentElement right = this.createLeafElement((Element)parent, attr.copyAttributes(), pos, content.getEndOffset());
        Element[] removes = new Element[]{content};
        Element[] adds = new Element[]{left, right};
        int index = ElementUtils.getChildIndex(parent, content);
        parent.replace(index, 1, adds);
        if (list != null) {
            list.getEventFor(parent, index, removes, adds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        if (!this.allowTableEdit && ElementUtils.crossesTable(offset, offset + length, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        int position = offset;
        int endOffset = Math.min(offset + (length > 0 ? length : 1), this.getModelLength());
        AttributeSet sCopy = s.copyAttributes();
        EventList list = new EventList();
        try {
            this.writeLock();
            while (position < endOffset) {
                Element currentP = this.getParagraphElement(position);
                boolean isTablePart = ElementUtils.isTablePart(currentP);
                if ((currentP.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY || isTablePart) && ElementUtils.isContent(currentP)) {
                    int start = this.getLowerContentBoundary(position, currentP);
                    int end = this.getUpperContentBoundary(position, currentP);
                    if (start != currentP.getStartOffset() || end != currentP.getEndOffset() || isTablePart) {
                        try {
                            currentP = this.wrapImpliedElement(position, list);
                        }
                        catch (BadLocationException e) {
                            Logger.error("Exception: " + e.getMessage());
                        }
                    }
                }
                if (!currentP.isLeaf()) {
                    this.setAttributeToElement(currentP, sCopy, replace, list);
                } else {
                    ++position;
                }
                position = this.getUpperContentBoundary(position, currentP);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.fireUpdateEvent(offset, length, DocumentEvent.EventType.CHANGE, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementAttributes(Element elem, AttributeSet attributes, boolean replace) {
        if (elem.getDocument() != this || attributes == null) {
            return;
        }
        MutableAttributeSet elemAtts = (MutableAttributeSet)elem.getAttributes();
        SimpleAttributeSet newAtts = new SimpleAttributeSet(attributes);
        if (!replace) {
            newAtts.addAttributes(elemAtts);
        }
        ElementUtils.clearTemp(newAtts);
        HtmlAttributeUndoableEdit edit = new HtmlAttributeUndoableEdit(elem, newAtts, replace);
        try {
            this.writeLock();
            if (replace) {
                elemAtts.removeAttributes(elemAtts);
            }
            elemAtts.addAttributes(attributes);
            this.styleResolver.fillAttributesNonLocked(elem, null);
        }
        finally {
            this.writeUnlock();
        }
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        EventList list = new EventList();
        list.addEvent(edit);
        this.fireUpdateEvent(start, end - start, DocumentEvent.EventType.CHANGE, list);
    }

    private void fireUpdateEvent(int offset, int len, DocumentEvent.EventType type, EventList events) {
        if (events.size() == 0) {
            return;
        }
        ExtendedDocuementEvent changes = new ExtendedDocuementEvent(offset, len, type, this);
        events.fillEvent(changes);
        changes.end();
        if (type == DocumentEvent.EventType.INSERT) {
            this.fireInsertUpdate(changes);
        } else if (type == DocumentEvent.EventType.REMOVE) {
            this.fireRemoveUpdate(changes);
        } else {
            this.fireChangedUpdate(changes);
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
    }

    private void setAttributeToElement(Element elem, AttributeSet set, boolean replace, EventList list) {
        MutableAttributeSet attr = (MutableAttributeSet)elem.getAttributes();
        list.addEvent(new HtmlAttributeUndoableEdit(elem, set, replace));
        if (replace) {
            attr.removeAttributes(attr);
        }
        attr.addAttributes(set);
        this.fillAttributes(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIndent(int step, int offset, int length, boolean increase) {
        int position = offset;
        int endOffset = Math.min(offset + (length > 0 ? length : 1), this.getModelLength());
        Element newListContainer = null;
        Element lastBaseContainer = null;
        boolean fireUpdate = increase;
        if (!this.allowTableEdit && ElementUtils.crossesTable(offset, endOffset, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        EventList list = new EventList();
        try {
            this.writeLock();
            while (position < endOffset) {
                AbstractDocument.BranchElement parent;
                int index;
                Element listItem;
                Element currentP = this.getParagraphElement(position);
                if (currentP.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                    try {
                        currentP = this.wrapImpliedElement(position, list);
                    }
                    catch (BadLocationException e) {
                        Logger.error("Exception: " + e.getMessage());
                    }
                }
                if ((listItem = ElementUtils.findListItemParent(currentP)) != null) {
                    if (increase) {
                        Element currentListContainer = ElementUtils.findListContainer(currentP);
                        if (newListContainer == null || currentListContainer != lastBaseContainer) {
                            Element parentContainer = ElementUtils.findNextHigherBlock(listItem);
                            Object name = parentContainer.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            if (name != HTML.Tag.UL && name != HTML.Tag.OL) {
                                name = HTML.Tag.UL;
                            }
                            AbstractDocument.BranchElement listItemParent = (AbstractDocument.BranchElement)listItem.getParentElement();
                            newListContainer = this.createBranchElement((Element)listItemParent, name);
                            this.checkDefaultStyle(newListContainer);
                            Element[] adds = new Element[]{newListContainer};
                            Element[] removes = new Element[]{listItem};
                            this.createCopy(listItemParent, newListContainer, listItem.getStartOffset(), listItem.getEndOffset(), 0);
                            this.replaceElements(removes, adds, list);
                            this.fillAttributes(newListContainer);
                            currentP = newListContainer.getElement(0);
                        } else {
                            AbstractDocument.BranchElement listItemParent = (AbstractDocument.BranchElement)listItem.getParentElement();
                            int listItems = newListContainer.getElementCount();
                            this.createCopy(listItemParent, newListContainer, listItem.getStartOffset(), listItem.getEndOffset(), listItems);
                            Element[] empty = new Element[]{};
                            this.replaceElements(new Element[]{listItem}, empty, list);
                            Element newListItem = newListContainer.getElement(listItems);
                            this.fillAttributes(newListContainer);
                            currentP = newListItem;
                        }
                        lastBaseContainer = currentListContainer;
                    } else {
                        Element parentContainer = ElementUtils.findNextHigherBlock(listItem);
                        Element superContainer = ElementUtils.findNextHigherBlock(parentContainer);
                        Object parentName = parentContainer.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        Object superName = superContainer.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        if (!(parentName != HTML.Tag.UL && parentName != HTML.Tag.OL || superName != HTML.Tag.UL && superName != HTML.Tag.OL)) {
                            int index2 = ElementUtils.getChildIndex(parentContainer, listItem);
                            int superIndex = ElementUtils.getChildIndex(superContainer, parentContainer);
                            if (index2 != -1 && index2 > 0 && index2 < parentContainer.getElementCount() - 1) {
                                this.splitElement(parentContainer, listItem.getStartOffset(), null, list, false, true);
                                listItem = ElementUtils.findListItemParent(ElementUtils.getLeafAt(superContainer, listItem.getStartOffset()));
                                parentContainer = ElementUtils.findNextHigherBlock(listItem);
                                index2 = ElementUtils.getChildIndex(parentContainer, listItem);
                                superIndex = ElementUtils.getChildIndex(superContainer, parentContainer);
                            }
                            boolean start = index2 == 0;
                            this.createCopy(parentContainer, superContainer, listItem.getStartOffset(), listItem.getEndOffset(), superIndex + (start ? 0 : 1));
                            Element[] adds = new Element[]{superContainer.getElement(superIndex + (start ? 0 : 1))};
                            Element[] removes = new Element[]{};
                            if (parentContainer.getElementCount() <= 1) {
                                ((AbstractDocument.BranchElement)superContainer).replace(superIndex + (start ? 1 : -1), 1, removes);
                                removes = new Element[]{parentContainer};
                            } else {
                                ((AbstractDocument.BranchElement)parentContainer).replace(index2, 1, removes);
                                list.getEventFor(parentContainer, index2, new Element[]{listItem}, removes);
                            }
                            fireUpdate = true;
                            list.getEventFor(superContainer, superIndex + (start ? 0 : 1), removes, adds);
                            this.fillAttributes(adds[0]);
                            currentP = adds[0];
                        }
                    }
                    position = currentP.getEndOffset();
                    continue;
                }
                Element blockQuote = null;
                newListContainer = null;
                if (!increase) {
                    Element top;
                    for (top = currentP; top != null && top.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BLOCKQUOTE; top = top.getParentElement()) {
                    }
                    if (top != null) {
                        blockQuote = top;
                    }
                }
                if (blockQuote != null && (index = ElementUtils.getChildIndex(parent = (AbstractDocument.BranchElement)blockQuote.getParentElement(), blockQuote)) >= 0) {
                    if (parent.getElementCount() == 1) {
                        int size = blockQuote.getElementCount();
                        this.createCopy(blockQuote, parent, blockQuote.getStartOffset(), blockQuote.getEndOffset(), index + 1);
                        parent.replace(index, 1, new Element[0]);
                        Element[] newElements = ElementUtils.getChildren(parent, index, size);
                        list.getEventFor(parent, index, new Element[]{blockQuote}, newElements);
                    } else {
                        this.moveElementTo(blockQuote, (Object)this.configuration.getDefaultBlock(), parent, index, true, list, true);
                    }
                    position = this.getUpperContentBoundary(blockQuote.getEndOffset(), parent);
                    currentP = parent;
                    fireUpdate = true;
                    continue;
                }
                LengthUnit marginLeft = StyleResolver.getAttributeValue(currentP, AttributeFinder.MARGIN_LEFT);
                int mLeft = marginLeft != null && marginLeft.getType() != -1 ? (int)marginLeft.getValue() : 0;
                SimpleAttributeSet margin = new SimpleAttributeSet();
                if (mLeft > 0 || increase) {
                    mLeft = (mLeft += increase ? step : -step) > 0 ? mLeft : 0;
                    CSS.setMarginLeft(margin, mLeft);
                    MutableAttributeSet attr = (MutableAttributeSet)currentP.getAttributes();
                    list.addEvent(new HtmlAttributeUndoableEdit(currentP, margin, false));
                    attr.addAttributes(margin);
                    ElementUtils.clearTemp(attr);
                    this.fillAttributes(currentP);
                    fireUpdate = true;
                }
                position = this.getUpperContentBoundary(position, currentP);
            }
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            this.writeUnlock();
        }
        if (list.size() > 0) {
            int start = Math.min(offset, list.getStartOffset());
            int endOrig = length + offset;
            int endList = list.getEndOffset();
            int len = Math.max(endOrig, endList) - start;
            ExtendedDocuementEvent changes = new ExtendedDocuementEvent(offset, length, start, len, DocumentEvent.EventType.CHANGE, this);
            list.fillEvent(changes);
            changes.end();
            if (fireUpdate) {
                this.fireChangedUpdate(changes);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
            } else {
                this.lockEvents();
                try {
                    this.writeLock();
                    changes.undo();
                }
                finally {
                    this.writeUnlock();
                }
                this.unlockEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeListStatus(int offset, int length, boolean numberedList) throws BadLocationException {
        HTML.Tag tag;
        if (offset + length > this.getLength()) {
            length = this.getLength() - offset;
        }
        int position = offset;
        int endOffset = offset + length;
        HTML.Tag tag2 = tag = numberedList ? HTML.Tag.OL : HTML.Tag.UL;
        if (!this.allowTableEdit && ElementUtils.crossesTable(offset, endOffset, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        boolean hasParagraphs = false;
        boolean hasULitems = false;
        boolean hasOLitems = false;
        EventList list = new EventList();
        EventList wrapList = new EventList();
        int insertIndex = -1;
        try {
            boolean removeList;
            int newPosition;
            this.writeLock();
            do {
                Element currentP = this.getParagraphElement(position);
                Element currentLI = ElementUtils.findListItemParent(currentP);
                if (currentP.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                    int start = this.getLowerContentBoundary(position, currentP);
                    int end = this.getUpperContentBoundary(position, currentP);
                    if (start != currentP.getStartOffset() || end != currentP.getEndOffset()) {
                        Element elem = currentP.getElement(currentP.getElementIndex(start));
                        if (end - start == 1 && elem.isLeaf() && ElementUtils.isEndMarker(elem)) {
                            if (end > this.getLength()) {
                                --end;
                            } else {
                                this.removeCompleteImpl(elem, wrapList);
                                wrapList.add(this.getContent().remove(start, 1));
                            }
                        } else {
                            try {
                                currentP = this.wrapImpliedElement(position, wrapList);
                            }
                            catch (BadLocationException e) {
                                Logger.error("Exception: " + e.getMessage());
                            }
                        }
                    }
                }
                if (currentLI != null) {
                    Element listBlock = ElementUtils.findNextHigherBlock(currentLI);
                    if (listBlock != null) {
                        Object blockName = listBlock.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        if (blockName == HTML.Tag.OL) {
                            hasOLitems = true;
                        } else if (blockName == HTML.Tag.UL) {
                            hasULitems = true;
                        }
                    }
                } else {
                    hasParagraphs = true;
                }
                newPosition = this.getUpperContentBoundary(position, currentP);
                if (newPosition != position) continue;
            } while ((position = ++newPosition) < endOffset);
            boolean bl = removeList = !hasParagraphs && (hasOLitems && !hasULitems && numberedList || !hasOLitems && hasULitems && !numberedList);
            if (!removeList) {
                this.createList(offset, length, tag, list, wrapList);
            } else {
                Element endParagraph;
                int finalOffset;
                Element endElem;
                int startOffset;
                Element startElem;
                position = offset;
                Object currentP = this.getParagraphElement(position);
                AbstractDocument.BranchElement listContainer = (AbstractDocument.BranchElement)ElementUtils.findSharedParent(offset, length, this.getDefaultRootElement());
                while (ElementUtils.findListContainer(listContainer) != null) {
                    listContainer = (AbstractDocument.BranchElement)ElementUtils.findListContainer(listContainer);
                }
                Object name = listContainer.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (name != null && (name == HTML.Tag.OL || name == HTML.Tag.UL)) {
                    int start = listContainer.getStartOffset();
                    int end = listContainer.getEndOffset();
                    if (offset == start && endOffset == end - 1 && end > start) {
                        ++endOffset;
                        ++length;
                    }
                    listContainer = (AbstractDocument.BranchElement)listContainer.getParentElement();
                }
                if ((startElem = listContainer.getElement(listContainer.getElementIndex(startOffset = currentP.getStartOffset()))).getStartOffset() != startOffset) {
                    int before = this.getLength();
                    this.splitElement(startElem, startOffset, null, list, false, true);
                    if (this.getLength() > before) {
                        ++position;
                        ++offset;
                        ++endOffset;
                        ++startOffset;
                    }
                }
                if ((endElem = listContainer.getElement(listContainer.getElementIndex(finalOffset = (endParagraph = this.getParagraphElement(offset + length - 1, listContainer, true)).getEndOffset()))) != null && endElem.getStartOffset() != finalOffset && endElem.getEndOffset() != finalOffset) {
                    this.splitElement(endElem, finalOffset, null, list, false, true);
                }
                insertIndex = listContainer.getElementIndex(startOffset);
                do {
                    DisplayValue disp;
                    if ((disp = StyleResolver.getAttributeValue((Element)(currentP = this.getParagraphElement(position)), AttributeFinder.DISPLAY)) != null && disp.getDisplay() == 4) {
                        this.moveElementTo((Element)currentP, (Object)this.configuration.getDefaultBlock(), listContainer, insertIndex++, true, list, true);
                        continue;
                    }
                    this.moveElementTo((Element)currentP, null, listContainer, insertIndex++, true, list, true);
                } while ((position = this.getUpperContentBoundary(position, (Element)currentP)) < endOffset);
            }
            if (wrapList.size() > 0) {
                for (Object entry : wrapList) {
                    if (entry instanceof ElementEditBuffer) {
                        ElementEditBuffer event = (ElementEditBuffer)entry;
                        Element[] removed = event.removed != null && event.removed.size() > 0 ? event.removed.toArray(new Element[event.removed.size()]) : new Element[]{};
                        Element[] added = event.added != null && event.added.size() > 0 ? event.added.toArray(new Element[event.added.size()]) : new Element[]{};
                        list.getEventFor(event.parent, event.index, removed, added);
                        continue;
                    }
                    list.addEvent(entry);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        int start = Math.min(offset, list.getStartOffset());
        int endOrig = length + offset;
        int endList = list.getEndOffset();
        int len = Math.max(endOrig, endList) - start;
        ExtendedDocuementEvent changes = new ExtendedDocuementEvent(offset, length, start, len, DocumentEvent.EventType.CHANGE, this);
        list.fillEvent(changes);
        changes.end();
        this.fireChangedUpdate(changes);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
    }

    private void createList(int offset, int length, HTML.Tag tag, EventList list, EventList wrapList) throws BadLocationException {
        int end;
        int insertIndex;
        AbstractDocument.BranchElement listContainer;
        AbstractDocument.BranchElement newListContainer = null;
        int position = offset;
        int endOffset = offset + length;
        Element currentP = this.getParagraphElement(position);
        Element container = ElementUtils.findListContainer(currentP);
        if (container != null && (container.getStartOffset() < offset || container.getEndOffset() > offset + length)) {
            Object name = container.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (name == tag) {
                listContainer = (AbstractDocument.BranchElement)container;
                insertIndex = container.getElementIndex(offset);
            } else {
                Element parent = ElementUtils.findListContainer(container);
                while (parent != null) {
                    container = parent;
                    parent = ElementUtils.findListContainer(container);
                }
                parent = container.getParentElement();
                if (currentP.getStartOffset() > container.getStartOffset()) {
                    this.splitElement(container, currentP.getStartOffset(), null, list, false, true);
                }
                listContainer = this.createBranchElement(parent, (Object)tag);
                this.checkDefaultStyle(listContainer);
                this.fillAttributes(listContainer);
                newListContainer = listContainer;
                insertIndex = parent.getElementIndex(offset);
            }
        } else {
            Element endP;
            int endOffs;
            int startOffs;
            Element parent;
            if (currentP.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY || ElementUtils.isTablePart(currentP)) {
                try {
                    currentP = this.wrapImpliedElement(position, wrapList);
                }
                catch (BadLocationException e) {
                    Logger.error("Exception: " + e.getMessage());
                }
            }
            if (ElementUtils.isRelated(parent = ElementUtils.findSharedParent(startOffs = currentP.getStartOffset(), (endOffs = (endP = this.getParagraphElement(position + length - (length > 0 ? 1 : 0))).getEndOffset() - 1) - startOffs, this.getRootElements()[0]), currentP) || ElementUtils.isRelated(parent, endP)) {
                parent = currentP.getParentElement();
            }
            Object parentName = parent.getAttributes().getAttribute(StyleConstants.NameAttribute);
            while (parentName != HTML.Tag.BODY && parentName != HTML.Tag.HTML && parent.getStartOffset() >= startOffs && parent.getEndOffset() <= endOffs + 1) {
                parent = parent.getParentElement();
                parentName = parent.getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            listContainer = this.createBranchElement(parent, (Object)tag);
            this.checkDefaultStyle(listContainer);
            this.fillAttributes(listContainer);
            newListContainer = listContainer;
            insertIndex = parent.getElementIndex(offset);
        }
        BoxElement newRoot = this.createBranchElement(this.getDefaultRootElement(), (Object)HTML.Tag.BODY);
        this.fillAttributes(newRoot);
        Element startElem = this.getParagraphElement(offset);
        Element prevEndElem = endOffset > 0 ? this.getParagraphElement(endOffset - 1) : null;
        Element endElem = this.getParagraphElement(endOffset);
        if (prevEndElem != null && InetHtmlParser.isMonolithic(prevEndElem) && endOffset != endElem.getStartOffset() || endElem.getStartOffset() == endOffset && length > 0) {
            endElem = prevEndElem;
        }
        AbstractDocument.BranchElement subContainer = listContainer;
        int currentListLevel = 1;
        int start = startElem.getStartOffset();
        endOffset = end = endElem != null ? endElem.getEndOffset() : start;
        if (ElementUtils.isRelated(startElem, listContainer) && (ElementUtils.findListItemParent(startElem) != null || startElem.getEndOffset() == listContainer.getEndOffset())) {
            start = startElem.getEndOffset();
        }
        position = start;
        Element body = ElementUtils.getBodyElement(this);
        this.createCopy(body, newRoot, start, end);
        this.removeRange(body, start, end, list);
        if (position >= endOffset) {
            endOffset = position + 1;
        }
        do {
            currentP = this.getParagraphElement(position, newRoot, true);
            int sourceListLevel = 0;
            Element currentLI = ElementUtils.findListItemParent(currentP);
            if (currentLI != null) {
                Element block = ElementUtils.findNextHigherBlock(currentLI);
                while (block != null && block != newRoot) {
                    Object blockName = block.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (blockName == HTML.Tag.OL || blockName == HTML.Tag.UL) {
                        ++sourceListLevel;
                    }
                    block = ElementUtils.findNextHigherBlock(block);
                }
            }
            if (sourceListLevel < 1) {
                sourceListLevel = 1;
            }
            while (sourceListLevel > currentListLevel) {
                BoxElement newSubContainer = this.createBranchElement((Element)subContainer, (Object)tag);
                this.checkDefaultStyle(newSubContainer);
                int index = subContainer.getElementCount();
                Element[] adds = new Element[]{newSubContainer};
                subContainer.replace(subContainer.getElementCount(), 0, adds);
                list.getEventFor(subContainer, index, new Element[0], adds);
                subContainer = newSubContainer;
                this.fillAttributes(newSubContainer);
                ++currentListLevel;
            }
            while (sourceListLevel < currentListLevel && currentListLevel > 1) {
                subContainer = (AbstractDocument.BranchElement)subContainer.getParentElement();
                --currentListLevel;
            }
            int index = subContainer.getElementCount();
            if (index > 0) {
                try {
                    int refPos = subContainer.getElement(index - 1).getStartOffset();
                    while (position <= refPos && index > 0) {
                        refPos = --index > 0 ? subContainer.getElement(index - 1).getStartOffset() : 0;
                    }
                }
                catch (NullPointerException refPos) {
                    // empty catch block
                }
            }
            if (currentLI != null) {
                this.moveElementTo(currentLI, null, subContainer, index, false, list, true);
                position = currentLI.getEndOffset();
                continue;
            }
            if (currentP.isLeaf()) {
                BoxElement wrap = this.createBranchElement((Element)subContainer, (Object)HTML.Tag.LI);
                this.checkDefaultStyle(wrap);
                this.moveElementTo(currentP, null, wrap, 0, false, list, false);
                listContainer.replace(index, 0, new Element[]{wrap});
                list.getEventFor(subContainer, index, new Element[0], new Element[]{wrap});
                this.fillAttributes(wrap);
            } else {
                int limitRight = this.getUpperContentBoundary(position, currentP);
                int limitLeft = this.getLowerContentBoundary(position, currentP);
                if (currentP.getStartOffset() < limitLeft || currentP.getEndOffset() > limitRight) {
                    if (limitRight - position == 1 && ElementUtils.isEndMarker(ElementUtils.getLeafAt(currentP, position))) {
                        this.removeCompleteImpl(ElementUtils.getLeafAt(currentP, position), list);
                        list.add(this.getContent().remove(position, 1));
                        --endOffset;
                    } else {
                        BoxElement wrap = this.createBranchElement((Element)subContainer, (Object)HTML.Tag.LI);
                        this.checkDefaultStyle(wrap);
                        this.createCopy(currentP, wrap, limitLeft, limitRight, 0);
                        listContainer.replace(index, 0, new Element[]{wrap});
                        list.getEventFor(subContainer, index, new Element[0], new Element[]{wrap});
                        this.fillAttributes(wrap);
                    }
                } else {
                    this.moveElementTo(currentP, (Object)HTML.Tag.LI, subContainer, index, false, list, true);
                }
            }
            position = this.getUpperContentBoundary(position, currentP);
        } while (position < endOffset);
        if (newListContainer != null) {
            Element[] newElem = new Element[]{newListContainer};
            Element parent = newListContainer.getParentElement();
            ((AbstractDocument.BranchElement)parent).replace(insertIndex, 0, newElem);
            list.getEventFor(parent, insertIndex, new Element[0], newElem);
        }
        list.clean();
    }

    private void moveElementTo(Element source, Object newName, Element newContainer, int index, boolean removeOld, EventList list, boolean fillAttributes) {
        AbstractDocument.AbstractElement wrap;
        if (source == null) {
            return;
        }
        if (newName == HTML.Tag.P) {
            Element start = this.getParagraphElement(source.getStartOffset(), source, true);
            Element end = this.getParagraphElement(source.getEndOffset() - 1, source, true);
            if (start.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.P || end.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.P) {
                this.createCopy(source, newContainer, source.getStartOffset(), source.getEndOffset(), index);
                Element[] newElements = ElementUtils.getChildren(newContainer, index, source.getElementCount());
                list.getEventFor(newContainer, index, new Element[0], newElements);
                this.removeCompleteImpl(source, list);
                return;
            }
        }
        if (source instanceof AbstractDocument.BranchElement) {
            Object tag = newName != null ? newName : source.getAttributes().getAttribute(StyleConstants.NameAttribute);
            SimpleAttributeSet set = new SimpleAttributeSet(source.getAttributes());
            set.addAttribute(StyleConstants.NameAttribute, tag);
            ElementUtils.clearTemp(set);
            wrap = this.createBranchElement(newContainer, set);
            this.createCopy(source, wrap, source.getStartOffset(), source.getEndOffset(), 0);
        } else {
            wrap = this.createLeafElement(newContainer, source.getAttributes(), source.getStartOffset(), source.getEndOffset());
        }
        Element oldContainer = source.getParentElement();
        int remIndex = ElementUtils.getChildIndex(oldContainer, source);
        Element[] newElements = new Element[]{wrap};
        if (oldContainer != newContainer || index != remIndex) {
            Element[] empty = new Element[]{};
            if (removeOld) {
                this.removeCompleteImpl(source, list);
            }
            ((AbstractDocument.BranchElement)newContainer).replace(index, 0, newElements);
            list.getEventFor(newContainer, index, empty, newElements);
        } else {
            this.replaceElements(new Element[]{source}, newElements, list);
        }
        if (fillAttributes) {
            this.fillAttributes(wrap);
        }
    }

    public EmbeddedImage[] getEmbeddedImages() {
        ArrayList<EmbeddedImage> imgList = new ArrayList<EmbeddedImage>();
        this.findImages(this.getDefaultRootElement(), imgList);
        return imgList.toArray(new EmbeddedImage[imgList.size()]);
    }

    private void findImages(Element elem, List<EmbeddedImage> imgList) {
        for (int i = 0; i < elem.getElementCount(); ++i) {
            DocumentImage img;
            Element child = elem.getElement(i);
            AttributeSet childAttributes = child.getAttributes();
            if (childAttributes.isDefined(StyleConstants.IconAttribute)) {
                img = (DocumentImage)childAttributes.getAttribute(StyleConstants.IconAttribute);
                img.setRefElement(child);
                imgList.add(img);
            } else if (childAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMG && childAttributes.isDefined((Object)HTML.Attribute.SRC)) {
                img = new DocumentImage(null, child);
                img.setURL(childAttributes.getAttribute((Object)HTML.Attribute.SRC).toString());
                imgList.add(img);
            }
            if (child.isLeaf()) continue;
            this.findImages(child, imgList);
        }
    }

    public void insertImage(Image image, int pos, File location) {
        this.insertImage(image, pos, null, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertImage(Image image, int pos, String alt, File location) {
        if (!this.configuration.isAllowInternalImages() && location == null) {
            return;
        }
        Element paragraph = this.getParagraphElement(pos);
        Element leaf = ElementUtils.getLeafAt(paragraph, pos);
        Element link = ElementUtils.findParentByTag(leaf, HTML.Tag.A);
        boolean addRigth = true;
        if (link != null && link.getStartOffset() == pos && ElementUtils.isRelated(link, paragraph) && link.getStartOffset() != paragraph.getStartOffset()) {
            addRigth = false;
        }
        EventList list = new EventList();
        boolean locked = false;
        try {
            Element parent;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                locked = true;
            }
            if (ElementUtils.isContent(leaf) && pos > leaf.getStartOffset()) {
                this.splitContentElement(leaf, pos, list);
            }
            SimpleAttributeSet atts = new SimpleAttributeSet();
            atts.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.IMG);
            if (image != null) {
                atts.addAttribute((Object)HTML.Attribute.WIDTH, new LengthUnit("" + image.getWidth(null)));
                atts.addAttribute((Object)HTML.Attribute.HEIGHT, new LengthUnit("" + image.getHeight(null)));
            }
            if (alt != null) {
                atts.addAttribute((Object)HTML.Attribute.ALT, new StringValueExp(alt));
            }
            int insertOffset = pos;
            AbstractDocument.Content docContent = this.getContent();
            if (addRigth) {
                String firstChar = docContent.getString(insertOffset, 1);
                list.addEvent(docContent.insertString(insertOffset + 1, "\n" + firstChar));
                list.addEvent(docContent.remove(insertOffset, 1));
                Element right = ElementUtils.getLeafAt(paragraph, insertOffset);
                this.cropElement(right, insertOffset + 1, right.getEndOffset(), list);
                parent = right.getParentElement();
            } else {
                list.addEvent(docContent.insertString(insertOffset, "\n"));
                Element left = ElementUtils.getLeafAt(paragraph, insertOffset);
                this.cropElement(left, left.getStartOffset(), left.getEndOffset() - 1, list);
                parent = left.getParentElement();
            }
            ContentElement img = this.createLeafElement(parent, atts, pos, pos + 1);
            DocumentImage documentImage = image != null ? new DocumentImage(image, img) : new DocumentImage(null, img);
            if (location != null) {
                String path = location.getAbsolutePath();
                try {
                    path = location.toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                    Logger.error(e);
                }
                documentImage.setURL(path);
                ImageCache.getStaticInstance().removeKey(path, this.getBase());
            }
            ((MutableAttributeSet)img.getAttributes()).addAttribute(StyleConstants.IconAttribute, documentImage);
            this.styleResolver.fillAttributesNonLocked(img, null);
            int index = parent.getElementIndex(insertOffset);
            Element[] adds = new Element[]{img};
            ((AbstractDocument.BranchElement)parent).replace(index, 0, adds);
            list.getEventFor(parent, index, new Element[0], adds);
        }
        catch (BadLocationException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
        }
        finally {
            if (locked) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(pos, 1, DocumentEvent.EventType.INSERT, list);
    }

    private void lockEvents() {
        this.eventsLocked = true;
    }

    private void unlockEvents() {
        this.eventsLocked = false;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(e);
        }
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(e);
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(e);
        }
    }

    private void fireDocumentEvent(DocumentEvent e) {
        if (e == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DocumentListener.class) continue;
            try {
                if (e.getType() == DocumentEvent.EventType.INSERT) {
                    ((DocumentListener)listeners[i + 1]).insertUpdate(e);
                    continue;
                }
                if (e.getType() == DocumentEvent.EventType.REMOVE) {
                    ((DocumentListener)listeners[i + 1]).removeUpdate(e);
                    continue;
                }
                ((DocumentListener)listeners[i + 1]).changedUpdate(e);
                continue;
            }
            catch (Exception ex) {
                if (!Logger.doesLog(1)) continue;
                Logger.error(ex);
            }
        }
    }

    public void setAllowInternalImages(boolean allowInternalImages) {
        this.configuration.setAllowInternalImages(allowInternalImages);
    }

    public boolean isAllowInternalImages() {
        return this.configuration.isAllowInternalImages();
    }

    @Override
    public Dictionary<Object, Object> getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object key, Object value) {
                    if (key == PROPERTY_CONFIGURATION && value != null && value instanceof InetHtmlConfiguration) {
                        InetHtmlDocument.this.configuration = (InetHtmlConfiguration)value;
                    }
                    if (key == PROPERTY_DEFAULT_STYLE_CLASS) {
                        InetHtmlDocument.this.defaultStyleName = value != null ? value.toString().toLowerCase().intern() : null;
                    }
                    if (key == "stream" && value != null) {
                        if (value instanceof URL) {
                            URL newValue = URLUtils.safeEncode((URL)value);
                            try {
                                value = new URL((URL)value, newValue.toString());
                            }
                            catch (MalformedURLException e) {
                                if (Logger.doesLog(4)) {
                                    Logger.debug("persisiting the stream handler failed, falling back to default");
                                }
                                value = newValue;
                            }
                        }
                        if (value instanceof String) {
                            value = URLUtils.safeEncode((String)value);
                        }
                    }
                    return super.put(key, value);
                }
            };
        }
        return this.documentProperties;
    }

    @Override
    public void setDocumentProperties(Dictionary<Object, Object> x) {
        this.documentProperties = this.getDocumentProperties();
        Enumeration<Object> keys = x.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.setDocumentProperty(key, x.get(key));
        }
    }

    public void setDocumentProperty(Object key, Object value) {
        if (this.documentProperties != null) {
            this.documentProperties.put(key, value);
            if (key == PROPERTY_CONFIGURATION && value != null && value instanceof InetHtmlConfiguration) {
                this.configuration = (InetHtmlConfiguration)value;
            }
            if (key == PROPERTY_DEFAULT_STYLE_CLASS) {
                this.defaultStyleName = value != null ? value.toString().toLowerCase().intern() : null;
            }
        }
    }

    public InetHtmlConfiguration getConfiguration() {
        return this.configuration;
    }

    public static String getCachedString(String value) {
        return value.intern();
    }

    @Override
    public Enumeration<?> getStyleNames() {
        return this.styleResolver.getStyleNames();
    }

    public Styles getStyleSheet(String nm) {
        return this.styleResolver.getStyleSheet(nm);
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public HTMLDocument.Iterator getIterator(HTML.Tag t) {
        return new InetHtmlDocumentIterator(this, t);
    }

    public URL getURLwithReferrer(URL url) {
        if (url == null) {
            return null;
        }
        InetStreamHandler urlHandler = new InetStreamHandler(url);
        urlHandler.setReferrer(this.getBase());
        String path = url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : "") + (url.getRef() != null ? "#" + url.getRef() : "");
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), path, urlHandler);
        }
        catch (MalformedURLException e) {
            return url;
        }
        catch (SecurityException e) {
            if (Logger.doesLog(4)) {
                Logger.debug("Could not attach referrer due to security restriction. URL was '" + url + "'");
            }
            return url;
        }
    }

    @Override
    public boolean readStylesOfVirtualTags() {
        return false;
    }

    public static String getEncoding(ChangedCharSetException charSetEx) {
        String content = charSetEx.getCharSetSpec();
        if (content == null || content.indexOf(59) < 0 && content.indexOf(61) < 0) {
            return content;
        }
        String[] parts = content.split(";");
        String snippet = parts[0];
        for (String part : parts) {
            if (!part.toLowerCase().contains("charset")) continue;
            snippet = part;
            break;
        }
        if ((parts = snippet.split("=")).length < 2) {
            return parts[0].trim();
        }
        return parts[1].trim();
    }

    public TimeoutProvider getTimeoutProvider() {
        Object timeout = this.getProperty(PROPERTY_CONNECTION_TIMEOUT);
        if (timeout == null) {
            return null;
        }
        if (timeout instanceof TimeoutProvider) {
            return (TimeoutProvider)timeout;
        }
        if (timeout instanceof Number) {
            return new StaticTimeout(((Number)timeout).intValue());
        }
        if (timeout instanceof String) {
            try {
                return new StaticTimeout(Integer.parseInt(timeout.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public int getConnectionTimeout(URL url) {
        if (url == null) {
            return -4242;
        }
        Object timeout = this.getProperty(PROPERTY_CONNECTION_TIMEOUT);
        if (timeout == null) {
            return -4242;
        }
        if (timeout instanceof TimeoutProvider) {
            return ((TimeoutProvider)timeout).getTimeout(url);
        }
        if (timeout instanceof Number) {
            return ((Number)timeout).intValue();
        }
        if (timeout instanceof String) {
            try {
                return Integer.parseInt(timeout.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -4242;
    }

    static class EventList
    extends ArrayList<Object> {
        private EventList child;
        private Map<Element, List<ElementEditBuffer>> buffers = new HashMap<Element, List<ElementEditBuffer>>();

        public EventList(EventList child) {
            this.child = child;
        }

        public EventList() {
            this.child = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ElementEditBuffer getEventFor(Element parent, int index, Element[] removes, Element[] adds) {
            ElementEditBuffer event = null;
            if (this.child != null) {
                event = this.child.getEventFor(parent, index, removes, adds);
                if (event != null && !this.contains(event)) {
                    this.add(event);
                }
            } else {
                ArrayList<Element> cleanUp = null;
                List<ElementEditBuffer> editBuffers = this.buffers.get(parent);
                if (editBuffers != null) {
                    if (editBuffers.size() > 1000) {
                        Collections.sort(editBuffers, (b1, b2) -> Integer.compare(b1.getIndex(), b2.getIndex()));
                        ElementEditBuffer mergeEvent = new ElementEditBuffer(parent, editBuffers.get(0).getIndex(), new Element[0], new Element[0]);
                        for (ElementEditBuffer edit : editBuffers) {
                            mergeEvent.merge(edit);
                        }
                        editBuffers.clear();
                        editBuffers.add(mergeEvent);
                    }
                    for (int i = editBuffers.size() - 1; i >= 0; --i) {
                        ElementEditBuffer eeb = editBuffers.get(i);
                        if (!(eeb instanceof ElementEditBuffer) || eeb.getElement() != parent) continue;
                        event = eeb;
                        int level = Logger.getLogLevel();
                        Logger.setLogLevel(-1);
                        try {
                            boolean hasRemovedContent;
                            int startOffs = -1;
                            boolean bl = hasRemovedContent = removes != null && removes.length > 0 && removes[0].getElementCount() > 0;
                            if (hasRemovedContent) {
                                startOffs = removes[0].getStartOffset();
                            } else if (adds != null && adds.length > 0 && adds[0].getElementCount() > 0) {
                                startOffs = adds[0].getStartOffset();
                            }
                            if (startOffs >= 0) {
                                int endOffs;
                                int n = endOffs = hasRemovedContent ? removes[removes.length - 1].getEndOffset() : adds[adds.length - 1].getEndOffset();
                                if (endOffs >= 0) {
                                    int eventEndOffset = event.getEndOffset();
                                    int eventStartOffset = event.getStartOffset();
                                    if (startOffs > eventEndOffset || endOffs < eventStartOffset) {
                                        event = null;
                                        continue;
                                    }
                                }
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        finally {
                            Logger.setLogLevel(level);
                        }
                        if (index < event.getIndex()) {
                            event.setIndex(index);
                        }
                        if (removes != null) {
                            for (Element rem : removes) {
                                if (!event.addRemove(rem)) continue;
                                if (cleanUp == null) {
                                    cleanUp = new ArrayList<Element>();
                                }
                                cleanUp.add(rem);
                            }
                        }
                        if (adds == null) break;
                        for (Element add : adds) {
                            event.addAdd(add);
                        }
                        break;
                    }
                    if (cleanUp != null) {
                        this.cleanUp(cleanUp);
                    }
                }
                if (event == null) {
                    event = new ElementEditBuffer(parent, index, removes, adds);
                    this.add(event);
                }
            }
            if (event != null && (event.added != null && event.added.size() > 0 || event.removed != null && event.removed.size() > 0)) {
                return event;
            }
            return null;
        }

        private void cleanUp(List<Element> toRemove) {
            HashMap<Element, Object> eventHash = new HashMap<Element, Object>();
            for (Object event : this) {
                if (!(event instanceof ElementEditBuffer)) continue;
                eventHash.put(((ElementEditBuffer)event).getElement(), event);
            }
            for (Element removed : toRemove) {
                Object removedEdit = eventHash.remove(removed);
                if (removedEdit == null) continue;
                this.remove(removedEdit);
                this.cleanUpRecurseion(ElementUtils.getAllChildren(removed), eventHash);
            }
        }

        private void cleanUpRecurseion(Element[] toRemove, HashMap<Element, Object> eventHash) {
            for (Element removed : toRemove) {
                Object removedEdit = eventHash.remove(removed);
                if (removedEdit == null) continue;
                this.remove(removedEdit);
                this.cleanUpRecurseion(ElementUtils.getAllChildren(removed), eventHash);
            }
        }

        public void setChild(EventList child) {
            this.child = child;
        }

        @Override
        public boolean add(Object o) {
            if (o instanceof ElementEditBuffer) {
                ElementEditBuffer buffer = (ElementEditBuffer)o;
                List<ElementEditBuffer> current = this.buffers.get(buffer.getElement());
                if (current == null) {
                    current = new ArrayList<ElementEditBuffer>();
                    this.buffers.put(buffer.getElement(), current);
                }
                current.add(buffer);
            }
            return super.add(o);
        }

        public void addEvent(Object otherEvent) {
            this.add(otherEvent);
            if (this.child != null) {
                this.child.addEvent(otherEvent);
            }
        }

        public void fillEvent(AbstractDocument.DefaultDocumentEvent docEvent) {
            for (Object event : this) {
                if (event instanceof ElementEditBuffer) {
                    ElementEditBuffer edit = (ElementEditBuffer)event;
                    if (edit.added.size() <= 0 && edit.removed.size() <= 0) continue;
                    docEvent.addEdit(edit.getElementEdit());
                    continue;
                }
                docEvent.addEdit((UndoableEdit)event);
            }
        }

        public int getStartOffset() {
            int start = Integer.MAX_VALUE;
            for (Object change : this) {
                if (!(change instanceof ElementEditBuffer)) continue;
                Element[] adds = ((ElementEditBuffer)change).getChildrenAdded();
                Element[] removes = ((ElementEditBuffer)change).getChildrenRemoved();
                for (Element add : adds) {
                    try {
                        if (add.getStartOffset() >= start) continue;
                        start = add.getStartOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                for (Element rem : removes) {
                    try {
                        if (rem.getStartOffset() >= start) continue;
                        start = rem.getStartOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            return start;
        }

        public int getEndOffset() {
            int end = 0;
            for (Object change : this) {
                if (!(change instanceof ElementEditBuffer)) continue;
                Element[] adds = ((ElementEditBuffer)change).getChildrenAdded();
                Element[] removes = ((ElementEditBuffer)change).getChildrenRemoved();
                for (Element add : adds) {
                    try {
                        if (add.getEndOffset() <= end) continue;
                        end = add.getEndOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                for (Element rem : removes) {
                    try {
                        if (rem.getEndOffset() <= end) continue;
                        end = rem.getEndOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            return end;
        }

        public void clean() {
            int index = 0;
            while (index < this.size()) {
                Object edit = this.get(index);
                if (edit instanceof ElementEditBuffer && ((ElementEditBuffer)edit).parent.getElementCount() == 0) {
                    this.remove(index);
                    continue;
                }
                ++index;
            }
        }
    }

    protected static class ElementEditBuffer {
        private ArrayList<Element> removed = new ArrayList();
        private ArrayList<Element> added;
        private Element parent;
        private int index;
        private static final Sorter SORTER = new Sorter();

        public ElementEditBuffer(Element parent, int index, Element[] removes, Element[] adds) {
            if (removes != null) {
                for (Element elem : removes) {
                    this.removed.add(elem);
                }
            }
            this.added = new ArrayList();
            if (adds != null) {
                for (Element elem : adds) {
                    this.added.add(elem);
                }
            }
            this.index = index;
            this.parent = parent;
        }

        private void merge(ElementEditBuffer toMerge) {
            if (toMerge.getElement() != this.getElement()) {
                throw new IllegalArgumentException("Cannot merge events for different parents");
            }
            this.added.addAll(toMerge.added);
            this.removed.addAll(toMerge.removed);
        }

        public Element[] getChildrenAdded() {
            return this.added.toArray(new Element[this.added.size()]);
        }

        public Element[] getChildrenRemoved() {
            return this.removed.toArray(new Element[this.removed.size()]);
        }

        public Element getElement() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean addRemove(Element e) {
            if (!this.added.remove(e)) {
                if (!this.removed.contains(e)) {
                    this.removed.add(e);
                }
                return false;
            }
            return true;
        }

        public void addAdd(Element e) {
            if (!this.removed.remove(e) && !this.added.contains(e)) {
                this.added.add(e);
            }
        }

        public AbstractDocument.ElementEdit getElementEdit() {
            Collections.sort(this.added, SORTER);
            Collections.sort(this.removed, SORTER);
            return new AbstractDocument.ElementEdit(this.parent, this.index, this.getChildrenRemoved(), this.getChildrenAdded());
        }

        public String toString() {
            return "Add: " + this.added + "\n Remove: " + this.removed + " \n@" + this.parent + ":" + this.parent.hashCode();
        }

        public int getStartOffset() {
            int min = Integer.MAX_VALUE;
            if (this.added != null && this.added.size() > 0) {
                for (Element add : this.added) {
                    if (add.getStartOffset() >= min) continue;
                    min = add.getStartOffset();
                }
            }
            if (this.removed != null && this.removed.size() > 0) {
                for (Element rem : this.removed) {
                    if (rem.getStartOffset() >= min) continue;
                    min = rem.getStartOffset();
                }
            }
            return min;
        }

        public int getEndOffset() {
            int max = -1;
            if (this.added != null && this.added.size() > 0) {
                for (Element add : this.added) {
                    if (add.getEndOffset() <= max) continue;
                    max = add.getEndOffset();
                }
            }
            if (this.removed != null && this.removed.size() > 0) {
                for (Element rem : this.removed) {
                    if (rem.getEndOffset() <= max) continue;
                    max = rem.getEndOffset();
                }
            }
            return max;
        }

        private static class Sorter
        implements Comparator<Element> {
            private Sorter() {
            }

            @Override
            public int compare(Element o1, Element o2) {
                int diff = o1.getStartOffset() - o2.getStartOffset();
                if (diff != 0) {
                    return diff;
                }
                return o1.getEndOffset() - o2.getEndOffset();
            }
        }
    }

    class ContentElement
    extends AbstractDocument.LeafElement
    implements ElementClonable {
        public ContentElement(Element parent, AttributeSet a, int offs0, int offs1) {
            super(InetHtmlDocument.this, parent, a, offs0, offs1);
        }

        @Override
        public String getName() {
            Object obj = this.getAttribute(StyleConstants.NameAttribute);
            if (obj != null) {
                return obj.toString();
            }
            return super.getName();
        }

        @Override
        public Element clone(Element parent) {
            return InetHtmlDocument.this.createLeafElement(parent, this.getAttributes().copyAttributes(), this.getStartOffset(), this.getEndOffset());
        }

        @Override
        public String toString() {
            int startOffset = this.getStartOffset();
            int endOffset = this.getEndOffset();
            String type = "ContentElement";
            if (this.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT) {
                type = this.getName();
            } else if (this.getAttribute("CR") != null) {
                type = "CR Marker";
            }
            try {
                String text = InetHtmlDocument.this.getText(startOffset, endOffset - startOffset);
                return type + "(" + startOffset + ":" + endOffset + "):" + (text.length() > 100 ? text.substring(0, 100) + "..." : text) + "\n";
            }
            catch (BadLocationException e) {
                return type + "(" + startOffset + ":" + endOffset + ")\n";
            }
        }
    }

    public class ExtendedDocuementEvent
    extends AbstractDocument.DefaultDocumentEvent {
        private HashMap<Element, ArrayList<DocumentEvent.ElementChange>> editByParagraph;
        private ArrayList<UndoableEdit> changes;
        private DocumentEvent.EventType type;
        private int contentChangeLen;
        private int contentChangeStart;

        public ExtendedDocuementEvent(int offs, int len, DocumentEvent.EventType type, InetHtmlDocument document) {
            InetHtmlDocument inetHtmlDocument = document;
            Objects.requireNonNull(inetHtmlDocument);
            super(inetHtmlDocument, offs, len, type);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = type;
        }

        public ExtendedDocuementEvent(int offs, int len, int contentChangeLen, DocumentEvent.EventType type, InetHtmlDocument document) {
            InetHtmlDocument inetHtmlDocument = document;
            Objects.requireNonNull(inetHtmlDocument);
            super(inetHtmlDocument, offs, len, type);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = type;
            this.contentChangeLen = contentChangeLen;
        }

        public ExtendedDocuementEvent(int offs, int len, int contentChangeStart, int contentChangeLen, DocumentEvent.EventType type, InetHtmlDocument document) {
            InetHtmlDocument inetHtmlDocument = document;
            Objects.requireNonNull(inetHtmlDocument);
            super(inetHtmlDocument, offs, len, type);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = type;
            this.contentChangeStart = contentChangeStart;
            this.contentChangeLen = contentChangeLen;
        }

        public int getStructureChangeLen() {
            if (this.contentChangeLen >= 0) {
                return this.contentChangeLen;
            }
            return super.getLength();
        }

        public int getStructureChangeStart() {
            if (this.contentChangeStart >= 0) {
                return this.contentChangeStart;
            }
            return super.getOffset();
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (this.changes == null) {
                this.changes = new ArrayList();
            }
            this.changes.add(anEdit);
            if (anEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange ec;
                Element paragraph;
                ArrayList<DocumentEvent.ElementChange> edits;
                if (this.editByParagraph == null) {
                    this.editByParagraph = new HashMap();
                }
                if ((edits = this.editByParagraph.get(paragraph = ElementUtils.getParagraphFor((ec = (DocumentEvent.ElementChange)((Object)anEdit)).getElement()))) == null) {
                    edits = new ArrayList();
                    this.editByParagraph.put(paragraph, edits);
                }
                edits.add((DocumentEvent.ElementChange)((Object)anEdit));
            }
            return super.addEdit(anEdit);
        }

        public ArrayList<UndoableEdit> getAllChanges() {
            return this.changes;
        }

        public boolean hasEditsFor(Element paragraph) {
            return this.editByParagraph != null && this.editByParagraph.containsKey(paragraph);
        }

        public ArrayList<DocumentEvent.ElementChange> getEditsFor(Element paragraph) {
            return this.editByParagraph != null ? this.editByParagraph.get(paragraph) : null;
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.type;
        }

        @Override
        public void undo() throws CannotUndoException {
            InetHtmlDocument.this.lockEvents();
            try {
                super.undo();
                InetHtmlDocument.this.unlockEvents();
                InetHtmlDocument.this.revision -= 2;
                if (this.hasEditsFor(InetHtmlDocument.this.getDefaultRootElement())) {
                    InetHtmlDocument.this.siteCount--;
                }
                if (this.type == DocumentEvent.EventType.INSERT) {
                    this.type = DocumentEvent.EventType.REMOVE;
                    InetHtmlDocument.this.fireRemoveUpdate(this);
                } else if (this.type == DocumentEvent.EventType.REMOVE) {
                    this.type = DocumentEvent.EventType.INSERT;
                    InetHtmlDocument.this.fireInsertUpdate(this);
                } else {
                    this.type = DocumentEvent.EventType.CHANGE;
                    InetHtmlDocument.this.fireChangedUpdate(this);
                }
            }
            catch (Exception e) {
                if (Logger.doesLog(0)) {
                    Logger.critical("Unable to perform Undo");
                }
                if (Logger.doesLog(1)) {
                    Logger.error(e);
                }
            }
            finally {
                InetHtmlDocument.this.unlockEvents();
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            InetHtmlDocument.this.lockEvents();
            super.redo();
            InetHtmlDocument.this.unlockEvents();
            if (this.hasEditsFor(InetHtmlDocument.this.getDefaultRootElement())) {
                InetHtmlDocument.this.siteCount++;
            }
            if (this.type == DocumentEvent.EventType.INSERT) {
                this.type = DocumentEvent.EventType.REMOVE;
                InetHtmlDocument.this.fireRemoveUpdate(this);
            } else if (this.type == DocumentEvent.EventType.REMOVE) {
                this.type = DocumentEvent.EventType.INSERT;
                InetHtmlDocument.this.fireInsertUpdate(this);
            } else {
                this.type = DocumentEvent.EventType.CHANGE;
                InetHtmlDocument.this.fireChangedUpdate(this);
            }
        }
    }

    class BoxElement
    extends AbstractDocument.BranchElement
    implements ElementClonable {
        public BoxElement(Element parent, AttributeSet a) {
            super(InetHtmlDocument.this, parent, a);
        }

        @Override
        public String getName() {
            Object obj = this.getAttribute(StyleConstants.NameAttribute);
            if (obj != null) {
                return obj.toString();
            }
            return super.getName();
        }

        @Override
        public Element clone(Element parent) {
            BoxElement elem = InetHtmlDocument.this.createBranchElement(parent, this.getAttributes().copyAttributes());
            Element[] children = ElementUtils.getChildren(this, 0, this.getElementCount());
            for (int i = 0; i < children.length; ++i) {
                children[i] = ((ElementClonable)((Object)children[i])).clone(elem);
            }
            elem.replace(0, 0, children);
            return elem;
        }

        @Override
        public int getStartOffset() {
            int count = this.getElementCount();
            for (int i = 0; i < count; ++i) {
                try {
                    Element child = this.getElement(i);
                    if (child.getElementCount() <= 0 && !child.isLeaf()) continue;
                    return this.getElement(i).getStartOffset();
                }
                catch (Exception ex) {
                    Logger.error(ex);
                }
            }
            return super.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            int count = this.getElementCount();
            for (int i = count - 1; i >= 0; --i) {
                try {
                    return this.getElement(i).getEndOffset();
                }
                catch (NullPointerException ex) {
                    Logger.debug("Element " + this.getElement(i).getName() + " has no leafs");
                    continue;
                }
            }
            return super.getEndOffset();
        }

        @Override
        public String toString() {
            Object id;
            String idString = "";
            Object object = id = this.getAttributes().isDefined((Object)HTML.Attribute.ID) ? this.getAttribute((Object)HTML.Attribute.ID) : null;
            if (id != null) {
                idString = " '" + id.toString() + "'";
            }
            if (this.getElementCount() == 0) {
                return "BoxElement(" + this.getName() + idString + ", empty)\n";
            }
            try {
                int startOffset = this.getStartOffset();
                int endOffset = this.getEndOffset();
                try {
                    String text = InetHtmlDocument.this.getText(startOffset, endOffset - startOffset);
                    return "BoxElement(" + this.getName() + idString + " " + startOffset + ":" + endOffset + "):" + (text.length() > 100 ? text.substring(0, 100) + "..." : text) + "\n";
                }
                catch (BadLocationException e) {
                    return "BoxElement(" + this.getName() + idString + " " + startOffset + ":" + endOffset + ")\n";
                }
            }
            catch (NullPointerException e) {
                return "BoxElement(" + this.getName() + idString + ", " + this.getElementCount() + " children, unfinished )\n";
            }
        }
    }

    public class ImpliedElement
    extends AbstractDocument.BranchElement
    implements ElementClonable,
    AttributeSet {
        private ArrayList<Element> children;
        private MutableAttributeSet attributes;
        private Element parent;

        public ImpliedElement(Element parent) {
            super(InetHtmlDocument.this, parent, null);
            this.children = new ArrayList();
            this.attributes = new SimpleAttributeSet();
            LengthUnit length0 = new LengthUnit("0px");
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_BOTTOM, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_TOP, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_LEFT, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_RIGHT, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_BOTTOM, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_TOP, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_LEFT, length0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_RIGHT, length0);
            LengthUnit lengthAuto = new LengthUnit("auto");
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.WIDTH, lengthAuto);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.HEIGHT, lengthAuto);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MIN_WIDTH, lengthAuto);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MIN_HEIGHT, lengthAuto);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MAX_WIDTH, lengthAuto);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MAX_HEIGHT, lengthAuto);
            BorderStyleValue none = new BorderStyleValue("none", 0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_LEFT_STYLE, none);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_RIGHT_STYLE, none);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_BOTTOM_STYLE, none);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_TOP_STYLE, none);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.POSITION, new Position());
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.FLOAT, new FloatValue());
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.DISPLAY, new DisplayValue(3));
            this.attributes.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.IMPLIED);
            AttributeValue.addCssAtrributes(this.attributes, CSS.Attribute.BACKGROUND_IMAGE, "none", false);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BACKGROUND_IMAGE, this.attributes.getAttribute((Object)CSS.Attribute.BACKGROUND_IMAGE));
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.TRANSFORM, new TransformValue());
            this.attributes.addAttribute(FLAG_INIT, true);
            this.parent = parent;
        }

        @Override
        public AttributeSet getAttributes() {
            return this;
        }

        @Override
        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        @Override
        public Object getAttribute(Object attrName) {
            return this.attributes.getAttribute(attrName);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            return this.attributes.isEqual(attr);
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        @Override
        public Document getDocument() {
            return InetHtmlDocument.this;
        }

        @Override
        public Element getElement(int index) {
            if (index >= 0 && index < this.children.size()) {
                return this.children.get(index);
            }
            return null;
        }

        @Override
        public int getElementCount() {
            return this.children.size();
        }

        @Override
        public int getElementIndex(int offset) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i).getStartOffset() > offset || this.children.get(i).getEndOffset() <= offset) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getEndOffset() {
            if (this.children.size() > 0) {
                return this.children.get(this.children.size() - 1).getEndOffset();
            }
            return -1;
        }

        @Override
        public String getName() {
            Object name = this.attributes.getAttribute(StyleConstants.NameAttribute);
            if (name != null) {
                return name.toString();
            }
            return "IMPLIED";
        }

        @Override
        public Element getParentElement() {
            return this.parent;
        }

        @Override
        public int getStartOffset() {
            if (this.children.size() > 0) {
                return this.children.get(0).getStartOffset();
            }
            return -1;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element clone(Element parent) {
            try {
                InetHtmlDocument.this.writeLock();
                SimpleAttributeSet atts = new SimpleAttributeSet();
                atts.addAttribute(StyleConstants.NameAttribute, (Object)InetHtmlDocument.this.configuration.getDefaultBlock());
                BoxElement clone = InetHtmlDocument.this.createBranchElement(parent, atts);
                clone.replace(0, 0, this.children.toArray(new Element[this.children.size()]));
                InetHtmlDocument.this.fillAttributes(clone);
                BoxElement boxElement = clone;
                return boxElement;
            }
            finally {
                InetHtmlDocument.this.writeUnlock();
            }
        }

        @Override
        public void replace(int start, int len, Element[] newElements) {
            block7: {
                block6: {
                    int i;
                    if (start >= this.children.size()) break block6;
                    if (len > 0) {
                        if (start + len > this.children.size()) {
                            len = this.children.size() - start;
                        }
                        for (i = 0; i < len; ++i) {
                            this.children.remove(start);
                        }
                    }
                    if (newElements == null) break block7;
                    for (i = 0; i < len; ++i) {
                        this.children.add(start + i, newElements[i]);
                    }
                    break block7;
                }
                if (newElements != null) {
                    for (Element e : newElements) {
                        this.children.add(e);
                    }
                }
            }
        }
    }

    public class StyleSheetClearEdit
    extends AbstractUndoableEdit {
        private Styles oldStyleSheet;

        public StyleSheetClearEdit(Styles oldStyleSheet) {
            this.oldStyleSheet = oldStyleSheet;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Styles backup = InetHtmlDocument.this.styleResolver.getStyles();
            InetHtmlDocument.this.styleResolver.setStyles(this.oldStyleSheet);
            this.oldStyleSheet = backup;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Styles backup = InetHtmlDocument.this.styleResolver.getStyles();
            InetHtmlDocument.this.styleResolver.setStyles(this.oldStyleSheet);
            this.oldStyleSheet = backup;
        }
    }

    static interface ElementClonable {
        public Element clone(Element var1);
    }

    private class HtmlAttributeUndoableEdit
    extends AttributeUndoableEdit {
        private AttributeSet newAttributes;
        private AttributeSet copy;
        private boolean isReplacing;
        private Element element;

        public HtmlAttributeUndoableEdit(Element element, AttributeSet newAttributes, boolean isReplacing) {
            super(element);
            this.element = element;
            this.newAttributes = newAttributes;
            this.isReplacing = isReplacing;
            this.copy = element.getAttributes().copyAttributes();
        }

        @Override
        public void redo() throws CannotRedoException {
            MutableAttributeSet as = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                as.removeAttributes(as);
            }
            as.addAttributes(this.newAttributes);
            InetHtmlDocument.this.fillAttributes(this.element);
        }

        @Override
        public void undo() throws CannotUndoException {
            MutableAttributeSet as = (MutableAttributeSet)this.element.getAttributes();
            as.removeAttributes(as);
            as.addAttributes(this.copy);
            InetHtmlDocument.this.fillAttributes(this.element);
        }
    }

    public static interface TimeoutProvider {
        public int getTimeout(URL var1);
    }

    private static class StaticTimeout
    implements TimeoutProvider {
        private int timeout;

        public StaticTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public int getTimeout(URL connection) {
            return this.timeout;
        }
    }
}

