/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.html.InetHtmlEditorKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import javax.swing.text.StyledEditorKit;

public class InetTextPane
extends JTextPane
implements PropertyChangeListener {
    private static final long serialVersionUID = 2172337629876615093L;
    private static final Map<byte[], String> BOM = new HashMap<byte[], String>(){
        {
            this.put(new byte[]{-17, -69, -65}, "UTF-8");
            this.put(new byte[]{-2, -1}, "UTF-16BE");
            this.put(new byte[]{-1, -2}, "UTF-16LE");
            this.put(new byte[]{0, 0, -2, -1}, "UTF-32BE");
            this.put(new byte[]{-1, -2, 0, 0}, "UTF-32LE");
            this.put(new byte[]{43, 47, 118, 56}, "UTF-7");
            this.put(new byte[]{43, 47, 118, 57}, "UTF-7");
            this.put(new byte[]{43, 47, 118, 43}, "UTF-7");
            this.put(new byte[]{43, 47, 118, 47}, "UTF-7");
            this.put(new byte[]{-9, 100, 76}, "UTF-1");
            this.put(new byte[]{-35, 115, 102, 115}, "UTF-EBCDIC");
            this.put(new byte[]{14, -2, -1}, "SCSU");
            this.put(new byte[]{-5, -18, 40}, "BOCU-1");
            this.put(new byte[]{-124, 49, -107, 51}, "GB 18030");
        }
    };
    private Dimension last;
    public static final int SHORTCUT_KEY_MASK;

    public InetTextPane() {
        this.setFocusTraversalKeys(0, new HashSet());
        this.setFocusTraversalKeys(1, new HashSet());
        this.addPropertyChangeListener("editorKit", this);
        this.setEditorKitForContentType("text/plain", new StyledEditorKit());
        if (this.getCaretColor() == null) {
            this.setCaretColor(Color.BLACK);
        }
    }

    @Override
    public void setKeymap(Keymap map) {
        super.setKeymap(map);
        if (map == null) {
            return;
        }
        Action[] actions = this.getEditorKit().getActions();
        if (actions != null) {
            for (Action a : actions) {
                if (!"paste-from-clipboard".equals(a.getValue("Name"))) continue;
                map.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), a);
                map.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), a);
                break;
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent ev) {
        block4: {
            try {
                Container parent;
                if (ev.isTemporary()) break block4;
                for (parent = this.getParent(); parent != null && !(parent instanceof BaseEditor); parent = parent.getParent()) {
                }
                if (parent == null) break block4;
                for (Component comp = ev.getOppositeComponent(); comp != null; comp = comp.getParent()) {
                    if (comp != parent) continue;
                    ev = new FocusEvent(ev.getComponent(), ev.getID(), true, ev.getOppositeComponent());
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.processFocusEvent(ev);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!"editable".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        if (!minimumSize.equals(this.last)) {
            super.getMinimumSize();
        }
        this.last = minimumSize;
        return minimumSize;
    }

    @Override
    public void setPage(String url) throws IOException {
        this.putClientProperty("charset", null);
        super.setPage(url);
    }

    @Override
    public void setPage(URL page) throws IOException {
        this.putClientProperty("charset", null);
        super.setPage(page);
    }

    @Override
    public InputStream getStream(URL page) throws IOException {
        int data;
        InputStream stream = super.getStream(page);
        HashMap<byte[], String> localBOM = new HashMap<byte[], String>(BOM);
        int index = 0;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(10);
        boolean doContinue = true;
        while (doContinue && (data = stream.read()) > -1) {
            byte b = (byte)data;
            Iterator i = localBOM.keySet().iterator();
            doContinue = false;
            while (i.hasNext()) {
                byte[] bom = (byte[])i.next();
                if (bom.length <= index) continue;
                if (bom[index] != b) {
                    i.remove();
                    continue;
                }
                doContinue = true;
            }
            ++index;
        }
        stream.reset();
        if (localBOM.size() == 1) {
            Map.Entry bom = localBOM.entrySet().iterator().next();
            this.putClientProperty("charset", bom.getValue());
            stream.skip(((byte[])bom.getKey()).length);
        }
        return stream;
    }

    @Override
    public void setCaretPosition(int position) {
        super.setCaretPosition(Math.max(0, position));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof InetHtmlEditorKit) {
            return;
        }
        Action[] actions = this.getEditorKit().getActions();
        if (actions != null) {
            Keymap map = this.getKeymap();
            for (Action a : actions) {
                if (!"paste-from-clipboard".equals(a.getValue("Name"))) continue;
                map.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), a);
                map.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), a);
                break;
            }
        }
    }

    static {
        try {
            String handler = System.getProperty("java.protocol.handler.pkgs", "");
            if (handler.indexOf("com.inet.protocol") < 0) {
                if (handler.length() > 0) {
                    handler = handler + "|";
                }
                handler = handler + "com.inet.protocol";
                System.getProperties().put("java.protocol.handler.pkgs", handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SHORTCUT_KEY_MASK = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 2;
    }
}

