/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.AutoCompletionKeyListener;
import com.inet.editor.BaseEditor;
import com.inet.editor.ColorButton;
import com.inet.editor.ColorList;
import com.inet.editor.FocusLostComboBox;
import com.inet.editor.HtmlConverter;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.InetToolBar;
import com.inet.editor.ScrollPopup;
import com.inet.editor.SpellCheckerProxy;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.css.CSS;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.parser.converter.TextDecoration;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;

public class BaseEditorToolBar
implements ContainerListener {
    private HashMap<Integer, ComponentGroup<Component>> comMap = new HashMap();
    private static final String[] FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final String[] FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private JToolBar toolbar;
    private JComboBox<?> fontNameComboBox;
    private JComboBox<?> fontSizeComboBox;
    private JButton fontColor;
    private JPopupMenu colorMenu;
    private ColorList colorList;
    private JToggleButton bold;
    private JToggleButton italic;
    private JToggleButton underline;
    private JToggleButton left;
    private JToggleButton center;
    private JToggleButton right;
    private JToggleButton justify;
    private JButton bulletList;
    private JButton numberList;
    private JButton blockLeft;
    private JButton blockRight;
    private JButton hr;
    private JButton hyperlink;
    private JButton undoButton;
    private JButton redoButton;
    private JButton htmlFormat;
    private JButton addimage;
    private JButton spellchecker;
    private JToggleButton autoSpell;
    private JButton search;
    private int buttonoffset;
    private JTextPane text;
    private final boolean isEditable;
    private final boolean isHtml;
    private boolean toolBarUpdateMode;
    private Dimension sepDimension;
    private boolean editComponentsCreated;
    private boolean htmlButtonsCreated;
    private static final Integer GROUP_DEFAULT = 1;
    private static final Integer GROUP_EDIT = 100;
    private static final Integer GROUP_HTMLFORMAT = 200;
    private static final Integer GROUP_UNDOREDO = 300;
    private boolean isCaretUpdate;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            block30: {
                if (BaseEditorToolBar.this.isCaretUpdate) {
                    return;
                }
                Object src = ev.getSource();
                if (src == BaseEditorToolBar.this.getFontColor()) {
                    return;
                }
                if (src == BaseEditorToolBar.this.getColorList()) {
                    JPopupMenu colorMenu = BaseEditorToolBar.this.getColorMenu();
                    if (colorMenu != null) {
                        colorMenu.setVisible(false);
                    }
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    Color selectedcolor = BaseEditorToolBar.this.getColorList().getColor();
                    if (selectedcolor != null && BaseEditorToolBar.this.getFontColor() != null) {
                        CSS.setTextColor(attr, selectedcolor);
                        BaseEditorToolBar.this.text.setCharacterAttributes(attr, false);
                        ((ColorButton)BaseEditorToolBar.this.getFontColor()).setColor(selectedcolor);
                    }
                } else if (src == BaseEditorToolBar.this.getFontNameComboBox()) {
                    String value = (String)BaseEditorToolBar.this.getFontNameComboBox().getSelectedItem();
                    if (value != null) {
                        SimpleAttributeSet attr = new SimpleAttributeSet();
                        CSS.setFontFamily(attr, value);
                        BaseEditorToolBar.this.text.setCharacterAttributes(attr, false);
                    }
                } else if (src == BaseEditorToolBar.this.getFontSizeComboBox()) {
                    try {
                        Object selectedItem = BaseEditorToolBar.this.getFontSizeComboBox().getSelectedItem();
                        String value = selectedItem.toString();
                        if (value == null) break block30;
                        try {
                            float size = Float.parseFloat(value);
                            if (size < 1.0f || size > 999.0f) {
                                JOptionPane.showMessageDialog(BaseEditorToolBar.this.text, "Fontsize must be between 1 and 999.", "Fontsize", 0);
                                BaseEditorToolBar.this.getFontSizeComboBox().requestFocus();
                                return;
                            }
                            if (InetHtmlEditorKit.getRenderingMode() == InetHtmlEditorKit.RENDER_MODE.os_native) {
                                int pxSize = Math.round(size * 4.0f / 3.0f);
                                size = (float)pxSize * 3.0f / 4.0f;
                            }
                            SimpleAttributeSet addAttr = new SimpleAttributeSet();
                            CSS.setFontSizePT((MutableAttributeSet)addAttr, size);
                            BaseEditorToolBar.this.text.setCharacterAttributes(addAttr, false);
                        }
                        catch (NumberFormatException size) {
                        }
                    }
                    catch (Exception ex) {
                        HtmlEditorUtils.printStackTrace(ex);
                    }
                } else if (src == BaseEditorToolBar.this.getHtmlFormat() && BaseEditorToolBar.this.editor != null) {
                    String newText;
                    int caretPosition = BaseEditorToolBar.this.text.getCaretPosition();
                    String oldText = BaseEditorToolBar.this.text.getText();
                    if (!BaseEditorToolBar.this.isHtml()) {
                        Object defaultClass = BaseEditorToolBar.this.editor.getDocumentProperties().get(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                        newText = HtmlConverter.text2html(oldText, null, true, defaultClass != null ? defaultClass.toString() : null);
                    } else {
                        newText = HtmlConverter.html2text(oldText);
                        if (!BaseEditorToolBar.this.editor.isOnlyPlainText()) {
                            Container parent;
                            for (parent = BaseEditorToolBar.this.editor; parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                                if (parent instanceof JComponent) {
                                    JComponent jcomp = parent;
                                    if (jcomp.getVisibleRect().height == jcomp.getBounds().height) break;
                                }
                                if (parent.getParent() == null) break;
                            }
                            if (JOptionPane.showConfirmDialog(parent, HtmlEditorUtils.getTranslation("msgHtml2Text"), HtmlEditorUtils.getTranslation("titleHtml2Text"), 0, 2) != 0) {
                                return;
                            }
                        }
                    }
                    BaseEditorToolBar.this.editor.setText(newText, !BaseEditorToolBar.this.isHtml(), false);
                    BaseEditorToolBar.this.text.setCaretPosition(BaseEditorToolBar.this.checkCaretRange(caretPosition));
                } else if (src == BaseEditorToolBar.this.getAutoSpell()) {
                    boolean enabled = BaseEditorToolBar.this.isAutoSpellCheck();
                    SpellCheckerProxy.enableAutoSpell(BaseEditorToolBar.this.text, enabled);
                    BaseEditorToolBar.this.setAutoSpellSelected(enabled);
                } else if (src instanceof JMenuItem) {
                    String content = ev.getActionCommand();
                    if (BaseEditorToolBar.this.editor != null) {
                        BaseEditorToolBar.this.editor.insertHtml(content);
                    } else {
                        BaseEditorToolBar.this.text.replaceSelection(content);
                    }
                }
            }
        }
    };
    private CaretListener caretListener = new CaretListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent ev) {
            try {
                AttributeSet attrs;
                Object attr;
                MutableAttributeSet inputAttributes;
                BaseEditorToolBar.this.isCaretUpdate = true;
                int mark = BaseEditorToolBar.this.checkCaretRange(ev.getMark());
                int dot = BaseEditorToolBar.this.checkCaretRange(ev.getDot());
                if (mark != ev.getMark() || dot != ev.getDot()) {
                    Caret caret = BaseEditorToolBar.this.text.getCaret();
                    caret.setDot(dot);
                    caret.moveDot(mark);
                }
                View view = BaseEditorToolBar.this.getCurrentView();
                BoxView glyphView = null;
                if (view instanceof BoxView) {
                    glyphView = (BoxView)view;
                }
                if ((inputAttributes = ((StyledEditorKit)BaseEditorToolBar.this.text.getEditorKit()).getInputAttributes()) != null) {
                    Object inputColor;
                    float fontSize = -1.0f;
                    Object inputFontSize = inputAttributes.getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
                    if (inputFontSize != null) {
                        if (glyphView != null && inputFontSize instanceof FontSize) {
                            fontSize = ((FontSize)inputFontSize).getValue(glyphView);
                        }
                        if (inputFontSize instanceof Float) {
                            fontSize = ((Float)inputFontSize).floatValue();
                        }
                    }
                    if ((inputFontSize = inputAttributes.getAttribute((Object)CSS.Attribute.FONT_SIZE)) != null) {
                        if (glyphView != null && inputFontSize instanceof FontSize) {
                            fontSize = ((FontSize)inputFontSize).getValue(glyphView);
                        }
                        if (inputFontSize instanceof Float) {
                            fontSize = ((Float)inputFontSize).floatValue();
                        }
                    }
                    if ((inputColor = inputAttributes.getAttribute((Object)CSS.Attribute.COLOR)) != null && inputColor instanceof ColorValue) {
                        BaseEditorToolBar.this.setSelectionColor(((ColorValue)inputColor).getValue());
                    } else {
                        BaseEditorToolBar.this.setSelectionColor(null);
                    }
                    String family = null;
                    Object inputFontFamily = inputAttributes.getAttribute((Object)CSS.Attribute.FONT_FAMILY);
                    if (inputFontFamily != null && inputFontFamily instanceof FontFamily) {
                        family = ((FontFamily)inputFontFamily).getFamily();
                    }
                    BaseEditorToolBar.this.setSelectedFontName(family != null ? family : "");
                    BaseEditorToolBar.this.setSelectedFontSize(fontSize > 0.0f ? Integer.valueOf((int)LengthUnit.getPTforPX(fontSize)) : "");
                    Object fontWeight = inputAttributes.getAttribute((Object)CSS.Attribute.FONT_WEIGHT);
                    BaseEditorToolBar.this.setBoldSelected(fontWeight instanceof FontWeight && ((FontWeight)fontWeight).isBold());
                    Object fontStyle = inputAttributes.getAttribute((Object)CSS.Attribute.FONT_STYLE);
                    BaseEditorToolBar.this.setItalicSelected(fontStyle instanceof FontStyle && ((FontStyle)fontStyle).isItalic());
                    Object textDeco = inputAttributes.getAttribute((Object)CSS.Attribute.TEXT_DECORATION);
                    BaseEditorToolBar.this.setUnderlineSelected(textDeco instanceof TextDecoration && ((TextDecoration)textDeco).getDecoration() != 0);
                }
                if ((attr = (attrs = BaseEditorToolBar.this.text.getParagraphAttributes()).getAttribute((Object)CSS.Attribute.TEXT_ALIGN)) == null) {
                    attr = attrs.getAttribute((Object)TemporaryStyle.Attribute.TEXT_ALIGN);
                }
                if (attr instanceof TextAlign) {
                    switch (((TextAlign)attr).getJustification()) {
                        case 0: {
                            BaseEditorToolBar.this.setLeftSelected(true);
                            break;
                        }
                        case 1: {
                            BaseEditorToolBar.this.setCenterSelected(true);
                            break;
                        }
                        case 2: {
                            BaseEditorToolBar.this.setRightSelected(true);
                            break;
                        }
                        case 3: {
                            BaseEditorToolBar.this.setJustifySelected(true);
                        }
                    }
                } else {
                    BaseEditorToolBar.this.setLeftSelected(true);
                }
            }
            finally {
                BaseEditorToolBar.this.isCaretUpdate = false;
            }
        }
    };
    private BaseEditor editor;

    BaseEditorToolBar(BaseEditor editor, boolean hasToolbar, boolean isEditable, boolean isHtml) {
        this.editor = editor;
        this.text = editor.getEditor();
        this.isEditable = isEditable;
        this.isHtml = isHtml;
        this.addCaretListener();
        if (hasToolbar) {
            this.createToolbar();
        }
        this.addButtons();
    }

    public BaseEditorToolBar(JTextPane editor) {
        this.editor = null;
        this.text = editor;
        this.isEditable = editor.isEditable();
        this.isHtml = this.isHtml();
        this.addCaretListener();
        this.createToolbar();
        this.addButtons();
        this.caretListener.caretUpdate(new BaseEditor.SimpleCaretEvent(editor, 0, 0));
    }

    private void createToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setRollover(true);
            this.toolbar.addContainerListener(this);
        }
    }

    public void addComponent(Component comp, Integer group, ActionListener listener) {
        if (comp == null) {
            return;
        }
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            boolean hasListener = false;
            for (ActionListener l : button.getActionListeners()) {
                if (l != listener) continue;
                hasListener = true;
                break;
            }
            if (!hasListener) {
                button.addActionListener(listener);
            }
            comp.setFocusable(false);
        } else {
            comp.setFocusable(true);
        }
        if (group != null) {
            ComponentGroup<Component> componentGroup = this.comMap.get(group);
            if (componentGroup == null) {
                componentGroup = new ComponentGroup(false, false);
                this.comMap.put(group, componentGroup);
            }
            componentGroup.add(comp);
        }
    }

    public void createComponentGroup(Integer groupKey, boolean requiresLeftSep, boolean requiresRightSep, boolean visible) {
        ComponentGroup<Component> componentGroup = this.comMap.get(groupKey);
        if (componentGroup != null) {
            componentGroup.setRequiresLeftSep(requiresLeftSep);
            componentGroup.setRequiresRightSep(requiresRightSep);
            componentGroup.setEnabled(visible);
        } else {
            componentGroup = new ComponentGroup(requiresLeftSep, requiresRightSep);
            componentGroup.setEnabled(visible);
            this.comMap.put(groupKey, componentGroup);
        }
    }

    private void createHtmlButtons() {
        if (this.htmlButtonsCreated) {
            return;
        }
        this.htmlButtonsCreated = true;
        this.fontNameComboBox = new FocusLostComboBox(FONTS);
        this.fontNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Component editor;
                if (e.getStateChange() == 1 && BaseEditorToolBar.this.fontNameComboBox.getEditor() != null && !BaseEditorToolBar.this.fontNameComboBox.isPopupVisible() && (editor = BaseEditorToolBar.this.fontNameComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextField)editor).setCaretPosition(0);
                        }
                    });
                }
            }
        });
        this.fontSizeComboBox = new FocusLostComboBox(FONT_SIZES);
        this.fontColor = new ColorButton();
        this.fontColor.setName("font_color");
        this.fontColor.setToolTipText(HtmlEditorUtils.getTranslation("font_color"));
        this.colorMenu = new ScrollPopup();
        this.colorList = new ColorList();
        this.bold = this.createToogleButton(HtmlEditorUtils.getTranslation("font_bold"), DEFAULT_COMPONENTS.btnBold);
        this.italic = this.createToogleButton(HtmlEditorUtils.getTranslation("font_italic"), DEFAULT_COMPONENTS.btnItalic);
        this.underline = this.createToogleButton(HtmlEditorUtils.getTranslation("font_underlined"), DEFAULT_COMPONENTS.btnUnderline);
        this.left = this.createToogleButton("font_align_left", DEFAULT_COMPONENTS.btnAlignLeft);
        this.center = this.createToogleButton("font_align_center", DEFAULT_COMPONENTS.btnAlignCenter);
        this.right = this.createToogleButton("font_align_right", DEFAULT_COMPONENTS.btnAlignRight);
        this.justify = this.createToogleButton("font_align_justify", DEFAULT_COMPONENTS.btnAlignJustify);
        this.bulletList = this.createButton("bulled_list", DEFAULT_COMPONENTS.btnUnorderedList);
        this.numberList = this.createButton("numbered_list", DEFAULT_COMPONENTS.btnOrderedList);
        this.blockLeft = this.createButton("block_left", DEFAULT_COMPONENTS.btnIndentDecrease);
        this.blockRight = this.createButton("block_right", DEFAULT_COMPONENTS.btnIndentIncrease);
        this.hr = this.createButton("hr", DEFAULT_COMPONENTS.btnHorizontalRule);
        this.hyperlink = this.createButton("hyperlink", DEFAULT_COMPONENTS.btnHyperlink);
        this.addimage = this.createButton("addimage", DEFAULT_COMPONENTS.btnAddImage);
        this.fontNameComboBox.addActionListener(this.listener);
        Dimension d1 = this.fontNameComboBox.getPreferredSize();
        if (d1.width > 130) {
            d1.width = 130;
        }
        ((JTextField)this.fontNameComboBox.getEditor().getEditorComponent()).addKeyListener(new AutoCompletionKeyListener(this.fontNameComboBox));
        this.fontNameComboBox.setPreferredSize(d1);
        this.fontNameComboBox.setMaximumSize(d1);
        this.fontNameComboBox.setMinimumSize(d1);
        this.fontNameComboBox.setEditable(true);
        this.fontNameComboBox.setToolTipText(HtmlEditorUtils.getTranslation("font_name"));
        this.fontNameComboBox.setName(DEFAULT_COMPONENTS.cmbFontFamily.name());
        this.addComponent(this.fontNameComboBox, GROUP_HTMLFORMAT, this.listener);
        this.fontSizeComboBox.addActionListener(this.listener);
        Dimension d2 = this.fontSizeComboBox.getPreferredSize();
        d2.width += 10;
        this.fontSizeComboBox.setPreferredSize(d2);
        this.fontSizeComboBox.setMaximumSize(d2);
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setToolTipText(HtmlEditorUtils.getTranslation("font_size"));
        this.fontSizeComboBox.setName(DEFAULT_COMPONENTS.cmbFontSize.name());
        this.addComponent(this.fontSizeComboBox, GROUP_HTMLFORMAT, this.listener);
        Component fontSizeEditor = this.fontSizeComboBox.getEditor().getEditorComponent();
        if (fontSizeEditor instanceof JTextField) {
            AbstractDocument doc = (AbstractDocument)((JTextField)fontSizeEditor).getDocument();
            doc.setDocumentFilter(new MyFilter());
        }
        this.colorList.addActionListener(this.listener);
        this.fontColor.setName(DEFAULT_COMPONENTS.ddbFontColor.name());
        this.fontColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (BaseEditorToolBar.this.text.isEnabled()) {
                    if (e.getX() < BaseEditorToolBar.this.fontColor.getWidth() - 14) {
                        SimpleAttributeSet attr = new SimpleAttributeSet();
                        CSS.setTextColor(attr, ((ColorButton)BaseEditorToolBar.this.fontColor).getColor());
                        BaseEditorToolBar.this.text.setCharacterAttributes(attr, false);
                    } else if (BaseEditorToolBar.this.fontColor.isShowing()) {
                        BaseEditorToolBar.this.colorMenu.removeAll();
                        for (JMenuItem mi : BaseEditorToolBar.this.colorList.getMenuItems()) {
                            BaseEditorToolBar.this.colorMenu.add(mi);
                        }
                        BaseEditorToolBar.this.colorMenu.show(BaseEditorToolBar.this.fontColor, 0, BaseEditorToolBar.this.fontColor.getHeight() - 2);
                    } else {
                        Component comp = e.getComponent();
                        if (comp != null && comp.isShowing()) {
                            Point location = BaseEditorToolBar.this.editor.getParent().getLocationOnScreen();
                            try {
                                location = comp.getLocationOnScreen();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            Point plocation = BaseEditorToolBar.this.editor.getParent().getLocationOnScreen();
                            BaseEditorToolBar.this.colorMenu.show(BaseEditorToolBar.this.editor.getParent(), location.x - plocation.x, location.y - plocation.y);
                        }
                    }
                }
                e.consume();
            }
        });
        this.addComponent(this.fontColor, GROUP_HTMLFORMAT, this.listener);
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.listener);
        this.addAction("font-bold", this.bold, GROUP_HTMLFORMAT);
        this.addAction("font-italic", this.italic, GROUP_HTMLFORMAT);
        this.addAction("font-underline", this.underline, GROUP_HTMLFORMAT);
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.listener);
        this.addAction("left-justify", this.left, GROUP_HTMLFORMAT);
        this.addAction("center-justify", this.center, GROUP_HTMLFORMAT);
        this.addAction("right-justify", this.right, GROUP_HTMLFORMAT);
        this.addAction("justified-justify", this.justify, GROUP_HTMLFORMAT);
        ButtonGroup align = new ButtonGroup();
        align.add(this.left);
        align.add(this.center);
        align.add(this.right);
        align.add(this.justify);
        ActionMap actionMap = this.text.getActionMap();
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.listener);
        this.addAction("bulletListAction", this.bulletList, GROUP_HTMLFORMAT);
        this.addAction("numberedListAction", this.numberList, GROUP_HTMLFORMAT);
        Action action = actionMap.get("paraIndentRight");
        if (action != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }
        this.addAction("paraIndentRight", this.blockLeft, GROUP_HTMLFORMAT);
        action = actionMap.get("paraIndentLeft");
        if (action != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 1));
        }
        this.addAction("paraIndentLeft", this.blockRight, GROUP_HTMLFORMAT);
        this.addAction("InsertHR", this.hr, GROUP_HTMLFORMAT);
        this.addAction("addimage", this.addimage, GROUP_HTMLFORMAT);
        this.addAction("hyperlink", this.hyperlink, GROUP_HTMLFORMAT);
    }

    private void createEditButtons() {
        Action action;
        if (this.editComponentsCreated) {
            return;
        }
        this.editComponentsCreated = true;
        this.undoButton = this.createButton("backward", DEFAULT_COMPONENTS.btnUndo);
        this.redoButton = this.createButton("forward", DEFAULT_COMPONENTS.btnRedo);
        this.search = this.createButton("search_init", DEFAULT_COMPONENTS.btnFind);
        this.htmlFormat = this.createButton("format", DEFAULT_COMPONENTS.btnChangeFormat);
        this.htmlFormat.setText(HtmlEditorUtils.getTranslation("PlainText"));
        this.htmlFormat.setIcon(HtmlEditorUtils.getResourceImage("format_plain.png"));
        this.htmlFormat.setIconTextGap(2);
        if (SpellCheckerProxy.isSpellCheckerAvailable()) {
            this.spellchecker = this.createButton("spellchecker", DEFAULT_COMPONENTS.btnCheckSpelling);
            this.autoSpell = null;
            boolean isAutoSpellCheck = this.editor != null ? this.editor.isAutoSpellCheck() : false;
            this.autoSpell = this.createToogleButton("autospell", DEFAULT_COMPONENTS.btnAutoSpellCheck);
            this.autoSpell.setSelected(isAutoSpellCheck);
            SpellCheckerProxy.enableShortKey(this.text, true);
            Action action2 = this.addAction("spell-checking", this.spellchecker, GROUP_EDIT);
            if (action2 != null) {
                action2.putValue("ShortDescription", HtmlEditorUtils.getTranslation("spellchecker"));
            }
            this.addComponent(this.autoSpell, GROUP_EDIT, this.listener);
            SpellCheckerProxy.ActivationCallback callback = new SpellCheckerProxy.ActivationCallback(){

                @Override
                public void setActive(boolean active) {
                    if (BaseEditorToolBar.this.toolbar != null) {
                        BaseEditorToolBar.this.toolbar.putClientProperty("activator", null);
                    }
                    BaseEditorToolBar.this.spellchecker.setVisible(active);
                    BaseEditorToolBar.this.autoSpell.setVisible(active);
                }
            };
            SpellCheckerProxy.activate(callback);
            if (this.toolbar != null) {
                this.toolbar.putClientProperty("activator", callback);
            }
        }
        if ((action = this.addAction("undo", this.undoButton, GROUP_UNDOREDO)) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
        }
        if ((action = this.addAction("redo", this.redoButton, GROUP_UNDOREDO)) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
        }
        action = this.addAction("search-init", this.search, GROUP_UNDOREDO);
        this.undoButton.setEnabled(true);
        if (this.editor != null && this.editor.hasFormatButton()) {
            this.addComponent(this.htmlFormat, GROUP_UNDOREDO, this.listener);
            this.notifyFormat(this.isHtml());
        }
    }

    private JButton createButton(String name, DEFAULT_COMPONENTS id) {
        ImageIcon icon = HtmlEditorUtils.getResourceImage(name + ".gif");
        if (icon == null) {
            icon = HtmlEditorUtils.getResourceImage(name + ".png");
        }
        JButton button = new JButton(icon);
        button.setName(id.name());
        button.setToolTipText(HtmlEditorUtils.getTranslation(name));
        return button;
    }

    private JToggleButton createToogleButton(String name, DEFAULT_COMPONENTS id) {
        ImageIcon icon = HtmlEditorUtils.getResourceImage(name + ".gif");
        if (icon == null) {
            icon = HtmlEditorUtils.getResourceImage(name + ".png");
        }
        JToggleButton button = new JToggleButton(icon);
        button.setToolTipText(HtmlEditorUtils.getTranslation(name));
        button.setName(id.name());
        return button;
    }

    private Action addAction(String actionName, AbstractButton button, Integer group) {
        Action action = this.text.getActionMap().get(actionName);
        if (action != null) {
            action.putValue("ShortDescription", HtmlEditorUtils.getTranslation(actionName));
            String label = button.getText();
            Icon icon = button.getIcon();
            button.setAction(action);
            button.setText(label);
            button.setIcon(icon);
            this.addComponent(button, group, this.listener);
        } else if (Logger.doesLog(2)) {
            Logger.warning("Editor action not found: '" + actionName + "'");
        }
        return action;
    }

    protected void addButtons() {
        this.sepDimension = new Dimension(new JToolBar.Separator().getPreferredSize().width, 16);
        this.comMap.put(GROUP_DEFAULT, new ComponentGroup(false, false));
        if (this.toolbar != null) {
            this.comMap.put(GROUP_EDIT, new ComponentGroup(false, true));
            this.comMap.put(GROUP_UNDOREDO, new ComponentGroup(false, false));
            this.comMap.put(GROUP_HTMLFORMAT, new ComponentGroup(true, true));
            if (this.isEditable) {
                this.createEditButtons();
            }
            if (this.isHtml) {
                this.createHtmlButtons();
            }
            if (this.editor != null) {
                this.editor.addButtons((List<Component>)this.comMap.get(GROUP_DEFAULT), (List<Component>)this.comMap.get(GROUP_EDIT), (List<Component>)this.comMap.get(GROUP_HTMLFORMAT));
                for (Component dComp : this.comMap.get(GROUP_DEFAULT)) {
                    this.addComponent(dComp, null, this.listener);
                }
                this.editor.add((Component)new InetToolBar(this.toolbar), "North");
            }
            this.setEditable(this.isEditable);
        }
        this.updateToolbar();
    }

    protected boolean isAutoSpellCheck() {
        return this.autoSpell != null && this.autoSpell.isSelected();
    }

    public void notifyFormat(boolean isHtml) {
        if (this.htmlFormat != null) {
            this.htmlFormat.setText(HtmlEditorUtils.getTranslation(isHtml ? "PlainText" : "HtmlText"));
            this.htmlFormat.setIcon(HtmlEditorUtils.getResourceImage(isHtml ? "format_plain.png" : "format_html.png"));
        }
    }

    public void setToolbarVisible(boolean visible) {
        if (this.toolbar != null) {
            this.toolbar.setVisible(visible);
        }
    }

    public void enableGroups(Integer ... groups) {
        this.changeGroupStatus(true, true, false, groups);
    }

    public void disableGroups(Integer ... groups) {
        this.changeGroupStatus(false, false, false, groups);
    }

    private boolean changeGroupStatus(boolean visible, boolean enabled, boolean modifyComponents, Integer ... groups) {
        boolean hasChanges = false;
        if (groups == null) {
            return hasChanges;
        }
        for (Integer key : groups) {
            ComponentGroup<Component> group = this.comMap.get(key);
            if (group == null) continue;
            hasChanges |= visible != group.isEnabled();
            group.setEnabled(visible);
            if (!modifyComponents) continue;
            for (Component comp : group) {
                hasChanges |= enabled != comp.isEnabled();
                comp.setEnabled(enabled);
            }
        }
        return hasChanges;
    }

    private boolean checkGroups(boolean isEditable, boolean isHtml) {
        boolean hasChanges = false;
        if (isEditable) {
            if (!this.editComponentsCreated) {
                this.createEditButtons();
                hasChanges = true;
            }
            if (!this.htmlButtonsCreated && isHtml) {
                this.createHtmlButtons();
                hasChanges = true;
            }
        }
        return hasChanges;
    }

    public void setEditable(boolean editable) {
        TreeSet<Integer> set = new TreeSet<Integer>(this.comMap.keySet());
        boolean hasChanges = false;
        if (editable) {
            hasChanges |= this.checkGroups(editable, this.isHtml());
        } else {
            hasChanges = true;
            set.remove(GROUP_DEFAULT);
        }
        if (hasChanges |= this.changeGroupStatus(editable, editable, true, set.toArray(new Integer[0]))) {
            this.updateToolbar();
        }
    }

    protected void setEnableFormatButtons(boolean isHtml) {
        boolean hasChanges = false;
        hasChanges |= this.checkGroups(this.text.isEditable(), this.isHtml());
        if (hasChanges |= this.changeGroupStatus(isHtml && this.text.isEditable(), this.text.isEnabled() && this.text.isEditable() && isHtml, true, GROUP_HTMLFORMAT)) {
            this.updateToolbar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToolbar() {
        if (this.toolbar == null) {
            return;
        }
        this.toolBarUpdateMode = true;
        try {
            this.toolbar.removeAll();
            ArrayList<Integer> keys = new ArrayList<Integer>(this.comMap.keySet());
            Collections.sort(keys);
            boolean recentSep = false;
            for (int i = 0; i < keys.size(); ++i) {
                Integer key = keys.get(i);
                ComponentGroup<Component> group = this.comMap.get(key);
                if (group.size() == 0 || !group.isEnabled()) continue;
                if (group.requiresLeftSep() && this.toolbar.getComponentCount() > 0 && !recentSep) {
                    this.toolbar.add(new JToolBar.Separator());
                }
                recentSep = false;
                for (Component comp : group) {
                    this.toolbar.add(comp);
                }
                if (!group.requiresRightSep() || i >= keys.size() - 1) continue;
                this.toolbar.add(new JToolBar.Separator());
                recentSep = true;
            }
        }
        finally {
            this.toolBarUpdateMode = false;
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (this.toolBarUpdateMode) {
            return;
        }
        this.addComponent(e.getChild(), GROUP_DEFAULT, this.listener);
        this.updateToolbar();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        int index;
        if (this.toolBarUpdateMode) {
            return;
        }
        ComponentGroup<Component> group = this.comMap.get(GROUP_DEFAULT);
        if (group != null && e.getChild() != null && (index = group.indexOf(e.getChild())) >= 0) {
            group.remove(index);
        }
        this.updateToolbar();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.checkGroups(this.text.isEditable(), this.isHtml());
        }
        for (ComponentGroup<Component> group : this.comMap.values()) {
            if (!group.isEnabled()) continue;
            for (Component comp : group) {
                comp.setEnabled(enabled);
            }
        }
    }

    private boolean isHtml() {
        return "text/html".equalsIgnoreCase(this.text.getContentType());
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void setSelectionColor(Color value) {
        if (this.colorList != null) {
            this.colorList.setSelectionColor(value);
        }
    }

    public void setSearchVisible(boolean visible) {
        if (this.search != null) {
            this.search.setVisible(visible);
        }
    }

    public void setBoldSelected(boolean b) {
        if (this.bold != null) {
            this.bold.setSelected(b);
        }
    }

    public void setItalicSelected(boolean b) {
        if (this.italic != null) {
            this.italic.setSelected(b);
        }
    }

    public void setUnderlineSelected(boolean b) {
        if (this.underline != null) {
            this.underline.setSelected(b);
        }
    }

    public void setSelectedFontName(String fontName) {
        if (this.fontNameComboBox != null) {
            this.fontNameComboBox.setSelectedItem(fontName);
        }
    }

    public void setSelectedFontSize(Object fontSize) {
        if (this.fontSizeComboBox != null) {
            this.fontSizeComboBox.setSelectedItem(fontSize);
        }
    }

    public void setLeftSelected(boolean b) {
        if (this.left != null) {
            this.left.setSelected(b);
        }
    }

    public void setCenterSelected(boolean b) {
        if (this.center != null) {
            this.center.setSelected(b);
        }
    }

    public void setRightSelected(boolean b) {
        if (this.right != null) {
            this.right.setSelected(b);
        }
    }

    public void setJustifySelected(boolean b) {
        if (this.justify != null) {
            this.justify.setSelected(b);
        }
    }

    public JComboBox<?> getFontNameComboBox() {
        return this.fontNameComboBox;
    }

    public JComboBox<?> getFontSizeComboBox() {
        return this.fontSizeComboBox;
    }

    public JButton getFontColor() {
        return this.fontColor;
    }

    public JPopupMenu getColorMenu() {
        return this.colorMenu;
    }

    public ColorList getColorList() {
        return this.colorList;
    }

    public JToggleButton getBold() {
        return this.bold;
    }

    public JToggleButton getItalic() {
        return this.italic;
    }

    public JToggleButton getUnderline() {
        return this.underline;
    }

    public JToggleButton getLeft() {
        return this.left;
    }

    public JToggleButton getCenter() {
        return this.center;
    }

    public JToggleButton getRight() {
        return this.right;
    }

    public JToggleButton getJustify() {
        return this.justify;
    }

    public JButton getBulletList() {
        return this.bulletList;
    }

    public JButton getNumberList() {
        return this.numberList;
    }

    public JButton getBlockLeft() {
        return this.blockLeft;
    }

    public JButton getBlockRight() {
        return this.blockRight;
    }

    public JButton getHr() {
        return this.hr;
    }

    public JButton getHyperlink() {
        return this.hyperlink;
    }

    public JButton getUndoButton() {
        return this.undoButton;
    }

    public JButton getRedoButton() {
        return this.redoButton;
    }

    public JButton getHtmlFormat() {
        return this.htmlFormat;
    }

    public JButton getAddimage() {
        return this.addimage;
    }

    public JButton getSpellchecker() {
        return this.spellchecker;
    }

    public JToggleButton getAutoSpell() {
        return this.autoSpell;
    }

    public int getButtonoffset() {
        return this.buttonoffset;
    }

    public void setUndoButtonEnabled(boolean canUndo) {
        if (this.undoButton != null) {
            this.undoButton.setEnabled(canUndo);
        }
    }

    public void setRedoButtonEnabled(boolean canRedo) {
        if (this.redoButton != null) {
            this.redoButton.setEnabled(canRedo);
        }
    }

    public Action getAddImageAction() {
        return this.addimage != null ? this.addimage.getAction() : null;
    }

    public void setAddImageEnabled(boolean enabled) {
        if (this.addimage != null) {
            this.addimage.setEnabled(enabled);
        }
    }

    public void setAutoSpellSelected(boolean enabled) {
        if (this.autoSpell != null) {
            this.autoSpell.setSelected(enabled);
        }
    }

    public void switchEditor(JTextPane text) {
        CaretListener[] listeners;
        this.text.removeCaretListener(this.caretListener);
        this.text = text;
        this.addCaretListener();
        SpellCheckerProxy.enableAutoSpell(text, this.isAutoSpellCheck());
        this.setEnabled(text.isEnabled());
        ActionMap actionMap = text.getActionMap();
        Action action = actionMap.get("paraIndentRight");
        if (action != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }
        if ((action = actionMap.get("paraIndentLeft")) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 1));
        }
        if ((listeners = text.getCaretListeners()) != null) {
            BaseEditor.SimpleCaretEvent event = new BaseEditor.SimpleCaretEvent(this.editor, text.getSelectionStart(), text.getSelectionEnd());
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].caretUpdate(event);
            }
        }
    }

    private void addCaretListener() {
        CaretListener[] listeners = this.text.getCaretListeners();
        if (listeners != null && listeners.length > 0) {
            for (CaretListener l : listeners) {
                this.text.removeCaretListener(l);
            }
            this.text.addCaretListener(this.caretListener);
            for (CaretListener l : listeners) {
                this.text.addCaretListener(l);
            }
        } else {
            this.text.addCaretListener(this.caretListener);
        }
    }

    private View getCurrentView() {
        int pos = this.text.getCaretPosition();
        Element paragraph = this.text.getStyledDocument().getParagraphElement(pos);
        if (paragraph.getStartOffset() != pos) {
            --pos;
        }
        Element el = this.text.getStyledDocument().getCharacterElement(pos);
        View baseView = this.text.getUI().getRootView(this.text);
        return this.findViewForElement(baseView, el);
    }

    private View findViewForElement(View baseView, Element el) {
        if (baseView.getElement() == el) {
            return baseView;
        }
        for (int i = 0; i < baseView.getViewCount(); ++i) {
            View searchView;
            View view = baseView.getView(i);
            if (view == null || (searchView = this.findViewForElement(view, el)) == null) continue;
            return searchView;
        }
        return null;
    }

    private int checkCaretRange(int caretPos) {
        Document doc = this.text.getDocument();
        if (caretPos > doc.getLength()) {
            return doc.getLength();
        }
        if (caretPos < 0) {
            return 0;
        }
        return caretPos;
    }

    private class ComponentGroup<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -8231009536777119100L;
        private boolean requiresLeftSep;
        private boolean requiresRightSep;
        private boolean enabled = true;

        public ComponentGroup(boolean requiresLeftSep, boolean requiresRightSep) {
            this.requiresLeftSep = requiresLeftSep;
            this.requiresRightSep = requiresRightSep;
        }

        public boolean requiresLeftSep() {
            return this.requiresLeftSep;
        }

        public boolean requiresRightSep() {
            return this.requiresRightSep;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setRequiresLeftSep(boolean requiresLeftSep) {
            this.requiresLeftSep = requiresLeftSep;
        }

        public void setRequiresRightSep(boolean requiresRightSep) {
            this.requiresRightSep = requiresRightSep;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void add(int index, T element) {
            super.add(index, element);
        }

        @Override
        public boolean add(T e) {
            return super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return super.addAll(index, c);
        }

        @Override
        public void clear() {
            super.clear();
        }

        @Override
        public T remove(int index) {
            return (T)super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return super.retainAll(c);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ComponentGroup( enabled=").append(this.enabled).append(" )\n");
            result.append(super.toString());
            return result.toString();
        }
    }

    public static enum DEFAULT_COMPONENTS {
        btnAutoSpellCheck,
        btnCheckSpelling,
        cmbFontFamily,
        cmbFontSize,
        ddbFontColor,
        btnBold,
        btnItalic,
        btnUnderline,
        btnAlignLeft,
        btnAlignCenter,
        btnAlignRight,
        btnAlignJustify,
        btnUnorderedList,
        btnOrderedList,
        btnIndentIncrease,
        btnIndentDecrease,
        btnHorizontalRule,
        btnAddImage,
        btnHyperlink,
        btnUndo,
        btnRedo,
        btnFind,
        btnChangeFormat;

    }

    private static class MyFilter
    extends DocumentFilter {
        private MyFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass bypass, int off, String string, AttributeSet attr) throws BadLocationException {
            bypass.insertString(off, this.filterPositiveNumber(string), attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass bypass, int offset, int length) throws BadLocationException {
            bypass.remove(offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass bypass, int off, int len, String str, AttributeSet attr) throws BadLocationException {
            bypass.replace(off, len, this.filterPositiveNumber(str), attr);
        }

        private String filterPositiveNumber(String string) {
            StringBuilder buff = new StringBuilder();
            for (char c : string.toCharArray()) {
                if (!Character.isDigit(c) && c != '.') continue;
                buff.append(c);
            }
            return buff.toString();
        }
    }
}

