/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.migrators.ticketfields;

import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.Field;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.setupwizard.HelpDeskSetupWizardPlugin;
import com.inet.helpdesk.plugins.setupwizard.steps.c;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class a
extends AutoSetupStep {
    public static final StepKey i = new StepKey("TicketFieldSettingsStep");
    private DatabaseConnectionFactory x;

    public a(DatabaseConnectionFactory databaseConnectionFactory) {
        this.x = databaseConnectionFactory;
    }

    public StepKey stepKey() {
        return i;
    }

    public String getStepDisplayName() {
        return HelpDeskSetupWizardPlugin.MSG.getMsg("TicketFieldMigration.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("24.4.53");
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        int n = 0;
        try (Connection connection = this.x.getConnectionFromCurrentConfiguration();
             UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            Object object;
            Object object2;
            try (Object object3 = connection.createStatement();){
                object2 = object3.executeQuery("SELECT PriID, PrioSelection FROM tblOptionen");
                try {
                    if (object2.next()) {
                        n = object2.getInt("PriID");
                        int n2 = object2.getInt("PrioSelection");
                        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEFAULT_PRIO_SELECTION, String.valueOf(n2));
                    }
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            object3 = Integer.valueOf(ConfigurationManager.getInstance().getCurrent().get("default.ticket.itilid", "0"));
            object2 = (List)new Json().fromJson(ConfigurationManager.getInstance().getCurrent().get("client.enduser.visibleticketfields", "[]"), List.class);
            ArrayList arrayList = new ArrayList(object2);
            TicketFieldSettingsManager ticketFieldSettingsManager = TicketFieldSettingsManager.getInstance();
            try (Object object4 = connection.createStatement();
                 Object object5 = object4.executeQuery("SELECT * from tblSettings");){
                block67: while (object5.next()) {
                    Object object6;
                    String string;
                    int n3 = object5.getInt("SetID");
                    switch (n3) {
                        case 13: {
                            object = Tickets.FIELD_IDENTIFIER;
                            break;
                        }
                        case 14: {
                            object = Tickets.FIELD_PRIORITY_ID;
                            break;
                        }
                        case 15: {
                            object = Tickets.FIELD_CATEGORY_ID;
                            break;
                        }
                        case 25: {
                            object = Tickets.FIELD_CLASSIFICATION_ID;
                            break;
                        }
                        case 29: {
                            object = Tickets.FIELD_ITIL_ID;
                            break;
                        }
                        case 51: {
                            object = Tickets.FIELD_TARGET_TIME;
                            break;
                        }
                        case 17: {
                            object = Tickets.getFieldByKey((String)"custom1");
                            break;
                        }
                        case 18: {
                            object = Tickets.getFieldByKey((String)"custom2");
                            break;
                        }
                        case 19: {
                            object = Tickets.getFieldByKey((String)"custom3");
                            break;
                        }
                        case 20: {
                            object = Tickets.getFieldByKey((String)"custom4");
                            break;
                        }
                        case 21: {
                            object = Tickets.getFieldByKey((String)"custom5");
                            break;
                        }
                        case 26: {
                            object = Tickets.getFieldByKey((String)"custom6");
                            break;
                        }
                        case 27: {
                            object = Tickets.getFieldByKey((String)"custom7");
                            break;
                        }
                        default: {
                            continue block67;
                        }
                    }
                    int n4 = object5.getInt("Selektion");
                    int n5 = object5.getInt("Pflichtfeld");
                    String string2 = object5.getString("Beschreibung");
                    Map<String, String> map = a.a(object, connection);
                    if (object == Tickets.FIELD_IDENTIFIER) {
                        string = null;
                        switch (n4) {
                            case 1: {
                                string = HDUsersAndGroups.FIELD_COMPUTER_NAME.getKey();
                                break;
                            }
                            case 2: {
                                string = HDUsersAndGroups.FIELD_COST_CENTRE.getKey();
                                break;
                            }
                            case 3: {
                                string = "department";
                                break;
                            }
                            case 4: {
                                string = "custom1";
                            }
                        }
                        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION, string);
                        n4 = 0;
                    } else if (object == Tickets.FIELD_CATEGORY_ID) {
                        switch (n4) {
                            case 0: {
                                n4 = 1;
                                break;
                            }
                            case 1: {
                                n4 = 2;
                                break;
                            }
                            case 2: {
                                n4 = 0;
                            }
                        }
                    } else if (object == Tickets.FIELD_PRIORITY_ID) {
                        switch (n4) {
                            case 0: {
                                n4 = 1;
                                break;
                            }
                            case 1: {
                                n4 = 0;
                            }
                        }
                    }
                    string = ticketFieldSettingsManager.getSetting(object.getKey());
                    if (string == null) {
                        object6 = ticketFieldSettingsManager.getSettings().stream().map(genericFieldSetting -> genericFieldSetting.getKey()).collect(Collectors.joining(","));
                        throw new IllegalStateException("Cannot find setting for " + object.getKey() + ". we have: " + (String)object6);
                    }
                    object6 = string.toMap((AbstractFieldSettingsManager)ticketFieldSettingsManager);
                    this.a((TicketField<?>)object, (Map<String, String>)object6, string2);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (map.get("de") != null) {
                        hashMap.put("de", this.a(map.get("de")));
                    }
                    hashMap.put("default", StringFunctions.isEmpty((String)map.get("en")) ? object.getLabel(Locale.ENGLISH) : this.a(map.get("en")));
                    object6.put("fieldsettingsLabel", new Json().toJson(hashMap));
                    object6.put("description", new Json().toJson(Collections.singletonMap("default", string2)));
                    MandatoryFieldVO.MandatoryType mandatoryType = n4 == 1 ? MandatoryFieldVO.MandatoryType.VISIBLE : (n4 == 2 ? MandatoryFieldVO.MandatoryType.REQUIRED : MandatoryFieldVO.MandatoryType.HIDDEN);
                    object6.put("ticketFieldEnduserEditable", mandatoryType.name());
                    object6.put("ticketFieldVisibility", arrayList.remove(object.getKey()) ? TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER.name() : TicketFieldDefinition.FIELD_VISIBILITY.SUPPORTER.name());
                    object6.put("ticketFieldMandatoryDispatcher", (n5 & 1) > 0 ? "true" : "false");
                    object6.put("ticketFieldMandatorySupporter", (n5 & 2) > 0 ? "true" : "false");
                    if (object == Tickets.FIELD_PRIORITY_ID || object == Tickets.FIELD_ITIL_ID) {
                        object6.put("ticketFieldMandatoryDispatcherDefaultMustbeChanged", (n5 & 1) > 0 ? "true" : "false");
                        object6.put("ticketFieldMandatorySupporterDefaultMustbeChanged", (n5 & 2) > 0 ? "true" : "false");
                    }
                    if (object == Tickets.FIELD_PRIORITY_ID) {
                        object6.put("fieldsettingsDefaultValueSelect", new Json().toJson((Object)new LocalizedKey(String.valueOf(n), "unused2")));
                    }
                    if (object == Tickets.FIELD_ITIL_ID) {
                        object6.put("fieldsettingsDefaultValueSelect", new Json().toJson((Object)new LocalizedKey(String.valueOf(object3), "unused2")));
                    }
                    ticketFieldSettingsManager.updateSetting(object.getKey(), (Map)object6);
                }
            }
            for (Object object5 : arrayList) {
                GenericFieldSetting genericFieldSetting2 = ticketFieldSettingsManager.getSetting((String)object5);
                if (genericFieldSetting2 == null) continue;
                object = genericFieldSetting2.toMap((AbstractFieldSettingsManager)ticketFieldSettingsManager);
                object.put("ticketFieldVisibility", TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER.name());
                ticketFieldSettingsManager.updateSetting((String)object5, (Map)object);
            }
            if (object2.size() > 1) {
                object4 = ticketFieldSettingsManager.getSettings();
                int n6 = ((GenericFieldSetting)object4.get(object4.size() - 1)).getSortPriority() + 1;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    GenericFieldSetting genericFieldSetting3 = ticketFieldSettingsManager.getSetting((String)object);
                    if (genericFieldSetting3 == null) continue;
                    Map map = genericFieldSetting3.toMap((AbstractFieldSettingsManager)ticketFieldSettingsManager);
                    map.put("sortPrio", String.valueOf(n6++));
                    ticketFieldSettingsManager.updateSetting((String)object, map);
                }
            }
            object4 = connection.createStatement();
            try {
                if (HdDatabaseCheck.tableExists(this.x, "tblTicketViews")) {
                    object4.executeUpdate("DROP TABLE tblTicketViews");
                }
                if (HdDatabaseCheck.tableExists(this.x, "tblTranslationTexts")) {
                    object4.executeUpdate("DROP TABLE tblTranslationTexts");
                }
                if (HdDatabaseCheck.tableExists(this.x, "tblTranslations")) {
                    object4.executeUpdate("DROP TABLE tblTranslations");
                }
            }
            finally {
                if (object4 != null) {
                    object4.close();
                }
            }
        }
        catch (Exception exception) {
            throw new StepExecutionException((Throwable)exception);
        }
    }

    private void a(TicketField<?> ticketField, Map<String, String> map, String string2) {
        if (TicketFieldSettings.isOpenFieldKey((String)ticketField.getKey()) && string2 != null) {
            ArrayList arrayList = new ArrayList();
            Predicate<String> predicate = new Predicate<String>(){

                public boolean h(String string) {
                    return string.startsWith("*") || string.startsWith("#");
                }

                @Override
                public /* synthetic */ boolean test(Object object) {
                    return this.h((String)object);
                }
            };
            Arrays.stream(string2.split("\\n")).filter(predicate).forEach(string -> {
                List<String> list2 = string.startsWith("*") ? List.of(string.substring(1).trim(), "selectOnlyForSupporter") : List.of(string.substring(1).trim(), "selectForSupporterAndEnduser");
                arrayList.add(list2);
            });
            if (!arrayList.isEmpty()) {
                map.put("selectstaticoptions", new Json().toJson(arrayList));
                map.put("type", FieldSettingsType.TYPE_SELECT.toString());
            }
        }
    }

    private String a(String string) {
        if (string.contains("{") || string.contains("}")) {
            return string.replace("{", "'{'").replace("}", "'}'");
        }
        return string;
    }

    private static Map<String, String> a(TicketField<?> ticketField, Connection connection) throws SQLException {
        String string = "SELECT LanguageID,Text FROM tblTranslationTexts WHERE TranslationID = (SELECT TranslationID FROM tblTranslations WHERE PluginID = ? AND TextKey = ?)";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setString(1, "helpdesk");
            preparedStatement.setString(2, a.a(ticketField));
            try (Object object = preparedStatement.executeQuery();){
                while (object.next()) {
                    String string2 = object.getString(1);
                    String string3 = object.getString(2);
                    hashMap.put(string2, string3);
                }
            }
            object = hashMap;
            return object;
        }
    }

    private static String a(Field<?> field) {
        String string = "TF_";
        if (field == Tickets.FIELD_PRIORITY_ID) {
            return string + "priority";
        }
        if (field == Tickets.FIELD_CATEGORY_ID) {
            return string + "category";
        }
        if (field.getKey().equals("custom1")) {
            return string + "custom1";
        }
        if (field.getKey().equals("custom2")) {
            return string + "custom2";
        }
        if (field.getKey().equals("custom3")) {
            return string + "custom3";
        }
        if (field.getKey().equals("custom4")) {
            return string + "custom4";
        }
        if (field.getKey().equals("custom5")) {
            return string + "custom5";
        }
        if (field.getKey().equals("custom6")) {
            return string + "custom6";
        }
        if (field.getKey().equals("custom7")) {
            return string + "custom7";
        }
        if (field == Tickets.FIELD_ITIL_ID) {
            return string + "itil";
        }
        if (field == Tickets.FIELD_CLASSIFICATION_ID) {
            return string + "classification";
        }
        if (field == Tickets.FIELD_TARGET_TIME) {
            return string + "duetime";
        }
        if (field == Tickets.FIELD_IDENTIFIER) {
            return string + "specialfield";
        }
        return null;
    }

    public SetupStepPriority getPriority() {
        return c.br;
    }

    public InfoMessageGetter a(EmptyStepConfig emptyStepConfig) {
        return () -> HelpDeskSetupWizardPlugin.MSG.getMsg("TicketFieldMigration.displayname", new Object[0]);
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.a((EmptyStepConfig)stepConfiguration);
    }
}

