/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.migrators.reports;

import com.inet.drive.api.DrivePermission;
import com.inet.helpdesk.plugins.setupwizard.migrators.reports.f;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;

public class c {
    private File aq;
    private File ar;
    private f as;

    public c(f f2, URL uRL) {
        this.as = f2;
        File file = c.a(uRL, "originalreports").toFile();
        file.deleteOnExit();
        this.aq = new File(file, "reports");
        this.ar = new File(file, "print");
        if (!this.ar.isDirectory()) {
            throw new IllegalStateException(this.ar.getAbsolutePath() + " does not exist or is not a directory");
        }
        if (!this.aq.isDirectory()) {
            throw new IllegalStateException(this.aq.getAbsolutePath() + " does not exist or is not a directory");
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Does not read file, creates temp file. And must read specified file.")
    public static Path a(URL uRL, String string) {
        try {
            final Path path = Files.createTempDirectory(string, new FileAttribute[0]);
            URI uRI = uRL.toURI();
            if (uRI.getScheme().equals("jar")) {
                HashMap hashMap = new HashMap();
                try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
                    final Path path2 = fileSystem.getPath(uRI.getSchemeSpecificPart().substring(uRI.getSchemeSpecificPart().lastIndexOf("!/") + 2), new String[0]);
                    Files.walkFileTree(path2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        public FileVisitResult a(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                            CopyOption[] copyOptionArray = new CopyOption[]{};
                            Path path22 = path.resolve(c.a(path2.toAbsolutePath().relativize(path3.toAbsolutePath())));
                            try {
                                Files.copy(path3, path22, copyOptionArray);
                            }
                            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                                // empty catch block
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult b(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                            Files.copy(path3, path.resolve(c.a(path2.toAbsolutePath().relativize(path3.toAbsolutePath()))), StandardCopyOption.REPLACE_EXISTING);
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path path3, IOException iOException) {
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult b(Path path3, IOException iOException) throws IOException {
                            throw iOException;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.a((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFileFailed(Object object, IOException iOException) throws IOException {
                            return this.b((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.b((Path)object, basicFileAttributes);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.a((Path)object, basicFileAttributes);
                        }
                    });
                }
            } else if (uRI.getScheme().equals("file")) {
                Path path3 = IOFunctions.getFile((URL)uRL).toPath();
                IOFunctions.copyDirectory((Path)path3, (Path)path);
            } else {
                throw new IllegalArgumentException("Cannot process given URL: " + uRL.toExternalForm());
            }
            return path;
        }
        catch (IOException | URISyntaxException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public void a(Version version) throws IOException {
        if (!this.A()) {
            return;
        }
        if (new Version("24.4").isHigherThan(version)) {
            this.C();
        }
        File file = this.B();
        SetupLogger.LOGGER.info((Object)String.format("[Reports] Adding/Updating reports in Drive and %s", file.getAbsolutePath()));
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            this.as.a(this.aq, version);
        }
        SetupLogger.LOGGER.info((Object)"[Reports] Update print reports.");
        this.as.c(file.toPath());
        this.as.b(file);
        this.as.a(this.ar, file, this.aq);
    }

    public void z() throws IOException {
        if (!this.A()) {
            return;
        }
        SetupLogger.LOGGER.info((Object)"Copying report structure to /reports and /print.");
        File file = this.B();
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            this.as.b(this.aq, this.ar, file);
        }
    }

    private boolean A() {
        if (!(Persistence.getInstance() instanceof FilePersistence)) {
            SetupLogger.LOGGER.error((Object)"[Reports] Cannot update or migrate reports because persistence is not FilePersistence!");
            return false;
        }
        return true;
    }

    private File B() {
        File file = ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().resolve("print").toFile();
        file.mkdirs();
        return file;
    }

    private void C() {
        GUID gUID2;
        Set<Permission> set = Set.of(DrivePermission.DRIVE_PERMISSION);
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        orSearchExpression.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)"reports"));
        orSearchExpression.add((Object)new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Administrator.name()));
        Set set2 = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{orSearchExpression}));
        for (GUID gUID2 : set2) {
            UserManager.getInstance().updateUserPermissions(gUID2, set, Set.of());
        }
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        gUID2 = new SearchCommand("permissions", SearchCondition.SearchTermOperator.Equals, (Object)"reports");
        for (GUID gUID3 : userGroupManager.getSearchEngine().simpleSearch((SearchCommand)gUID2)) {
            if (gUID3.equals((Object)UsersAndGroups.GROUPID_ADMIN)) continue;
            userGroupManager.updateGroupPermissions(gUID3, set, Set.of());
        }
    }

    public static Path a(Path path) {
        Path path2 = Paths.get("", new String[0]);
        for (Path path3 : path) {
            path2 = path2.resolve(URLEncoder.encode(path3.toString(), Charset.forName("UTF-8")));
        }
        return path2;
    }

    public static Path b(Path path) {
        Path path2 = Paths.get("", new String[0]);
        for (Path path3 : path) {
            path2 = path2.resolve(URLDecoder.decode(path3.toString(), Charset.forName("UTF-8")));
        }
        return path2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Nix file-access!")
    public static String d(String string) {
        return c.b(Paths.get(string, new String[0])).toString();
    }
}

