/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.steps.database;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.plugins.setupwizard.steps.database.d;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.api.StepKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

@InternalApi
public class DatabaseConnectionFactory
implements ConnectionCreationListener,
SetupStepsExecutionListener {
    private SQLException bT;
    private boolean bU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(DatabaseConfigInfo dbInfo) throws ClassNotFoundException, SQLException {
        LoaderUtils.classForName((String)dbInfo.getDriverClassName(), (Object)this);
        int n = DriverManager.getLoginTimeout();
        DriverManager.setLoginTimeout(10);
        try {
            Object object = dbInfo.getUrl();
            if (((String)object).startsWith("jdbc:") && !((String)object).startsWith("jdbc:inetpool:")) {
                object = "jdbc:inetpool:" + ((String)object).substring(5);
            }
            Connection connection = DriverManager.getConnection((String)object, dbInfo.getUser(), dbInfo.getDecodedPassword());
            return connection;
        }
        finally {
            DriverManager.setLoginTimeout(n);
        }
    }

    public DatabaseConfigInfo getCurrentDatabaseConfigInfo() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        return new d().a(configuration);
    }

    public Connection getConnectionFromCurrentConfiguration() throws ClassNotFoundException, SQLException {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        DatabaseConfigInfo databaseConfigInfo = new d().a(configuration);
        if (databaseConfigInfo != null) {
            if (!this.bU && this.bT != null) {
                throw new SQLException("Connecting to database failed, see the cause", this.bT);
            }
            try {
                return this.createConnection(databaseConfigInfo);
            }
            catch (SQLException sQLException) {
                this.bT = sQLException;
                throw sQLException;
            }
        }
        throw new IllegalStateException(String.format("Cannot create a connection to HDS because there are no settings for the database in the current configuration %s/%s", ConfigurationManager.getScopeName((int)configuration.getScope()), configuration.getName()));
    }

    public void executionFailed(String failingStepMessage, Throwable error, List<StepKey> executedSteps) {
        this.bU = false;
        this.bT = null;
    }

    public void executionPhaseFinished(boolean serverWillRestart, List<StepKey> executedSteps) throws Exception {
        this.bU = false;
        this.bT = null;
    }

    public void executionStarted(List<StepKey> stepsToExecute) {
        this.bU = true;
    }

    public void connectionCreated() {
        this.bT = null;
    }
}

