/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.steps;

import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.UploadListener;
import com.inet.helpdesk.plugins.setupwizard.migrators.configmigration.b;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a {
    public static final Path aQ = b.k().resolve("adhoc_templates");
    public static final Path aR = Paths.get("adhoc_templates", new String[0]);

    public void I() {
        ServerPluginManager.getInstance().runIfPluginLoaded("drive", () -> new Executable(){

            public void execute() {
                Drive drive = Drive.getInstance();
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    DriveEntry driveEntry = drive.resolve(aR);
                    if (driveEntry != null) {
                        driveEntry.delete(new OperationProgressListener(){

                            public void startOperationFor(@Nonnull String entryID) {
                            }

                            public void operateElements(HashSet<String> elements) {
                            }

                            @Nullable
                            public UploadListener getUploadListener() {
                                return null;
                            }
                        });
                    }
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    throw new IllegalStateException(driveOperationConflictException);
                }
            }
        });
    }

    public void J() {
        SetupLogger.LOGGER.info((Object)"[Adhoc] Delete adhoc_templates and original_adhoc_templates");
        try {
            IOFunctions.deleteDir((Path)aQ);
        }
        catch (IOException iOException) {
            SetupLogger.LOGGER.error((Object)"[Adhoc] Could not delete templates dir");
            SetupLogger.LOGGER.error((Throwable)iOException);
        }
    }

    public void K() {
        ServerPluginManager.getInstance().runIfPluginLoaded("drive", () -> new Executable(){

            public void execute() {
                block18: {
                    Drive drive = Drive.getInstance();
                    SetupLogger.LOGGER.info((Object)"[Adhoc] Copy customer AdHoc templates to the user homes in drive");
                    try {
                        DatabaseConnectionFactory databaseConnectionFactory = new DatabaseConnectionFactory();
                        Connection connection = databaseConnectionFactory.getConnectionFromCurrentConfiguration();
                        if (!HdDatabaseCheck.tableExists(connection, "tbl_adhoc_userstore")) break block18;
                        try (Statement statement = connection.createStatement();){
                            ResultSet resultSet = statement.executeQuery("SELECT * FROM tbl_adhoc_userstore");
                            Pattern pattern = Pattern.compile("^\"(.*?)\";\"(.*)\"$");
                            while (resultSet.next()) {
                                String string = resultSet.getString("identifier");
                                String string2 = resultSet.getString("name");
                                Matcher matcher = pattern.matcher(string2);
                                if (matcher.matches()) {
                                    string2 = matcher.group(2);
                                }
                                String string3 = resultSet.getString("pageData");
                                GUID gUID = GUID.valueOf((String)string);
                                if (gUID == null) continue;
                                try {
                                    UserAccountScope userAccountScope = UserAccountScope.create((GUID)gUID);
                                    try {
                                        DriveEntry driveEntry = drive.resolve("/Home/");
                                        if (driveEntry == null) continue;
                                        DataEntry dataEntry = new DataEntry(string2 + ".adhoc", string3);
                                        DriveEntry driveEntry2 = drive.resolve(Path.of(driveEntry.getPath(), string2));
                                        if (driveEntry2 != null) continue;
                                        drive.createFile(driveEntry.getID(), dataEntry);
                                    }
                                    finally {
                                        if (userAccountScope == null) continue;
                                        userAccountScope.close();
                                    }
                                }
                                catch (DriveOperationConflictException driveOperationConflictException) {
                                    SetupLogger.LOGGER.error((Object)"[Adhoc] Could not copy template to user home dir");
                                    SetupLogger.LOGGER.error((Throwable)driveOperationConflictException);
                                }
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        SetupLogger.LOGGER.error((Object)"[Adhoc] Could not copy templates into the user home in drive");
                        SetupLogger.LOGGER.error((Throwable)classNotFoundException);
                    }
                    catch (SQLException sQLException) {
                        SetupLogger.LOGGER.error((Throwable)sQLException);
                    }
                }
            }
        });
    }
}

