/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.steps.database;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.plugins.setupwizard.HelpDeskSetupWizardPlugin;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConfigInfoW;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseSettings;
import com.inet.helpdesk.plugins.setupwizard.steps.database.a;
import com.inet.helpdesk.plugins.setupwizard.steps.database.b;
import com.inet.helpdesk.plugins.setupwizard.steps.database.d;
import com.inet.helpdesk.plugins.setupwizard.steps.database.e;
import com.inet.helpdesk.plugins.setupwizard.steps.database.f;
import com.inet.helpdesk.plugins.setupwizard.steps.database.g;
import com.inet.helpdesk.plugins.setupwizard.steps.database.h;
import com.inet.helpdesk.plugins.setupwizard.steps.database.i;
import com.inet.helpdesk.plugins.setupwizard.steps.database.j;
import com.inet.helpdesk.plugins.setupwizard.steps.database.k;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.CommandExecutor;
import com.inet.shared.utils.ProductionEnvironmentCheck;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class c
extends SetupStep<DatabaseSettings> {
    public static final StepKey i = new StepKey("database");
    public static final Path bV = Paths.get("SQLEXPR_x64_DEU.zip", new String[0]);
    private DatabaseConnectionFactory x;
    private b bW;

    public c(DatabaseConnectionFactory databaseConnectionFactory) {
        this.x = databaseConnectionFactory;
    }

    public StepKey stepKey() {
        return i;
    }

    public DatabaseSettings a(StepConfigurationStorage stepConfigurationStorage, StepsRepository stepsRepository, DatabaseSettings databaseSettings, StepKey stepKey) {
        boolean bl;
        SetupLogger.LOGGER.info((Object)"[Database] start Db Step init");
        boolean bl2 = System.getProperty("os.name").toLowerCase().startsWith("windows");
        boolean bl3 = bl = databaseSettings != null;
        if (bl) {
            SetupLogger.LOGGER.info((Object)"[Database] Take the previous settings");
            return databaseSettings;
        }
        DatabaseSettings databaseSettings2 = this.a(stepConfigurationStorage);
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl2 && Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage())) {
            boolean bl6 = new j().Y();
            bl4 = !bl6;
            bl5 = this.d(databaseSettings2);
        }
        databaseSettings2.setUpdateSQLExpressMode(bl5);
        databaseSettings2.setOptionInstallSQLExpressEnabled(bl4);
        return databaseSettings2;
    }

    private DatabaseSettings a(StepConfigurationStorage stepConfigurationStorage) {
        DatabaseConfigInfo databaseConfigInfo = new d().a(ConfigurationManager.getInstance().getCurrent());
        DatabaseSettings databaseSettings = new DatabaseSettings();
        if (databaseConfigInfo == null) {
            databaseSettings.databaseInfo().setCatalog("InetHelpDesk");
            return databaseSettings;
        }
        databaseSettings.databaseInfo().setCatalog(databaseConfigInfo.getCatalog());
        databaseSettings.databaseInfo().setDecodedPassword(databaseConfigInfo.getDecodedPassword().toCharArray());
        databaseSettings.databaseInfo().setDriver(databaseConfigInfo.getDriver());
        databaseSettings.databaseInfo().setHost(databaseConfigInfo.getHost());
        databaseSettings.databaseInfo().setPort(databaseConfigInfo.getPort());
        databaseSettings.databaseInfo().setSid(databaseConfigInfo.getSid());
        databaseSettings.databaseInfo().setCustomUrl(databaseConfigInfo.getCustomUrl());
        databaseSettings.databaseInfo().setUser(databaseConfigInfo.getUser());
        boolean bl = databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7 && (databaseConfigInfo.getUser() == null || databaseConfigInfo.getUser().isEmpty());
        databaseSettings.setCreateNewUser(bl ? 2 : 0);
        databaseSettings.setReadOnly(ProductionEnvironmentCheck.inProduction());
        return databaseSettings;
    }

    public SetupStepProblems a(DatabaseSettings databaseSettings) {
        if (this.c(databaseSettings)) {
            SetupStepProblems setupStepProblems = new SetupStepProblems();
            String string = databaseSettings.databaseInfo().getDecodedSystemPassword();
            if (string == null || string.length() < 8) {
                setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.error.password", new Object[]{8}));
            }
            return setupStepProblems;
        }
        if (databaseSettings.isUpdateSQLExpressMode()) {
            SetupStepProblems setupStepProblems = new SetupStepProblems();
            setupStepProblems.addWarning(HelpDeskSetupWizardPlugin.MSG.getMsg("database.warn.updateSQLExpress", new Object[0]));
            return setupStepProblems;
        }
        return this.b(databaseSettings);
    }

    private SetupStepProblems b(DatabaseSettings databaseSettings) {
        boolean bl;
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        DatabaseConfigInfoW databaseConfigInfoW = databaseSettings.databaseInfo();
        SetupStepProblems setupStepProblems = new SetupStepProblems();
        boolean bl2 = bl = databaseSettings.databaseInfo().getCustomUrl() != null;
        if (databaseConfigInfoW.getDriver() == null || databaseConfigInfoW.getDriver() == DatabaseConfigInfo.DatabaseType.unknown) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.noDriver", new Object[0]));
            return setupStepProblems;
        }
        if (!bl && (databaseConfigInfoW.getHost() == null || databaseConfigInfoW.getHost().isEmpty())) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.noHost", new Object[0]));
            return setupStepProblems;
        }
        if (!(bl || databaseConfigInfoW.getDriver() != DatabaseConfigInfo.DatabaseType.mysql && databaseConfigInfoW.getDriver() != DatabaseConfigInfo.DatabaseType.mariadb && databaseConfigInfoW.getDriver() != DatabaseConfigInfo.DatabaseType.inetdae7 || databaseConfigInfoW.getCatalog() != null && !databaseConfigInfoW.getCatalog().trim().isEmpty())) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.noCatalog", new Object[0]));
            return setupStepProblems;
        }
        if (bl && (databaseConfigInfoW.getCustomUrl() == null || databaseConfigInfoW.getCustomUrl().isEmpty())) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.noCustomUrl", new Object[0]));
            return setupStepProblems;
        }
        if (bl && !databaseConfigInfoW.getCustomUrl().contains(":" + databaseConfigInfoW.getDriver().name() + ":")) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.customUrlWrongType", new Object[0]));
            return setupStepProblems;
        }
        a a2 = this.a(databaseConfigInfoW.getDriver());
        String string = databaseConfigInfoW.getUrl();
        if (databaseSettings.createNewUser() != 1) {
            String string2;
            String string3 = connectionFactory.testDBConnection(string, databaseConfigInfoW.getDecodedPassword(), databaseConfigInfoW.getUser(), databaseConfigInfoW.getDriverClassName(), null);
            if (string3 != null) {
                String string4;
                if (bl) {
                    setupStepProblems.addError(string3);
                    setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.customUrlExtraMessage", new Object[0]));
                    return setupStepProblems;
                }
                string2 = a2.a(connectionFactory, (DatabaseConfigInfo)databaseConfigInfoW);
                if (string2 != null) {
                    setupStepProblems.addError(string2);
                }
                if ((string4 = a2.b(databaseConfigInfoW)) != null) {
                    setupStepProblems.addError(string4);
                    return setupStepProblems;
                }
                if (setupStepProblems.hasErrors()) {
                    return setupStepProblems;
                }
            } else {
                try {
                    int n = com.inet.helpdesk.plugins.setupwizard.steps.database.post.a.a(this.x, databaseConfigInfoW);
                    if (n < 206) {
                        setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.helpdeskversion.outofdate", new Object[]{com.inet.helpdesk.plugins.setupwizard.steps.precondition.a.cx}));
                        return setupStepProblems;
                    }
                }
                catch (SQLException sQLException) {
                }
                catch (Exception exception) {
                    SetupLogger.LOGGER.error((Throwable)exception);
                    setupStepProblems.addError(exception.getMessage());
                    return setupStepProblems;
                }
                string2 = bl ? "" : (databaseConfigInfoW.getDriver() == DatabaseConfigInfo.DatabaseType.inetora ? databaseConfigInfoW.getUser() : databaseConfigInfoW.getCatalog());
                setupStepProblems.addWarning(HelpDeskSetupWizardPlugin.MSG.getMsg("database.databaseAlreadyExists", new Object[]{string2}));
            }
            string2 = a2.a(databaseConfigInfoW);
            if (string2 != null) {
                setupStepProblems.addError(string2);
            }
            return setupStepProblems;
        }
        if (bl) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.customUrlCannotCreateUser", new Object[0]));
            return setupStepProblems;
        }
        DatabaseConfigInfo databaseConfigInfo = new DatabaseConfigInfo();
        databaseConfigInfo.setDriver(databaseConfigInfoW.getDriver());
        databaseConfigInfo.setHost(databaseConfigInfoW.getHost());
        databaseConfigInfo.setPort(databaseConfigInfoW.getPort());
        databaseConfigInfo.setSid(databaseConfigInfoW.getSid());
        databaseConfigInfo.setCatalog(databaseConfigInfoW.getCatalog());
        databaseConfigInfo.setUser(databaseConfigInfoW.getSystemUser());
        databaseConfigInfo.setDecodedPassword(databaseConfigInfoW.getDecodedSystemPassword().toCharArray());
        String string5 = a2.a(connectionFactory, databaseConfigInfo);
        if (string5 != null) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.error.systemuserconnect", new Object[0]));
            setupStepProblems.addError(string5);
            return setupStepProblems;
        }
        if (!this.b(databaseConfigInfoW.getUser(), databaseConfigInfoW.getDecodedPassword())) {
            setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.invalidUserPassword", new Object[0]));
            return setupStepProblems;
        }
        if (a2.i(databaseConfigInfoW.getUser())) {
            if (databaseConfigInfoW.getDriver() == DatabaseConfigInfo.DatabaseType.inetora) {
                setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.databaseExceededLengthLimit", new Object[]{a2.R()}));
            } else {
                setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.userNameExceededLengthLimit", new Object[]{a2.R()}));
            }
            return setupStepProblems;
        }
        if (a2.a(connectionFactory, databaseConfigInfoW)) {
            if (databaseConfigInfoW.getDriver() == DatabaseConfigInfo.DatabaseType.inetora) {
                setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.alreadyexistsOra", new Object[0]));
            } else {
                setupStepProblems.addError(HelpDeskSetupWizardPlugin.MSG.getMsg("database.alreadyexists", new Object[0]));
            }
            return setupStepProblems;
        }
        String string6 = a2.a(databaseConfigInfo);
        if (string6 != null) {
            setupStepProblems.addError(string6);
            return setupStepProblems;
        }
        String string7 = a2.b(databaseConfigInfo);
        if (string7 != null) {
            setupStepProblems.addError(string7);
            return setupStepProblems;
        }
        return setupStepProblems;
    }

    private boolean b(String string, String string2) {
        boolean bl = string != null && !string.isEmpty();
        boolean bl2 = string2 != null && !string2.isEmpty();
        return bl && bl2;
    }

    private a a(DatabaseConfigInfo.DatabaseType databaseType) {
        switch (databaseType) {
            case inetdae7: {
                return new e();
            }
            case mysql: {
                return new g(this.x);
            }
            case mariadb: {
                return new f(this.x);
            }
            case inetora: {
                return new h(this.x);
            }
        }
        return new a();
    }

    public void a(DatabaseSettings databaseSettings, Map<String, String> map) throws StepExecutionException {
        SetupStepProblems setupStepProblems = this.a(databaseSettings);
        if (setupStepProblems.hasErrors()) {
            throw new StepExecutionException(setupStepProblems.getErrors().toString());
        }
        DBUpdateBackdoor dBUpdateBackdoor = (DBUpdateBackdoor)ServerPluginManager.getInstance().getSingleInstance(DBUpdateBackdoor.class);
        DatabaseConfigInfoW databaseConfigInfoW = databaseSettings.databaseInfo();
        if (this.c(databaseSettings)) {
            this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(0, () -> HelpDeskSetupWizardPlugin.MSG.getMsg("database.installingSqlExpress", new Object[0])));
            databaseConfigInfoW = this.c("HELPDESK", databaseSettings.databaseInfo().getDecodedSystemPassword());
            this.c(databaseConfigInfoW);
            this.a("HELPDESK", databaseSettings.databaseInfo().getDecodedSystemPassword(), bV);
        } else if (databaseSettings.isUpdateSQLExpressMode()) {
            this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(0, () -> HelpDeskSetupWizardPlugin.MSG.getMsg("database.updatingSqlExpress", new Object[0])));
            this.c(databaseConfigInfoW);
            this.j("HELPDESK");
        } else {
            this.c(databaseConfigInfoW);
        }
        try {
            SetupLogger.LOGGER.info((Object)("update DB " + new Json().toJson((Object)databaseConfigInfoW.getDriver())));
            dBUpdateBackdoor.updateDB((DatabaseConfigInfo)databaseConfigInfoW, databaseConfigInfoW.getSystemUser(), databaseConfigInfoW.getDecodedSystemPassword(), updaterEvent -> {
                int n = updaterEvent.getJobCount();
                int n2 = n > 10 ? 60 * updaterEvent.getCurrentJob() / n : 103;
                this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(n2, () -> updaterEvent.getCurrentJobName(ClientLocale.getThreadLocale())));
            }, new ArrayList());
            this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(60, () -> this.e(databaseSettings).getMsg()));
            com.inet.helpdesk.plugins.setupwizard.steps.database.post.a.a(this.x, this, 60, 79);
            this.V();
            this.bW.T();
        }
        catch (SQLException sQLException) {
            throw new StepExecutionException((Throwable)sQLException);
        }
    }

    private void V() {
        try (Connection connection = this.x.getConnectionFromCurrentConfiguration();
             Statement statement = connection.createStatement();){
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            DatabaseConfigInfo databaseConfigInfo = new d().a(configuration);
            String string = "";
            int n = UtilityFunctions.getDBVersion();
            switch (databaseConfigInfo.getDriver()) {
                case mysql: 
                case mariadb: {
                    string = String.format("Update tblOptionen Set `Release` = %d", n);
                    break;
                }
                default: {
                    string = String.format("Update tblOptionen Set Release = %d", n);
                }
            }
            statement.executeUpdate(string);
            SetupLogger.LOGGER.info((Object)("[Database] Set database version in DB: " + n));
        }
        catch (ClassNotFoundException | SQLException exception) {
            SetupLogger.LOGGER.error((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public StepExecutionProgressListener getStepExecutionProgressListener() {
        return super.getStepExecutionProgressListener();
    }

    private void a(String string, String string2, Path path) throws StepExecutionException {
        String string3 = " /Q /IACCEPTSQLSERVERLICENSETERMS /ACTION=Install /SECURITYMODE=SQL /SAPWD=\"" + string2 + "\" /FEATURES=SQL,AS,RS,IS,Tools /SQLSVCACCOUNT=\"NT AUTHORITY\\SYSTEM\" /SQLSYSADMINACCOUNTS=\"BUILTIN\\ADMINISTRATORS\" /INSTANCENAME=" + string + " /ADDCURRENTUSERASSQLADMIN /TCPENABLED=1";
        this.a(string3, path);
    }

    private void j(String string) throws StepExecutionException {
        String string2 = " /Q /ACTION=upgrade /INSTANCEID=" + string + " /INSTANCENAME=" + string + " /ISSVCAccount=\"NT Authority\\Network Service\" /IACCEPTSQLSERVERLICENSETERMS";
        this.a(string2, bV);
    }

    private void a(String object, Path path) throws StepExecutionException {
        try {
            Path path2 = Files.createTempDirectory("helpDeskSetupWizardTempFiles", new FileAttribute[0]);
            String string = path2.toAbsolutePath().toString() + "\\SETUP.exe";
            object = string + (String)object;
            new k().b(path, path2);
            new CommandExecutor().executeCommand((String)object);
            IOFunctions.deleteDir((Path)path2);
        }
        catch (IOException iOException) {
            throw new StepExecutionException("Could not install Microsoft SQL Server Express.", (Throwable)iOException);
        }
        catch (CommandExecutor.UnsuccessfulExecutionException unsuccessfulExecutionException) {
            int n = unsuccessfulExecutionException.getExitStatus().orElse(0);
            if (n > 0) {
                String string = String.format("Could not install Microsoft SQL Server Express. The error code is %d", n);
                if (n == 3010) {
                    string = String.format("The SQL Server Express was successfully installed, but now the System must be restarted before we can continue. Please restart the server system and then go to this setup page again (open HelpDesk startpage, then add /setup in the browser address bar). Then follow the shown instructions.", n);
                }
                throw new StepExecutionException(string, (Throwable)unsuccessfulExecutionException);
            }
            throw new StepExecutionException("Could not install Microsoft SQL Server Express.", (Throwable)unsuccessfulExecutionException);
        }
    }

    private DatabaseConfigInfoW c(final String string, final String string2) {
        return new DatabaseConfigInfoW(){
            {
                this.setCatalog("InetHelpDesk");
                this.setPort(string);
                this.setDriver(DatabaseConfigInfo.DatabaseType.inetdae7);
                this.setHost("localhost");
                this.setUser("sa");
                this.setDecodedPassword(string2.toCharArray());
            }
        };
    }

    private boolean c(DatabaseSettings databaseSettings) {
        return databaseSettings != null && databaseSettings.isOptionInstallSQLExpressEnabled() && databaseSettings.isOptionInstallSQLExpressSelected();
    }

    private boolean d(DatabaseSettings databaseSettings) {
        j j2;
        return databaseSettings.databaseInfo().getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7 && "HELPDESK".equals(databaseSettings.databaseInfo().getPort()) && "localhost".equals(databaseSettings.databaseInfo().getHost()) && (j2 = new j()).Y() && j2.Z();
    }

    private void c(DatabaseConfigInfo databaseConfigInfo) {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        DatabaseConfigInfoList databaseConfigInfoList = DatabaseConfigInfoList.valueOf((String)configuration.get(HDConfigKeys.DB_CONFIGS.getKey()));
        DatabaseConfigInfo databaseConfigInfo2 = databaseConfigInfoList.get("HDS");
        if (databaseConfigInfo2 == null) {
            databaseConfigInfo2 = new DatabaseConfigInfo();
            databaseConfigInfo2.setDbName("HDS");
            databaseConfigInfoList.add((Object)databaseConfigInfo2);
        }
        databaseConfigInfo2.setCatalog(databaseConfigInfo.getCatalog());
        databaseConfigInfo2.setEncodedPassword(databaseConfigInfo.getEncodedPassword());
        databaseConfigInfo2.setDriver(databaseConfigInfo.getDriver());
        databaseConfigInfo2.setHost(databaseConfigInfo.getHost());
        databaseConfigInfo2.setPort(databaseConfigInfo.getPort());
        databaseConfigInfo2.setSid(databaseConfigInfo.getSid());
        databaseConfigInfo2.setCustomUrl(databaseConfigInfo.getCustomUrl());
        databaseConfigInfo2.setUser(databaseConfigInfo.getUser());
        configuration.put(HDConfigKeys.DB_CONFIGS.getKey(), new Json().toJson((Object)databaseConfigInfoList));
    }

    public InfoMessageGetter e(DatabaseSettings databaseSettings) {
        return () -> {
            String string = databaseSettings.databaseInfo().getCustomUrl();
            if (string != null && !string.isEmpty()) {
                return HelpDeskSetupWizardPlugin.MSG.getMsg("database.executionMessage.custom", new Object[]{string});
            }
            String string2 = null;
            DatabaseConfigInfoW databaseConfigInfoW = databaseSettings.databaseInfo();
            switch (databaseConfigInfoW.getDriver()) {
                case inetdae7: 
                case mysql: 
                case mariadb: {
                    string2 = databaseConfigInfoW.getCatalog();
                    break;
                }
                case inetora: {
                    string2 = databaseConfigInfoW.getUser();
                    break;
                }
                case other: {
                    string2 = databaseConfigInfoW.getUrl().startsWith("jdbc:inetora:") ? databaseConfigInfoW.getUser() : databaseConfigInfoW.getCatalog();
                    break;
                }
                default: {
                    SetupLogger.LOGGER.debug((Object)String.format("[Database] Unknown Driver: %s", databaseConfigInfoW.getDriver()));
                    return null;
                }
            }
            int n = databaseSettings.createNewUser() == 1 || databaseSettings.isOptionInstallSQLExpressSelected() ? 0 : 1;
            return HelpDeskSetupWizardPlugin.MSG.getMsg("database.executionMessage", new Object[]{n, string2, this.f(databaseSettings)});
        };
    }

    private String f(DatabaseSettings databaseSettings) {
        if (this.c(databaseSettings)) {
            return "localhost";
        }
        return databaseSettings.databaseInfo().getHost();
    }

    public SetupStepPriority getPriority() {
        return com.inet.helpdesk.plugins.setupwizard.steps.c.aZ;
    }

    public boolean hasPendingTasks() {
        try {
            Connection connection = this.x.getConnectionFromCurrentConfiguration();
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            return true;
        }
        return this.W();
    }

    public boolean W() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        DatabaseConfigInfoList databaseConfigInfoList = DatabaseConfigInfoList.valueOf((String)configuration.get(HDConfigKeys.DB_CONFIGS.getKey()));
        DatabaseConfigInfo databaseConfigInfo = databaseConfigInfoList.get("HDS");
        if (databaseConfigInfo == null) {
            return true;
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        String string = connectionFactory.testDBConnection(databaseConfigInfo.getUrl(), databaseConfigInfo.getDecodedPassword(), databaseConfigInfo.getUser(), databaseConfigInfo.getDriverClassName(), "HDS");
        return string != null;
    }

    public boolean g(DatabaseSettings databaseSettings) {
        DatabaseConfigInfoW databaseConfigInfoW = databaseSettings.databaseInfo();
        if (databaseConfigInfoW == null) {
            return false;
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        String string = connectionFactory.testDBConnection(databaseConfigInfoW.getUrl(), databaseConfigInfoW.getDecodedPassword(), databaseConfigInfoW.getUser(), databaseConfigInfoW.getDriverClassName(), "HDS");
        if (string == null) {
            return false;
        }
        String string2 = connectionFactory.testDBConnection(databaseConfigInfoW.getUrl(), databaseConfigInfoW.getDecodedPassword(), databaseConfigInfoW.getUser(), databaseConfigInfoW.getDriverClassName(), null);
        return string2 == null;
    }

    public String getStepDisplayName() {
        return HelpDeskSetupWizardPlugin.MSG.getMsg("database.displayname", new Object[0]);
    }

    public boolean h(DatabaseSettings databaseSettings) {
        return true;
    }

    public List<ServiceMethod<?, ?>> getServiceMethods() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new i());
        return arrayList;
    }

    public void a(b b2) {
        this.bW = b2;
    }

    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ALWAYS;
    }

    public /* synthetic */ StepConfiguration updateConfiguration(StepConfigurationStorage stepConfigurationStorage, StepsRepository stepsRepository, StepConfiguration stepConfiguration, StepKey stepKey) {
        return this.a(stepConfigurationStorage, stepsRepository, (DatabaseSettings)stepConfiguration, stepKey);
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.e((DatabaseSettings)stepConfiguration);
    }

    public /* synthetic */ void execute(StepConfiguration stepConfiguration, Map map) throws StepExecutionException {
        this.a((DatabaseSettings)stepConfiguration, map);
    }

    public /* synthetic */ SetupStepProblems findProblemsWithConfig(StepConfiguration stepConfiguration) {
        return this.a((DatabaseSettings)stepConfiguration);
    }

    public /* synthetic */ boolean willPerformIrreversibleMigration(StepConfiguration stepConfiguration) {
        return this.g((DatabaseSettings)stepConfiguration);
    }

    public /* synthetic */ boolean doesRequireToRestartServerAfterExecution(StepConfiguration stepConfiguration) {
        return this.h((DatabaseSettings)stepConfiguration);
    }
}

