clearreportsApp.run(function ($rootScope, promptFactory) {
    promptFactory.registerPromptCustomRenderer(function(prompt) {
        // See ReportsViewer.java
        if( prompt.promptRenderType == "prompttype_number" && (prompt.name == "UsrID" || prompt.name == "Benutzer" || prompt.name == "BenutzerID" || prompt.name == "Mitarbeiter")) {
            return '<userselectrenderer prompt="prompt" engineproperties="engineproperties" serializedvalues="serializedvalues"></userselectrenderer>';
        }
        return false;
    });
});

clearreportsApp.directive('userselectrenderer', function (promptFactory, $sce, dataservice, $timeout, $rootScope, keyservice) {
    
    var template =  '<div class="userselectrenderer">' +
                    '    <div class="userselected">' +
                    '       <span>{{$root.getMsg("promptdialog.userselect.selecteduser")}}</span>'+
                    '       <h4 ng-if="model.selectedUser==undefined" class="text-muted""><div class="spinner small muted"></div> {{$root.getMsg("promptdialog.userselect.selecteduser.loading")}}</h4>' +
                    '       <h4 ng-if="model.selectedUser!=undefined && model.selectedUser.hduid==undefined" class="text-muted">{{$root.getMsg("promptdialog.userselect.selecteduser.none")}}</h4>' +
                    '       <h4 ng-if="model.selectedUser!=undefined && model.selectedUser.hduid!=undefined" class="userentry"><img ng-if="model.selectedUser.guid != undefined" ng-src="{{$root.rootPath}}images/user/{{model.selectedUser.guid}}?applystate=true"> {{model.selectedUser.displayName}}</h4>' +
                    '    </div>' +
                    '    <form class="form form-horizontal dropdown userselectsearch" ng-class="{open:model.searchTags.length > 0 && model.searchHasFocus}">' +
                    '        <input class="form-control" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" type="text" ng-model="model.searchterm" ng-trim="false" ng-i18n="search">' + 
                    '        <span class="mouse-pointer icon-close-sm" style="position: absolute;right: 7px;top: 9px;" ng-click="clearSearch()" ng-show="model.searchterm.length>0"></span>' +
                    '        <ul class="dropdown-menu scrollable-search-menu" ng-if="model.searchTags.length>0">' + // scrollable-search-menu
                    '            <li ng-repeat="tag in model.searchTags"><a tabindex="-1" href="" ng-click="assignTag(tag)" ng-bind-html="getSearchTagLabel(tag)"></a></li>' +
                    '        </ul>' +
                    '    </form>' +
                    '    <div class="userselectlistcontainer">' +
                    '        <div class="userselectlist">' +
                    '            <h4 class="text-center" ng-if="model.users==undefined" ng-i18n="promptdialog.userselect.loading"></h4>' +
                    '            <h4 class="text-center" ng-if="model.users!=undefined && model.users.length == 0" ng-i18n="promptdialog.userselect.empty"></h4>' +
                    
                    '            <div ng-repeat-start="user in model.users" ng-if="hasAccountTypeName(user) && accountTypeChanged(model.users, $index)" class="userselectentryheader">' +
                    '                <div class="userselectentryheadertext">' +
                    '                    {{getAccountTypeName(user)}}' +
                    '                </div>' +
                    '            </div>' +
                    
                    '            <div class="userselectentry mouse-pointer" ng-repeat-end ng-click="selectUser(user)" ng-class="{\'selected\': isSelected(user)}">' +
                    '                <div class="userselectentryicon">' +
                    '                    <img ng-src="{{$root.rootPath}}images/user/{{user.guid}}?applystate=true">' +
                    '                </div>' +
                    '                <div class="userselectentrytext">' +
                    '                    <div class="userselectentryheading word-break" ng-bind-html="getTrusted(user.displayName)"></div>' +
                    '                    <div ng-if="user.otherDetail != undefined" class="userselectentryotherdetail text-muted word-break" ng-bind-html="getTrusted(user.otherDetail)"></div>' +
                    '                </div>' +
                    '            </div>' +
                    '            <h4 class="text-center" ng-if="model.users!=undefined && model.users.length > 0 && model.hasMore">{{$root.getMsg("promptdialog.userselect.hasMore", model.users.length)}}</h4>' +
                    '        </div>' +
                    '    </div>' +
                    '</div>';
    
    var linkFunction = function (scope, element, attrs) {
        
        scope.elem = undefined;
        
        scope.model = {
            searchTags: [],
            searchterm: '',
            searchHasFocus: false,
            escBlockFocus: false,
            requestNumber: 0,
            requestTagNumber: 0,
            users: undefined,
            hasMore: false,
            accountTypeNames: {},
            selectedUser: undefined
        };
        
        var tagsTimeout = undefined;
        var listTimeout = undefined;
        
        scope.selectUser = function(userEntry) {
            scope.prompt.value = {
                defaultValue: false,
                displayName: Util.fastHtml2text(userEntry.displayName),
                value: userEntry.hduid+""
            };
            scope.model.selectedUser = {
                guid: userEntry.guid,
                hduid: userEntry.hduid,
                displayName: Util.fastHtml2text(userEntry.displayName)
            }
        };
        
        scope.hasAccountTypeName = function(user) {
            return scope.getAccountTypeName(user).length > 0;
        };
        
        scope.accountTypeChanged = function(users, idx) {
            if(idx == 0) {
                return true;
            }
            return users[idx].accountType != users[idx-1].accountType;
        };
        
        scope.getAccountTypeName = function(user) {
            return scope.model.accountTypeNames[user.accountType];
        };
        
        scope.isSelected = function(userEntry) {
            if (scope.prompt.value == undefined) {
                return false;
            }
            return scope.prompt.value.value == userEntry.hduid+"";
        };
        
        scope.assignTag = function(tag) {
            var label = tag.key.substr( tag.key.indexOf( ':' ) + 1 );
            var lastIndex = scope.model.searchterm.lastIndexOf(':') + 1;
            if( lastIndex < 0 || label.toLowerCase().indexOf( scope.model.searchterm.substr(lastIndex).toLowerCase() ) != 0 ) {
                lastIndex = Math.max( scope.model.searchterm.lastIndexOf(' ') + 1, lastIndex );
            }
            if( label.indexOf(" ") >= 0 && tag.key.indexOf( "field:" ) != 0 ) {
                label = '\"' + label + '\"';
            }
            scope.model.searchterm = scope.model.searchterm.substr(0, lastIndex) + label;
            var searchInput = $(element).find("form input");
            searchInput.focus();
            if (searchInput[0].setSelectionRange !== undefined) {
                var strLength = searchInput.val().length;
                searchInput[0].setSelectionRange(strLength, strLength);
            } else {
                $(searchInput[0]).val(searchInput[0].value);
            }
        };
        
        scope.getSearchTagLabel = function(tag) {
            if( tag.key.indexOf( "field:" ) == 0 ) {
                return $sce.trustAsHtml($rootScope.getMsg("promptdialog.userselect.searchintag") + " <b>" + tag.label + "</b>");
            } else {
                return $sce.trustAsHtml("<b>" + tag.label + "</b>");
            }
        };
        
        scope.getTrusted = function(displayName) {
            return $sce.trustAsHtml(displayName);
        };
        
        scope.loadUserSelectList = function () {
            listTimeout = undefined;
            scope.model.requestNumber++;
            dataservice.execute('helpdeskreporting_userhandler', {
                data: JSON.stringify({
                    searchTerm: scope.model.searchterm == undefined ? "" : scope.model.searchterm,
                    requestNumber: scope.model.requestNumber,
                    searchID: "helpdeskreporting_userhandler",
                }),
                beforeExecute: function() {
                    
                },
                afterExecute: function() {
                    
                },
                handleSuccess: function (response) {
                    if(scope.model.requestNumber > response.responseNumber) {
                        return;
                    }
                    scope.model.users = response.users;
                    scope.model.hasMore = response.hasMore;
                    scope.model.accountTypeNames = response.accountTypeNames;
                }
            });
        };
        
        scope.loadUserSelectTags = function () {
            tagsTimeout = undefined;
            scope.model.requestTagNumber++;
            dataservice.execute('helpdeskreporting_userhandler', {
                data: JSON.stringify({
                    requestNumber: scope.model.requestTagNumber,
                    searchTerm: scope.model.searchterm == undefined ? "" : scope.model.searchterm,
                    searchID: "helpdeskreporting_userhandler_tags",
                    tagsOnly: true
                }),
                beforeExecute: function() {
                },
                afterExecute: function() {
                },
                handleSuccess: function (response) {
                    if(scope.model.requestTagNumber > response.responseNumber) {
                        return;
                    }
                    scope.model.searchTags = response.tags;
                }
            });
        };
        
        scope.clearSearch = function() {
            scope.model.searchterm = '';
            $timeout(function () {
                $(element).find("form input").focus();
            });
        };
        
        scope.$watch('model.searchterm', function(newValue, oldValue) {
            if(newValue != oldValue) {
                if(!scope.model.searchHasFocus) {
                    if(!scope.model.escBlockFocus) {
                        scope.model.searchHasFocus = true;
                    }
                }
            }
            if(tagsTimeout != undefined) {
                $timeout.cancel(tagsTimeout);
            }
            if(listTimeout != undefined) {
                $timeout.cancel(listTimeout);
            }
            tagsTimeout = $timeout(scope.loadUserSelectTags, 250);
            listTimeout = $timeout(scope.loadUserSelectList, 750);
            
            if (promptFactory.supportsTaskPlannerPlaceholders()) {
                var placeHolderStart = newValue.indexOf('{');
                if (placeHolderStart>=0) {
                    var placeHolderEnd = newValue.indexOf('}', placeHolderStart+1);
                    if (placeHolderEnd > placeHolderStart + 1) {
                        scope.prompt.value = {
                            defaultValue: false,
                            displayName: undefined,
                            value: newValue
                        };
                        scope.model.selectedUser = {
                            hduid: newValue,
                            guid: undefined,
                            displayName: newValue
                        }
                    }
                }
            }
        });
        
        $timeout(function() {
            var searchInput = $(element).find("form input");
            searchInput.on('focus', function (evt) {
                evt.preventDefault();
                evt.stopPropagation();
                if(scope.model.escBlockFocus == false) {
                    $timeout(function () {
                        scope.model.searchHasFocus = true;
                    });
                }
            });
            searchInput.on('blur', function (event, data) {
                var parents = $(event.relatedTarget || (event.originalEvent ? event.originalEvent.explicitOriginalTarget : undefined) || document.activeElement).parents();
                if (data != "escHandler" && parents.hasClass('userselectsearch')) {
                    return;
                }
                $timeout(function() {
                    if(scope.model.escBlockFocus == true && data != "escHandler") {
                        scope.model.escBlockFocus = false;
                    }
                    scope.model.searchHasFocus = false;
                });
                event.preventDefault();
                event.stopPropagation();
            });
            
            var keyDownHandler = function(evt) {
                if ($(evt.target).is($('.userselectsearch .scrollable-search-menu li:last a:focus'))) {
                    return true;
                }
                if ($(evt.target).is(searchInput)) {
                    if (scope.model.searchHasFocus == false) {
                        $timeout(function () {
                            scope.model.searchHasFocus = true;
                            scope.model.escBlockFocus = false;
                        });
                    } else {
                        $('.userselectsearch .scrollable-search-menu li:first a').focus();
                    }
                    return true;
                }
                if ($(evt.target).is($('.userselectsearch .scrollable-search-menu li a'))) {
                    $(evt.target).parent().next().find('a').focus();
                    return true;
                }
            };

            var keyUpHandler = function(evt) {
                if ($(evt.target).is($('.userselectsearch .scrollable-search-menu li:first a:focus'))) {
                    searchInput.focus();
                    return true;
                }
                if ($(evt.target).is(searchInput)) {
                    return true;
                }
                if ($(evt.target).is($('.userselectsearch .scrollable-search-menu li a'))) {
                    $(evt.target).parent().prev().find('a').focus();
                    return true;
                }
            };
            
            var escHandler = function(evt) {
                if ($('.userselectsearch .scrollable-search-menu:visible').length > 0) {
                    searchInput.trigger("blur", "escHandler");
                    $timeout(function () {
                        scope.model.escBlockFocus = true;
                        searchInput.focus();
                    });
                    return true;
                }
            };
            
            keyservice.registerKey(Key.UP, 0, keyUpHandler);
            keyservice.registerKey(Key.DOWN, 0, keyDownHandler);
            keyservice.registerKey(Key.ESC, 0, escHandler);
            
            scope.$on('$destroy', function(){
                keyservice.deregisterKey(Key.UP, 0, keyUpHandler);
                keyservice.deregisterKey(Key.DOWN, 0, keyDownHandler);
                keyservice.deregisterKey(Key.ESC, 0, escHandler);
            });
            
            
            scope.model.selectedUser = {
                hduid: undefined,
                guid: undefined,
                displayName: undefined
            };
            if (scope.prompt.value != undefined) {
                var value = scope.prompt.value.value;
                if (value != undefined && value.length>0) {
                    scope.model.selectedUser = undefined;
                    if(value == parseInt(value)) {
                        dataservice.execute('helpdeskreporting_userhandlerdetails', {
                            data: JSON.stringify({
                                hduid: value
                            }),
                            beforeExecute: function() {},
                            afterExecute: function() {},
                            handleSuccess: function (response) {
                                scope.model.selectedUser = response;
                            }
                        });
                    } else {
                        
                        // PromptType must be number, otherwise this renderer is not used. so the string "null" is not a valid value and should be ignored
                        if ("null" == value) {
                            scope.prompt.value.value=null;
                            scope.model.selectedUser = {
                                hduid: undefined,
                                guid: undefined,
                                displayName: undefined
                            }
                        } else {
                            scope.model.searchterm = value;
                            scope.model.selectedUser = {
                                hduid: value,
                                guid: undefined,
                                displayName: value
                            }
                        }
                    }
                }
            }
            
        });
            
    }
        return {
            restrict: 'E',
            replace: true,
            scope: {
                prompt: "=",
                engineproperties: "=",
                serializedvalues: "="
            },
            link: linkFunction,
            template: template
        }
    });