/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.timeline;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.timeline.PeriodOfTime;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;

public class TimelineUtilities {
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final int DEFAULT_HOURS_PER_WORKINGDAY = 9;
    private static final int DEFAULT_START_HOUR = 8;
    private static boolean configValuesInitialized = false;
    protected static final ExecutionType[] ESCALATION_TYPES = new ExecutionType[]{ExecutionType.ESCALATION, ExecutionType.ESCALATION_WARNING_RED, ExecutionType.ESCALATION_WARNING_YELLOW};
    protected static final ExecutionType[] DEADLINE_TYPES = new ExecutionType[]{ExecutionType.DEADLINE, ExecutionType.DEADLINE_WARNING_RED, ExecutionType.DEADLINE_WARNING_YELLOW};
    protected static final ConfigValue<Integer> ESCALATION_WARNING_ACTION = new ConfigValue<Integer>(HDConfigKeys.ESCALATION_WARNING_ACTION){

        protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (configValuesInitialized) {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();){
                    HDLogger.info("Escalation warning action settings changed!!!!");
                    ((TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class)).checkEscalationDataForExecutions(con);
                }
                catch (Exception ex) {
                    HDLogger.error(ex);
                }
            }
        }
    };
    private static final ConfigValue<Double> TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD = new ConfigValue<Double>(HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD){

        protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (configValuesInitialized) {
                TimelineUtilities.baseSettingsChanged(true, false);
            }
        }
    };
    private static final ConfigValue<Double> TICKET_WARNING_RED_ESCALATION_THRESHOLD = new ConfigValue<Double>(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD){

        protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (configValuesInitialized) {
                TimelineUtilities.baseSettingsChanged(true, false);
            }
        }
    };
    private static final ConfigValue<Double> TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD = new ConfigValue<Double>(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD){

        protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (configValuesInitialized) {
                TimelineUtilities.baseSettingsChanged(false, true);
            }
        }
    };
    private static final ConfigValue<Double> TICKET_WARNING_RED_DEADLINE_THRESHOLD = new ConfigValue<Double>(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD){

        protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (configValuesInitialized) {
                TimelineUtilities.baseSettingsChanged(false, true);
            }
        }
    };
    private static List<PeriodOfTime> nonWorkingDays = null;
    private static long lastModified = Integer.MIN_VALUE;

    public static List<PeriodOfTime> readFeiertage() {
        try {
            File targ = new File(AppDataLocation.getBaseLocationPath().toFile(), "Feiertage.txt");
            if (targ.exists() && lastModified != targ.lastModified()) {
                int i;
                lastModified = targ.lastModified();
                Calendar calendar = Calendar.getInstance();
                ArrayList<PeriodOfTime> ferien = new ArrayList<PeriodOfTime>();
                HDLogger.info("Read holiday settings from \"Feiertage.txt\"");
                FileInputStream is = new FileInputStream(targ);
                byte[] buf = new byte[is.available()];
                is.read(buf);
                is.close();
                for (i = 0; i < buf.length; ++i) {
                    if (buf[i] != 35 || i != 0 && buf[i - 1] != 10) continue;
                    for (int n = i; n < buf.length && buf[n] != 10; ++n) {
                        buf[n] = 32;
                    }
                }
                for (i = 0; i < buf.length; ++i) {
                    if (buf[i] <= 57 && buf[i] >= 45) continue;
                    buf[i] = 32;
                }
                Date zeitRaumPuffer = null;
                for (int i2 = 0; i2 < buf.length; ++i2) {
                    boolean zeitRaum;
                    if (buf[i2] <= 47 || i2 != 0 && buf[i2 - 1] >= 46) continue;
                    int end = buf.length;
                    for (int n = i2 + 1; n < buf.length; ++n) {
                        if (buf[n] >= 46) continue;
                        end = n;
                        break;
                    }
                    boolean bl = zeitRaum = end < buf.length - 5 && buf[end] == 45 && buf[end + 1] > 47;
                    if (TimelineUtilities.testValid(calendar, buf, i2, end, zeitRaum)) {
                        if (zeitRaum) {
                            zeitRaumPuffer = calendar.getTime();
                            continue;
                        }
                        if (zeitRaumPuffer == null) {
                            zeitRaumPuffer = calendar.getTime();
                        }
                        calendar.add(6, 1);
                        ferien.add(new PeriodOfTime(zeitRaumPuffer, calendar.getTime()));
                        zeitRaumPuffer = null;
                        continue;
                    }
                    zeitRaumPuffer = null;
                }
                Collections.sort(ferien, new Comparator<PeriodOfTime>(){

                    @Override
                    public int compare(PeriodOfTime o1, PeriodOfTime o2) {
                        return o1.compare(o2);
                    }
                });
                if (HDLogger.isDebug()) {
                    TimelineUtilities.printListContent("Feiertage.txt", ferien);
                }
                HDLogger.info("Init new list of non working days.");
                nonWorkingDays = Collections.unmodifiableList(ferien);
            } else if (!(targ.exists() || nonWorkingDays != null && nonWorkingDays.size() <= 0)) {
                HDLogger.info("Init empty list of non working days.");
                nonWorkingDays = Collections.unmodifiableList(new ArrayList());
            }
        }
        catch (FileNotFoundException e) {
            HDLogger.error(e);
        }
        catch (IOException e) {
            HDLogger.error(e);
        }
        return nonWorkingDays;
    }

    protected static void baseSettingsChanged(boolean escalation, boolean deadline) {
        if (escalation) {
            ((TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class)).resetEscalationData();
        }
        if (deadline) {
            ((TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class)).resetDeadlineData();
        }
    }

    protected static int findDatePosition(List<PeriodOfTime> periods, Date toFind, boolean defaultFirstAfter) {
        for (int i = 0; i < periods.size(); ++i) {
            PeriodOfTime pt = periods.get(i);
            if (pt.isInPeriod(toFind)) {
                return i;
            }
            if (!defaultFirstAfter || !pt.isBeforePeriod(toFind)) continue;
            return i;
        }
        return -1;
    }

    private static boolean testValid(Calendar calendar, byte[] buf, int firstSign, int afterLastSign, boolean zeitraumTest) {
        int monat;
        int tag;
        calendar.setTimeInMillis(System.currentTimeMillis());
        int firstSep = -1;
        int secondSep = -1;
        if (firstSign + 6 > afterLastSign) {
            return false;
        }
        for (int i = firstSign + 1; i < afterLastSign; ++i) {
            if (buf[i] >= 48) continue;
            if (firstSep == -1) {
                firstSep = i;
                continue;
            }
            if (secondSep == -1) {
                secondSep = i;
                continue;
            }
            return false;
        }
        if (firstSep == -1 || secondSep == -1 || buf[firstSep] != buf[secondSep] || secondSep == firstSep + 1) {
            return false;
        }
        if (firstSep > firstSign + 2 || secondSep > firstSep + 3) {
            return false;
        }
        if (afterLastSign - secondSep != 3 && afterLastSign - secondSep != 5) {
            return false;
        }
        if (buf[firstSep] == 46) {
            tag = TimelineUtilities.getZahl(buf, firstSign, firstSep);
            monat = TimelineUtilities.getZahl(buf, firstSep + 1, secondSep);
        } else {
            monat = TimelineUtilities.getZahl(buf, firstSign, firstSep);
            tag = TimelineUtilities.getZahl(buf, firstSep + 1, secondSep);
        }
        int jahr = TimelineUtilities.getZahl(buf, secondSep + 1, afterLastSign);
        if (jahr < 1000) {
            jahr += 2000;
        }
        if (tag > 31 || monat > 12) {
            return false;
        }
        if (!zeitraumTest) {
            if (calendar.get(1) - 1 > jahr) {
                return false;
            }
            if (calendar.get(1) - 1 == jahr && calendar.get(2) > monat) {
                return false;
            }
        }
        try {
            calendar.set(1, jahr);
            calendar.set(2, monat - 1);
            calendar.set(5, tag);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static int getZahl(byte[] buf, int firstSign, int afterLastSign) {
        int retval = 0;
        for (int i = firstSign; i < afterLastSign; ++i) {
            retval = retval * 10 + buf[i] - 48;
        }
        return retval;
    }

    protected static ArrayList<PeriodOfTime> createDefaultWorkingPeriods() {
        ArrayList<PeriodOfTime> weekHours = new ArrayList<PeriodOfTime>();
        long start = 28800000L;
        weekHours.add(new PeriodOfTime(new Date(start), new Date(start + 32400000L)));
        weekHours.add(new PeriodOfTime(new Date(start += 86400000L), new Date(start + 32400000L)));
        weekHours.add(new PeriodOfTime(new Date(start += 86400000L), new Date(start + 32400000L)));
        weekHours.add(new PeriodOfTime(new Date(start += 86400000L), new Date(start + 32400000L)));
        weekHours.add(new PeriodOfTime(new Date(start += 86400000L), new Date(start + 32400000L)));
        return weekHours;
    }

    protected static ArrayList<PeriodOfTime> getResourceAttendanceTimes(int resourceId) {
        UserGroupInfo resource = HDUsersAndGroups.getResource(resourceId);
        ResourceFieldWorkingHours.WorkingHours wh = (ResourceFieldWorkingHours.WorkingHours)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
        ArrayList<PeriodOfTime> weekHours = new ArrayList<PeriodOfTime>();
        long dayOffset = 0L;
        long calcualtedTime = 0L;
        for (DayOfWeek day : DayOfWeek.values()) {
            ResourceFieldWorkingHours.HourRange dayRange = wh.getHourRange(day);
            if (dayRange != null) {
                long start = dayOffset + TimelineUtilities.calcMilis(dayRange.getStart());
                long end = dayOffset + TimelineUtilities.calcMilis(dayRange.getEnd());
                calcualtedTime += end - start;
                weekHours.add(new PeriodOfTime(new Date(start), new Date(end)));
            }
            dayOffset += 86400000L;
        }
        if (calcualtedTime < 3600000L) {
            weekHours = TimelineUtilities.createDefaultWorkingPeriods();
        }
        return weekHours;
    }

    protected static boolean compareWorkingHours(List<PeriodOfTime> someAttendanceTimes, List<PeriodOfTime> otherAttendanceTimes) {
        if (someAttendanceTimes != null && otherAttendanceTimes != null) {
            if (someAttendanceTimes == otherAttendanceTimes) {
                return true;
            }
            if (someAttendanceTimes.size() == otherAttendanceTimes.size()) {
                for (int i = 0; i < someAttendanceTimes.size(); ++i) {
                    if (someAttendanceTimes.get(i).compare(otherAttendanceTimes.get(i)) == 0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static long calcMilis(LocalTime localTime) {
        long time = (long)localTime.getHour() * 3600000L;
        time += (long)localTime.getMinute() * 60000L;
        return time += (long)localTime.getSecond() * 1000L;
    }

    protected static double getMaximumTimelineRange() {
        double maxThreshold;
        double maxDead;
        double valueYellowEsca = (Double)TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD.get();
        double valueRedEsca = (Double)TICKET_WARNING_RED_ESCALATION_THRESHOLD.get();
        double valueYellowDead = (Double)TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD.get();
        double valueRedDead = (Double)TICKET_WARNING_RED_DEADLINE_THRESHOLD.get();
        double maxEsca = Math.max(valueYellowEsca, valueRedEsca);
        if (maxEsca > 1000.0 || valueRedEsca > valueYellowEsca && valueYellowEsca != 0.0) {
            HDLogger.error("Invalid escalation threshold values yellow " + valueYellowEsca + " red " + valueRedEsca);
            maxEsca = 0.0;
        }
        if ((maxDead = Math.max((Double)TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD.get(), (Double)TICKET_WARNING_RED_DEADLINE_THRESHOLD.get())) > 1000.0 || valueRedDead > valueYellowDead && valueYellowDead != 0.0) {
            HDLogger.error("Invalid deadline threshold valus yellow " + valueYellowDead + " red " + valueRedDead);
            maxDead = 0.0;
        }
        double max = 0.0;
        for (PriorityVO prio : PriorityManager.getInstance().getAll(true)) {
            max = Math.max(max, prio.getDeadline());
            max = Math.max(max, prio.getEscalationTimeout());
        }
        configValuesInitialized = true;
        if (max > 1000.0) {
            HDLogger.error("Invalid period value " + max);
            max = 1000.0;
        }
        if ((maxThreshold = Math.max(maxEsca, maxDead)) > max) {
            HDLogger.info("Threshold bigger than max period values " + maxThreshold + " " + max);
            return maxThreshold;
        }
        return max;
    }

    public static double getThresholdPeriodFor(ExecutionType type) {
        double valueYellowEsca = (Double)TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD.get();
        double valueRedEsca = (Double)TICKET_WARNING_RED_ESCALATION_THRESHOLD.get();
        double valueYellowDead = (Double)TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD.get();
        double valueRedDead = (Double)TICKET_WARNING_RED_DEADLINE_THRESHOLD.get();
        switch (type) {
            case ESCALATION_WARNING_YELLOW: {
                if (!(valueYellowEsca > 0.0) || !(Math.max(valueYellowEsca, valueRedEsca) <= 1000.0) || !(valueRedEsca > 0.0) || !(valueYellowEsca > valueRedEsca)) break;
                return valueYellowEsca;
            }
            case ESCALATION_WARNING_RED: {
                if (!(valueRedEsca > 0.0) || !(Math.max(valueYellowEsca, valueRedEsca) <= 1000.0) || !(valueYellowEsca > valueRedEsca) && valueYellowEsca != 0.0) break;
                return valueRedEsca;
            }
            case DEADLINE_WARNING_YELLOW: {
                if (!(valueYellowDead > 0.0) || !(Math.max(valueYellowDead, valueRedDead) <= 1000.0) || !(valueRedDead > 0.0) || !(valueYellowDead > valueRedDead)) break;
                return valueYellowDead;
            }
            case DEADLINE_WARNING_RED: {
                if (!(valueRedDead > 0.0) || !(Math.max(valueYellowDead, valueRedDead) <= 1000.0) || !(valueYellowDead > valueRedDead) && valueYellowDead != 0.0) break;
                return valueRedDead;
            }
        }
        return 0.0;
    }

    protected static void printListContent(String was, List<PeriodOfTime> periodList) {
        HDLogger.debug("############################################## " + was + " ######################################");
        for (PeriodOfTime pt : periodList) {
            HDLogger.debug(pt);
        }
    }

    public static enum ExecutionType {
        ESCALATION,
        ESCALATION_WARNING_RED,
        ESCALATION_WARNING_YELLOW,
        DEADLINE,
        DEADLINE_WARNING_RED,
        DEADLINE_WARNING_YELLOW;

    }
}

