/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.userfields;

import com.inet.classloader.translations.TranslationKey;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.field.ConfigurableField;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.fieldsettings.user.model.UserFieldCustom;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.user.fields.UserFieldOpen;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.SearchTag;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UF_Editability;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class UserFieldSettingManagerHD
extends UserFieldSettingsManager {
    protected String setSpecificDefaultValues(UserFieldDefinition def, Map<String, String> properties) {
        String defaultValue = super.setSpecificDefaultValues(def, properties);
        if (def == null) {
            properties.putIfAbsent("showFieldForNewUser", "false");
            SqlQuerySelectValueProvider.setDefaultValuesForSqlProperties(properties);
        } else {
            ArrayList<String> defaultActivatedKeys = new ArrayList<String>();
            defaultActivatedKeys.add(UsersAndGroups.FIELD_EMAIL.getKey());
            defaultActivatedKeys.add(UsersAndGroups.FIELD_FIRSTNAME.getKey());
            defaultActivatedKeys.add(UsersAndGroups.FIELD_LASTNAME.getKey());
            defaultActivatedKeys.add(HDUsersAndGroups.FIELD_CLASS_ID.getKey());
            defaultActivatedKeys.add(HDUsersAndGroups.FIELD_LOCATION_ID.getKey());
            if (defaultActivatedKeys.contains(def.getFieldKey())) {
                properties.putIfAbsent("showFieldForNewUser", "true");
            } else {
                properties.putIfAbsent("showFieldForNewUser", "false");
            }
        }
        return defaultValue;
    }

    protected void handleUnknownRegisteredField(GenericFieldSetting setting) {
        if (UserFieldOpen.isOpenField(setting.getKey())) {
            if (!setting.isCustom()) {
                String key = setting.getKey();
                HDLogger.info("[Update] Convert open user field " + key + " to custom format.");
                HashMap<String, String> rowProps = new HashMap<String, String>();
                rowProps.put("fieldsettingsKey", key);
                rowProps.put("type", key.equals("custom6") ? FieldSettingsType.TYPE_MULTILINE_TEXT.toString() : FieldSettingsType.TYPE_TEXT.toString());
                rowProps.put("sortPrio", String.valueOf(setting.getSortPriority()));
                rowProps.putAll(setting.getSpecificProperties());
                TranslationKey baseKey = HDFieldDisplayNameProvider.getFieldDisplayNameKey(key);
                String fieldLabelsJson = new Json().toJson((Object)setting.loadLabelsFromResourceManager(baseKey));
                TranslationKey descriptionKey = new TranslationKey(baseKey.pluginId, baseKey.bundleName, baseKey.language, baseKey.key + ".description");
                String fieldDescriptionsJson = new Json().toJson((Object)setting.loadLabelsFromResourceManager(descriptionKey));
                GenericFieldSetting newSetting = new GenericFieldSetting(key, true, setting.getDefaultValue(), (GenericFieldNature)new CustomNature(rowProps), rowProps);
                Map.Entry customField = this.saveNewCustomSetting(key, newSetting);
                this.registerTranslationKeys((ConfigurableField)((UserFieldDefinition)customField.getKey()));
                this.updateLabelsOfField(fieldLabelsJson, fieldDescriptionsJson, newSetting);
                this.updateConfigurableValuesOfField((UserFieldDefinition)customField.getKey(), newSetting);
            }
        } else {
            super.handleUnknownRegisteredField(setting);
        }
    }

    public void init() {
        super.init();
        if (this.getSetting("custom1") == null) {
            List<String> toadd = List.of("department", "custom1", "custom2", "custom3", "custom4", "custom5", "custom6");
            for (String key : toadd) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("fieldsettingsKey", key);
                properties.put("sortPrio", String.valueOf(140 + toadd.indexOf(key) * 10));
                properties.put("type", key.equals("custom6") ? FieldSettingsType.TYPE_MULTILINE_TEXT.toString() : FieldSettingsType.TYPE_TEXT.toString());
                Map<String, String> translations = Map.of("default", HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(key, Locale.ENGLISH), "de", HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(key, Locale.GERMAN));
                properties.put("users_visibility", UF_Visibility.VISIBLE_ONLY_FOR_USER_MANAGER.toString());
                properties.put("users_editability", UF_Editability.ONLY_USER_MANAGER_CAN_CHANGE.toString());
                GenericFieldSetting setting = new GenericFieldSetting(key, true, "", (GenericFieldNature)new CustomNature(properties), properties);
                Map.Entry customField = this.saveNewCustomSetting(key, setting);
                this.registerTranslationKeys((ConfigurableField)((UserFieldDefinition)customField.getKey()));
                this.updateLabelsOfField(new Json().toJson(translations), new Json().toJson(Map.of()), setting);
                this.updateConfigurableValuesOfField((UserFieldDefinition)customField.getKey(), setting);
            }
        }
    }

    protected <T> UserFieldCustom<T> createUserField(GenericFieldSetting setting) {
        if (UserFieldOpen.isOpenField(setting.getKey())) {
            return new UserFieldOpen(setting);
        }
        return super.createUserField(setting);
    }

    protected <T> Map.Entry<UserFieldDefinition, UserField<?>> createAndRegisterForCustom(GenericFieldSetting setting) {
        Map.Entry result = super.createAndRegisterForCustom(setting);
        AbstractTicketFieldDefinitionForTicketOwner extra = new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition)result.getKey(), 200 + setting.getSortPriority());
        DynamicExtensionManager.getInstance().register(TicketFieldDefinition.class, (Object)extra);
        return result;
    }

    protected UserField unregisterForCustom(GenericFieldSetting setting) {
        UserField result = super.unregisterForCustom(setting);
        String ownerFieldkey = "ticketowner." + setting.getKey();
        DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).forEach(def -> {
            if (ownerFieldkey.equals(def.getFieldKey())) {
                DynamicExtensionManager.getInstance().unregister(TicketFieldDefinition.class, def);
                return;
            }
        });
        return result;
    }

    protected void sendExternalSignal(List<UserField<?>> removedInfos, List<UserField<?>> addedInfos) {
        List<String> tags;
        super.sendExternalSignal(removedInfos, addedInfos);
        List removedSearchTags = removedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List addedSearchTags = addedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!addedInfos.isEmpty()) {
            tags = addedSearchTags.stream().map(SearchTag::getTag).toList();
            JoinTokenMatcher.addToIndex(TicketManager.getReader().getSearchEngine(), (String)"ownerid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), tags, (boolean)true);
        }
        if (!removedSearchTags.isEmpty()) {
            tags = removedSearchTags.stream().map(SearchTag::getTag).toList();
            JoinTokenMatcher.removeFromIndex(TicketManager.getReader().getSearchEngine(), (String)"ownerid", tags);
        }
    }

    public List<ConfigValidationMsg> validate(String key, Map<String, String> properties, boolean willBeNewField) {
        FieldSettingsType type;
        List list = super.validate(key, properties, willBeNewField);
        SqlQuerySelectValueProvider.validateSQLQuery(properties, list);
        String typeStr = properties.get("type");
        if (typeStr != null && (type = FieldSettingsType.valueOf((String)typeStr)) == FieldSettingsType.TYPE_LINK && UserFieldOpen.isOpenField(key)) {
            list.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, TicketFieldSettingsManager.MSG.getMsg("fields.validation.openFieldCannotBeLink", new Object[]{type.getLabel()}), "type"));
        }
        return list;
    }

    public void deleteCustomSetting(String key) {
        if (UserFieldOpen.isOpenField(key)) {
            throw new IllegalArgumentException("Cannot delete open fields 1-6");
        }
        super.deleteCustomSetting(key);
    }
}

