/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.rpc;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.shared.http.upload.AttachmentType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonData
public class LargeContent {
    private transient byte[] memoryContent;
    private transient InputStreamProvider streamProvider;
    private String name;
    private long lastModified;
    private AttachmentType contentType;

    private LargeContent() {
    }

    public LargeContent(byte[] memoryContent) {
        this.memoryContent = memoryContent;
    }

    public LargeContent(InputStreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    public void setStreamProvider(InputStreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    public InputStreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    public long getSize() {
        if (this.streamProvider != null) {
            return this.streamProvider.getSize();
        }
        if (this.memoryContent != null) {
            return this.memoryContent.length;
        }
        return -1L;
    }

    public InputStream getContent() throws IOException {
        if (this.streamProvider != null) {
            return this.streamProvider.getStream();
        }
        if (this.memoryContent != null) {
            return new ByteArrayInputStream(this.memoryContent);
        }
        throw new IOException("There is no content in LargeContent object '" + this.name + "'");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public static List<LargeContent> getLargeContent(Object data) {
        ArrayList<LargeContent> parts = new ArrayList<LargeContent>();
        if (data == null) {
            return parts;
        }
        if (data instanceof LargeContent) {
            parts.add((LargeContent)data);
        } else if (data.getClass().isArray()) {
            Object[] ar;
            for (Object value : ar = (Object[])data) {
                Type[] types;
                if (value instanceof LargeContent) {
                    parts.add((LargeContent)value);
                    continue;
                }
                if (value instanceof LargeContent[]) {
                    for (LargeContent lc : (LargeContent[])value) {
                        parts.add(lc);
                    }
                    continue;
                }
                if (!(value instanceof List) || (types = value.getClass().getGenericInterfaces()) == null || types.length != 1 || types[0] != LargeContent.class) continue;
                for (LargeContent lc : (List)value) {
                    parts.add(lc);
                }
            }
        }
        return parts;
    }

    public AttachmentType getContentType() {
        if (this.contentType == null) {
            return AttachmentType.Unknown;
        }
        return this.contentType;
    }

    public void setContentType(AttachmentType contentType) {
        this.contentType = contentType;
    }

    public static ArrayList<LargeContent> getAttachmentsAsList(LargeContent[] attachments) {
        ArrayList<LargeContent> arrayList = new ArrayList<LargeContent>();
        Collections.addAll(arrayList, attachments);
        return arrayList;
    }

    @InternalApi
    public static interface InputStreamProvider {
        public long getSize();

        public InputStream getStream();
    }
}

