/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class HDFileUrlPermissionChecker
implements PluginPermissionChecker {
    public boolean checkExecutePermission(@Nonnull URL url) throws AccessDeniedException {
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Does not read file, just checks name")
    public boolean checkReportLocation(@Nonnull URL url) throws AccessDeniedException {
        String protocol = url.getProtocol();
        if (protocol.equals("file") || protocol.equals("persistence")) {
            String path;
            if (protocol.equals("file") && Persistence.getInstance() instanceof FilePersistence) {
                FilePersistence instance = (FilePersistence)Persistence.getInstance();
                String path2 = URLDecoder.decode(url.getPath(), Charset.forName("UTF-8"));
                Path persistenceFolder = instance.getPersistenceFolder();
                Path printDir = persistenceFolder.resolve("print");
                if (new File(path2).toPath().startsWith(printDir)) {
                    return true;
                }
            } else if (protocol.equals("persistence") && (path = URLDecoder.decode(url.getPath(), Charset.forName("UTF-8"))).startsWith(Persistence.getInstance().resolve("print").getPath())) {
                return true;
            }
            throw new AccessDeniedException(url);
        }
        return false;
    }
}

