/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TicketFieldClassificationId
extends TicketField<Integer>
implements HasSelectOptions {
    public static final String KEY = "classificationid";
    public static final Integer DEFAULT_ID = 0;

    public TicketFieldClassificationId() {
        super(KEY, DEFAULT_ID, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Integer> createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), (HasSelectOptions)this);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }

    @Override
    public void validateIsValidValue(Integer value) {
        super.validateIsValidValue(value);
        BasicFieldValidation.throwIfFieldValueDoesNotExist(ClassificationManager.getInstance().get(value), (Object)value, (String)this.getLabel());
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        Object oldCategoryVO = ClassificationManager.getInstance().get(fieldValue);
        if (oldCategoryVO != null) {
            return ((FieldVO)oldCategoryVO).getDisplayValue();
        }
        return null;
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -28;
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        Map<Integer, String> pathNames = ClassificationManager.getInstance().getAllAttributeDisplayNames(!includeDeleted);
        ArrayList<SelectOption> list = new ArrayList<SelectOption>(pathNames.size());
        pathNames.forEach((key, path) -> list.add(new SelectOption(key.toString(), path)));
        return list;
    }
}

