/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.helpdesk.config.mailtemplates.data.LoadMailTemplatesRequest;
import com.inet.helpdesk.config.mailtemplates.data.LoadMailTemplatesResponse;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplateDescription;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplatesHelper;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;

public class LoadMailTemplates
extends ServiceMethod<LoadMailTemplatesRequest, LoadMailTemplatesResponse> {
    public String getMethodName() {
        return "mailtemplates.loadmailtemplates";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadMailTemplatesResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadMailTemplatesRequest payload) throws IOException {
        ArrayList<String> listTemplates = MailTemplatesManager.listTemplates(payload.getSet(), payload.getLang());
        ArrayList<MailTemplateDescription> templates = MailTemplatesHelper.templateStringToDescription(listTemplates, payload.getSet(), payload.getLang());
        MailTemplatesHelper.filterTemplateDescriptions(payload.getSearchTerm(), templates);
        LoadMailTemplatesResponse mailTemplatesResponse = new LoadMailTemplatesResponse(templates);
        mailTemplatesResponse.setAvailableLang(MailTemplatesManager.listLanguages(payload.getSet()));
        return mailTemplatesResponse;
    }
}

