/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.helpdesk.config.autotext.LoadAutoTextUtil;
import com.inet.helpdesk.config.autotext.data.AutoTextEntry;
import com.inet.helpdesk.config.autotext.data.AvailableAutoTextsRequest;
import com.inet.helpdesk.config.autotext.data.AvailableAutoTextsResponse;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LoadAvailableAutoTexts
extends ServiceMethod<AvailableAutoTextsRequest, AvailableAutoTextsResponse> {
    public String getMethodName() {
        return "autotext.loadavailableautotexts";
    }

    public short getMethodType() {
        return 1;
    }

    public AvailableAutoTextsResponse invoke(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, AvailableAutoTextsRequest payload) throws IOException {
        List<AutoTextEntry> entries = LoadAutoTextUtil.getAutoTextEntries(payload.getFilter(), payload.getSearchfilter());
        Set userGroups = entries.stream().map(AutoTextEntry::getGroupLabel).collect(Collectors.toSet());
        List<String> groups = ((AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class)).getAutoTextGroups();
        groups.retainAll(userGroups);
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        boolean userIsAdmin = currentUserAccount != null ? currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator) : false;
        boolean userHasPermission = currentUserAccount != null ? SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION}) : false;
        Set groupsForUser = currentUserAccount != null ? UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID()) : new HashSet();
        boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean isSupporterGroup = currentUserAccount != null ? HDUsersAndGroups.isSupporter(currentUserAccount) : false;
        boolean canAccess = userIsAdmin || isAdminGroup || userHasPermission || isSupporterGroup;
        Collections.sort(entries, (a, b) -> a.getLabel().compareToIgnoreCase(b.getLabel()));
        Collections.sort(groups, (a, b) -> {
            if (StringFunctions.isEmpty((String)a)) {
                if (!StringFunctions.isEmpty((String)b)) {
                    return 1;
                }
            } else if (StringFunctions.isEmpty((String)b)) {
                return -1;
            }
            return a.compareToIgnoreCase((String)b);
        });
        AvailableAutoTextsResponse availableAutoTextsResponse = new AvailableAutoTextsResponse(entries, groups);
        availableAutoTextsResponse.setUserHasPermission(canAccess);
        availableAutoTextsResponse.setUserIsAdmin(userIsAdmin || isAdminGroup);
        return availableAutoTextsResponse;
    }
}

