/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.helpdesk.config.FieldMappingEntry;
import java.util.ArrayList;
import java.util.List;

public class FieldMapping {
    public static final String USERNAME = "Username";
    public static final String ALTERNATIVE_USERNAME = "SecondUsername";
    public static final String SURNAME = "Nachname";
    public static final String GIVENNAME = "Vorname";
    public static final String SUPERVISOR = "Supervisor";
    public static final String EMAIL = "Email";
    public static final String LOCATION = "GebID";
    public static final String USERGROUP = "BgrID";
    public static final String[] DB_COLUMNS = new String[]{"Username", "Nachname", "Vorname", "GebID", "BgrID", "Telefon", "Zimmer", "Abteilung", "Email", "Kostenstelle", "Frei1", "Frei2", "Frei3", "Frei4", "Frei5", "Frei6"};

    public static ArrayList<FieldMappingEntry> createFieldList(String in) {
        int end;
        ArrayList<FieldMappingEntry> fieldList = new ArrayList<FieldMappingEntry>();
        int start = 0;
        int writepos = 0;
        while ((end = in.indexOf("<>", start)) > -1) {
            fieldList.add(new FieldMappingEntry(DB_COLUMNS[writepos++], in.substring(start, end).trim()));
            start = end + 2;
        }
        fieldList.add(new FieldMappingEntry(DB_COLUMNS[writepos], in.substring(start).trim()));
        fieldList.add(1, new FieldMappingEntry(ALTERNATIVE_USERNAME, ""));
        return fieldList;
    }

    public static List<FieldMappingEntry> validateFieldList(List<FieldMappingEntry> neededAttributesOrColumns) {
        return new ArrayList<FieldMappingEntry>(neededAttributesOrColumns);
    }

    public static int getColumnSize(String columnName) {
        switch (columnName) {
            case "Frei1": 
            case "Frei2": 
            case "Frei3": 
            case "Frei4": 
            case "Frei5": 
            case "GebID": 
            case "BgrID": {
                return 255;
            }
            case "Abteilung": 
            case "Email": 
            case "Frei6": {
                return 100;
            }
            case "Nachname": 
            case "Vorname": 
            case "Telefon": 
            case "Zimmer": 
            case "Kostenstelle": {
                return 50;
            }
        }
        return -1;
    }
}

