/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VCardPackageAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    @Override
    public String getType() {
        return "vcard";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        block52: {
            try {
                PersistenceEntry file;
                AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
                if (attachmentFile == null || !(file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath())).exists()) break block52;
                FastByteArrayOutputStream cache = new FastByteArrayOutputStream();
                try (InputStream input = file.getInputStream();){
                    IOFunctions.copyData((InputStream)input, (OutputStream)cache);
                }
                input = new FastByteArrayInputStream(cache.toByteArray());
                try {
                    String string;
                    boolean streamEnded = false;
                    boolean vCardStarted = false;
                    boolean inBase64Data = false;
                    VCardData vcard = new VCardData();
                    HashMap<String, String> commandMap = new HashMap<String, String>();
                    commandMap.put("adr", "address");
                    commandMap.put("tel", "telephone");
                    commandMap.put("email", "email");
                    commandMap.put("url", "url");
                    block20: while (!streamEnded) {
                        String encoding;
                        String cmdMediaType;
                        Object value;
                        int ch;
                        StringBuilder commandBuffer = new StringBuilder();
                        boolean lineEnded = false;
                        while (true) {
                            if ((ch = input.read()) == -1) {
                                streamEnded = true;
                                break;
                            }
                            if (ch == 58) break;
                            if (ch == 10) {
                                lineEnded = true;
                                break;
                            }
                            commandBuffer.append((char)ch);
                        }
                        if (inBase64Data && commandBuffer.length() > 0) {
                            if (commandBuffer.charAt(0) == ' ') {
                                if (vcard.photo == null) continue;
                                vcard.photo = vcard.photo + commandBuffer.toString().trim();
                                continue;
                            }
                            inBase64Data = false;
                        }
                        if (commandBuffer.toString().isBlank() && !lineEnded) {
                            do {
                                if ((ch = input.read()) != -1) continue;
                                streamEnded = true;
                                continue block20;
                            } while (ch != 10);
                            continue;
                        }
                        if (lineEnded || streamEnded) continue;
                        List commandList = Arrays.asList(commandBuffer.toString().split(";")).stream().filter(c -> !StringFunctions.isEmpty((String)c)).collect(Collectors.toList());
                        String command = commandList.size() > 0 ? ((String)commandList.remove(0)).toLowerCase() : null;
                        Map<String, String> commandParameters = commandList.stream().map(c -> c.split("=")).collect(Collectors.toMap(c -> c[0].toLowerCase(), c -> ((String[])c).length > 1 ? c[1] : "", (c1, c2) -> c1));
                        Charset charSet = StandardCharsets.UTF_8;
                        if (commandParameters.containsKey("charset")) {
                            try {
                                charSet = Charset.forName(commandParameters.get("charset"));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        byte[] valueBytes = null;
                        try (FastByteArrayOutputStream valueBuffer = new FastByteArrayOutputStream();){
                            while (true) {
                                int ch2;
                                if ((ch2 = input.read()) == -1) {
                                    streamEnded = true;
                                    break;
                                }
                                if (ch2 == 13) continue;
                                if (ch2 == 10) {
                                    byte[] byteArray;
                                    if (!commandParameters.containsKey("quoted-printable") && !"quoted-printable".equalsIgnoreCase(commandParameters.get("encoding")) || (byteArray = valueBuffer.toByteArray())[byteArray.length - 1] != 61) break;
                                    valueBuffer.reset();
                                    valueBuffer.write(byteArray, 0, byteArray.length - 1);
                                    ch2 = input.read();
                                    if (ch2 == 32 || ch2 == 9) continue;
                                    valueBuffer.write(ch2);
                                    continue;
                                }
                                valueBuffer.write(ch2);
                            }
                            valueBytes = valueBuffer.toByteArray();
                        }
                        if (valueBytes != null && (commandParameters.containsKey("quoted-printable") || "quoted-printable".equalsIgnoreCase(commandParameters.get("encoding")))) {
                            InputStream inputStream = MimeUtility.decode((InputStream)new ByteArrayInputStream(valueBytes), (String)"quoted-printable");
                            valueBytes = IOFunctions.readBytes((InputStream)inputStream);
                        }
                        if (!StringFunctions.isEmpty((String)(value = new String(valueBytes, charSet)))) {
                            value = Arrays.asList(((String)value).split(";")).stream().filter(p -> !StringFunctions.isEmpty((String)p)).collect(Collectors.joining(", "));
                        }
                        if (!vCardStarted) {
                            if (!"begin".equals(command) || !"vcard".equalsIgnoreCase((String)value)) continue;
                            vCardStarted = true;
                            continue;
                        }
                        if ("end".equals(command) && "vcard".equalsIgnoreCase((String)value)) {
                            vCardStarted = false;
                            streamEnded = true;
                            continue;
                        }
                        String valueType = "";
                        if (commandParameters.containsKey("work")) {
                            valueType = "work";
                        }
                        if (commandParameters.containsKey("cell")) {
                            valueType = "mobile";
                        }
                        if (commandParameters.containsKey("fax")) {
                            valueType = "fax";
                        }
                        if (commandParameters.containsKey("home")) {
                            valueType = "home";
                        }
                        if (commandParameters.containsKey("pager")) {
                            valueType = "pager";
                        }
                        if ("fn".equals(command) && !StringFunctions.isEmpty((String)value)) {
                            vcard.fullname = value;
                        }
                        if ("title".equals(command) && !StringFunctions.isEmpty((String)value)) {
                            vcard.title = value;
                        }
                        if ("org".equals(command) && !StringFunctions.isEmpty((String)value)) {
                            vcard.organization = value;
                        }
                        if (command != null && commandMap.containsKey(command) && !StringFunctions.isEmpty((String)value)) {
                            List<LocalizedKey> list;
                            if ("url".equals(command) && !((String)value).toLowerCase().startsWith("http://") && !((String)value).toLowerCase().startsWith("https://")) {
                                value = "http://" + (String)value;
                            }
                            if ((list = vcard.properties.get(commandMap.get(command))) == null) {
                                list = new ArrayList<LocalizedKey>();
                                vcard.properties.put((String)commandMap.get(command), list);
                            }
                            list.add(new LocalizedKey(valueType, (String)value));
                        }
                        if (!"photo".equals(command) && !"x-ms-cardpicture".equals(command)) continue;
                        Object type = "image/jpg";
                        String cmdType = commandParameters.get("type");
                        if (!StringFunctions.isEmpty((String)cmdType)) {
                            type = "image/" + cmdType.toLowerCase();
                        }
                        if (!StringFunctions.isEmpty((String)(cmdMediaType = commandParameters.get("mediatype")))) {
                            type = cmdMediaType;
                        }
                        if ("base64".equalsIgnoreCase(encoding = commandParameters.get("encoding"))) {
                            inBase64Data = true;
                            vcard.photo = "data:" + (String)type + ";base64,";
                            continue;
                        }
                        if (StringFunctions.isEmpty((String)value)) continue;
                        vcard.photo = value;
                    }
                    if (StringFunctions.isEmpty((String)vcard.fullname)) {
                        string = null;
                        return string;
                    }
                    string = new Json().toJson((Object)vcard);
                    return string;
                }
                finally {
                    input.close();
                }
            }
            catch (Throwable t) {
                LogManager.getApplicationLogger().error(t);
            }
        }
        return null;
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        String fileNameLowerCase;
        if (mimeType != null && (mimeType.equals("text/x-vcard") || mimeType.startsWith("text/x-vcard;") || mimeType.equals("text/vcard") || mimeType.startsWith("text/vcard;"))) {
            return true;
        }
        String fileName = attachment.getFileName();
        return fileName != null && (fileNameLowerCase = fileName.toLowerCase()).endsWith(".vcf");
    }

    @Override
    public boolean isJsonSerializedSource() {
        return true;
    }

    @JsonData
    public static final class VCardData {
        private String photo;
        private String fullname;
        private String title;
        private String organization;
        private HashMap<String, List<LocalizedKey>> properties = new HashMap();

        private VCardData() {
        }
    }
}

