/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import srv.automatic.GeraeteImporter;
import srv.automatic.LdapFormatHandler;
import srv.automatic.LdapUtilities;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DbDeviceImporter;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public class LdapDeviceImporter
extends AbstractDeviceImporter {
    private static final int PAGE_SIZE = 500;
    private InitialLdapContext ctxLDAP = null;
    private LdapConnectionInfo ldapConn;
    private static final I18nMessages I18N = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", DbDeviceImporter.class);

    public LdapDeviceImporter(LdapConnectionInfo ldapConn) throws NamingException {
        this.ldapConn = ldapConn;
        this.ctxLDAP = this.getDirContextInternal(ldapConn);
    }

    public InitialLdapContext getDirContextInternal(LdapConnectionInfo ldapConn) throws NamingException {
        return LdapUtilities.getDirContext(ldapConn);
    }

    @Override
    public HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> userHm, String objKlasse, String keyAttr, String userNameAttr, String filter) throws DeviceImportingException {
        try {
            HashMap<String, Integer> newHm;
            block9: {
                String[] atts;
                if (keyAttr == null || objKlasse == null || userNameAttr == null || keyAttr.isEmpty() || objKlasse.isEmpty() || userNameAttr.isEmpty()) {
                    throw new DeviceImportingException(new IllegalArgumentException(I18N.getMsg("dataImport.userImport.noUserReference", new Object[0])));
                }
                newHm = new HashMap<String, Integer>();
                LdapSearchOptions lso = new LdapSearchOptions();
                lso.ctx = this.ctxLDAP;
                lso.searchContextValues = LdapUtilities.getSearchContext(lso.ctx, filter);
                if (keyAttr.equals("dnX")) {
                    lso.spezDN = true;
                    atts = new String[1];
                } else {
                    atts = new String[2];
                    atts[1] = keyAttr;
                }
                atts[0] = userNameAttr;
                lso.sc = LdapUtilities.getSearchControls(atts);
                try {
                    this.executeReplaceOwnKey(userHm, newHm, objKlasse, keyAttr, userNameAttr, lso);
                }
                catch (OperationNotSupportedException onse) {
                    this.logger.error((Throwable)onse);
                    if (lso.searchExecutions != 0) break block9;
                    try {
                        lso.ctx.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    lso.pagedSearch = false;
                    lso.ctx = LdapUtilities.getDirContext(this.ldapConn);
                    this.executeReplaceOwnKey(userHm, newHm, objKlasse, keyAttr, userNameAttr, lso);
                }
            }
            return newHm;
        }
        catch (Exception exc) {
            throw new DeviceImportingException(exc);
        }
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="custom ldap query is expected")
    private void executeReplaceOwnKey(HashMap<String, Integer> userHm, HashMap<String, Integer> newHm, String objKlasse, String keyAttr, String userNameAttr, LdapSearchOptions lso) throws NamingException, IOException {
        Attributes attrs = null;
        NamingEnumeration<SearchResult> enumeration = null;
        String addString = null;
        for (String searchContext : lso.searchContextValues) {
            if ((searchContext = LdapDeviceImporter.removeBlanks(searchContext)).length() > 0) {
                addString = "," + searchContext;
            }
            byte[] cookie = null;
            if (lso.pagedSearch) {
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
            }
            do {
                enumeration = lso.ctx.search(searchContext, "objectClass=" + objKlasse, lso.sc);
                ++lso.searchExecutions;
                while (LdapUtilities.enumerationHasMore(enumeration)) {
                    Integer realUserId;
                    Object fremdKey = null;
                    String userName = null;
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    attrs = sr.getAttributes();
                    Attribute attr = attrs.get(userNameAttr);
                    if (attr != null && attr.size() == 1) {
                        userName = attr.get().toString();
                    }
                    if ((userName = GeraeteImporter.normalizeName(userName)) == null || (realUserId = userHm.get(userName)) == null) continue;
                    if (lso.spezDN) {
                        fremdKey = sr.getName();
                        if (addString != null) {
                            fremdKey = (String)fremdKey + addString;
                        }
                        if (this.logger.isDebug()) {
                            this.logger.debug((Object)("User mapping: '" + userName + "' -> '" + realUserId + "' ref '" + (String)fremdKey + "'"));
                        }
                        this.putKontrolle(newHm, (String)fremdKey, realUserId);
                        continue;
                    }
                    attr = attrs.get(keyAttr);
                    if (attr == null) continue;
                    for (int i = 0; i < attr.size(); ++i) {
                        if (this.logger.isDebug()) {
                            this.logger.debug((Object)("User mapping: '" + userName + "' -> '" + realUserId + "' ref '" + attr.get(i).toString() + "'"));
                        }
                        this.putKontrolle(newHm, attr.get(i).toString(), realUserId);
                    }
                }
                try {
                    enumeration.close();
                }
                catch (Exception sr) {
                    // empty catch block
                }
                if (!lso.pagedSearch) continue;
                Control[] controls = lso.ctx.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
            } while (cookie != null);
        }
    }

    @Override
    public List<Map<String, String>> doImport(DataImportJob dataImportJob, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler mappingHandler, String nameRef, boolean indirekt, AbstractDeviceImporter.RowAddedListener listener) throws Exception {
        List<Map<String, String>> result;
        block6: {
            ArrayList<MappingHandler.MappedColumn> requiredAttributes = mappingHandler.getListOfColumnsToSelect(new String[0]);
            ArrayList<String> attributeNames = new ArrayList<String>();
            if (!importConfig.isIgnoreUser()) {
                attributeNames.add(nameRef);
            }
            for (MappingHandler.MappedColumn attribute : requiredAttributes) {
                String colName = attribute.getSourceColumnName();
                if (attributeNames.contains(colName) || "dnX".equals(colName)) continue;
                attributeNames.add(colName);
            }
            LdapSearchOptions lso = new LdapSearchOptions();
            lso.sc = LdapUtilities.getSearchControls(attributeNames.toArray(new String[attributeNames.size()]));
            lso.ctx = this.ctxLDAP;
            lso.searchContextValues = LdapUtilities.getSearchContext(lso.ctx, filter);
            lso.indirekt = indirekt;
            result = null;
            try {
                result = this.executeDoImport(dataImportJob, userHm, importConfig, nameRef, lso, requiredAttributes, listener, name, newVersID, importConfig.isIgnoreUser());
            }
            catch (OperationNotSupportedException onse) {
                this.logger.error((Throwable)onse);
                if (lso.searchExecutions != 0) break block6;
                try {
                    lso.ctx.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lso.pagedSearch = false;
                lso.ctx = LdapUtilities.getDirContext(this.ldapConn);
                result = this.executeDoImport(dataImportJob, userHm, importConfig, nameRef, lso, requiredAttributes, listener, name, newVersID, importConfig.isIgnoreUser());
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "LDAP_INJECTION"}, justification="internally created statement, custom ldap query is expected")
    private List<Map<String, String>> executeDoImport(DataImportJob dataImportJob, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String nameRef, LdapSearchOptions lso, ArrayList<MappingHandler.MappedColumn> requiredAttributes, AbstractDeviceImporter.RowAddedListener listener, String importName, int newVersID, boolean ignoreUser) throws Exception {
        String addString = null;
        Attributes attrs = null;
        NamingEnumeration<SearchResult> enumeration = null;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        String importSourceClass = importConfig.getImportSource();
        int gerType = importConfig.getGerTyp();
        for (String searchContext : lso.searchContextValues) {
            if ((searchContext = LdapDeviceImporter.removeBlanks(searchContext)).length() > 0) {
                addString = "," + searchContext;
            }
            this.logger.info((Object)("searchContext: '" + searchContext + "' objectClass '" + importSourceClass + "' Username-Attribut '" + nameRef + "'"));
            byte[] cookie = null;
            if (lso.pagedSearch) {
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
            }
            do {
                boolean isPreviewMode;
                enumeration = lso.ctx.search(searchContext, "objectClass=" + importSourceClass, lso.sc);
                ++lso.searchExecutions;
                ArrayList<Map<String, String>> exampleBuffer = new ArrayList<Map<String, String>>();
                boolean bl = isPreviewMode = listener != null;
                while (LdapUtilities.enumerationHasMore(enumeration)) {
                    int datensatzCount;
                    Attribute nameAttr;
                    ++this.available;
                    dataImportJob.incrementDataCount();
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    attrs = sr.getAttributes();
                    Object dnString = sr.getName();
                    if (addString != null) {
                        dnString = (String)dnString + addString;
                    }
                    Attribute attribute = nameAttr = ignoreUser ? null : attrs.get(nameRef);
                    if (((String)dnString).length() > 250) {
                        dnString = ((String)dnString).substring(0, 250);
                    }
                    int n = datensatzCount = nameAttr == null ? 1 : nameAttr.size();
                    if ((ignoreUser || nameAttr != null) && datensatzCount > 0) {
                        userIds.clear();
                        for (int i = 0; i < datensatzCount; ++i) {
                            Integer uId;
                            String test;
                            String string = test = ignoreUser ? null : nameAttr.get(i).toString();
                            if (!lso.indirekt) {
                                test = GeraeteImporter.normalizeName(test);
                            }
                            if ((uId = userHm.get(test)) == null) continue;
                            userIds.add(uId);
                        }
                        if (userIds.size() > 0 || ignoreUser) {
                            Integer userId = ignoreUser ? null : (Integer)userIds.get(0);
                            HashMap<String, String> assetKeyToValue = new HashMap<String, String>();
                            for (int i = 0; i < requiredAttributes.size(); ++i) {
                                String attrName = requiredAttributes.get(i).getSourceColumnName();
                                String attrKey = requiredAttributes.get(i).getInternalColumnName();
                                try {
                                    if ("dnX".equals(attrName)) {
                                        assetKeyToValue.put(attrKey, (String)dnString);
                                    } else {
                                        Attribute someAttr = attrs.get(attrName);
                                        if (someAttr != null) {
                                            if (!requiredAttributes.get(i).allowsMultiRows() || someAttr.size() == 1) {
                                                assetKeyToValue.put(attrKey, LdapFormatHandler.handleLdapFormatWithDateAsLong(attrName, someAttr.get().toString()));
                                            } else {
                                                int countMemo = someAttr.size();
                                                StringBuffer buf = new StringBuffer();
                                                for (int n2 = 0; n2 < countMemo; ++n2) {
                                                    buf.append(someAttr.get(n2)).append('\n');
                                                }
                                                assetKeyToValue.put(attrKey, buf.toString());
                                            }
                                        }
                                    }
                                    String value = (String)assetKeyToValue.get(attrKey);
                                    if (value == null || value.length() <= requiredAttributes.get(i).getMaxValueLength()) continue;
                                    assetKeyToValue.put(attrKey, value.substring(0, requiredAttributes.get(i).getMaxValueLength()));
                                    continue;
                                }
                                catch (Throwable e) {
                                    this.logger.error(e);
                                }
                            }
                            if (assetKeyToValue.get(AssetFields.FIELD_NAME.getKey()) == null) {
                                if (!isPreviewMode) {
                                    this.logger.error((Object)("import '" + importName + "': Daten inkonsistent f\u00fcr '" + (String)dnString + "' - kein username"));
                                }
                                dataImportJob.incrementMissingReferenceCount();
                                continue;
                            }
                            if (isPreviewMode) {
                                exampleBuffer.add(assetKeyToValue);
                                if (!listener.finishedWithRowCount(exampleBuffer.size())) continue;
                                break;
                            }
                            UserAccountScope scope = UserAccountScope.createPrivileged();
                            try {
                                AssetManager manager = AssetManager.getInstance();
                                IndexSearchEngine searchEngine = manager.getSearchEngine();
                                AndSearchExpression and = new AndSearchExpression();
                                and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)importName));
                                and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORTED_FROM_COLUMN.getEntrySearchKey(), SearchCondition.SearchTermOperator.Equals, dnString));
                                SearchCommand command = new SearchCommand(new SearchExpression[]{and});
                                Set results = searchEngine.simpleSearch(command);
                                if (results.isEmpty()) {
                                    try {
                                        MutableAssetData dataToSet = this.createAssetDataFromData(importName, gerType, assetKeyToValue, (String)dnString, userId, newVersID);
                                        if (dataToSet.getIncludedFields().size() > 1) {
                                            manager.createAsset(dataToSet, Collections.emptyList(), true);
                                        }
                                        ++this.newImports;
                                        dataImportJob.incrementAddedCount();
                                    }
                                    catch (Exception exc) {
                                        HDLogger.error(exc);
                                        dataImportJob.incrementErrorsCount();
                                    }
                                    continue;
                                }
                                if (results.size() == 1) {
                                    try {
                                        GUID g = (GUID)results.stream().findFirst().get();
                                        MutableAssetData dataToSet = this.createAssetDataFromData(importName, gerType, assetKeyToValue, (String)dnString, userId, newVersID);
                                        if (manager.getAsset(g).isArchived()) {
                                            manager.unarchiveAsset(g);
                                        }
                                        manager.updateAsset(g, dataToSet, Collections.emptyList(), true);
                                        dataImportJob.incrementUpdatedCount();
                                        ++this.updates;
                                    }
                                    catch (Exception exc) {
                                        HDLogger.error(exc);
                                        dataImportJob.incrementErrorsCount();
                                    }
                                    continue;
                                }
                                if (isPreviewMode) continue;
                                HDLogger.error("more than one device found for unique id: " + (String)dnString);
                                continue;
                            }
                            finally {
                                if (scope != null) {
                                    scope.close();
                                }
                                continue;
                            }
                        }
                        if (!isPreviewMode) {
                            this.logger.error((Object)("import '" + importName + "': Keine User f\u00fcr '" + (String)dnString + "' gefunden"));
                        }
                        dataImportJob.incrementErrorsCount();
                        continue;
                    }
                    if (!isPreviewMode) {
                        this.logger.error((Object)("import '" + importName + "': Kein Eintrag f\u00fcr Attribut '" + nameRef + "' in '" + (String)dnString + "'"));
                    }
                    dataImportJob.incrementErrorsCount();
                }
                try {
                    enumeration.close();
                }
                catch (Exception sr) {
                    // empty catch block
                }
                if (isPreviewMode) {
                    return this.createEntrys(exampleBuffer, requiredAttributes);
                }
                if (!lso.pagedSearch) continue;
                Control[] controls = lso.ctx.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
            } while (cookie != null);
        }
        return null;
    }

    @Override
    public void cleanup() {
        try {
            this.ctxLDAP.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.ctxLDAP = null;
    }

    private class LdapSearchOptions {
        private int searchExecutions = 0;
        private boolean pagedSearch = true;
        private boolean indirekt = false;
        private boolean spezDN = false;
        private InitialLdapContext ctx;
        private SearchControls sc;
        private String[] searchContextValues;

        private LdapSearchOptions() {
        }
    }
}

